<?php
// xuhuong.php - Phiên bản HOÀN CHỈNH, TỐI ƯU VÀ BẢO MẬT

// Nạp các file cần thiết
require_once __DIR__ . '/config/function.php'; // Nạp function.php để có biến $_vincenzo
require_once __DIR__ . "/head.php";

// --- PHẦN 1: LOGIC LẤY DỮ LIỆU TỐI ƯU ---

// 1a. Lấy phiên đang chạy (nếu có) để hiển thị riêng ở trên cùng
$running_session = $_vincenzo->get_row("
    SELECT id, result, status, start_time, end_time 
    FROM game_sessions 
    WHERE status = 'running' 
    ORDER BY id DESC 
    LIMIT 1
");

// 1b. Lấy Lịch sử phiên ĐÃ KẾT THÚC với logic PHÂN TRANG
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1; // Đảm bảo trang không phải là số âm
$limit = 20; // Số phiên trên mỗi trang
$offset = ($page - 1) * $limit;

// Đếm tổng số phiên ĐÃ KẾT THÚC để tính số trang
$total_finished_sessions_row = $_vincenzo->get_row("SELECT COUNT(id) AS total FROM game_sessions WHERE status = 'finished'");
$total_sessions_finished = $total_finished_sessions_row['total'] ?? 0;
$total_pages = ceil($total_sessions_finished / $limit);

// Lấy dữ liệu lịch sử cho trang hiện tại. Chỉ lấy các phiên 'finished'.
$historical_sessions = $_vincenzo->get_list("
    SELECT id, result, status 
    FROM game_sessions 
    WHERE status = 'finished' 
    ORDER BY id DESC 
    LIMIT $limit OFFSET $offset
");

// 1c. Lấy tổng số đơn cược một cách hiệu quả
$total_bets_row = $_vincenzo->get_row("SELECT COUNT(id) AS total FROM user_bets");
$total_bets = $total_bets_row['total'] ?? 0;

// 1d. Tổng số phiên sẽ hiển thị cho người dùng (chỉ tính running và finished)
$total_visible_sessions = $total_sessions_finished + ($running_session ? 1 : 0);

// --- PHẦN 2: CÁC HÀM HỖ TRỢ HIỂN THỊ ---

// Hàm format kết quả (an toàn, không làm lộ kết quả phiên đang chạy)
function formatResultForUser($result_str, $status) {
    if ($status !== 'finished') {
        return 'Đang chờ kết quả...';
    }
    if (empty($result_str)) {
        return 'N/A';
    }
    return str_replace(',', ' ', $result_str);
}

// Hàm format trạng thái
function getStatusForUser($status) {
    if ($status === 'finished') {
        return '<span style="color: red; font-weight: bold;">Đã kết thúc</span>';
    }
    if ($status === 'running') {
        return '<span style="color: green; font-weight: bold;">Đang chạy</span>';
    }
    return ucfirst($status);
}
?>

<style>
    /* CSS cho giao diện giống như trong hình ảnh của bạn */
    body {
        max-width: 500px; margin: 0 auto; background-color: #f8f9fa;
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
    }
    .modal-custom { min-height: 100vh; background: #fff; box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1); }
    .modal-header {
        background-color: #2fbba1; color: white; padding: 12px; text-align: center;
        font-size: 16px; font-weight: bold; position: sticky; top: 0; z-index: 10;
    }
    .summary-box {
        background-color: #c3e9e2; padding: 10px 15px; display: flex;
        justify-content: space-between; font-size: 14px; font-weight: bold; color: #005a49;
    }
    .table { width: 100%; font-size: 14px; border-collapse: collapse; }
    .table thead { background-color: #dbf7f2; }
    .table th, .table td {
        padding: 8px 10px; border-bottom: 1px solid #c3e9e2; text-align: center; vertical-align: middle;
    }
    .table td:first-child { color: #ff5722; font-weight: bold; }
    .pagination { display: flex; justify-content: center; align-items: center; padding: 15px 0; list-style: none; margin: 0; }
    .pagination li a, .pagination li span {
        display: block; margin: 0 3px; padding: 5px 10px; text-decoration: none;
        border-radius: 4px; font-size: 14px; border: 1px solid #ddd; color: #337ab7; background-color: #fff;
    }
    .pagination li a:hover { background-color: #eee; }
    .pagination li a.active {
        background-color: #2fbba1; color: white; border-color: #2fbba1; font-weight: bold;
    }
</style>

<div class="modal-custom">
    <div class="modal-header">Xu Hướng Kỷ Lục</div>
    <div class="summary-box">
        <div>Tổng phiên: <strong><?php echo number_format($total_visible_sessions); ?></strong></div>
        <div>Tổng số đơn: <strong><?php echo number_format($total_bets); ?></strong></div>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>Phiên</th>
                <th>Kết quả</th>
                <th>Trạng thái</th>
            </tr>
        </thead>
        <tbody>
            <?php // Hiển thị phiên đang chạy ở trên cùng, nhưng chỉ ở trang 1
            if ($page == 1 && $running_session): ?>
                <tr style="background-color: #e8f5e9;">
                    <td><?php echo htmlspecialchars($running_session['id']); ?></td>
                    <td><?php echo htmlspecialchars(formatResultForUser($running_session['result'], $running_session['status'])); ?></td>
                    <td><?php echo getStatusForUser($running_session['status']); ?></td>
                </tr>
            <?php endif; ?>

            <?php // Hiển thị lịch sử các phiên đã kết thúc
            if (empty($historical_sessions) && !$running_session): ?>
                <tr>
                    <td colspan="3">Không có dữ liệu để hiển thị</td>
                </tr>
            <?php else: ?>
                <?php foreach ($historical_sessions as $session): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($session['id']); ?></td>
                        <td><?php echo htmlspecialchars(formatResultForUser($session['result'], $session['status'])); ?></td>
                        <td><?php echo getStatusForUser($session['status']); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>

    <nav>
        <ul class="pagination">
            <?php if ($total_pages > 1):
                // Nút "Trước"
                if ($page > 1): ?>
                    <li><a href="?page=<?php echo $page - 1; ?>">« Trước</a></li>
                <?php endif;

                // Logic hiển thị các số trang thông minh
                $start = max(1, $page - 2);
                $end = min($total_pages, $page + 2);

                if ($start > 1) echo '<li><span>...</span></li>';
                for ($i = $start; $i <= $end; $i++): ?>
                    <li><a href="?page=<?php echo $i; ?>" class="<?= ($i == $page) ? 'active' : '' ?>"><?php echo $i; ?></a></li>
                <?php endfor;
                if ($end < $total_pages) echo '<li><span>...</span></li>';

                // Nút "Sau"
                if ($page < $total_pages): ?>
                    <li><a href="?page=<?php echo $page + 1; ?>">Sau »</a></li>
                <?php endif;
            endif; ?>
        </ul>
    </nav>
</div>

<?php
require_once __DIR__ . "/foot.php";
?>