<?php
// send_message.php - Cập nhật để match insert với 'images' field riêng biệt, như chat.php gốc
require_once __DIR__ . "/../config/function.php";

if (!isset($_SESSION['activeAdmin'])) {
    header("Location: /");
    exit();
}

header('Content-Type: application/json');

if (isset($_GET['action']) && $_GET['action'] === 'mark_read') {
    $id = (int)$_GET['user_id'];
    $_vincenzo->query("UPDATE chat_messages SET is_read = 1 WHERE sender_id = $id AND sender_type = 'user' AND is_read = 0");
    echo json_encode(['success' => true]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Invalid method']);
    exit;
}

$id = (int)$_POST['user_id'];
$message = trim($_POST['message'] ?? '');
$images = $_FILES['images'] ?? null;
$success = false;

try {
    if ($images && $images['error'][0] != UPLOAD_ERR_NO_FILE) {
        $upload_dir = '../upload/chat_images/';
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }

        foreach ($images['tmp_name'] as $index => $tmp_name) {
            if ($images['error'][$index] === UPLOAD_ERR_OK) {
                $filename = basename($images['name'][$index]);
                $file_extension = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
                $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
                if (!in_array($file_extension, $allowed_extensions)) continue;

                $new_filename = time() . '_' . rand(1000, 9999) . '.' . $file_extension;
                $target_file = $upload_dir . $new_filename;

                if (move_uploaded_file($tmp_name, $target_file)) {
                    $img_html = '<a href="' . BASE_URL() . 'upload/chat_images/' . $new_filename . '" target="_blank"><img src="' . BASE_URL() . 'upload/chat_images/' . $new_filename . '" alt="Image" style="width: 300px; max-width: 200px; height: auto; object-fit: cover; border-radius: 6px; border: 1px solid #ddd;"></a>';
                    $_vincenzo->insert("chat_messages", [
                        'sender_id' => 1,
                        'sender_type' => 'admin',
                        'receiver_type' => 'user',
                        'receiver_id' => $id,
                        'message' => $message,
                        'images' => $img_html
                    ]);
                }
            }
        }
    } elseif ($message) {
        $_vincenzo->insert("chat_messages", [
            'sender_id' => 1,
            'sender_type' => 'admin',
            'receiver_type' => 'user',
            'receiver_id' => $id,
            'message' => $message
        ]);
    }
    $success = true;
} catch (Exception $e) {
    $success = false;
    $error = $e->getMessage();
}

echo json_encode(['success' => $success, 'error' => $error ?? null]);
?>