<?php
require_once __DIR__ . "/head.php";

$per_page = 10;
$current_page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($current_page - 1) * $per_page;

// Get total count (toàn bộ)
$count_query = "SELECT COUNT(*) as total FROM `history_withdraw`";
$count_result = $_vincenzo->get_list($count_query);
$total_items = $count_result[0]['total'] ?? 0;
$total_pages = ceil($total_items / $per_page);

// Get paginated data (ưu tiên status 'Đang Duyệt' lên đầu)
$main_query = "SELECT * FROM `history_withdraw` ORDER BY CASE WHEN `status` = 'Đang Duyệt' THEN 0 ELSE 1 END, `id` ASC LIMIT " . $per_page . " OFFSET " . $offset;
$page_data = $_vincenzo->get_list($main_query);

// Adjust current_page if total_pages is less
$current_page = min($current_page, $total_pages);
?>

<!--begin::App Content Header-->
<div class="app-content-header">
    <!--begin::Container-->
    <div class="container-fluid">
        <!--begin::Row-->
        <div class="row">
            <div class="col-sm-6">
                <h3 class="mb-0">Danh rút tiền</h3>
            </div>
        </div>

    </div>

</div>
<div class="app-content">
    <!--begin::Container-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <!-- /.card-header -->
                    <div class="card-body p-0">
                        <table class="table" role="table">
                            <thead>
                                <tr>
                                    <th style="width: 10px" scope="col">ID</th>
                                    <th scope="col">Người chơi</th>
                                    <th scope="col">Số tiền</th>
                                    <th scope="col">Ngân hàng</th>
                                    <th scope="col">Chủ tài khoản</th>
                                    <th scope="col">Số tài khoản</th>
                                    <th scope="col">Ngày tạo</th>
                                    <th scope="col">Trạng thái</th>
                                    <th scope="col" class="text-center align-middle">Tác vụ</th>
                                    <!-- <th style="width: 40px" scope="col">Label</th> -->
                                </tr>
                            </thead>
                            <?php if (empty($page_data)): ?>
                                <tr>
                                    <td colspan="10" style="text-align:center;">Không có dữ liệu</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($page_data as $item): ?>
                                    <?php
                                    $id = $item['id'];
                                    $username = $item['username'];
                                    $coin = $item['coin'];
                                    $bank_name = $item['bank_name'];
                                    $name_bank = $item['name_bank'];
                                    $stk_bank = $item['stk_bank'];
                                    $date = $item['date'];
                                    $status = $item['status'];
                                    ?>
                                    <tr>
                                        <td><?php echo $id; ?></td>
                                        <td><?php echo $username; ?></td>
                                        <td><?php echo format_money($coin); ?></td>
                                        <td><?php echo $bank_name; ?></td>
                                        <td><?php echo $name_bank; ?></td>
                                        <td><?php echo $stk_bank; ?></td>
                                        <td><?php echo $date; ?></td>
                                        <td><?php echo status_ruttien($status); ?></td>
                                        <td class="text-center align-middle">
                                            <div class="d-flex justify-content-center gap-2">
                                                <?php if ($status == 'Đang Duyệt'): ?>
                                                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modal-qr"
                                                        data-bank="<?= htmlspecialchars($bank_name); ?>"
                                                        data-stk="<?= htmlspecialchars($stk_bank); ?>"
                                                        data-coin="<?= htmlspecialchars($coin); ?>"
                                                        data-name="<?= htmlspecialchars($name_bank); ?>">
                                                        <i class="bi bi-qr-code me-1"></i>
                                                    </button>
                                                    <a href="./status-rut-tien.php?type=hoanthanh&id=<?= $id ?>" class="btn btn-success">
                                                        <i class="bi bi-check-circle me-1"></i>
                                                    </a>
                                                    <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#modal-note"
                                                        data-id="<?= $id ?>" data-type="hoan">
                                                        <i class="bi bi-arrow-return-left me-1"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#modal-note-error"
                                                        data-id="<?= $id ?>" data-type="huy">
                                                        <i class="bi bi-x-circle me-1"></i>
                                                    </button>
                                                <?php endif; ?>

                                            </div>

                                        </td>

                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <?php if ($total_pages > 1): ?>
                    <nav aria-label="Page navigation">
                        <ul class="pagination justify-content-center">
                            <?php if ($current_page > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?php echo $current_page - 1; ?>" aria-label="Previous">
                                        <span aria-hidden="true">&laquo; Trước</span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php
                            // Hiển thị các trang, giới hạn số trang hiển thị nếu nhiều
                            $start_page = max(1, $current_page - 2);
                            $end_page = min($total_pages, $current_page + 2);
                            if ($start_page > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=1">1</a>
                                </li>
                                <?php if ($start_page > 2): ?>
                                    <li class="page-item disabled">
                                        <span class="page-link">...</span>
                                    </li>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
                                <?php if ($i == $current_page): ?>
                                    <li class="page-item active">
                                        <span class="page-link"><?php echo $i; ?></span>
                                    </li>
                                <?php else: ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                                    </li>
                                <?php endif; ?>
                            <?php endfor; ?>

                            <?php if ($end_page < $total_pages): ?>
                                <?php if ($end_page < $total_pages - 1): ?>
                                    <li class="page-item disabled">
                                        <span class="page-link">...</span>
                                    </li>
                                <?php endif; ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?php echo $total_pages; ?>"><?php echo $total_pages; ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if ($current_page < $total_pages): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?php echo $current_page + 1; ?>" aria-label="Next">
                                        <span aria-hidden="true">Tiếp &raquo;</span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                <?php endif; ?>
            </div>
            <!-- /.col -->
        </div>
    </div>
    <!--end::Container-->
</div>
<!--end::App Content-->

<!-- Modal QR (giữ nguyên) -->
<div class="modal fade" id="modal-qr" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="exampleModalLabel">
                    <i class="bi bi-info-circle"></i> Qr bank
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <img id="qrImage" src="" alt="QR Bank" class="img-fluid" />
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Note cho Hoàn -->
<div class="modal fade" id="modal-note" tabindex="-1" aria-labelledby="modalNoteLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title" id="modalNoteLabel">
                    <i class="bi bi-note-text me-1"></i> Nhập Ghi Chú (Note) cho Hoàn Tiền
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="hoanForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="hoanTextarea" class="form-label">Ghi Chú:</label>
                        <textarea class="form-control" id="hoanTextarea" rows="3" placeholder="Nhập lý do hoàn tiền..." required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-warning">Lưu và Hoàn</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Note cho Hủy (cập nhật) -->
<div class="modal fade" id="modal-note-error" tabindex="-1" aria-labelledby="modalNoteErrorLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="modalNoteErrorLabel">
                    <i class="bi bi-note-text me-1"></i> Nhập Ghi Chú (Note) cho Hủy Tiền
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="huyForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="huyTextarea" class="form-label">Ghi Chú:</label>
                        <textarea class="form-control" id="huyTextarea" rows="3" placeholder="Nhập lý do hủy tiền..." required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-danger">Lưu và Hủy</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // JS cho Modal QR (giữ nguyên)
        const qrModal = document.getElementById('modal-qr');
        const qrImage = document.getElementById('qrImage');

        qrModal.addEventListener('show.bs.modal', function(event) {
            const button = event.relatedTarget;
            const bank = button.getAttribute('data-bank');
            const stk = button.getAttribute('data-stk');
            const coin = button.getAttribute('data-coin');
            const name = button.getAttribute('data-name');

            const qrUrl = `https://api.vietqr.io/${bank}/${stk}/${coin}/chuyen khoan/vietqr_net_2.jpg?accountName=${name}`;
            qrImage.src = qrUrl;
            qrImage.alt = `QR ${bank} Bank`;

            const modalTitle = qrModal.querySelector('.modal-title');
            modalTitle.innerHTML = `<i class="bi bi-info-circle"></i> QR ${bank} Bank`;
        });

        // JS cho Modal Note Hoàn
        let currentIdHoan = null;
        const hoanModal = document.getElementById('modal-note');
        const hoanForm = document.getElementById('hoanForm');

        hoanModal.addEventListener('show.bs.modal', function(event) {
            const button = event.relatedTarget;
            currentIdHoan = button.getAttribute('data-id');
            document.getElementById('hoanTextarea').value = ''; // Reset textarea
        });

        hoanForm.addEventListener('submit', function(event) {
            event.preventDefault();
            const note = document.getElementById('hoanTextarea').value.trim();
            if (!note) {
                alert('Vui lòng nhập ghi chú!');
                return;
            }

            const redirectUrl = `./status-rut-tien.php?type=hoan&id=${currentIdHoan}&note=${encodeURIComponent(note)}`;

            const modalInstance = bootstrap.Modal.getInstance(hoanModal);
            modalInstance.hide();

            setTimeout(() => {
                window.location.href = redirectUrl;
            }, 300);
        });

        // JS cho Modal Note Hủy (mới)
        let currentIdHuy = null;
        const huyModal = document.getElementById('modal-note-error');
        const huyForm = document.getElementById('huyForm');

        huyModal.addEventListener('show.bs.modal', function(event) {
            const button = event.relatedTarget;
            currentIdHuy = button.getAttribute('data-id');
            document.getElementById('huyTextarea').value = ''; // Reset textarea
        });

        huyForm.addEventListener('submit', function(event) {
            event.preventDefault();
            const note = document.getElementById('huyTextarea').value.trim();
            if (!note) {
                alert('Vui lòng nhập ghi chú!');
                return;
            }

            const redirectUrl = `./status-rut-tien.php?type=huy&id=${currentIdHuy}&note=${encodeURIComponent(note)}`;

            const modalInstance = bootstrap.Modal.getInstance(huyModal);
            modalInstance.hide();

            setTimeout(() => {
                window.location.href = redirectUrl;
            }, 300);
        });
    });
</script>

<?php
require_once __DIR__ . "/foot.php";

?>