<?php
require_once __DIR__ . "/head.php";

// --- LOGIC PHP CŨ ĐƯỢỢC GIỮ NGUYÊN HOÀN TOÀN ---
$per_page = 15;
$current_page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($current_page - 1) * $per_page;

$search_term = $_GET['search'] ?? '';
$search_query = '';
$search_param = '';

if (!empty($search_term)) {
    $safe_search_term = "%" . $_vincenzo->real_escape_string($search_term) . "%";
    $search_query = " WHERE `username` LIKE '{$safe_search_term}' OR `name_bank` LIKE '{$safe_search_term}' OR `city` LIKE '{$safe_search_term}' ";
    $search_param = '&search=' . urlencode($search_term);
}

// Lấy tổng số thành viên
$total_items = $_vincenzo->get_row("SELECT COUNT(*) as total FROM `users` " . $search_query)['total'] ?? 0;
$total_pages = ceil($total_items / $per_page);

// Lấy dữ liệu thành viên
$page_data = $_vincenzo->get_list("SELECT * FROM `users` " . $search_query . " ORDER BY `id` DESC LIMIT {$per_page} OFFSET {$offset}");
// --- KẾT THÚC LOGIC CŨ ---


// --- CÁC HÀM HELPER CHO GIAO DIỆN MỚI ---
function format_money_new($amount) {
    return number_format($amount, 0, ',', '.');
}

function status_members_new($status) {
    if ($status == '1') {
        return '<span class="badge bg-success-soft text-success">Hoạt động</span>';
    } else {
        return '<span class="badge bg-danger-soft text-danger">Đã khóa</span>';
    }
}

function get_avatar_text($username) {
    return strtoupper(substr(trim($username), 0, 1));
}
?>

<!-- === CSS CHO GIAO DIỆN DARK MODE CHUYÊN NGHIỆP === -->
<style>
    :root {
        --bs-body-bg: #1A2035;
        --bs-body-color: #aeb9e1;
        --card-bg: #202940;
        --card-border-color: rgba(174, 185, 225, 0.1);
        --table-header-bg: #2A3452;
        --table-hover-bg: #2A3452;
        --primary-accent: #00abfb;
        --primary-accent-hover: #0089c9;
        --bs-success: #00d27a;
        --bs-danger: #e7515a;
        --bs-warning: #e2a03f;
        --bs-info: #2196f3;
        --bs-secondary: #888ea8;
    }
    .form-control, .input-group-text {
        background-color: #2A3452 !important;
        border-color: var(--card-border-color) !important;
        color: var(--bs-body-color) !important;
    }
    .form-control::placeholder { color: #6c757d; }
    .main-card {
        background-color: var(--card-bg);
        border: 1px solid var(--card-border-color);
        border-radius: 0.75rem;
        box-shadow: 0 0.5rem 1.5rem rgba(0,0,0,0.1);
    }
    .table { color: var(--bs-body-color); }
    .table thead th {
        background-color: var(--table-header-bg);
        border-bottom: 2px solid var(--card-border-color);
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.75rem;
        letter-spacing: 0.5px;
        color: #aeb9e1;
    }
    .table tbody tr { border-bottom: 1px solid var(--card-border-color); }
    .table tbody tr:last-of-type { border-bottom: none; }
    .table-hover > tbody > tr:hover {
        background-color: var(--table-hover-bg);
        color: #fff;
    }
    .avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        color: #fff;
    }
    .bg-success-soft { background-color: rgba(0, 210, 122, 0.1); }
    .bg-danger-soft  { background-color: rgba(231, 81, 90, 0.1); }
    .pagination .page-link {
        background-color: transparent;
        border-color: var(--card-border-color);
        color: var(--bs-body-color);
    }
    .pagination .page-item.active .page-link {
        background-color: var(--primary-accent);
        border-color: var(--primary-accent);
    }
    /* Style cho dải nút hành động */
    .btn-group-sm > .btn {
        padding: 0.25rem 0.6rem;
    }
</style>
<!-- === KẾT THÚC CSS === -->

<!-- Header của trang -->
<div class="app-content-header pb-4">
    <div class="container-fluid">
        <div class="row align-items-center">
            <div class="col-sm-6">
                <h2 class="mb-0 fw-bold text-white"><i class="fas fa-users me-2 text-white-50"></i>Quản Lý Thành Viên</h2>
                <p class="mb-0 text-white-50">Tổng quan và quản lý chi tiết tài khoản người dùng.</p>
            </div>
            <div class="col-sm-6">
                <form method="GET" action="" class="d-flex">
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-search"></i></span>
                        <input type="text" class="form-control" name="search" placeholder="Tìm kiếm thành viên..." value="<?= htmlspecialchars($search_term) ?>">
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Nội dung chính -->
<div class="app-content pt-0">
    <div class="container-fluid">
        <div class="card main-card">
            <div class="card-header bg-transparent border-0 d-flex justify-content-between align-items-center py-3">
                <h5 class="mb-0 text-white">Danh sách thành viên (<?= number_format($total_items) ?>)</h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th scope="col" style="min-width: 220px;">Thành viên</th>
                                <th scope="col" class="text-end">Số Dư</th>
                                <th scope="col" style="min-width: 200px;">Tổng Giao Dịch</th>
                                <th scope="col" style="min-width: 200px;">Giao Dịch Admin</th>
                                <th scope="col">Trạng Thái</th>
                                <th scope="col" class="text-center" style="min-width: 220px;">Tác Vụ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($page_data)): ?>
                                <tr>
                                    <td colspan="6" class="text-center py-5">
                                        <i class="fas fa-inbox fa-3x text-white-50 mb-3"></i>
                                        <h5 class="mb-1 text-white">Không có dữ liệu</h5>
                                        <p class="text-white-50">Không tìm thấy thành viên nào phù hợp.</p>
                                    </td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($page_data as $item): 
                                    // --- LOGIC PHP CŨ BÊN TRONG VÒNG LẶP ĐƯỢC GIỮ NGUYÊN ---
                                    $total_nap = $_vincenzo->get_row("SELECT SUM(coin) as total FROM `history_deposit` WHERE username = '{$item['username']}'")['total'] ?? 0;
                                    $total_rut = abs($_vincenzo->get_row("SELECT SUM(coin) as total FROM `history_withdraw` WHERE username = '{$item['username']}' AND status = 'Thành Công'")['total'] ?? 0);
                                    $tong_huong_km = $_vincenzo->get_row("SELECT SUM(coin) as total FROM `point_status` WHERE username = '{$item['username']}' AND note LIKE '%Quà tặng%'")['total'] ?? 0;
                                    $tong_admin_cong = $_vincenzo->get_row("SELECT SUM(coin) as total FROM `point_status` WHERE username = '{$item['username']}' AND note LIKE '%Hệ thống cộng%'" )['total'] ?? 0;
                                    $tong_admin_tru = abs($_vincenzo->get_row("SELECT SUM(coin) as total FROM `point_status` WHERE username = '{$item['username']}' AND note LIKE '%Hệ thống trừ%'" )['total'] ?? 0);
                                ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar bg-primary me-3"><?= get_avatar_text($item['username']) ?></div>
                                                <div>
                                                    <span class="text-white fw-bold"><?= htmlspecialchars($item['username']) ?></span>
                                                    <div class="text-white-50 small">ID: #<?= $item['id'] ?></div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-end">
                                            <strong class="text-success fs-6"><?= format_money_new($item['coin']) ?>đ</strong>
                                        </td>
                                        <td>
                                            <div class="small">
                                                <div class="d-flex justify-content-between"><span>Nạp:</span> <span class="text-info"><?= format_money_new($total_nap) ?>đ</span></div>
                                                <div class="d-flex justify-content-between"><span>Rút:</span> <span class="text-warning"><?= format_money_new($total_rut) ?>đ</span></div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="small">
                                                <div class="d-flex justify-content-between"><span>Cộng:</span> <span class="text-primary-emphasis"><?= format_money_new($tong_admin_cong) ?>đ</span></div>
                                                <div class="d-flex justify-content-between"><span>Trừ:</span> <span class="text-danger"><?= format_money_new($tong_admin_tru) ?>đ</span></div>
                                            </div>
                                        </td>
                                        <td>
                                            <?= status_members_new($item['status']) ?>
                                        </td>
                                        <td class="text-center">
                                            <!-- === DẢI NÚT HÀNH ĐỘNG GỐC ĐƯỢC KHÔI PHỤC VÀ TÙY CHỈNH LẠI === -->
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="./cong-tru-sodu.php?id=<?= $item['id'] ?>" class="btn btn-outline-success" title="Cộng/Trừ tiền" data-bs-toggle="tooltip">
                                                    <i class="fas fa-coins"></i>
                                                </a>
                                                <?php if ($item['status'] == 1): ?>
                                                    <a href="./block-member.php?id=<?= $item['id'] ?>" class="btn btn-outline-warning" title="Khóa tài khoản" onclick="return confirm('Bạn có chắc muốn KHÓA tài khoản <?= htmlspecialchars($item['username']) ?>?');" data-bs-toggle="tooltip">
                                                        <i class="fas fa-lock"></i>
                                                    </a>
                                                <?php else: ?>
                                                    <a href="./unblock-member.php?id=<?= $item['id'] ?>" class="btn btn-outline-primary" title="Mở khóa tài khoản" onclick="return confirm('Bạn có chắc muốn MỞ KHÓA tài khoản <?= htmlspecialchars($item['username']) ?>?');" data-bs-toggle="tooltip">
                                                        <i class="fas fa-lock-open"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <a href="./edit-member.php?id=<?= $item['id'] ?>" class="btn btn-outline-info" title="Chỉnh sửa thông tin" data-bs-toggle="tooltip">
                                                    <i class="fas fa-user-edit"></i>
                                                </a>
                                                <button class="btn btn-outline-secondary" title="Xem chi tiết" data-bs-toggle="tooltip" onclick="viewDetail(<?= $item['id'] ?>)">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                                <a href="./delete-member.php?id=<?= $item['id'] ?>" class="btn btn-outline-danger" title="Xóa tài khoản" onclick="return confirm('Bạn có chắc chắn muốn XÓA tài khoản <?= htmlspecialchars($item['username']) ?>?');" data-bs-toggle="tooltip">
                                                    <i class="fas fa-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php if ($total_pages > 1): ?>
            <div class="card-footer bg-transparent py-3">
                <div class="d-flex justify-content-between align-items-center">
                    <small>Hiển thị <?= ($offset + 1) ?> - <?= min($offset + $per_page, $total_items) ?> / <?= number_format($total_items) ?></small>
                    <!-- Phân trang đầy đủ được khôi phục -->
                    <nav>
                        <ul class="pagination pagination-sm mb-0">
                            <li class="page-item <?= ($current_page <= 1) ? 'disabled' : '' ?>">
                                <a class="page-link" href="?page=<?= $current_page - 1 ?><?= $search_param ?>"><i class="fas fa-chevron-left"></i></a>
                            </li>
                            <?php 
                                $start_page = max(1, $current_page - 2);
                                $end_page = min($total_pages, $current_page + 2);
                                if ($start_page > 1): ?>
                                    <li class="page-item"><a class="page-link" href="?page=1<?= $search_param ?>">1</a></li>
                                    <?php if ($start_page > 2): ?><li class="page-item disabled"><span class="page-link">...</span></li><?php endif; ?>
                                <?php endif; ?>
                                <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
                                    <li class="page-item <?= ($i == $current_page) ? 'active' : '' ?>">
                                        <a class="page-link" href="?page=<?= $i ?><?= $search_param ?>"><?= $i ?></a>
                                    </li>
                                <?php endfor; ?>
                                <?php if ($end_page < $total_pages): ?>
                                    <?php if ($end_page < $total_pages - 1): ?><li class="page-item disabled"><span class="page-link">...</span></li><?php endif; ?>
                                    <li class="page-item"><a class="page-link" href="?page=<?= $total_pages ?><?= $search_param ?>"><?= $total_pages ?></a></li>
                                <?php endif; ?>
                            <li class="page-item <?= ($current_page >= $total_pages) ? 'disabled' : '' ?>">
                                <a class="page-link" href="?page=<?= $current_page + 1 ?><?= $search_param ?>"><i class="fas fa-chevron-right"></i></a>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    // Kích hoạt Tooltip của Bootstrap
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
// Hàm xem chi tiết cũ của bạn
function viewDetail(id) {
    alert('Xem chi tiết UID: ' + id);
}
</script>

<?php
require_once __DIR__ . "/foot.php";
?>