<?php
// Tải các tệp cấu hình và hàm cần thiết.
// File function.php sẽ tự động nạp config.php và khởi tạo đối tượng $_vincenzo
require_once '../config/function.php';

// Tải phần head của trang (chứa header và sidebar)
require_once __DIR__ . "/head.php";

// --- BẮT ĐẦU TRUY VẤN DỮ LIỆU SỬ DỤNG LỚP VINCENZO ---
// Chỉ thực hiện khi người dùng đã đăng nhập
if (isset($_SESSION['username'])) {
    $username = $_SESSION['username'];
    
    // Lấy thông tin IP đã lưu của người dùng
    $currentUser = $_vincenzo->get_row("SELECT `ipaddress` FROM `users` WHERE `username` = '{$username}'");
    
    // Lấy IP hiện tại của người dùng
    $newIp = $_SERVER['REMOTE_ADDR'];
    
    // So sánh IP cũ và mới. Chỉ cập nhật nếu chúng khác nhau.
    if ($currentUser && $currentUser['ipaddress'] !== $newIp) {
        
        // Gọi hàm getLocationFromIP (hàm này phải có trong /config/function.php)
        $newLocation = getLocationFromIP($newIp);
        
        // Chuẩn bị dữ liệu để cập nhật
        $updateData = ['ipaddress' => $newIp];
        if ($newLocation !== null) {
            $updateData['city'] = $newLocation;
        }
        
        // Cập nhật vào cơ sở dữ liệu
        $_vincenzo->update('users', $updateData, "`username` = '{$username}'");
    }
}

// 1. Thống kê các ô thông tin chính
$totalUsersResult = $_vincenzo->get_row("SELECT COUNT(id) as total FROM users");
$totalUsers = $totalUsersResult['total'] ?? 0;

$profitData = $_vincenzo->get_row("SELECT SUM(bet_amount) as total_bet, SUM(win_amount) as total_win FROM user_bets");
$netProfit = ($profitData['total_bet'] ?? 0) - ($profitData['total_win'] ?? 0);

$pendingWithdrawalsResult = $_vincenzo->get_row("SELECT COUNT(id) as total FROM history_withdraw WHERE status = 'Đang Duyệt'");
$pendingWithdrawals = $pendingWithdrawalsResult['total'] ?? 0;

$today = date('Y-m-d');
$newUsersTodayResult = $_vincenzo->get_row("SELECT COUNT(id) as total FROM users WHERE DATE(date) = '$today'");
$newUsersToday = $newUsersTodayResult['total'] ?? 0;


// 2. Dữ liệu cho biểu đồ doanh thu (7 ngày qua)
$chartLabels = [];
$totalBetData = [];
$totalWinData = [];
for ($i = 6; $i >= 0; $i--) {
    $date = date('Y-m-d', strtotime("-$i days"));
    $dayLabel = date('d/m', strtotime("-$i days"));
    $chartLabels[] = $dayLabel;

    $dailyData = $_vincenzo->get_row("SELECT SUM(bet_amount) as daily_bet, SUM(win_amount) as daily_win FROM user_bets WHERE DATE(bet_time) = '$date'");
    
    $totalBetData[] = $dailyData['daily_bet'] ?? 0;
    $totalWinData[] = $dailyData['daily_win'] ?? 0;
}


// 3. Lấy 5 yêu cầu rút tiền mới nhất
$recentWithdrawals = $_vincenzo->get_list("SELECT * FROM history_withdraw ORDER BY date DESC LIMIT 5");

// 4. Lấy 5 thành viên mới nhất
$newestMembers = $_vincenzo->get_list("SELECT * FROM users ORDER BY id DESC LIMIT 5");

// --- KẾT THÚC TRUY VẤN DỮ LIỆU ---
?>

<!--begin::App Content Header-->
<div class="app-content-header">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-6">
                <h3 class="mb-0">Bảng Điều Khiển Tổng Quan</h3>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-end">
                    <li class="breadcrumb-item"><a href="#">Trang chủ</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Bảng điều khiển</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<!--end::App Content Header-->

<!--begin::App Content-->
<div class="app-content">
    <div class="container-fluid">
        <!-- Hàng thống kê nhanh -->
        <div class="row">
            <div class="col-12 col-md-6 col-xl-3 mb-4">
                <div class="small-box text-bg-primary h-100">
                    <div class="inner">
                        <h3><?= format_money($totalUsers) ?></h3>
                        <p>Tổng Người Chơi</p>
                    </div>
                    <div class="icon"><i class="fa-solid fa-users"></i></div>
                    <a href="./members.php" class="small-box-footer link-light">Xem chi tiết <i class="bi bi-arrow-right-circle-fill"></i></a>
                </div>
            </div>
            <div class="col-12 col-md-6 col-xl-3 mb-4">
                <div class="small-box text-bg-success h-100">
                    <div class="inner">
                        <h3><?= format_money($netProfit) ?><sup class="fs-6"> đ</sup></h3>
                        <p>Lợi Nhuận Ròng</p>
                    </div>
                    <div class="icon"><i class="fa-solid fa-sack-dollar"></i></div>
                    <a href="./thongke.php" class="small-box-footer link-light">Xem chi tiết <i class="bi bi-arrow-right-circle-fill"></i></a>
                </div>
            </div>
            <div class="col-12 col-md-6 col-xl-3 mb-4">
                <div class="small-box text-bg-warning h-100">
                    <div class="inner">
                        <h3><?= format_money($pendingWithdrawals) ?></h3>
                        <p>Yêu Cầu Rút Tiền Mới</p>
                    </div>
                    <div class="icon"><i class="fa-solid fa-hourglass-half"></i></div>
                    <a href="./rut-tien.php" class="small-box-footer link-dark">Xem chi tiết <i class="bi bi-arrow-right-circle-fill"></i></a>
                </div>
            </div>
            <div class="col-12 col-md-6 col-xl-3 mb-4">
                <div class="small-box text-bg-danger h-100">
                    <div class="inner">
                        <h3>+<?= format_money($newUsersToday) ?></h3>
                        <p>Người Dùng Mới Hôm Nay</p>
                    </div>
                    <div class="icon"><i class="fa-solid fa-user-plus"></i></div>
                    <a href="./members.php" class="small-box-footer link-light">Xem chi tiết <i class="bi bi-arrow-right-circle-fill"></i></a>
                </div>
            </div>
        </div>
        <!-- Kết thúc hàng thống kê -->

        <!-- Hàng nội dung chính -->
        <div class="row">
            <!-- Cột trái -->
            <section class="col-lg-7 mb-4">
                <!-- Biểu đồ doanh thu -->
                <div class="card h-100">
                    <div class="card-header"><h3 class="card-title"><i class="fas fa-chart-line me-1"></i>Thống Kê Cược (7 Ngày Gần Nhất)</h3></div>
                    <div class="card-body"><div id="revenue-chart" style="height: 300px;"></div></div>
                </div>
            </section>
            <!-- /.Cột trái -->

            <!-- Cột phải -->
            <section class="col-lg-5 mb-4">
                <!-- Thống kê nền tảng -->
                <div class="card h-100">
                    <div class="card-header"><h3 class="card-title"><i class="fa-solid fa-chart-pie me-1"></i>Thống Kê Nền Tảng</h3></div>
                    <div class="card-body">
                        <?php
                            $totalBetsCount = $_vincenzo->get_row("SELECT COUNT(id) as total FROM user_bets")['total'] ?? 0;
                            $wonBets = $_vincenzo->get_row("SELECT COUNT(id) as total FROM user_bets WHERE status = 'won'")['total'] ?? 0;
                            $lostBets = $_vincenzo->get_row("SELECT COUNT(id) as total FROM user_bets WHERE status = 'lost'")['total'] ?? 0;
                            $winRate = ($totalBetsCount > 0) ? ($wonBets / $totalBetsCount) * 100 : 0;
                        ?>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex justify-content-between align-items-center">Tổng số lượt cược <span class="badge bg-primary rounded-pill"><?= format_money($totalBetsCount) ?></span></li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">Lượt cược thắng <span class="badge bg-success rounded-pill"><?= format_money($wonBets) ?></span></li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">Lượt cược thua <span class="badge bg-danger rounded-pill"><?= format_money($lostBets) ?></span></li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">Tỉ lệ thắng <span class="badge bg-info rounded-pill"><?= round($winRate, 2) ?>%</span></li>
                        </ul>
                    </div>
                </div>
            </section>
            <!-- /.Cột phải -->
        </div>

        <div class="row">
            <!-- Yêu cầu rút tiền mới nhất -->
            <div class="col-lg-7 mb-4">
                <div class="card">
                    <div class="card-header"><h3 class="card-title"><i class="fa-solid fa-wallet me-1"></i>Yêu Cầu Rút Tiền Mới Nhất</h3></div>
                    <div class="card-body table-responsive p-0">
                        <table class="table table-striped table-valign-middle">
                            <thead><tr><th>Người chơi</th><th>Số tiền</th><th>Ngân hàng</th><th>Thời gian</th><th>Trạng thái</th></tr></thead>
                            <tbody>
                                <?php if (!empty($recentWithdrawals)): ?>
                                    <?php foreach ($recentWithdrawals as $row) : ?>
                                    <tr>
                                        <td><?= htmlspecialchars($row['username']) ?></td>
                                        <td><?= format_money($row['coin']) ?> đ</td>
                                        <td>
                                            <?= htmlspecialchars($row['bank_name']) ?><br>
                                            <small><?= htmlspecialchars($row['stk_bank']) ?> - <?= htmlspecialchars($row['name_bank']) ?></small>
                                        </td>
                                        <td><?= date('d/m H:i', strtotime($row['date'])) ?></td>
                                        <td><?= status_ruttien($row['status']) ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr><td colspan="5" class="text-center">Không có yêu cầu nào.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Thành viên mới nhất -->
            <div class="col-lg-5 mb-4">
                <div class="card">
                    <div class="card-header"><h3 class="card-title"><i class="fa-solid fa-user-group me-1"></i>Thành Viên Mới Nhất</h3></div>
                    <div class="card-body p-0">
                         <ul class="list-group list-group-flush">
                             <?php if (!empty($newestMembers)): ?>
                                 <?php foreach ($newestMembers as $row) : ?>
                                    <li class="list-group-item">
                                        <div class="d-flex w-100 justify-content-between">
                                            <h6 class="mb-1"><i class="fa-solid fa-user text-secondary"></i> <?= htmlspecialchars($row['username']) ?></h6>
                                            <small class="text-muted"><?= date('d/m/Y', strtotime($row['date'])) ?></small>
                                        </div>
                                        <small class="text-muted">Đăng ký từ: <?= htmlspecialchars($row['city'] ?? 'Không rõ') ?></small>
                                    </li>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <li class="list-group-item text-center">Không có thành viên mới.</li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<!--end::App Content-->


<!-- Script cho biểu đồ (Không thay đổi) -->
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Chỉ render biểu đồ nếu có phần tử #revenue-chart trên trang
        const revenueChartEl = document.querySelector("#revenue-chart");
        if (revenueChartEl) {
            var options = {
                series: [{
                    name: 'Tổng Cược',
                    data: <?= json_encode($totalBetData) ?>
                }, {
                    name: 'Tổng Thắng',
                    data: <?= json_encode($totalWinData) ?>
                }],
                chart: { height: 300, type: 'area', toolbar: { show: false }},
                dataLabels: { enabled: false },
                stroke: { curve: 'smooth' },
                xaxis: { type: 'category', categories: <?= json_encode($chartLabels) ?> },
                yaxis: {
                    labels: {
                        formatter: function (value) { return new Intl.NumberFormat('vi-VN').format(value) + " đ"; }
                    },
                },
                tooltip: {
                    y: {
                        formatter: function (val) { return new Intl.NumberFormat('vi-VN').format(val) + " đ" }
                    }
                },
                colors: ['#007bff', '#28a745'],
                legend: { position: 'top', horizontalAlign: 'right', floating: true, offsetY: -25, offsetX: -5 }
            };

            var chart = new ApexCharts(revenueChartEl, options);
            chart.render();
        }
    });
</script>

<?php
// DÒNG QUAN TRỌNG NHẤT: Nạp footer để các script và chức năng giao diện hoạt động
require_once __DIR__ . "/foot.php";
?>