</main>
        <!--end::App Main-->

        <!--begin::Footer-->
        <footer class="app-footer">
            <div class="float-end d-none d-sm-inline">Anything you want</div>
            <strong>
                Copyright &copy; 2014-2025&nbsp;
                <a href="https://adminlte.io" class="text-decoration-none">AdminLTE.io</a>.
            </strong>
            All rights reserved.
        </footer>
        <!--end::Footer-->
    </div>
    <!--end::App Wrapper-->

    <!-- =============================================================================== -->
    <!-- BẮT ĐẦU KHỐI SCRIPT GỐC - GIỮ NGUYÊN THEO YÊU CẦU -->
    <!-- =============================================================================== -->
    
    <!--begin::Third Party Plugin(OverlayScrollbars)-->
    <script src="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.11.0/browser/overlayscrollbars.browser.es6.min.js" crossorigin="anonymous"></script>
    
    <!--begin::Required Plugin(popperjs for Bootstrap 5)-->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" crossorigin="anonymous"></script>
    
    <!--begin::Required Plugin(Bootstrap 5)-->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.min.js" crossorigin="anonymous"></script>
    
    <!--begin::Required Plugin(AdminLTE) - Rất quan trọng cho chức năng giao diện -->
    <script src="/admin/js/adminlte.js"></script>
    
    <!--begin::jQuery-->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Bootstrap JS Bundle (Lưu ý: Đã bao gồm Popper.js) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <!-- Logic khởi tạo Select2 (Giữ nguyên) -->
    <script>
        $(document).ready(function() {
            // Chỉ chạy nếu phần tử tồn tại để tránh lỗi
            if ($('#bankSelect').length) {
                $('#bankSelect').select2({
                    placeholder: '-- Chọn ngân hàng --',
                    allowClear: true,
                    width: '100%',
                    matcher: function(params, data) {
                        if ($.trim(params.term) === '') return data;
                        if (typeof data.text === 'string') {
                            var term = params.term.toLowerCase();
                            var text = data.text.toLowerCase();
                            if (text.indexOf(term) > -1) return data;
                        }
                        return null;
                    },
                    templateResult: formatBankOption,
                    templateSelection: formatBankSelection
                });
            }
        });

        function formatBankOption(bank) {
            if (!bank.id) return bank.text;
            var imgSrc = $(bank.element).data('img');
            return $('<div class="d-flex align-items-center"><img src="' + imgSrc + '" class="img-bank me-2" style="width:24px" onerror="this.style.display=\'none\'" /><span>' + bank.text + '</span></div>');
        }

        function formatBankSelection(bank) {
            if (!bank.id) return bank.text;
            var imgSrc = $(bank.element).data('img');
            return $('<div class="d-flex align-items-center"><img src="' + imgSrc + '" class="img-bank me-2" style="width:20px" onerror="this.style.display=\'none\'" /><span>' + bank.text + '</span></div>');
        }
    </script>
    
    <!-- Logic khởi tạo OverlayScrollbars (Giữ nguyên) -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarWrapper = document.querySelector('.sidebar-wrapper');
            if (sidebarWrapper && typeof OverlayScrollbarsGlobal?.OverlayScrollbars !== 'undefined') {
                OverlayScrollbarsGlobal.OverlayScrollbars(sidebarWrapper, {
                    scrollbars: {
                        theme: 'os-theme-light',
                        autoHide: 'leave',
                        clickScroll: true,
                    },
                });
            }
        });
    </script>

    <!-- OPTIONAL SCRIPTS (Giữ nguyên) -->
    <!-- sortablejs -->
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js" crossorigin="anonymous"></script>
    <script>
        // Chỉ chạy nếu có phần tử .connectedSortable để tránh lỗi
        const sortableElement = document.querySelector('.connectedSortable');
        if (sortableElement) {
            new Sortable(sortableElement, {
                group: 'shared',
                handle: '.card-header',
            });
            const cardHeaders = document.querySelectorAll('.connectedSortable .card-header');
            cardHeaders.forEach((cardHeader) => {
                cardHeader.style.cursor = 'move';
            });
        }
    </script>

    <!-- apexcharts -->
    <script src="https://cdn.jsdelivr.net/npm/apexcharts@3.37.1/dist/apexcharts.min.js"></script>
    
    <!-- jsvectormap -->
    <script src="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/js/jsvectormap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/maps/world.js"></script>

    <!-- Logic khởi tạo các biểu đồ (Giữ nguyên) -->
    <script>
        // Sales Chart (Lưu ý: index.php đã có phiên bản động của biểu đồ này)
        const revenueChartElement = document.querySelector('#revenue-chart');
        if (revenueChartElement) {
            // Đoạn mã này sẽ không chạy nếu script trong index.php đã render biểu đồ rồi.
            // Tuy nhiên, nó được giữ lại để đảm bảo logic gốc không bị mất.
            if (!revenueChartElement.hasChildNodes()) {
                const sales_chart_options = {
                    series: [{ name: 'Digital Goods', data: [28, 48, 40, 19, 86, 27, 90] }, { name: 'Electronics', data: [65, 59, 80, 81, 56, 55, 40] }],
                    chart: { height: 300, type: 'area', toolbar: { show: false } },
                    legend: { show: false },
                    colors: ['#0d6efd', '#20c997'],
                    dataLabels: { enabled: false },
                    stroke: { curve: 'smooth' },
                    xaxis: { type: 'datetime', categories: ['2023-01-01', '2023-02-01', '2023-03-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-07-01'] },
                    tooltip: { x: { format: 'MMMM yyyy' } },
                };
                const sales_chart = new ApexCharts(revenueChartElement, sales_chart_options);
                sales_chart.render();
            }
        }

        // World map
        if (document.querySelector('#world-map')) {
            new jsVectorMap({ selector: '#world-map', map: 'world' });
        }

        // Sparkline charts
        if (document.querySelector('#sparkline-1')) {
            new ApexCharts(document.querySelector('#sparkline-1'), { series: [{ data: [1000, 1200, 920, 927, 931, 1027, 819, 930, 1021] }], chart: { type: 'area', height: 50, sparkline: { enabled: true } }, stroke: { curve: 'straight' }, fill: { opacity: 0.3 }, yaxis: { min: 0 }, colors: ['#DCE6EC'] }).render();
        }
        if (document.querySelector('#sparkline-2')) {
            new ApexCharts(document.querySelector('#sparkline-2'), { series: [{ data: [515, 519, 520, 522, 652, 810, 370, 627, 319, 630, 921] }], chart: { type: 'area', height: 50, sparkline: { enabled: true } }, stroke: { curve: 'straight' }, fill: { opacity: 0.3 }, yaxis: { min: 0 }, colors: ['#DCE6EC'] }).render();
        }
        if (document.querySelector('#sparkline-3')) {
            new ApexCharts(document.querySelector('#sparkline-3'), { series: [{ data: [15, 19, 20, 22, 33, 27, 31, 27, 19, 30, 21] }], chart: { type: 'area', height: 50, sparkline: { enabled: true } }, stroke: { curve: 'straight' }, fill: { opacity: 0.3 }, yaxis: { min: 0 }, colors: ['#DCE6EC'] }).render();
        }
    </script>

</body>
</html>