<?php
require_once __DIR__ . "/head.php";

// Get current chat user ID from GET
$user_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Mark as read if user_id provided
if ($user_id > 0) {
    $_vincenzo->query("UPDATE chat_messages SET is_read = 1 WHERE sender_id = $user_id AND sender_type = 'user' AND is_read = 0");
}

// Get user info
$current_username = '';
if ($user_id > 0) {
    $user_query = $_vincenzo->get_row("SELECT username, city FROM users WHERE id = $user_id");
    $current_username = $user_query['username'] ?? 'Unknown';
}
?>

<style>
    /* Style cho giao diện chat dark theme */
    .app-content {
        display: flex;
        flex-direction: column;
        min-height: calc(100vh - 120px);
    }
    .chat-container {
        flex: 1;
        display: flex;
        height: 100%;
    }
    .chat-main {
        background-color: #0d1117;
        color: white;
        flex: 1;
        display: flex;
        flex-direction: column;
        height: 100%;
        min-height: 0;
    }
    .direct-chat-messages {
        flex: 1;
        overflow-y: auto;
        padding: 10px;
        background-color: #0d1117;
        min-height: 0;
    }
    .direct-chat-msg.right .direct-chat-text {
        background-color: #17a2b8 !important;
        border-color: #17a2b8 !important;
        color: white !important;
    }
    .direct-chat-msg.left .direct-chat-text {
        background-color: #30363d !important;
        border-color: #30363d !important;
        color: white !important;
    }
    .direct-chat-text {
        border-radius: 10px;
        padding: 10px;
        max-width: 70%;
    }
    .card-primary.card-outline {
        border-color: #17a2b8;
        background-color: #21262d;
        flex: 1;
        display: flex;
        flex-direction: column;
        height: 100%;
        margin: 0;
    }
    .card-header {
        background-color: #21262d;
        border-bottom-color: #30363d;
        flex-shrink: 0;
    }
    .card-body {
        flex: 1;
        display: flex;
        flex-direction: column;
        overflow: hidden;
        min-height: 0;
    }
    .card-footer {
        background-color: #21262d;
        border-top-color: #30363d;
        flex-shrink: 0;
    }
    .form-control {
        background-color: #30363d;
        border-color: #30363d;
        color: white;
        overflow: hidden;
    }
    .form-control:focus {
        background-color: #30363d;
        border-color: #17a2b8;
        color: white;
    }
    .btn-primary {
        background-color: #17a2b8;
        border-color: #17a2b8;
    }
    #imagePreviewContainer {
        display: flex;
        flex-wrap: wrap;
        margin-top: 10px;
        gap: 5px;
        flex-shrink: 0;
        max-height: 100px;
        overflow-y: auto;
    }
    .btn-outline-secondary {
        color: #ccc;
        border-color: #30363d;
    }
    .btn-outline-secondary:hover {
        background-color: #30363d;
        color: white;
    }
    #noChatSelected {
        flex: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }
</style>

<div class="app-content-header">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-6">
                <h3 class="mb-0">Chat với <?= htmlspecialchars($current_username); ?></h3>
            </div>
        </div>
    </div>
</div>

<div class="app-content">
    <div class="container-fluid chat-container">
        <div class="row">
            <div class="col-md-12">
                <div class="chat-main" id="chatMain">
                    <?php if ($user_id == 0): ?>
                        <div id="noChatSelected" class="text-center text-muted">
                            <div>
                                <h5>Không có cuộc chat được chọn</h5>
                                <p>Vui lòng chọn một người dùng để chat.</p>
                            </div>
                        </div>
                    <?php else: ?>
                        <div id="chatCard" class="card card-primary card-outline">
                            <div class="card-header p-0 border-bottom-0">
                                <h1 class="m-0" style="padding: 15px; color: white;">Chat với <?= htmlspecialchars($current_username); ?></h1>
                                <ul class="nav nav-tabs" id="chat-tab" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="chat-tab-pane" data-bs-toggle="pill" data-bs-target="#chat-tab-pane" type="button" role="tab">Tin nhắn</button>
                                    </li>
                                </ul>
                            </div>
                            <div class="card-body">
                                <div class="tab-content" id="chat-tab-content">
                                    <div class="tab-pane fade show active" id="chat-tab-pane" role="tabpanel">
                                        <!-- Chat Messages Container -->
                                        <div id="chatMessages" class="direct-chat-messages">
                                            <!-- Messages load via JS -->
                                        </div>

                                        <!-- Image Preview Container -->
                                        <div id="imagePreviewContainer">
                                            <!-- Previews load via JS -->
                                        </div>

                                        <!-- Chat Input Form -->
                                        <div class="card-footer">
                                            <form id="chatForm">
                                                <div class="input-group">
                                                    <textarea
                                                        class="form-control"
                                                        placeholder="Viết tin nhắn..."
                                                        name="message"
                                                        id="chatInput"
                                                        rows="1"
                                                        style="resize: none; overflow-y: auto; min-height: 38px; max-height: 120px;"></textarea>
                                                    <div class="input-group-append">
                                                        <button type="button" class="btn btn-outline-secondary" id="emojiButton" title="Chèn emoji">
                                                            <i class="fas fa-smile"></i>
                                                        </button>
                                                        <label for="fileInput" class="btn btn-outline-secondary" title="Tải lên hình ảnh">
                                                            <i class="fas fa-image"></i>
                                                            <input type="file"
                                                                id="fileInput"
                                                                class="d-none"
                                                                accept="image/*"
                                                                name="images[]"
                                                                multiple>
                                                        </label>
                                                        <button type="button" class="btn btn-primary" id="sendButton" title="Gửi">
                                                            <i class="fas fa-paper-plane"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // JS từ chat.php, compatible với cskh.php
    let currentChatId = <?= $user_id; ?>;
    let currentUsername = '<?= htmlspecialchars($current_username); ?>';
    const chatMessages = document.getElementById("chatMessages");
    const chatInput = document.getElementById("chatInput");
    const sendButton = document.getElementById("sendButton");
    const fileInput = document.getElementById("fileInput");
    const imagePreviewContainer = document.getElementById("imagePreviewContainer");
    const noChatSelected = document.getElementById("noChatSelected");
    const chatCard = document.getElementById("chatCard");

    let isUserAtBottom = true;

    function isNearBottom() {
        return chatMessages.scrollHeight - chatMessages.scrollTop <= chatMessages.clientHeight + 50;
    }

    function scrollToBottom(force = false) {
        if (force || isUserAtBottom) {
            chatMessages.scrollTop = chatMessages.scrollHeight;
        }
    }

    chatMessages.addEventListener("scroll", function() {
        isUserAtBottom = isNearBottom();
    });

    // Auto-resize textarea
    function autoResize() {
        chatInput.style.height = 'auto';
        chatInput.style.height = Math.min(chatInput.scrollHeight, 120) + 'px';
    }

    chatInput.addEventListener("input", autoResize);

    chatInput.addEventListener("keypress", function(e) {
        if (e.key === "Enter" && !e.shiftKey) {
            e.preventDefault();
            sendButton.click();
        }
    });

    fileInput.addEventListener("change", function(event) {
        imagePreviewContainer.innerHTML = "";
        const files = event.target.files;
        Array.from(files).forEach(file => {
            if (file.type.startsWith("image/")) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement("img");
                    img.src = e.target.result;
                    img.alt = file.name;
                    img.style.maxWidth = "60px";
                    img.style.maxHeight = "60px";
                    img.style.margin = "5px";
                    img.classList.add("border", "rounded", "p-1");
                    imagePreviewContainer.appendChild(img);
                };
                reader.readAsDataURL(file);
            }
        });
    });

    function loadChatMessages() {
        if (currentChatId === 0) return;
        fetch(`chat_load_messages.php?id=${currentChatId}`)
            .then(response => response.text())
            .then(html => {
                chatMessages.innerHTML = html;
                scrollToBottom(true);
            })
            .catch(error => console.error("Lỗi khi tải tin nhắn:", error));
    }

    // Send message via AJAX
    sendButton.addEventListener("click", function() {
        if (!currentChatId || (chatInput.value.trim() === '' && fileInput.files.length === 0)) return;
        const formData = new FormData();
        formData.append('user_id', currentChatId);
        formData.append('message', chatInput.value.trim());
        Array.from(fileInput.files).forEach(file => formData.append('images[]', file));

        fetch('send_message.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                chatInput.value = '';
                fileInput.value = '';
                imagePreviewContainer.innerHTML = '';
                autoResize();
                loadChatMessages();
            } else {
                alert('Lỗi gửi tin nhắn: ' + (data.error || 'Unknown'));
            }
        })
        .catch(error => console.error('Error:', error));
    });

    let pollingInterval;
    function startChatPolling() {
        if (pollingInterval) clearInterval(pollingInterval);
        pollingInterval = setInterval(() => {
            if (currentChatId > 0) loadChatMessages();
        }, 10000);
    }

    // Initial load
    if (currentChatId > 0) {
        loadChatMessages();
        startChatPolling();
    }

    // Initial auto-resize
    autoResize();
</script>

<?php require_once __DIR__ . "/foot.php"; ?>