<?php
// manager-game-bom3p.php - FIXED: Chỉ sửa backend, giữ nguyên giao diện
require_once 'head.php';

// Handle POST for edit result
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'edit_result') {
    $id = (int)($_POST['id'] ?? 0);
    $results = array_map('intval', $_POST['results'] ?? []);
    
    if ($id > 0 && count($results) === 5) {
        $result_str = implode(',', $results);
        
        // Cập nhật kết quả và đánh dấu finished
        $update_query = "UPDATE `game_sessions` SET `result` = '{$result_str}', `status` = 'finished' WHERE `id` = {$id}";
        $vincenzo->query($update_query);
        
        // Xử lý cược
        $sum = array_sum($results);
        $last_digit = $sum % 10;
        $winner = ($last_digit >= 5) ? 'TH TRUEMILK' : 'VINAMILK';
        $multiplier = 1.95;
        
        // Cập nhật kết quả cược
        $bets = $vincenzo->get_list("SELECT * FROM `user_bets` WHERE `session_id` = {$id} AND `status` = 'running'");
        foreach ($bets as $bet) {
            if ($bet['bet_type'] == $winner) {
                $win_amount = $bet['bet_amount'] * $multiplier;
                $vincenzo->update('user_bets', [
                    'status' => 'won',
                    'win_amount' => $win_amount
                ], "`id` = " . $bet['id']);
                
                $vincenzo->cong('users', 'coin', $win_amount, "`username` = '" . $vincenzo->escape_string($bet['username']) . "'");
            } else {
                $vincenzo->update('user_bets', ['status' => 'lost'], "`id` = " . $bet['id']);
            }
        }
        
        header('Location: ' . $_SERVER['PHP_SELF'] . '?page=' . ($_GET['page'] ?? 1));
        exit;
    }
}

// Phân trang
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;

$perPage = 15;

// SỬA: Dùng get_row thay vì get_one
$totalGamesRow = $vincenzo->get_row("SELECT COUNT(id) as total FROM `game_sessions`");
$totalGames = $totalGamesRow['total'] ?? 0;

$totalPages = ceil($totalGames / $perPage);
if ($page > $totalPages && $totalPages > 0) $page = $totalPages;
$offset = ($page - 1) * $perPage;

$game_sessions = $vincenzo->get_list("SELECT * FROM `game_sessions` ORDER BY `id` DESC LIMIT {$offset}, {$perPage}");

function generatePagination($currentPage, $totalPages) {
    if ($totalPages <= 1) return '';

    $html = '<nav><ul class="pagination justify-content-center">';
    $window = 1;

    if ($currentPage > $window + 2) {
        $html .= '<li class="page-item"><a class="page-link" href="?page=1">1</a></li>';
        $html .= '<li class="page-item disabled"><span class="page-link">...</span></li>';
    }

    for ($i = max(1, $currentPage - $window); $i <= min($totalPages, $currentPage + $window); $i++) {
        $html .= '<li class="page-item ' . ($i == $currentPage ? 'active' : '') . '"><a class="page-link" href="?page=' . $i . '">' . $i . '</a></li>';
    }

    if ($currentPage < $totalPages - $window) {
        if ($currentPage < $totalPages - $window - 1) {
            $html .= '<li class="page-item disabled"><span class="page-link">...</span></li>';
        }
        $html .= '<li class="page-item"><a class="page-link" href="?page=' . $totalPages . '">' . $totalPages . '</a></li>';
    }
    
    if ($currentPage < $totalPages) {
        $html .= '<li class="page-item"><a class="page-link" href="?page=' . ($currentPage + 1) . '">&raquo;</a></li>';
    }

    $html .= '</ul></nav>';
    return $html;
}
?>

<div class="col-md-10">
    <h3 class="mb-3">Quản lý phiên 180 giây</h3>
    <div class="table-responsive">
        <table class="table table-bordered text-center">
            <thead class="thead-dark">
                <tr>
                    <th>Số kỳ</th> <th>Loại phiên</th> <th>Kết quả</th> <th>Đặt hàng</th> <th>Bắt đầu</th> <th>Kết thúc</th> <th>Trạng thái</th> <th>Tổng cược</th> <th>Tổng thắng</th> <th>Thao tác</th>
                </tr>
            </thead>
            <tbody id="gameTableBody">
                <?php if (count($game_sessions) > 0): ?>
                    <?php foreach ($game_sessions as $session): ?>
                        <?php
                            // --- LOGIC HIỂN THỊ MỚI - ƯU TIÊN CỘT STATUS ---
                            $status_from_db = $session['status'];
                            $status_html = '';
                            $result_bg_class = '';

                            switch ($status_from_db) {
                                case 'upcoming':
                                    $status_html = '<span class="badge badge-warning">Sắp chạy</span>';
                                    $result_bg_class = 'bg-warning';
                                    break;
                                
                                case 'running':
                                    $status_html = '<span class="badge badge-success">Đang chạy</span> ' .
                                                 '<span class="badge badge-danger countdown-timer" data-end-time="'. htmlspecialchars($session['end_time']) .'">--:--</span>';
                                    $result_bg_class = 'bg-success';
                                    break;

                                case 'finished':
                                default:
                                    $status_html = '<span class="badge badge-danger">Đã kết thúc</span>';
                                    $result_bg_class = 'bg-dark';
                                    break;
                            }
                            
                            $bet_info = $vincenzo->get_row("SELECT COUNT(id) as count, SUM(bet_amount) as amount, SUM(win_amount) as win_amount FROM `user_bets` WHERE `session_id` = '{$session['id']}'");
                            $result_numbers = explode(',', $session['result'] ?? '');
                            $result_numbers = array_pad(array_map('intval', $result_numbers), 5, 0); // Pad to 5
                            $display_numbers = $result_numbers; // Hiển thị tất cả 5 số
                            $sum_result = array_sum($result_numbers);
                            $last_digit = $sum_result % 10;
                            $winner_html = ($last_digit >= 5) ? "<strong class='text-uppercase text-danger'>THTRUE MILK</strong>" : "<strong class='text-uppercase text-dark'>VINAMILK</strong>";
                        ?>
                        <tr>
                            <td><?= htmlspecialchars($session['id']) ?></td>
                            <td><span class="badge badge-primary">180 giây</span></td>
                            <td>
                                <?php foreach($display_numbers as $num): ?>
                                    <span class='rounded-circle text-white mr-1 <?= $result_bg_class ?>' style='width: 30px; height: 30px; display: inline-flex; justify-content: center; align-items: center; font-weight: bold;'>
                                        <?= htmlspecialchars($num) ?>
                                    </span>
                                <?php endforeach; ?>
                            </td>
                            <td><?= $winner_html ?></td>
                            <td><?= htmlspecialchars($session['start_time']) ?></td>
                            <td><?= htmlspecialchars($session['end_time']) ?></td>
                            <td><?= $status_html ?></td>
                            <td><?= number_format($bet_info['amount'] ?? 0) ?> (<?= number_format($bet_info['count'] ?? 0) ?>)</td>
                            <td><?= number_format($bet_info['win_amount'] ?? 0) ?></td>
                            <td class="text-center">
                                <button class="btn btn-warning btn-sm edit-result-btn me-1" data-game-id="<?= $session['id'] ?>" data-result="<?= htmlspecialchars(implode(',', $result_numbers)) ?>" title="Sửa kết quả">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-danger btn-sm delete-game-btn" data-game-id="<?= $session['id'] ?>">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="10" class="text-center p-5">Không tìm thấy phiên game nào.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <!-- Hiển thị phân trang nâng cao -->
        <?php echo generatePagination($page, $totalPages); ?>

    </div>

    <!-- Modal sửa kết quả -->
    <div class="modal fade" id="editResultModal" tabindex="-1" aria-labelledby="editResultModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" id="editForm">
                    <input type="hidden" name="action" value="edit_result">
                    <input type="hidden" name="id" id="editSessionIdHidden">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editResultModalLabel">Chỉnh sửa kết quả phiên #<span id="editSessionId"></span></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row g-2">
                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                <div class="col-md-2">
                                    <label class="form-label">BOM <?= $i ?></label>
                                    <input type="number" class="form-control" name="results[]" min="0" max="9" required placeholder="0-9">
                                </div>
                            <?php endfor; ?>
                        </div>
                        <div class="mt-3">
                            <small class="text-muted">Nhập 5 số từ 0-9 để cập nhật kết quả.</small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                        <button type="submit" class="btn btn-warning">Lưu thay đổi</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- ================================================================================= -->
<!-- PHẦN 5: JAVASCRIPT CHO CÁC TÍNH NĂNG CỦA TRANG -->
<!-- ================================================================================= -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    initializeCountdowns();
    initActionButtons();
    initEditResult();
});

function initializeCountdowns() {
    document.querySelectorAll('.countdown-timer').forEach(el => {
        const endTime = new Date(el.dataset.endTime.replace(' ', 'T') + 'Z'); 
        const timerInterval = setInterval(() => {
            const remaining = endTime - new Date();
            if (remaining <= 0) {
                el.textContent = '00:00';
                clearInterval(timerInterval);
                setTimeout(() => window.location.reload(), 2000);
                return;
            }
            const minutes = Math.floor((remaining / 1000 / 60) % 60).toString().padStart(2, '0');
            const seconds = Math.floor((remaining / 1000) % 60).toString().padStart(2, '0');
            el.textContent = `${minutes}:${seconds}`;
        }, 1000);
    });
}

function initActionButtons() {
    document.querySelectorAll('.delete-game-btn').forEach(button => {
        button.addEventListener('click', function() {
            const gameId = this.dataset.gameId;
            Swal.fire({
                title: 'Bạn có chắc chắn?',
                text: `Hành động này sẽ xóa vĩnh viễn phiên #${gameId}!`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Xóa ngay',
                cancelButtonText: 'Hủy'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch('delete_game_bom3p.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({ game_id: gameId })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            Swal.fire('Đã xóa!', data.message, 'success').then(() => window.location.reload());
                        } else {
                            Swal.fire('Lỗi!', data.message, 'error');
                        }
                    });
                }
            });
        });
    });
}

function initEditResult() {
    const editModalElement = document.getElementById('editResultModal');
    let editModal;
    
    // Khởi tạo modal - tương thích cả Bootstrap 5 và 4
    if (typeof bootstrap !== 'undefined') {
        // Bootstrap 5
        editModal = new bootstrap.Modal(editModalElement);
    } else if (typeof $ !== 'undefined' && $.fn.modal) {
        // Bootstrap 4 với jQuery
        editModal = $(editModalElement);
    }
    
    document.querySelectorAll('.edit-result-btn').forEach(button => {
        button.addEventListener('click', function() {
            const gameId = this.dataset.gameId;
            const result = this.dataset.result.split(',');
            
            document.getElementById('editSessionId').textContent = gameId;
            document.getElementById('editSessionIdHidden').value = gameId;
            
            const inputs = document.querySelectorAll('#editForm input[name="results[]"]');
            inputs.forEach((input, idx) => {
                input.value = result[idx] || '';
            });
            
            // Hiển thị modal theo phiên bản Bootstrap
            if (typeof bootstrap !== 'undefined') {
                editModal.show(); // Bootstrap 5
            } else if (typeof $ !== 'undefined' && $.fn.modal) {
                editModal.modal('show'); // Bootstrap 4
            } else {
                // Fallback: thêm class manually
                editModalElement.classList.add('show');
                editModalElement.style.display = 'block';
                document.body.classList.add('modal-open');
                
                // Tạo backdrop
                const backdrop = document.createElement('div');
                backdrop.className = 'modal-backdrop fade show';
                backdrop.id = 'modal-backdrop-fallback';
                document.body.appendChild(backdrop);
            }
        });
    });
    
    // Xử lý đóng modal cho fallback
    editModalElement.querySelectorAll('[data-bs-dismiss="modal"], [data-dismiss="modal"]').forEach(btn => {
        btn.addEventListener('click', function() {
            if (typeof bootstrap === 'undefined' && (typeof $ === 'undefined' || !$.fn.modal)) {
                editModalElement.classList.remove('show');
                editModalElement.style.display = 'none';
                document.body.classList.remove('modal-open');
                const backdrop = document.getElementById('modal-backdrop-fallback');
                if (backdrop) backdrop.remove();
            }
        });
    });

    document.getElementById('editForm').addEventListener('submit', function(e) {
        const inputs = document.querySelectorAll('#editForm input[name="results[]"]');
        const nums = Array.from(inputs).map(input => parseInt(input.value));
        if (nums.some(n => isNaN(n) || n < 0 || n > 9)) {
            e.preventDefault();
            Swal.fire('Lỗi!', 'Vui lòng nhập đúng 5 số từ 0-9.', 'error');
            return;
        }
    });
}
</script>

<?php
// 6. NẠP FILE FOOTER (Chứa các thẻ đóng và script cuối trang)
require_once 'foot.php';
?>