<?php
// manager-chat.php - Tích hợp backend từ cskh.php vào giao diện hiện tại

// --- PHẦN 1: KHỞI TẠO VÀ CẤU HÌNH ---
session_start();
if (!isset($_SESSION['admin_loggedin'])) {
    $_SESSION['admin_username'] = 'Admin';
}

require_once __DIR__ . '/../vendor/autoload.php';
use Pusher\Pusher;

$pusher = null;
try {
    $pusher = new Pusher('2d0f22dbc701cefbfde0', 'ecd8c8070503a09fda8c', '1951282', ['cluster' => 'mt1', 'useTLS' => true]);
} catch (Exception $e) {
    error_log("Pusher init error: " . $e->getMessage());
}

// --- Class Database ---
class Database {
    private $connection;
    
    public function __construct() {
        $host = 'localhost';
        $user = 'eqwdrsog_test';
        $pass = 'eqwdrsog_test';
        $dbname = 'eqwdrsog_test';

        mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
        try {
            $this->connection = new mysqli($host, $user, $pass, $dbname);
            $this->connection->set_charset("utf8mb4");
        } catch (mysqli_sql_exception $e) {
            die("Lỗi kết nối CSDL: " . $e->getMessage());
        }
    }

    public function query($sql, $params = []) {
        try {
            $stmt = $this->connection->prepare($sql);
            if ($stmt === false) {
                throw new Exception("Prepare statement failed: " . $this->connection->error);
            }
            if (!empty($params)) {
                $stmt->bind_param(str_repeat('s', count($params)), ...$params);
            }
            if (!$stmt->execute()) {
                throw new Exception("Execute statement failed: " . $stmt->error);
            }
            return $stmt;
        } catch (Exception $e) {
            error_log("Database Query Error: " . $e->getMessage());
            return false;
        }
    }

    public function get_list($sql, $params = []) {
        $stmt = $this->query($sql, $params);
        if ($stmt === false) { return []; }
        $result = $stmt->get_result();
        $stmt->close();
        if ($result === false) { return []; }
        return $result->fetch_all(MYSQLI_ASSOC);
    }

    public function get_row($sql, $params = []) {
        $stmt = $this->query($sql, $params);
        if ($stmt === false) { return null; }
        $result = $stmt->get_result();
        $stmt->close();
        if ($result === false) { return null; }
        return $result->fetch_assoc();
    }
    
    public function __destruct() {
        $this->connection->close();
    }
}

$db = new Database();

// --- PHẦN 2: XỬ LÝ API ---
if (isset($_GET['action'])) {
    $action = $_GET['action'];
    
    // Load tin nhắn
    if ($action == 'load_messages') {
        header('Content-Type: text/html; charset=utf-8');
        $user_id = (int)($_GET['user_id'] ?? 0);
        if ($user_id > 0) {
            $messages = $db->get_list(
                "SELECT id, sender_type, message, images, created_at 
                FROM chat_messages 
                WHERE (sender_id = ? AND sender_type = 'user') OR (receiver_id = ? AND sender_type = 'admin') 
                ORDER BY id ASC",
                [$user_id, $user_id]
            );
            
            if (empty($messages)) {
                echo '<div class="text-center text-muted">Bắt đầu cuộc trò chuyện!</div>';
            } else {
                foreach ($messages as $msg) {
                    $isAdmin = $msg['sender_type'] === 'admin';
                    $alignClass = $isAdmin ? 'justify-content-end' : '';
                    $bgClass = $isAdmin ? 'bg-primary text-white' : 'bg-light';
                    $time = date('H:i', strtotime($msg['created_at']));
                    
                    echo '<div class="d-flex mb-3 ' . $alignClass . '">';
                    echo '<div class="message-box p-3 rounded ' . $bgClass . '" style="max-width: 70%;">';
                    
                    if (!empty($msg['message'])) {
                        echo nl2br(htmlspecialchars($msg['message']));
                    }
                    
                    if (!empty($msg['images'])) {
                        $images_arr = json_decode($msg['images'], true);
                        if (is_array($images_arr)) {
                            echo '<div class="message-images d-flex flex-wrap mt-2">';
                            foreach($images_arr as $img) {
                                echo '<a href="' . htmlspecialchars($img) . '" target="_blank">';
                                echo '<img src="' . htmlspecialchars($img) . '" style="max-width: 150px; border-radius: 8px; margin: 5px;">';
                                echo '</a>';
                            }
                            echo '</div>';
                        }
                    }
                    
                    echo '<div class="text-muted small mt-1">' . $time . '</div>';
                    echo '</div></div>';
                }
            }
        }
        exit;
    }
    
    // Gửi tin nhắn
    if ($action == 'send_message' && $_SERVER['REQUEST_METHOD'] === 'POST') {
        header('Content-Type: application/json');
        $user_id = (int)($_POST['user_id'] ?? 0);
        $message = trim($_POST['message'] ?? '');
        $response = ['success' => false, 'error' => 'Dữ liệu không hợp lệ.'];
        
        if ($user_id > 0 && (!empty($message) || !empty($_FILES['images']['name'][0]))) {
            $images_to_save = null;
            $images_to_push = [];
            
            if (!empty($_FILES['images']['name'][0])) {
                $upload_dir = __DIR__ . '/../uploads/chat/';
                if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);
                
                foreach ($_FILES['images']['name'] as $key => $name) {
                    if ($_FILES['images']['error'][$key] === 0) {
                        $ext = pathinfo($name, PATHINFO_EXTENSION);
                        $newName = 'chat_' . time() . '_' . uniqid() . '.' . $ext;
                        if (move_uploaded_file($_FILES['images']['tmp_name'][$key], $upload_dir . $newName)) {
                            $images_to_push[] = '/uploads/chat/' . $newName;
                        }
                    }
                }
                if(!empty($images_to_push)) $images_to_save = json_encode($images_to_push);
            }
            
            $insert_result = $db->query(
                "INSERT INTO chat_messages (sender_id, sender_type, receiver_id, receiver_type, message, images, created_at) 
                VALUES (1, 'admin', ?, 'user', ?, ?, NOW())",
                [$user_id, $message, $images_to_save]
            );
            
            if ($insert_result !== false) {
                if ($pusher) {
                    $data_to_push = [
                        'sender_type' => 'admin',
                        'message' => $message,
                        'images' => $images_to_push,
                        'created_at' => date('Y-m-d H:i:s')
                    ];
                    $pusher->trigger("chat-channel-{$user_id}", 'new-message', $data_to_push);
                }
                $response = ['success' => true];
            } else {
                $response['error'] = 'Lỗi insert DB';
            }
        }
        echo json_encode($response);
        exit;
    }
    
    // Đánh dấu đã đọc
    if ($action == 'mark_read') {
        header('Content-Type: application/json');
        $user_id = (int)($_GET['user_id'] ?? 0);
        if ($user_id > 0) {
            $db->query(
                "UPDATE chat_messages SET is_read = 1 
                WHERE sender_id = ? AND sender_type = 'user' AND is_read = 0",
                [$user_id]
            );
        }
        echo json_encode(['success' => true]);
        exit;
    }
}

// --- PHẦN 3: LOAD DỮ LIỆU TRANG CHÍNH ---
$per_page = 20;
$current_page = max(1, (int)($_GET['page'] ?? 1));
$offset = ($current_page - 1) * $per_page;

$total_items = $db->get_row(
    "SELECT COUNT(DISTINCT sender_id) as total FROM chat_messages WHERE sender_type = 'user'"
)['total'] ?? 0;
$total_pages = ceil($total_items / $per_page);

$main_query = "SELECT u.id as user_id, u.username, u.city, cm.message, cm.created_at,
    (SELECT COUNT(*) FROM chat_messages sub 
     WHERE sub.sender_id = u.id AND sub.sender_type = 'user' AND sub.is_read = 0) as unread_count
FROM users u
JOIN chat_messages cm ON u.id = cm.sender_id
JOIN (SELECT sender_id, MAX(id) as max_id FROM chat_messages WHERE sender_type = 'user' GROUP BY sender_id) latest 
    ON cm.sender_id = latest.sender_id AND cm.id = latest.max_id
WHERE cm.sender_type = 'user'
ORDER BY latest.max_id DESC
LIMIT ? OFFSET ?";

$page_data = $db->get_list($main_query, [$per_page, $offset]);

$current_user_id = (int)($_GET['user_id'] ?? 0);
$current_username = 'Không xác định';

if ($current_user_id > 0) {
    $db->query(
        "UPDATE chat_messages SET is_read = 1 
        WHERE sender_id = ? AND sender_type = 'user' AND is_read = 0",
        [$current_user_id]
    );
    $user_info = $db->get_row("SELECT username FROM users WHERE id = ?", [$current_user_id]);
    $current_username = $user_info['username'] ?? 'Không xác định';
}
?>
<!DOCTYPE html>
<html lang="vi">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=0">
<meta name="robots" content="noindex, nofollow">
<link rel="icon" href="/favicon/favicon.png" type="image/x-icon">
<title>Admin Panel</title>
<link rel="stylesheet" href="css/stylev4.css">
<link rel="stylesheet" href="css/editor.css">
<link rel="stylesheet" href="css/select2/dist/css/select2.min.css">
<link rel="stylesheet" href="css/lightbox2/css/lightbox.min.css">
<link rel="stylesheet" href="css/sweetalert2/sweetalert2.min.css">
<link rel="stylesheet" href="css/fontawesome/css/all.min.css">
<link rel="stylesheet" href="css/bootstrap/bootstrap.min.css">
<script src="css/sweetalert2/sweetalert2.min.js"></script>
<script src="css/jquery-3.6.0.min.js"></script>
<script src="css/bootstrap/bootstrap.min.js"></script>
<script src="https://js.pusher.com/8.2/pusher.min.js"></script>
<style>
.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 38px;
}
span.select2-selection.select2-selection--single {
    height: 40px;
}
#postsListContainer {
    max-height: calc(100vh - 150px);
    overflow-y: auto;
    padding-right: 8px;
    scroll-behavior: smooth;
}
#postsListContainer::-webkit-scrollbar {
    width: 6px;
}
#postsListContainer::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 3px;
}
#postsListContainer::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 3px;
}
#postsListContainer::-webkit-scrollbar-thumb:hover {
    background: #555;
}
.text-address {
    color: #6e9fcb !important;
}
.badge-unread {
    background-color: #dc3545;
    color: white;
    padding: 2px 8px;
    border-radius: 10px;
    font-size: 11px;
}
</style>
</head>
<body>

<div class="container-fluid">
<div class="row">
    <button class="togglePostsListButton" id="togglePostsListButton" onclick="togglePostsList()">
        <i class="fas fa-bars"></i>
    </button>
    <button class="closePostsListButton bg-danger" id="closePostsListButton" onclick="togglePostsList()">
        <i class="fas fa-times"></i>
    </button>

    <!-- Danh sách người dùng đã chat -->
    <div class="col-md-2 bg-dark font-weight-bold" id="postsListContainer">
        <ul class="list-group">
            <a href="manager-chat.php">
                <h3 class="bg-success text-white text-center">DANH SÁCH CHAT</h3>
            </a>

            <?php foreach ($page_data as $item): ?>
            <li class="list-group-item d-flex justify-content-between align-items-center <?= $current_user_id == $item['user_id'] ? 'active' : '' ?>">
                <div class="flex-grow-1">
                    <a href="manager-chat.php?page=<?= $current_page ?>&user_id=<?= $item['user_id'] ?>" 
                       title="ID: <?= $item['user_id'] ?>" class="d-block">
                        <i class="fas fa-user"></i> <?= htmlspecialchars($item['username']) ?> (ID: <?= $item['user_id'] ?>)
                        <?php if ((int)$item['unread_count'] > 0): ?>
                            <span class="badge-unread"><?= $item['unread_count'] ?></span>
                        <?php endif; ?>
                    </a>
                    <?php if (!empty($item['city'])): ?>
                        <div class="small text-address"><?= htmlspecialchars($item['city']) ?></div>
                    <?php endif; ?>
                </div>
                <button class="btn btn-sm btn-link text-danger px-2"
                    onclick="confirmDeleteAllMessages(<?= $item['user_id'] ?>)"
                    title="Xóa tất cả tin nhắn của <?= htmlspecialchars($item['username']) ?>">
                    <i class="fas fa-trash"></i>
                </button>
            </li>
            <?php endforeach; ?>
        </ul>

        <!-- PHÂN TRANG -->
        <?php if ($total_pages > 1): ?>
        <nav class="mt-2">
            <ul class="pagination pagination-sm justify-content-center mb-0">
                <li class="page-item <?= $current_page <= 1 ? 'disabled' : '' ?>">
                    <a class="page-link" href="manager-chat.php?page=1<?= $current_user_id ? '&user_id='.$current_user_id : '' ?>">&laquo;</a>
                </li>
                <li class="page-item <?= $current_page <= 1 ? 'disabled' : '' ?>">
                    <a class="page-link" href="manager-chat.php?page=<?= max(1, $current_page - 1) ?><?= $current_user_id ? '&user_id='.$current_user_id : '' ?>">&lsaquo;</a>
                </li>
                
                <?php for ($i = max(1, $current_page - 2); $i <= min($total_pages, $current_page + 2); $i++): ?>
                <li class="page-item <?= $i == $current_page ? 'active' : '' ?>">
                    <a class="page-link" href="manager-chat.php?page=<?= $i ?><?= $current_user_id ? '&user_id='.$current_user_id : '' ?>"><?= $i ?></a>
                </li>
                <?php endfor; ?>
                
                <li class="page-item <?= $current_page >= $total_pages ? 'disabled' : '' ?>">
                    <a class="page-link" href="manager-chat.php?page=<?= min($total_pages, $current_page + 1) ?><?= $current_user_id ? '&user_id='.$current_user_id : '' ?>">&rsaquo;</a>
                </li>
                <li class="page-item <?= $current_page >= $total_pages ? 'disabled' : '' ?>">
                    <a class="page-link" href="manager-chat.php?page=<?= $total_pages ?><?= $current_user_id ? '&user_id='.$current_user_id : '' ?>">&raquo;</a>
                </li>
            </ul>
            <div class="text-center text-muted small mt-1">
                Trang <?= $current_page ?> / <?= $total_pages ?> - Tổng <?= $total_items ?> người
            </div>
        </nav>
        <?php endif; ?>
    </div>

    <!-- Nội dung chat -->
    <div class="col-md-10">
        <nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm mb-2">
            <div class="container-fluid">
                <a href="index.php" class="text-uppercase text-danger font-weight-bold">
                    <i class="fas fa-user-cog"></i> <?= htmlspecialchars($_SESSION['admin_username']) ?>
                </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav">
                    <i class="fas fa-bars"></i>
                </button>
                <div class="collapse navbar-collapse font-weight-bold" id="navbarNav">
                    <ul class="navbar-nav ml-auto align-items-center">
                        <li class="nav-item">
                            <a class="nav-link" target="_blank" href="/"> <i class="fas fa-home"></i> Đi tới trang chủ</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link text-danger" href="manager-chat.php"> <i class="fas fa-comments"></i> Live Chat</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link text-danger" href="logout.php"><i class="fas fa-sign-out-alt"></i> Đăng xuất</a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>

        <div class="d-flex flex-row vh-100">
            <div class="flex-grow-1 p-3">
                <h5 class="d-flex justify-content-between align-items-center">
                    Chat với <?= htmlspecialchars($current_username) ?>
                    <?php if ($current_user_id > 0): ?>
                    <button class="btn btn-sm btn-danger" 
                            onclick="confirmDeleteAllMessages(<?= $current_user_id ?>)" 
                            title="Xóa toàn bộ tin nhắn">
                        <i class="fas fa-trash"></i> Xóa tất cả tin nhắn
                    </button>
                    <?php endif; ?>
                </h5>

                <div id="chatMessages" class="chat-container border p-3 mb-3" style="height: 65vh; overflow-y: auto;">
                    <?php if ($current_user_id > 0): ?>
                        <div class="text-center text-muted">Đang tải...</div>
                    <?php else: ?>
                        <div class="text-center text-muted">Chọn một cuộc trò chuyện để bắt đầu</div>
                    <?php endif; ?>
                </div>

                <!-- Form gửi tin nhắn -->
                <?php if ($current_user_id > 0): ?>
                <form id="chatForm" onsubmit="sendMessage(event)">
                    <div class="chat-input-container d-flex align-items-center border rounded p-2 shadow-sm" style="background-color: #f9f9f9;">
                        <textarea class="form-control border-0 shadow-none me-2" 
                                  placeholder="Viết tin nhắn..."
                                  id="chatInput"
                                  rows="4"
                                  style="outline: none; font-size: 1rem; resize: none;"></textarea>
                        <label for="fileInput" class="btn btn-link text-secondary me-2" title="Tải lên hình ảnh">
                            <i class="fas fa-image"></i>
                        </label>
                        <input type="file" id="fileInput" class="d-none" accept="image/*" name="images[]" multiple>
                        <button type="submit" class="btn btn-link text-primary" id="sendButton" title="Gửi tin nhắn">
                            <i class="fas fa-paper-plane"></i>
                        </button>
                    </div>
                    <div id="imagePreviewContainer" class="d-flex flex-wrap mt-3"></div>
                </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
</div>

<script>
let currentUserId = <?= $current_user_id ?>;
let userChannel = null;
const chatMessagesContainer = document.getElementById('chatMessages');
const chatInput = document.getElementById('chatInput');
const fileInput = document.getElementById('fileInput');
const imagePreviewContainer = document.getElementById('imagePreviewContainer');
const pusher = new Pusher('2d0f22dbc701cefbfde0', { cluster: 'mt1' });

function scrollToBottom() {
    chatMessagesContainer.scrollTop = chatMessagesContainer.scrollHeight;
}

function appendMessage(data) {
    const isAdmin = data.sender_type === 'admin';
    const alignClass = isAdmin ? 'justify-content-end' : '';
    const bgClass = isAdmin ? 'bg-primary text-white' : 'bg-light';
    
    let imagesHtml = '';
    if (data.images && data.images.length > 0) {
        imagesHtml = "<div class='message-images d-flex flex-wrap mt-2'>";
        data.images.forEach(imgUrl => {
            imagesHtml += `<a href="${imgUrl}" target="_blank"><img src="${imgUrl}" style="max-width: 150px; border-radius: 8px; margin: 5px;"></a>`;
        });
        imagesHtml += "</div>";
    }
    
    const time = new Date(data.created_at || new Date()).toLocaleTimeString('vi-VN', {hour: '2-digit', minute: '2-digit'});
    const msgDiv = document.createElement('div');
    msgDiv.className = `d-flex mb-3 ${alignClass}`;
    msgDiv.innerHTML = `
        <div class="message-box p-3 rounded ${bgClass}" style="max-width: 70%;">
            ${data.message ? data.message.replace(/\n/g, '<br>') : ''}
            ${imagesHtml}
            <div class="text-muted small mt-1">${time}</div>
        </div>
    `;
    chatMessagesContainer.appendChild(msgDiv);
    scrollToBottom();
}

function loadChatHistory() {
    if (currentUserId === 0) return;
    chatMessagesContainer.innerHTML = '<div class="text-center text-muted">Đang tải lịch sử tin nhắn...</div>';
    fetch(`manager-chat.php?action=load_messages&user_id=${currentUserId}`)
        .then(res => res.text())
        .then(html => {
            chatMessagesContainer.innerHTML = html;
            scrollToBottom();
        })
        .catch(err => {
            console.error('Load error:', err);
            chatMessagesContainer.innerHTML = '<div class="text-center text-danger">Lỗi tải lịch sử</div>';
        });
}

function subscribeToUserChannel() {
    if (userChannel) {
        pusher.unsubscribe(userChannel.name);
    }
    if (currentUserId > 0) {
        userChannel = pusher.subscribe(`chat-channel-${currentUserId}`);
        userChannel.bind('new-message', function(data) {
            if (data.sender_type === 'user') {
                appendMessage(data);
            }
        });
    }
}

function sendMessage(event) {
    event.preventDefault();
    const message = chatInput.value.trim();
    const files = fileInput.files;
    
    if (!currentUserId || (message === '' && files.length === 0)) return;
    
    const formData = new FormData();
    formData.append('user_id', currentUserId);
    formData.append('message', message);
    for (let i = 0; i < files.length; i++) {
        formData.append('images[]', files[i]);
    }
    
    fetch('manager-chat.php?action=send_message', {
        method: 'POST',
        body: formData
    })
    .then(res => res.json())
    .then(data => {
        if (!data.success) {
            alert('Lỗi: ' + data.error);
        } else {
            appendMessage({
                sender_type: 'admin',
                message: message,
                images: [],
                created_at: new Date().toISOString()
            });
        }
    })
    .catch(err => console.error('Send error:', err));
    
    chatInput.value = '';
    fileInput.value = '';
    imagePreviewContainer.innerHTML = '';
}

if (fileInput) {
    fileInput.addEventListener('change', e => {
        imagePreviewContainer.innerHTML = '';
        Array.from(e.target.files).forEach(file => {
            const reader = new FileReader();
            reader.onload = e => {
                const img = document.createElement('img');
                img.src = e.target.result;
                img.style.maxHeight = '60px';
                img.style.borderRadius = '5px';
                img.style.margin = '5px';
                imagePreviewContainer.appendChild(img);
            };
            reader.readAsDataURL(file);
        });
    });
}

if (chatInput) {
    chatInput.addEventListener('keypress', e => {
        if (e.key === 'Enter' && !e.shiftKey) {
            e.preventDefault();
            sendMessage(e);
        }
    });
}

document.addEventListener('DOMContentLoaded', () => {
    if (currentUserId > 0) {
        loadChatHistory();
        subscribeToUserChannel();
        fetch(`manager-chat.php?action=mark_read&user_id=${currentUserId}`);
    }
    
    const adminChannel = pusher.subscribe('admin-notifications');
    adminChannel.bind('new-user-message', function(data) {
        if (currentUserId !== data.user_id) {
            location.reload();
        } else {
            loadChatHistory();
        }
    });
});

function confirmDeleteAllMessages(userId) {
    if (!confirm('Bạn có chắc chắn muốn xóa tất cả tin nhắn của người dùng này?')) {
        return;
    }
    // Gọi API xóa (cần tạo endpoint riêng)
    alert('Chức năng xóa cần được implement trong file delete_all_chat_user_messages.php');
}

function togglePostsList() {
    const container = document.getElementById('postsListContainer');
    container.classList.toggle('d-none');
}
</script>

<script src="css/select2/dist/js/select2.min.js"></script>
<script src="css/slick/slick.min.js"></script>
<script src="css/lightbox2/js/lightbox.js"></script>
<script src="css/popper/dist/umd/popper.min.js"></script>
<script src="css/bootstrap/bootstrap.min.js"></script>
<script src="css/custom.js"></script>
<script src="css/editor.js"></script>
</body>
</html>