const sleep = function (ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
const waitButton = function (elm, type, text = null) {
    if (type == true) {
        $(elm).attr('disabled', true).html(`<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
        <span class="sr-only">Loading...</span> Đang xử lý...`);
    } else {
        $(elm).attr('disabled', false).html(text);
    }
}

const swal = function (text, type = null) {
    var color;
    var icon;
    switch (type) {
        case 'success':
            color = 'success';
            break;
        case 'error':
            color = 'error';
            break;
        case 'info':
            color = 'info';
            break;
        case 'warning':
            color = 'warning';
            break;
        default:
            color = 'dark';
            break;
    }
    return Swal.fire("Thông báo", text, color);
}

$(document).ready(function () {
    $("form[submit-ajax=true]").submit(async function (e) {
        e.preventDefault();
        let _this = this
        let url = $(_this).attr("action");
        let method = $(_this).attr("method");
        let url_redirect = $(_this).attr("url_redirect");
        let button = $(_this).find('button[type=submit]');
        let oldTextButton = button.html();
        let data = $(_this).serialize();
        let option = {
            type: method,
            url: url,
            data: data,
            dataType: "json"
        };
        option.beforeSend = function () {
            waitButton(button, true);
        };
        option.complete = function () {
            waitButton(button, false, oldTextButton);
        };
        option.success = async function (response) {
            if ($(_this).attr("callback_function")) {
                window[$(_this).attr("callback_function")](response);
            }
            swal(response.message, response.status === true ? 'success' : 'error');
            if (response.status) {
                if (url_redirect) {
                    if (url_redirect == 'reloadListOrder') {
                        tableListOrder();
                        $('.modal').modal('hide');
                        return;
                    }
                    await sleep(2000);
                    if (url_redirect == 'reload') {
                        return window.location.reload();
                    }
                    return window.location.href = url_redirect;
                }
                if (confirm_order) {
                    $(_this).trigger('reset');
                    $('.detailServer').remove();
                    $([document.documentElement, document.body]).animate({
                        scrollTop: $(_this).offset().top - 300
                    }, 500);
                }
                return;
            }
        };
        $.ajax(option);
    })
});