<?php
require_once __DIR__ . '/config/config.php';
header('Content-Type: application/json');

$response = ['success' => false, 'message' => 'Lỗi không xác định.'];

// Kiểm tra xem người dùng đã đăng nhập chưa
if (!isset($_SESSION['username'])) {
    $response['message'] = 'Vui lòng đăng nhập để tiếp tục.';
    echo json_encode($response);
    exit();
}

// Lấy dữ liệu từ yêu cầu POST
$data = json_decode(file_get_contents('php://input'), true);
$bet_type = $data['bet_type'] ?? null;
$bet_amount = isset($data['bet_amount']) ? intval($data['bet_amount']) : 0;
$session_id = isset($data['bet_game_id']) ? intval($data['bet_game_id']) : 0;
$username = $_SESSION['username'];

// --- VALIDATE DỮ LIỆU ---
if (!in_array($bet_type, ['TH TRUEMILK', 'VINAMILK'])) {
    $response['message'] = 'Lựa chọn không hợp lệ.';
} else if ($bet_amount <= 0) {
    $response['message'] = 'Số tiền phải lớn hơn 0.';
} else if ($session_id <= 0) {
    $response['message'] = 'Phiên không hợp lệ.';
} else {
    $vincenzo = new Vincenzo();

    // Lấy thông tin người dùng (đặc biệt là số coin)
    $user = $vincenzo->get_row("SELECT `coin` FROM `users` WHERE `username` = '{$username}'");

    if (!$user) {
        $response['message'] = 'Không tìm thấy người dùng.';
    } else if ($user['coin'] < $bet_amount) {
        $response['message'] = 'Số dư của bạn không đủ.';
    } else {
        // --- MỌI THỨ HỢP LỆ, TIẾN HÀNH ĐẶT CƯỢC ---

        // 1. Trừ tiền người dùng
        $vincenzo->tru('users', 'coin', $bet_amount, "`username` = '{$username}'");

        // 2. Lưu lịch sử cược vào bảng user_bets
        $bet_data = [
            'username' => $username,
            'session_id' => $session_id,
            'bet_type' => $bet_type,
            'bet_amount' => $bet_amount,
            'bet_time' => date('Y-m-d H:i:s'),
            'status' => 'running'
        ];

        if ($vincenzo->insert('user_bets', $bet_data)) {
            $response['success'] = true;
            $response['message'] = 'Đặt hàng thành công!';
        } else {
            // Hoàn lại tiền nếu không lưu được cược (tránh mất tiền oan)
            $vincenzo->cong('users', 'coin', $bet_amount, "`username` = '{$username}'");
            $response['message'] = 'Lỗi hệ thống khi lưu đơn hàng, vui lòng thử lại.';
        }
    }
    $vincenzo->dis_connect();
}

echo json_encode($response);
