<?php
header('Content-Type: text/html; charset=UTF-8');
ini_set('default_charset', 'UTF-8');  // Fallback nếu mbstring off

// Nếu dùng output buffering, thêm encoding
if (ob_get_level() == 0) ob_start();

require_once __DIR__ . "/head.php"; ?>
<script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>
<style>
    body::after {
        content: '';
        display: block;
        height: 0px;
    }

    body {
        margin: auto !important;
        max-width: 500px !important;
        min-height: 100vh !important;
        background-color: #f2f2f2 !important;
    }

    .swal-mb-180 {
        margin-bottom: 180px !important;
    }

    .swal-popup-compact {
        min-height: 35px !important;
        height: 35px !important;
        padding: 5px 10px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        font-size: 14px !important;
        line-height: 1 !important;
    }


    @keyframes bounceIn {
        0% {
            transform: scale(0.5) translateY(20px);
            opacity: 0;
        }

        60% {
            transform: scale(1.2) translateY(-10px);
            opacity: 1;
        }

        100% {
            transform: scale(1) translateY(0);
        }
    }

    .animated-bounce {
        animation: bounceIn 0.5s ease;
    }

    @keyframes spin {
        from {
            transform: rotate(0deg);
        }

        to {
            transform: rotate(360deg);
        }
    }

    .vongquay-xoay {
        width: 120px;
        height: 120px;
        animation-name: spin;
        animation-duration: 0.5s;
        animation-iteration-count: infinite;
        animation-timing-function: linear;
    }


    span.rounded-circle.mx-1 {
        background: linear-gradient(to top, #79745c, #e9d175, #ffffff);
    }

    span.bom-item.rounded-circle.mx-1.animated-bounce {
        background: linear-gradient(to top, #79745c, #e9d175, #ffffff);
    }

    span.thtruemilk,
    span.vinamilk {
        display: inline-block;
        width: 40px;
        height: 20px;
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        margin-left: 10px;
        position: relative;
        top: 2px;
    }

    .col-6 a {
        padding: .375rem .1rem;
    }

    span.thtruemilk {
        background-image: url('/images/thtruemilk/thmilk.png');
    }

    span.vinamilk {
        background-image: url('/images/thtruemilk/vinamilk.png');
    }

    .so-luong-item {
        border: 1px solid #2fbba1;
        color: #2fbba1;
    }

    .text-milk-item {
        color: #2fbba1;
    }

    .btn-success-custom {
        color: #fff;
        background: #2fbba1;
        border-color: #2fbba1;
    }

    .btn-primary-custom {
        color: #fff;
        background: #018dd4;
        border-color: #018dd4;
    }



    .sua-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        background-color: #ffffff;
        border: 1px solid #2fbba1;
        border-radius: 5px;
        padding: 4px 6px;
        margin-bottom: 8px;
        cursor: pointer;
        transition: background 0.2s;
    }

    .sua-item:hover {
        background-color: #d0f0ff;
    }

    .responsive-text {
        font-size: 80%;
        font-weight: 400;
        white-space: nowrap;
        color: #2fbba1;
    }

    .sua-logo {
        width: 30px;
        height: 30px;
        background-size: contain;
        background-repeat: no-repeat;
        background-position: center;
        border-radius: 4px;
    }

    /* Brand-specific logos */
    .sua-mocchau {
        background-image: url('/images/thtruemilk/mocchau.png');
    }

    .sua-nutifood {
        background-image: url('/images/thtruemilk/nutifood.png');
    }

    .sua-dutchlady {
        background-image: url('/images/thtruemilk/dutchlady.png');
    }

    .sua-anfagold {
        background-image: url('/images/thtruemilk/anfagold.png');
    }

    .sua-cogaihalan {
        background-image: url('/images/thtruemilk/cogaihalan.png');
    }

    .sua-optimum {
        background-image: url('/images/thtruemilk/optimumgold2.png');
    }

    .sua-milo {
        background-image: url('/images/thtruemilk/milo.png');
    }

    .sua-fami {
        background-image: url('/images/thtruemilk/fami.png');
    }

    /* popup hũ */
    .swal2-popup.custom-popup-class {
        background-color: transparent !important;
        box-shadow: none !important;
        padding: 10px !important;
        width: 100% !important;
        max-width: 480px;
        /* hoặc 500px, tuỳ bạn */
        border-radius: 12px;
        overflow: visible;
        margin: auto !important;
        /* ✅ Đảm bảo căn giữa */
    }

    .swal2-html-container {
        width: 100% !important;
        padding: 10px !important;
        margin: 0 auto !important;
        /* ✅ Căn giữa nội dung bên trong */
        text-align: center;
    }

    .gift-popup-wrapper {
        position: relative;
        background: url('/images/popop_gift.png') no-repeat center/contain;
        width: 100%;
        padding-top: 130%;
    }

    .gift-popup-gif {
        position: absolute;
        top: 0px;
        left: 50%;
        transform: translateX(-50%);
        width: 50%;
        height: auto;
        z-index: 2;
        animation: bounceGift 1s infinite;
    }

    .gift-popup-content {
        position: absolute;
        top: 29%;
        left: 16%;
        width: 66%;
        color: #222;
        font-size: 14px;
        line-height: 1.4;
        font-weight: bold;
        text-align: center;
        z-index: 3;
    }


    /* nút Đồng ý nằm đúng ô cam */
    .gift-popup-button-wrapper {
        position: absolute;
        bottom: 22%;
        left: 50%;
        transform: translateX(-50%);
        z-index: 4;
    }

    .gift-popup-button-wrapper button {
        padding: 6px 16px;
        font-size: 15px;
        font-weight: bold;
        background: linear-gradient(to right, #ff9900, #ff3300);
        color: white;
        border: none;
        border-radius: 40px;
        box-shadow: 0 0 6px rgba(0, 0, 0, 0.3);
        cursor: pointer;
    }

    /* hiệu ứng rung */
    @keyframes bounceGift {

        0%,
        100% {
            transform: translateX(-50%) translateY(0);
        }

        50% {
            transform: translateX(-50%) translateY(-8px);
        }
    }

    .swal2-popup.popup-nap-class {
        background-color: white !important;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.2);
        border-radius: 12px;
        padding: 20px;
        max-width: 100%;
    }

    .text-dh {
        font-size: 1.1rem;
        background: #2fbba1 !important;
    }

    .text-kq {
        font-size: 1.1rem;
        background: #2fbba1 !important;
    }

    .text-bomx {
        font-size: 1.1rem;
        background: #2fbba1 !important;
        border-top: 1px solid rgb(255, 255, 255);
    }

    .bg-light-custom {
        background-color: #e8fffb !important;
    }

    /* Cập nhật CSS cho vòng quay để căn giữa cân đối */
    #giftSection {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-align: center;
        padding: 20px 0;
    }

    #vongQuay {
        display: flex;
        justify-content: center;
        align-items: center;
        margin: 20px 0;
    }

    #vongQuay img {
        display: block;
        margin: 0 auto;
    }
</style>


<div class="container-fluid p-0 bg-light-custom text-center">
    <div class="bg-success text-dh text-white py-1">
        Đơn hàng tiếp theo <strong id="nextGameId">Đang tải...</strong> |
        <i class="fas fa-stopwatch"></i> <span id="countdownTimer">--:--</span>
    </div>

    <div id="result-container">
        <div class="bg-info text-kq text-white py-2 d-flex align-items-center px-3">
            <div class="mx-auto">
                Kết quả đơn hàng <strong id="lastGameId">...</strong>
            </div>
            <span class="ms-auto">
                <i class="fa-solid fa-circle-info btn-open-rules" style="cursor:pointer;"></i>
            </span>
        </div>

        <div class="bg-primary text-bomx text-white py-2">
            <div class="d-inline-flex justify-content-center align-items-center" id="bomResult">
                <span class="text-white-50">Đang chờ kết quả...</span>
            </div>
        </div>
    </div>

</div>


<div class="py-3">
    <div class="slick-slider-logo">
        <div>
            <img src="/images/thtruemilk/vinamilk-logo-go.png" alt="Vinamilk" class="img-fluid">
        </div>
        <div>
            <img src="/images/thtruemilk/thtruemilk-logos.png" alt="TH True Milk" class="img-fluid">
        </div>
    </div>
</div>


<div class="row m-0 p-0 mb-3">
    <div class="col-6 px-1">
        <a href="#"
            data-bet-type="TH TRUEMILK"
            onclick="openBetPopup('TH TRUEMILK', '73789')"
            class="btn btn-success-custom btn-block font-weight-bold w-100">
            TH TRUEMILK <span class="thtruemilk"></span>
        </a>
    </div>
    <div class="col-6 px-1">
        <a href="#"
            data-bet-type="VINAMILK"
            onclick="openBetPopup('VINAMILK', '73789')"
            class="btn btn-primary-custom btn-block font-weight-bold w-100">
            VINAMILK <span class="vinamilk"></span>
        </a>
    </div>
</div>



<div class="row m-0 p-0 mb-3">
    <div class="col-6 px-1">
        <div class="bg-white so-luong-item rounded p-2 text-center small">
            Số Lượng Hàng Ngày:
        </div>
    </div>
    <div class="col-6 px-1">
        <div class="bg-white so-luong-item rounded p-2 text-center small">
            Số Lượng Hàng Ngày:
        </div>
    </div>
</div>

<div class="row m-0 p-0 mb-3">
    <div class="col-6 px-1">
        <div class="sua-item">
            <span class="responsive-text">SỮA MỘC CHÂU</span> <span class="sua-logo sua-mocchau"></span>
        </div>
        <div class="sua-item">
            <span class="responsive-text">SỮA NUTIFOOD</span> <span class="sua-logo sua-nutifood"></span>
        </div>
        <div class="sua-item">
            <span class="responsive-text">SỮA DUTCH LADY</span> <span class="sua-logo sua-dutchlady"></span>
        </div>
        <div class="sua-item">
            <span class="responsive-text">SỮA ANFA GOLD</span> <span class="sua-logo sua-anfagold"></span>
        </div>
    </div>
    <div class="col-6 px-1">
        <div class="sua-item">
            <span class="responsive-text">SỮA CÔ GÁI HÀ LAN</span> <span class="sua-logo sua-cogaihalan"></span>
        </div>
        <div class="sua-item">
            <span class="responsive-text">SỮA OPTIMUM GOLD</span> <span class="sua-logo sua-optimum"></span>
        </div>
        <div class="sua-item">
            <span class="responsive-text">SỮA MILO</span> <span class="sua-logo sua-milo"></span>
        </div>
        <div class="sua-item">
            <span class="responsive-text">SỮA ĐẬU NÀNH FAMI</span> <span class="sua-logo sua-fami"></span>
        </div>
    </div>
</div>


<div class="my-3 p-0">
    <div class="slick-slider">
        <div>
            <img src="/images/thtruemilk/thtruemilk-0.jpg" class="img-fluid rounded shadow lazyload" alt="Banner" style="width: 100%; height: auto;">
        </div>
        <div>
            <img src="/images/thtruemilk/thtruemilk-1.jpg" class="img-fluid rounded shadow lazyload" alt="Banner" style="width: 100%; height: auto;">
        </div>
        <div>
            <img src="/images/thtruemilk/thtruemilk-2.jpg" class="img-fluid rounded shadow lazyload" alt="Banner" style="width: 100%; height: auto;">
        </div>
        <div>
            <img src="/images/thtruemilk/thtruemilk-3.jpg" class="img-fluid rounded shadow lazyload" alt="Banner" style="width: 100%; height: auto;">
        </div>
        <div>
            <img src="/images/thtruemilk/thtruemilk-4.jpg" class="img-fluid rounded shadow lazyload" alt="Banner" style="width: 100%; height: auto;">
        </div>
        <div>
            <img src="/images/thtruemilk/thtruemilk-5.jpg" class="img-fluid rounded shadow lazyload" alt="Banner" style="width: 100%; height: auto;">
        </div>
        <div>
            <img src="/images/thtruemilk/thtruemilk-6.jpg" class="img-fluid rounded shadow lazyload" alt="Banner" style="width: 100%; height: auto;">
        </div>
    </div>
</div>


<div class="my-2 px-3" id="giftSection">

    <!-- 🎡 Vòng quay nếu chưa trúng -->
    <h6 class="text-primary font-weight-bold">TRI ÂN KHÁCH HÀNG VỚI NHIỀU PHẦN QUÀ CÓ GIÁ TRỊ LỚN</h6>
    <div id="vongQuay">
        <img src="/images/vong-quay.png" alt="Vòng quay may mắn" class="img-fluid my-2 vongquay-xoay">
    </div>
    <h6 class="text-primary font-weight-bold my-2">HỆ THỐNG ĐANG TỰ ĐỘNG TÌM KIẾM KHÁCH HÀNG MAY MẮN</h6>

    <div>
        <img src="/images/thtruemilk/logo-sua-small.png" class="img-fluid mt-4" alt="Default Banner">
    </div>

    <div class="my-5 py-5"></div>
</div>

</div>

<script>
    $(document).ready(function() {
        // Slider chính
        if ($('.slick-slider').children().length > 0) {
            $('.slick-slider').slick({
                infinite: true,
                slidesToShow: 1,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 3000, // tốc độ auto riêng
                dots: true,
                arrows: false,
                lazyLoad: 'ondemand',
                fade: false, // hiệu ứng slide ngang
                speed: 500
            });
        }

        // Slider logo với hiệu ứng giống hệt nhưng tốc độ khác
        if ($('.slick-slider-logo').children().length > 0) {
            $('.slick-slider-logo').slick({
                infinite: true,
                slidesToShow: 1,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 5000, // tốc độ auto riêng
                dots: false,
                arrows: false,
                lazyLoad: 'ondemand',
                fade: false, // giống slider chính
                speed: 500
            });
        }
    });
</script>

<!-- ✅ DI CHUYỂN LÊN ĐÂY: Định nghĩa openBetPopup global trước render động -->
<script>
    function openBetPopup(betType, betGameId) {
        const titleHtml =
            '<div style="font-weight:800;font-size:22px;color:#c70000;letter-spacing:1px;margin-bottom:6px;text-transform:uppercase;">' +
            (betType || '') +
            '</div>';

        const presetValues = [20, 30, 50, 100, 500, 1000, 50000, 100000, 200000];

        let html = '' +
            '<div style="text-align:center;">' +
            titleHtml +
            '<div style="display:flex;justify-content:center;align-items:center;margin:10px 0 12px;">' +
            '<button type="button" class="btn-dec"' +
            ' style="width:40px;height:40px;font-size:20px;background:#e74c3c;color:#fff;border:none;border-radius:8px;">−</button>' +
            '<input id="betInput" type="text" value="" placeholder="DỮ LIỆU NHẬP"' +
            ' inputmode="numeric" autocomplete="off"' +
            ' style="text-align:center;width:220px;margin:0 10px;font-size:16px;font-weight:700;' +
            ' color:#2c3e50;background:#ecf0f1;border:2px solid #bdc3c7;border-radius:8px;' +
            ' padding:8px 10px;"/>' +
            '<button type="button" class="btn-inc"' +
            ' style="width:40px;height:40px;font-size:20px;background:#2ecc71;color:#fff;border:none;border-radius:8px;">+</button>' +
            '</div>' +
            '<div id="presetPad" style="display:grid;grid-template-columns:repeat(3,1fr);gap:10px;padding:5px 8px 0;">';

        for (let i = 0; i < presetValues.length; i++) {
            html += '<button type="button" data-v="' + presetValues[i] + '"' +
                ' style="padding:10px;font-size:16px;font-weight:700;background:#f8f9fa;color:#333;' +
                ' border:2px solid #e0e0e0;border-radius:6px;">' +
                presetValues[i].toLocaleString('vi-VN') + '</button>';
        }
        html += '</div>' +
            '</div>';

        Swal.fire({
            html: html,
            showCancelButton: true,
            confirmButtonText: 'Xác nhận',
            cancelButtonText: 'Hủy',
            customClass: {
                confirmButton: 'bg-danger text-white px-4 py-2 rounded border-0',
                cancelButton: 'bg-secondary text-white px-4 py-2 rounded border-0'
            },
            focusConfirm: false,
            didOpen: function() {
                const input = document.getElementById('betInput');
                const presetPad = document.getElementById('presetPad');

                // Click preset
                presetPad.addEventListener('click', function(e) {
                    const val = e.target.getAttribute('data-v');
                    if (val === null) return;
                    input.value = parseInt(val, 10).toLocaleString('vi-VN');
                });

                // Nút -
                document.querySelector('.btn-dec').addEventListener('click', function() {
                    const cur = parseInt((input.value || '0').replace(/\D/g, ''), 10) || 0;
                    const v = Math.max(cur - 1, 0);
                    input.value = v ? v.toLocaleString('vi-VN') : '';
                });

                // Nút +
                document.querySelector('.btn-inc').addEventListener('click', function() {
                    const cur = parseInt((input.value || '0').replace(/\D/g, ''), 10) || 0;
                    const v = cur + 1;
                    input.value = v.toLocaleString('vi-VN');
                });

                // Chặn ký tự lạ & tự format nghìn
                input.addEventListener('input', function() {
                    const raw = this.value.replace(/[^\d]/g, '');
                    if (!raw) {
                        this.value = '';
                        return;
                    }
                    this.value = parseInt(raw, 10).toLocaleString('vi-VN');
                });

                // Enter để xác nhận
                input.addEventListener('keydown', function(e) {
                    if (e.key === 'Enter') Swal.clickConfirm();
                });
            },
            preConfirm: function() {
                const raw = (document.getElementById('betInput').value || '').replace(/[^\d]/g, '');
                const amount = parseInt(raw, 10);
                if (!raw || isNaN(amount) || amount <= 0) {
                    Swal.showValidationMessage('Vui lòng nhập số hợp lệ!');
                    return false;
                }
                return amount;
            }
        }).then(function(result) {
            if (result.isConfirmed) {
                const betAmount = result.value;
                submitBet(betType, betAmount, betGameId);
            }
        });
    }

    function submitBet(betType, betAmount, betGameId) {
        fetch('submit_bet.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    bet_type: betType,
                    bet_amount: betAmount,
                    bet_game_id: betGameId
                })
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    const formattedAmount = new Intl.NumberFormat('vi-VN').format(betAmount);

                    Swal.fire({
                        html: '<div>Đơn hàng ' + betType + '</div>',
                        showConfirmButton: false,
                        timer: 1500,
                        position: 'bottom-end',
                        toast: true,
                        customClass: {
                            popup: 'shadow-lg border border-danger mb-5 swal-mb-180 swal-popup-compact'
                        }
                    }).then(() => {
                        Swal.fire({
                            html: '<div style="color:#dc3545;">- ' + formattedAmount + ' ' + betType + '</div>',
                            icon: null,
                            showConfirmButton: false,
                            timer: 5000,
                            timerProgressBar: true,
                            position: 'bottom-end',
                            toast: true,
                            customClass: {
                                popup: 'shadow-lg border border-danger mb-5 swal-mb-180 swal-popup-compact'
                            },
                            didOpen: () => {
                                const bar = document.querySelector('.swal2-timer-progress-bar');
                                if (bar) bar.style.backgroundColor = '#dc3545';
                            }
                        });
                    });
                } else {
                    Swal.fire({
                        html: '<div style="color:#dc3545;">❌ ' + (data.message || 'Có lỗi xảy ra') + '</div>',
                        icon: null,
                        showConfirmButton: false,
                        timer: 5000,
                        timerProgressBar: true,
                        position: 'bottom-end',
                        toast: true,
                        customClass: {
                            popup: 'shadow-lg border border-danger mb-5 swal-mb-180 swal-popup-compact'
                        },
                        didOpen: function() {
                            const bar = document.querySelector('.swal2-timer-progress-bar');
                            if (bar) bar.style.backgroundColor = '#dc3545';
                        }
                    });
                }
            })
            .catch(function(error) {
                console.error(error);
                Swal.fire('❌ Lỗi kết nối', 'Không thể gửi đơn hàng, vui lòng thử lại.', 'error');
            });
    }
</script>
<script>
document.addEventListener("DOMContentLoaded", function() {
    // Event delegation cho btn-open-rules (an toàn với DOM động)
    const resultContainer = document.getElementById('result-container');
    if (resultContainer) {
        resultContainer.addEventListener('click', function(e) {
            if (e.target.classList.contains('btn-open-rules')) {
                console.log('Rules button clicked!'); // Debug log
                Swal.fire({
                    title: '<span style="color:#009688;font-weight:bold;font-size:16px;">QUY ĐỊNH</span>',
                    html: '<div style="text-align:left; font-size:14px; line-height:1.7; color:#333;">' +
                        '<p><strong>Mở thưởng theo thứ tự:</strong> từ trái qua phải bắt đầu từ <strong>Chục Ngàn, Ngàn, Trăm, Chục</strong></p>' +
                        '<ul>' +
                        '<li>Đối với ID thành viên tổng số tiền rút và xuất khoản dưới <strong>100.000.000 vnđ/1 ngày</strong></li>' +
                        '<li>Đối với ID V.I.P tổng số tiền rút và xuất khoản dưới <strong>1.000.000.000 vnđ/1 ngày</strong></li>' +
                        '</ul>' +
                        '<p>Để đảm bảo web được hoạt động lâu dài cũng như bắt buộc duy trì các hoạt động đóng thuế cho doanh nghiệp, đối với các quý khách nhận được phần quà ngẫu nhiên may mắn từ Web, khi rút điểm cần thực hiện đóng phí duy trì theo hạn mức rút điểm như sau:</p>' +
                        '<ul>' +
                        '<li>Hạn mức rút tài khoản dưới 200 triệu tương ứng <strong>15% phí</strong></li>' +
                        '<li>Hạn mức rút tài khoản dưới 500 triệu tương ứng với <strong>20% phí</strong></li>' +
                        '<li>Hạn mức rút tài khoản trên 500 triệu tương ứng với <strong>30% phí</strong></li>' +
                        '</ul>' +
                        '</div>',
                    confirmButtonText: 'Tôi đã hiểu',
                    showCloseButton: true,
                    closeButtonHtml: '<i class="fas fa-times text-muted" style="font-size:20px;"></i>',
                    width: 650,
                    background: '#fff',
                    backdrop: 'rgba(0, 0, 0, 0.4)',
                    customClass: {
                        popup: 'text-start rounded',
                        confirmButton: 'bg-info text-white px-4 py-2 rounded'
                    }
                });
            }
        });
    } else {
        console.error('result-container not found!');
    }
});
</script>
<script>
    let popupTimer;

    // ✅ Hàm hiển thị popup
    function showPopup(type, mainText, subText, link, msgId) {
        // Nếu là gift message (chứa "Xin Chúc Mừng")
        if (mainText.includes("Xin Chúc Mừng")) {
            // Parse số tiền từ text (ví dụ: extract số sau "giá trị: ")
            const amountMatch = mainText.match(/(\d{1,3}(?:,\d{3})*|\d+) VND/);
            const amount = amountMatch ? amountMatch[0].replace(/,/g, '') : '0';

            // Random 5 digits như ảnh (9 0 1 7 9)
            const digits = Array.from({
                length: 5
            }, () => Math.floor(Math.random() * 10)).join(' ');

            // Random logo: Vinamilk hoặc TH True Milk
            const logos = [
                '<img src="/images/thtruemilk/vinamilk-logo-go.png" alt="Vinamilk" style="width: 100px; height: auto;">',
                '<img src="/images/thtruemilk/thtruemilk-logos.png" alt="TH True Milk" style="width: 100px; height: auto;">'
            ];
            const randomLogo = logos[Math.floor(Math.random() * logos.length)];

            // HTML fancy như ảnh (sử dụng escape cho mainText để tránh encoding lỗi)
            const escapedMainText = escapeHtmlForNote(mainText);
            const fancyHtml = `
                <div style="text-align: center; background: linear-gradient(to bottom, #e8f5e8, #f0f8ff); padding: 20px; border-radius: 15px;">
                    <div style="font-size: 24px; color: #28a745; font-weight: bold; margin-bottom: 10px;">${digits}</div>
                    <div style="margin-bottom: 15px;">${randomLogo}</div>
                    <div style="background: #fff; border: 2px solid #28a745; border-radius: 10px; padding: 15px; margin: 10px 0;">
                        <img src="/images/gift-box.png" alt="Quà Tặng" style="width: 80px; height: 80px; margin: 0 10px;">
                        <img src="/images/gift-box.png" alt="Quà Tặng" style="width: 80px; height: 80px; margin: 0 10px;">
                    </div>
                    <div style="font-size: 16px; color: #333; line-height: 1.4; margin-bottom: 15px;">${escapedMainText}</div>
                    <button id="acceptGiftBtn" data-gift-id="${msgId}" onclick="acceptGift(${msgId})" style="background: linear-gradient(to right, #ff6b35, #f7931e); color: white; border: none; padding: 12px 30px; border-radius: 25px; font-size: 16px; font-weight: bold; cursor: pointer;">Đồng ý &#128157;</button>  <!-- 💝 as entity -->
                </div>
            `;

            Swal.fire({
                html: fancyHtml,
                showConfirmButton: false,
                allowOutsideClick: false,
                allowEscapeKey: false,
                timer: 60000, // 1 phút như yêu cầu
                width: '400px',
                customClass: {
                    popup: 'gift-popup'
                }
            });
        } else {
            // Popup thường (như cũ)
            const popup = document.getElementById("popupNotify");
            const icon = document.getElementById("popupIcon");
            const content = document.getElementById("popupContent");
            const sub = document.getElementById("popupSubtext");

            content.innerHTML = mainText;
            sub.innerHTML = subText || "";

            // Đặt icon phù hợp
            if (type === "message") {
                icon.className = "fa-solid fa-comment-dots text-primary";
            } else if (type === "friend") {
                icon.className = "fa-solid fa-user-plus text-success";
            } else {
                icon.className = "fa-solid fa-bell text-info";
            }

            // Hiển thị
            popup.style.display = "block";
            popup.onclick = () => window.location.href = link;

            // Nếu có mã tin nhắn, gọi AJAX đánh dấu đã đọc
            if (msgId) {
                fetch("ajax_mark_message_read.php", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/x-www-form-urlencoded"
                    },
                    body: "msg_id=" + encodeURIComponent(msgId)
                });
            }

            // Tự ẩn sau 30s
            clearTimeout(popupTimer);
            popupTimer = setTimeout(() => {
                popup.style.display = "none";
            }, 30000);
        }
    }

    // ✅ Hàm chấp nhận quà tặng (AJAX update received=1)
    function acceptGift(giftId) {
        fetch('ajax_mark_gift_received.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: 'gift_id=' + encodeURIComponent(giftId)
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    Swal.close(); // Đóng popup
                    // Optional: Hiển thị toast thành công
                    Swal.fire({
                        toast: true,
                        position: 'top-end',
                        icon: 'success',
                        title: 'Quà tặng đã nhận!',
                        showConfirmButton: false,
                        timer: 2000
                    });
                    window.location.href = './cskh.php'; // Chuyển đến CSKH như cũ
                } else {
                    Swal.fire('Lỗi!', data.message || 'Không thể nhận quà.', 'error');
                }
            })
            .catch(err => {
                console.error('Error accepting gift:', err);
                Swal.fire('Lỗi!', 'Lỗi kết nối, vui lòng thử lại.', 'error');
            });
    }
</script>

<!-- Popup Container -->
<div id="popupNotify" style="display:none; position:fixed; bottom:80px; right:10px; z-index:9999; max-width:500px; width:100%;">
    <div class="card shadow border-info animated-popup" style="cursor:pointer;">
        <div class="card-body d-flex align-items-start">
            <div class="mr-3">
                <i id="popupIcon" class="fa-solid fa-bell text-info"></i>
            </div>
            <div style="flex: 1;">
                <div id="popupContent" class="font-weight-bold text-dark small"></div>
                <div id="popupSubtext" class="text-muted small mt-1"></div>
            </div>
        </div>
    </div>
</div>

<style>
    .animated-popup {
        animation: slideInFade 0.5s ease-out;
        border-radius: 12px;
    }

    @keyframes slideInFade {
        from {
            transform: translateY(30px);
            opacity: 0;
        }

        to {
            transform: translateY(0);
            opacity: 1;
        }
    }

    .gift-popup {
        background: rgba(255, 255, 255, 0.95) !important;
        border: 2px solid #28a745 !important;
        border-radius: 20px !important;
        animation: bounceIn 0.6s ease-out !important;
    }

    @keyframes bounceIn {
        0% {
            transform: scale(0.3);
            opacity: 0;
        }

        50% {
            transform: scale(1.05);
        }

        70% {
            transform: scale(0.9);
        }

        100% {
            transform: scale(1);
            opacity: 1;
        }
    }
</style>



<div class="supper-nav">

    <div class="row m-0 p-0 mb-1">
        <div class="col-6 text-left text-white">
            <small> ID: 10042</small>
        </div>
        <div class="col-6 text-right text-white">
            <small class="reloadBalance" data-balance-id="footer">Số dư: 0</small>
        </div>
    </div>

    <ul>
        <li>
            <a href="/" rel="nofollow">
                <i class="fas fa-home text-white fa-2x"></i> Home
            </a>
        </li>
        <li>
            <a href="/" rel="nofollow">
                <i class="fas fa-sync-alt text-white fa-2x"></i> Làm mới
            </a>
        </li>
        <li>
            <a href="/xuhuong.php" rel="nofollow">
                <i class="fa-solid fa-chart-line-up text-white fa-2x"></i> Xu hướng
            </a>
        </li>
        <!-- <li class="phone-mobile"> -->
        <!-- <a href="/dau-tu.php?coin=gold" rel="nofollow" class="button"> -->
        <!-- <span class="phone_animation animation-shadow"> -->
        <!-- <i class="fas fa-coins text-white fa-2x" aria-hidden="true"></i> -->
        <!-- </span> -->
        <!-- <span class="btn_phone_txt">Đầu tư</span> -->
        <!-- </a> -->
        <!-- </li> -->
        <!-- <li> -->
        <!-- <a href="/vitien.php" rel="nofollow"> -->
        <!-- <i class="fas fa-wallet text-white fa-2x"></i> Ví tiền -->
        <!-- </a> -->
        <!-- </li> -->
        <li>
            <a href="/account.php" rel="nofollow">
                <i class="fas fa-user text-white fa-2x"></i> Cá nhân
            </a>
        </li>
        <li>
            <a href="chat.php" class="chat_animation">
                <i class="fas fa-headset text-white fa-2x"></i> CSKH
            </a>
        </li>
    </ul>

</div>



<script>
document.addEventListener('DOMContentLoaded', function() {
    // === THÔNG TIN PUSHER CỦA BẠN ===
    const PUSHER_APP_KEY = 'd8f1f623fd37086447aa';     // THAY BẰNG KEY CỦA BẠN
    const PUSHER_CLUSTER = 'ap1';   // THAY BẰNG CLUSTER CỦA BẠN (ví dụ: 'ap1')

    const pusher = new Pusher(PUSHER_APP_KEY, {
        cluster: PUSHER_CLUSTER
    });

    const channel = pusher.subscribe('game-events');

    // BIẾN MỚI: Dùng để lưu lại ID của phiên kết quả cuối cùng đã hiển thị
    let displayedLastSessionId = null;
    let countdownInterval;

    channel.bind('state-update', function(data) {
        console.log('New state received from Pusher:', data);
        clearInterval(countdownInterval);

        // =========================================================================
        // PHẦN LOGIC CHÍNH ĐÃ THAY ĐỔI
        // =========================================================================
        
        // ĐIỀU KIỆN MỚI: Kiểm tra xem đây có phải là kết quả của một phiên MỚI không
        const isNewResult = data.last_id && data.last_id !== displayedLastSessionId;
        
        // A. Cập nhật kết quả phiên trước
        const resultContainerEl = document.getElementById('result-container');
        if (resultContainerEl && data.last_id && data.result) {
            
            // THÊM LỚP CSS ĐỘNG: Chỉ thêm 'animated-bounce' nếu isNewResult là true
            const animationClass = isNewResult ? 'animated-bounce' : '';

            let resultHTML = `
                <div class="bg-info text-kq text-white py-2 d-flex align-items-center px-3">
                    <div class="mx-auto">
                        Kết quả đơn hàng <strong id="lastGameId">${data.last_id}</strong>
                    </div>
                    <span class="ms-auto">
                        <i class="fa-solid fa-circle-info btn-open-rules" style="cursor:pointer;"></i>
                    </span>
                </div>
                <div class="bg-primary text-bomx text-white py-2">
                    <div class="d-inline-flex justify-content-center align-items-center" id="bomResult">
                        ${data.result.map(number => `
                            <span class="d-inline-flex justify-content-center align-items-center bg-warning text-dark rounded-circle mx-1 ${animationClass}"
                                  style="width: 50px; height: 50px; font-weight: bold;font-size: 25px;">
                                ${number}
                            </span>
                        `).join('')}
                    </div>
                </div>
            `;
            resultContainerEl.innerHTML = resultHTML;

            // CẬP NHẬT LẠI ID: Nếu là kết quả mới, cập nhật biến ghi nhớ
            if (isNewResult) {
                displayedLastSessionId = data.last_id;
            }
        }

        // B. Cập nhật ID phiên và nút cược (luôn chạy)
        const nextGameIdEl = document.getElementById('nextGameId');
        if (nextGameIdEl) {
            nextGameIdEl.textContent = data.next_id || '---';
        }
        document.querySelectorAll('a[data-bet-type]').forEach(button => {
            button.setAttribute('onclick', `openBetPopup('${button.dataset.betType}', '${data.next_id}')`);
        });

        // C. Cập nhật và chạy đồng hồ đếm ngược (luôn chạy)
        const countdownTimerEl = document.getElementById('countdownTimer');
        if (countdownTimerEl && data.countdown > 0) {
            let secondsRemaining = data.countdown;

            function updateTimer() {
                const minutes = Math.floor(secondsRemaining / 60);
                const seconds = secondsRemaining % 60;
                countdownTimerEl.textContent = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
                if (secondsRemaining > 0) {
                    secondsRemaining--;
                } else {
                    clearInterval(countdownInterval);
                    countdownTimerEl.textContent = '00:00';
                }
            }
            
            updateTimer();
            countdownInterval = setInterval(updateTimer, 1000);
        }
    });

    pusher.connection.bind('error', function(err) {
        console.error("Pusher connection error:", err);
    });
});
</script>

<script>
    // Giả sử user_id từ PHP, echo vào JS
    const userId = <?php echo isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 0; ?>;

    // Polling để check quà tặng mới mỗi 5 giây (thay vì messages)
    function checkNewGifts() {
        if (!userId) return;

        fetch('ajax_get_unread_gifts.php', {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded"
                },
                body: "user_id=" + userId
            })
            .then(res => res.json())
            .then(data => {
                if (data.success && data.gifts && data.gifts.length > 0) {
                    data.gifts.forEach(gift => {
                        showPopup("gift", gift.note, "", "", gift.id); // Type "gift" để trigger fancy popup
                    });
                }
            })
            .catch(err => console.error("Error fetching gifts:", err));
    }

    // Start polling khi page load
    document.addEventListener("DOMContentLoaded", function() {
        checkNewGifts(); // Check ngay lần đầu
        setInterval(checkNewGifts, 5000); // Mỗi 5s
    });
</script>
<!-- Thêm vào cuối index.php của user (trước </body>), sau khi load jQuery nếu cần -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    // ✅ KHÔNG duplicate: Chỉ 1 khai báo userId
    const userId = <?php echo json_encode($_SESSION['user_id'] ?? 0); ?>;
    let lastGiftId = parseInt(localStorage.getItem('lastGiftId_' + userId) || '0');
    let pollInterval;

    if (userId > 0) {
        // Reset last_id nếu cần test (xóa nếu OK)
        if (lastGiftId > 1000) {
            lastGiftId = 0;
            localStorage.setItem('lastGiftId_' + userId, '0');
            console.log('Reset lastGiftId to 0 for testing');
        }

        function startGiftPolling() {
            pollInterval = setInterval(checkForNewGifts, 3000);
            checkForNewGifts();
        }

        function checkForNewGifts() {
            fetch(`ajax_get_unread_gifts.php?user_id=${userId}&last_id=${lastGiftId}`, {
                    method: 'GET',
                    credentials: 'same-origin'
                })
                .then(res => res.json())
                .then(data => {
                    console.log('Polling response:', data); // DEBUG: F12 Console
                    if (data.success && data.gifts && data.gifts.length > 0) {
                        data.gifts.forEach(gift => {
                            showScreenshotLikeGiftPopup(gift);
                            if (gift.id > lastGiftId) {
                                lastGiftId = gift.id;
                                localStorage.setItem('lastGiftId_' + userId, lastGiftId);
                            }
                        });
                    } else {
                        console.log('No gifts: ', data.message || 'Empty');
                    }
                })
                .catch(err => {
                    console.error('Polling error:', err);
                });
        }

        // acceptGift với credentials
        window.acceptGift = function(giftId) {
            fetch('ajax_mark_gift_received.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: `gift_id=${giftId}`,
                    credentials: 'same-origin'
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        Swal.close();
                        Swal.fire({
                            toast: true,
                            position: 'top-end',
                            icon: 'success',
                            title: 'Quà tặng đã nhận thành công!',
                            timer: 2000,
                            showConfirmButton: false
                        });
                        setTimeout(() => {
                            window.location.href = 'chat.php';
                        }, 2000);
                    } else {
                        Swal.fire('Lỗi!', data.message || 'Không thể nhận quà.', 'error');
                    }
                })
                .catch(err => {
                    console.error('Accept error:', err);
                    Swal.fire('Lỗi!', 'Lỗi kết nối.', 'error');
                });
        }

        // showScreenshotLikeGiftPopup (với HTML entities cho emoji)
        function showScreenshotLikeGiftPopup(gift) {
            // HTML entities cho emoji - luôn render đúng
            const emojiFest = '&#127881;&#127881;&#127881;';  // 🎉🎉🎉
            const emojiGift = '&#127876;&#127876;&#127876;';  // 🎁🎁🎁
            const emojiSparkle = '&#10024;&#10024;&#10024;';   // ✨✨✨
            const emojiCheck = '&#10004;';                      // ✅
            const emojiHeart = '&#128158;';                     // 💝

            // Random digits (vòng tròn xanh)
            const randomDigits = Array.from({length: 5}, () => Math.floor(Math.random() * 10))
                .map(d => `<span style="display: inline-block; width: 50px; height: 50px; background: #28a745; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 24px; font-weight: bold; margin: 0 5px;">${d}</span>`).join('');

            // Random logo (với fallback)
            const logos = [
                {src: '/images/thtruemilk/vinamilk-logo-go.png', alt: 'Vinamilk'},
                {src: '/images/thtruemilk/thtruemilk-logos.png', alt: 'TH True Milk'}
            ];
            const randomLogo = logos[Math.floor(Math.random() * logos.length)];

            // Format amount & note với entities
            const formattedAmount = new Intl.NumberFormat('vi-VN').format(gift.amount || 0);
            const defaultNote = `${emojiFest}Xin Chúc Mừng Quý Khách Hàng "ID ${userId}" đã may mắn được phân quà Tri Ân khách hàng nhân dịp sinh nhật Công ty THHH TM&DV sữa Hà Nam với giá trị: ${formattedAmount} VND. Vui lòng liên hệ với CSKH để nhận thưởng. ${emojiHeart}${emojiHeart}${emojiHeart}`;
            const message = escapeHtmlForNote(gift.note || defaultNote);

            // Gift boxes: Img với fallback emoji entities
            const giftBoxHtml = `
                <img src="/images/gift-box.png" alt="Quà Tặng" style="width: 60px; height: 60px; margin: 0 10px;" 
                     onerror="this.outerHTML='<span style=\'font-size: 60px; margin: 0 10px; color: #ff9900;\'>${emojiGift}</span>';">
                <img src="/images/gift-box.png" alt="Quà Tặng" style="width: 60px; height: 60px; margin: 0 10px;" 
                     onerror="this.outerHTML='<span style=\'font-size: 60px; margin: 0 10px; color: #ff9900;\'>${emojiGift}</span>';">
            `;

            // Full HTML popup
            const html = `
                <div style="text-align: center; background: linear-gradient(135deg, #e8f5e8 0%, #f0f8ff 100%); padding: 20px; border-radius: 15px; border: 2px solid #28a745;">
                    <div style="margin-bottom: 15px;">${randomDigits}</div>
                    <img src="${randomLogo.src}" alt="${randomLogo.alt}" style="width: 120px; height: auto; margin: 10px 0;" 
                         onerror="this.src='/images/thtruemilk/thtruemilk-logos.png';">
                    <div style="margin: 10px 0; font-size: 24px;">${emojiSparkle} ${emojiCheck} ${emojiSparkle}</div>
                    <div style="margin: 15px 0; display: flex; justify-content: center;">
                        ${giftBoxHtml}
                    </div>
                    <div style="font-size: 14px; color: #333; line-height: 1.4; margin: 15px 0; text-align: center;">${message}</div>
                    <button id="acceptGiftBtn" class="gift-accept-btn" onclick="acceptGift(${gift.id})" 
                            style="background: linear-gradient(to right, #ff9900, #ff3300); color: white; border: none; padding: 12px 30px; border-radius: 25px; font-size: 16px; font-weight: bold; cursor: pointer; box-shadow: 0 4px 8px rgba(0,0,0,0.2);">
                        Đồng ý ${emojiHeart}
                    </button>
                    <div style="margin-top: 20px; font-size: 12px; color: #666;">
                        <img src="/images/thtruemilk/thtruemilk-logos.png" alt="TH True Milk" style="width: 80px; height: auto; margin-bottom: 5px;" 
                             onerror="this.outerHTML='<span style=\'color: #2fbba1; font-size: 20px;\'>TH True Milk</span>';">
                        <p>ID: ${userId} | Số dư: <span id="balance-display"><?= htmlspecialchars($getUser['coin'] ?? 0) ?></span></p>
                    </div>
                </div>
            `;

            Swal.fire({
                html: html,
                showConfirmButton: false,
                allowOutsideClick: false,
                allowEscapeKey: false,
                timer: 60000,
                width: '400px',
                customClass: { popup: 'gift-screenshot-popup' },
                didOpen: () => {
                    document.getElementById('acceptGiftBtn').focus();
                    // Force font hỗ trợ emoji (Segoe UI Emoji cho Windows, Arial cho mobile)
                    const container = document.querySelector('.swal2-html-container');
                    if (container) {
                        container.style.fontFamily = '"Segoe UI Emoji", Arial, sans-serif';
                    }
                }
            });
        }

        // Cập nhật escapeHtmlForNote (hỗ trợ entities tốt hơn)
        function escapeHtmlForNote(text) {
            if (!text) return '';
            // Escape cơ bản
            const map = {
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;',
                '"': '&quot;',
                "'": '&#039;'
            };
            return text.replace(/[&<>"']/g, m => map[m]);
        }

        // showPopup (nếu dùng ở nơi khác, giữ nguyên từ code cũ)
        let popupTimer;

        function showPopup(type, mainText, subText, link, msgId) {
            if (mainText.includes("Xin Chúc Mừng")) {
                const amountMatch = mainText.match(/(\d{1,3}(?:,\d{3})*|\d+) VND/);
                const amount = amountMatch ? amountMatch[0].replace(/,/g, '') : '0';
                const digits = Array.from({
                    length: 5
                }, () => Math.floor(Math.random() * 10)).join(' ');
                const logos = [
                    '<img src="/images/thtruemilk/vinamilk-logo-go.png" alt="Vinamilk" style="width: 100px; height: auto;">',
                    '<img src="/images/thtruemilk/thtruemilk-logos.png" alt="TH True Milk" style="width: 100px; height: auto;">'
                ];
                const randomLogo = logos[Math.floor(Math.random() * logos.length)];
                const escapedMainText = escapeHtmlForNote(mainText);
                const fancyHtml = `
                    <div style="text-align: center; background: linear-gradient(to bottom, #e8f5e8, #f0f8ff); padding: 20px; border-radius: 15px;">
                        <div style="font-size: 24px; color: #28a745; font-weight: bold; margin-bottom: 10px;">${digits}</div>
                        <div style="margin-bottom: 15px;">${randomLogo}</div>
                        <div style="background: #fff; border: 2px solid #28a745; border-radius: 10px; padding: 15px; margin: 10px 0;">
                            <img src="/images/gift-box.png" alt="Quà Tặng" style="width: 80px; height: 80px; margin: 0 10px;">
                            <img src="/images/gift-box.png" alt="Quà Tặng" style="width: 80px; height: 80px; margin: 0 10px;">
                        </div>
                        <div style="font-size: 16px; color: #333; line-height: 1.4; margin-bottom: 15px;">${escapedMainText}</div>
                        <button id="acceptGiftBtn" data-gift-id="${msgId}" onclick="acceptGift(${msgId})" style="background: linear-gradient(to right, #ff6b35, #f7931e); color: white; border: none; padding: 12px 30px; border-radius: 25px; font-size: 16px; font-weight: bold; cursor: pointer;">Đồng ý &#128157;</button>  <!-- 💝 as entity -->
                    </div>
                `;
                Swal.fire({
                    html: fancyHtml,
                    showConfirmButton: false,
                    allowOutsideClick: false,
                    allowEscapeKey: false,
                    timer: 60000,
                    width: '400px',
                    customClass: {
                        popup: 'gift-popup'
                    }
                });
            } else {
                // Popup thường (giữ nguyên logic cũ nếu cần)
                const popup = document.getElementById("popupNotify");
                if (!popup) return;
                const icon = document.getElementById("popupIcon");
                const content = document.getElementById("popupContent");
                const sub = document.getElementById("popupSubtext");
                content.innerHTML = mainText;
                sub.innerHTML = subText || "";
                if (type === "message") icon.className = "fa-solid fa-comment-dots text-primary";
                else if (type === "friend") icon.className = "fa-solid fa-user-plus text-success";
                else icon.className = "fa-solid fa-bell text-info";
                popup.style.display = "block";
                popup.onclick = () => window.location.href = link;
                if (msgId) {
                    fetch("ajax_mark_message_read.php", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded"
                        },
                        body: "msg_id=" + encodeURIComponent(msgId),
                        credentials: 'same-origin'
                    });
                }
                clearTimeout(popupTimer);
                popupTimer = setTimeout(() => {
                    popup.style.display = "none";
                }, 30000);
            }
        }

        // Start polling
        document.addEventListener('DOMContentLoaded', startGiftPolling);
        window.addEventListener('beforeunload', () => clearInterval(pollInterval));
    } else {
        console.log('No user session, skip polling');
    }
</script>
<script>
    let isPopupGiaithuongVisible = false;

    window.confirmGiftPopup = function(id) { // Move lên đầu để đảm bảo global sớm
        console.log('Confirm called with id:', id, 'Current visible:', isPopupGiaithuongVisible);
        isPopupGiaithuongVisible = false;
        console.log('Set visible to false. New value:', isPopupGiaithuongVisible);
        Swal.close();
        fetch('/get-balance.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: 'update_nohu_id=' + encodeURIComponent(id)
        }).catch(error => console.error('Fetch error:', error));
    };

    function startNohuPolling() {
        console.log("%c[Polling] Bắt đầu polling nổ hủ mỗi 15 giây", "color: green;");
        setInterval(function() {
            console.log("%c[Polling] Tải lại nổ hủ", "color: blue;");
            loadNohu();
        }, 3000); // Sửa thành 15 giây
    }

    function loadNohu() {
        console.log('Polling check: visible =', isPopupGiaithuongVisible); // Log để debug
        if (isPopupGiaithuongVisible) {
            console.log("%c[Polling] Nổ hủ popup đang hiển thị, bỏ qua lần này", "color: orange;");
            return;
        }

        let fireworksInterval; // Scope local cho loadNohu

        fetch("ajax_gift_no_hu.php")
            .then(response => response.json())
            .then(json => {
                isPopupGiaithuongVisible = true;
                if (json.success && json.html && json.id) { // Check json.id tồn tại
                    const giftContainer = document.getElementById('giftSection');
                    if (giftContainer) {
                        giftContainer.innerHTML = json.html;
                    }
                    var popupHTML = '' +
                        '<div class="gift-popup-wrapper" style="position: relative;">' +
                        '<canvas id="fireworks-canvas" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 0; pointer-events: none;"></canvas>' +
                        '<img src="/images/open_gift.gif" class="gift-popup-gif" alt="Open Gift">' +
                        '<div class="gift-popup-content">' +
                        json.content +
                        '</div>' +
                        '<div class="gift-popup-button-wrapper">' +
                        '<button class="confirm-btn" data-id="' + json.id + '">Đồng ý</button>' + // Sửa thành data-id
                        '</div>' +
                        '</div>';

                    Swal.fire({
                        html: popupHTML,
                        showConfirmButton: false,
                        showCancelButton: false,
                        buttonsStyling: false,
                        customClass: {
                            popup: 'custom-popup-class'
                        },
                        background: 'transparent',
                        backdrop: 'rgba(0,0,123,0.4)',
                        willClose: () => {
                            if (fireworksInterval) clearInterval(fireworksInterval);
                            isPopupGiaithuongVisible = false; // Fallback set false
                            console.log('Swal willClose: set visible to false');
                        },
                        didOpen: () => { // Thêm event để attach listener
                            const popup = Swal.getPopup();
                            popup.addEventListener('click', function(e) {
                                if (e.target.classList.contains('confirm-btn')) {
                                    const id = e.target.dataset.id;
                                    confirmGiftPopup(id);
                                }
                            });
                        }
                    });

                    setTimeout(() => {
                        const canvas = document.getElementById('fireworks-canvas');
                        if (!canvas) return;
                        const myConfetti = confetti.create(canvas, {
                            resize: true,
                            useWorker: true
                        });
                        fireworksInterval = setInterval(() => {
                            myConfetti({
                                particleCount: 70,
                                spread: 120,
                                startVelocity: 35,
                                origin: {
                                    x: Math.random(),
                                    y: Math.random() * 0.5
                                }
                            });
                        }, 300);
                    }, 100);
                } else {
                    isPopupGiaithuongVisible = false; // Reset nếu không có data
                }
            })
            .catch(error => {
                console.error("Lỗi khi tải nổ hủ:", error);
                isPopupGiaithuongVisible = false; // Reset nếu error
            });

    }

    document.addEventListener('DOMContentLoaded', function() {
        startNohuPolling();
    });
</script>
<?php
require_once __DIR__ . "/foot.php"; ?>