<?php
// cron_update_sessions.php - FIXED: Đảm bảo trả thưởng đúng, xử lý stuck bets, trim strings, thêm debug

require_once __DIR__ . '/config/function.php';
require_once __DIR__ . '/vendor/autoload.php';

// Cài đặt hệ thống
define('SESSION_DURATION_SECONDS', 180);
define('PAYOUT_RATE', 1.95);
define('SESSION_QUEUE_SIZE', 4); // 1 running + 3 upcoming

$vincenzo = $_vincenzo;
$currentTime = date('Y-m-d H:i:s');

echo "=== CRON JOB START: " . date('Y-m-d H:i:s') . " ===\n";

// Bắt đầu transaction để tránh race condition
$vincenzo->begin_transaction();

// =========================================================================
// BƯỚC 1: XỬ LÝ CÁC PHIÊN HẾT HẠN (Chuyển từ running -> finished)
// =========================================================================
$expired_sessions = $vincenzo->get_list("SELECT * FROM `game_sessions` WHERE `status` = 'running' AND `end_time` <= '{$currentTime}'");

if (!empty($expired_sessions)) {
    foreach ($expired_sessions as $expired_session) {
        echo "Processing expired session ID: " . $expired_session['id'] . "\n";
        
        // Kiểm tra xem phiên đã có kết quả chưa
        if (!empty($expired_session['result']) && $expired_session['result'] !== '0,0,0,0,0') {
            // Đánh dấu phiên là finished
            $vincenzo->update('game_sessions', ['status' => 'finished'], "`id` = " . $expired_session['id']);
            
            // Xử lý trả thưởng
            $result_array = array_map('intval', explode(',', $expired_session['result']));
            $sum = array_sum($result_array);
            $last_digit = $sum % 10;
            
            // Logic xác định người thắng: >= 5 là TH TRUEMILK, < 5 là VINAMILK
            $winning_type = ($last_digit >= 5) ? 'TH TRUEMILK' : 'VINAMILK';
            
            echo "Result: {$expired_session['result']}\n";
            echo "Result sum: {$sum}, Last digit: {$last_digit}, Winner: {$winning_type}\n";
            
            // Lấy tất cả cược trong phiên này
            $bets_in_session = $vincenzo->get_list("SELECT * FROM `user_bets` WHERE `session_id` = " . $expired_session['id'] . " AND `status` = 'running'");
            
            echo "Found " . count($bets_in_session) . " bets to process\n";
            
            foreach ($bets_in_session as $bet) {
                $username_escaped = $vincenzo->real_escape_string($bet['username']);
                
                // ===== FIX: TRIM STRINGS TRƯỚC KHI SO SÁNH =====
                $bet_type_trimmed = trim($bet['bet_type']);
                $winning_type_trimmed = trim($winning_type);
                
                // DEBUG LOG (comment out sau khi fix)
                echo "DEBUG - Bet ID: {$bet['id']}, User: {$bet['username']}, Bet type raw: '{$bet['bet_type']}' (trimmed: '{$bet_type_trimmed}'), Winning type: '{$winning_type_trimmed}', Match?: " . ($bet_type_trimmed === $winning_type_trimmed ? 'YES' : 'NO') . "\n";
                
                if ($bet_type_trimmed === $winning_type_trimmed) {
                    // Người chơi thắng
                    $win_amount = (int)($bet['bet_amount'] * PAYOUT_RATE);
                    
                    echo "Processing WIN for user: {$bet['username']}, bet_amount: {$bet['bet_amount']}, win_amount: {$win_amount}\n";
                    
                    // Cập nhật trạng thái cược
                    $update_bet_sql = "UPDATE `user_bets` SET `status` = 'won', `win_amount` = {$win_amount} WHERE `id` = " . $bet['id'];
                    $vincenzo->query($update_bet_sql);
                    echo "Updated bet status to WON\n";
                    
                    // ===== FIX: CỘNG TIỀN TRỰC TIẾP BẰNG SQL =====
                    // Lấy số dư hiện tại
                    $current_user = $vincenzo->get_row("SELECT `coin`, `total_coin` FROM `users` WHERE `username` = '{$username_escaped}' LIMIT 1");
                    
                    if ($current_user) {
                        $old_coin = (int)$current_user['coin'];
                        $new_coin = $old_coin + $win_amount;
                        
                        $old_total = (int)$current_user['total_coin'];
                        $new_total = $old_total + $win_amount;
                        
                        // Cập nhật số dư
                        $update_user_sql = "UPDATE `users` SET `coin` = {$new_coin}, `total_coin` = {$new_total} WHERE `username` = '{$username_escaped}'";
                        $vincenzo->query($update_user_sql);
                        
                        echo "User {$bet['username']}: Old coin: {$old_coin} → New coin: {$new_coin}\n";
                        
                        // Ghi log vào point_status
                        $note = "Thắng cược phiên #{$expired_session['id']} - {$bet_type_trimmed}";
                        $insert_point_sql = "INSERT INTO `point_status` (`username`, `date`, `note`, `coin`, `received`) 
                                            VALUES ('{$username_escaped}', NOW(), '{$note}', {$win_amount}, 0)";
                        $vincenzo->query($insert_point_sql);
                        echo "Logged to point_status\n";
                    } else {
                        echo "ERROR: User {$bet['username']} not found!\n";
                    }
                    
                } else {
                    // Người chơi thua
                    $update_bet_sql = "UPDATE `user_bets` SET `status` = 'lost' WHERE `id` = " . $bet['id'];
                    $vincenzo->query($update_bet_sql);
                    echo "User {$bet['username']} lost (bet on {$bet_type_trimmed})\n";
                }
            }
            
            echo "Session {$expired_session['id']} finished successfully.\n\n";
        } else {
            echo "WARNING: Session {$expired_session['id']} has no valid result. Skipping...\n\n";
        }
    }
}

// =========================================================================
// BƯỚC 2: KIỂM TRA VÀ KHỞI ĐỘNG PHIÊN MỚI (Chỉ nếu không có phiên running)
// =========================================================================
$running_count = $vincenzo->get_one("SELECT COUNT(*) FROM `game_sessions` WHERE `status` = 'running'");

echo "Current running sessions: {$running_count}\n";

if ($running_count == 0) {
    // Lấy phiên upcoming tiếp theo
    $next_session = $vincenzo->get_row("SELECT * FROM `game_sessions` WHERE `status` = 'upcoming' ORDER BY `id` ASC LIMIT 1");
    
    if ($next_session) {
        $start_time = date('Y-m-d H:i:s');
        $end_time = date('Y-m-d H:i:s', time() + SESSION_DURATION_SECONDS);
        
        $vincenzo->update('game_sessions', [
            'status' => 'running',
            'start_time' => $start_time,
            'end_time' => $end_time
        ], "`id` = " . $next_session['id']);
        
        echo "Started new session ID: {$next_session['id']}\n";
        echo "Start time: {$start_time}, End time: {$end_time}\n\n";
    } else {
        echo "WARNING: No upcoming session found to start!\n\n";
    }
} else {
    echo "A session is already running. Skipping start step.\n\n";
}

// =========================================================================
// BƯỚC 3: BỔ SUNG PHIÊN UPCOMING CHO ĐỦ HÀNG CHỜ
// =========================================================================
$total_active = $vincenzo->get_one("SELECT COUNT(*) FROM `game_sessions` WHERE `status` IN ('running', 'upcoming')");
$needed = SESSION_QUEUE_SIZE - $total_active;

echo "Active sessions (running + upcoming): {$total_active}\n";
echo "Need to generate: {$needed} new session(s)\n";

if ($needed > 0) {
    for ($i = 0; $i < $needed; $i++) {
        // Tạo kết quả ngẫu nhiên 5 số từ 0-9
        $result_array = [];
        for ($j = 0; $j < 5; $j++) {
            $result_array[] = rand(0, 9);
        }
        $result_string = implode(',', $result_array);
        
        $vincenzo->insert('game_sessions', [
            'status' => 'upcoming',
            'result' => $result_string,
            'start_time' => '0000-00-00 00:00:00',
            'end_time' => '0000-00-00 00:00:00'
        ]);
        
        echo "Created upcoming session with result: {$result_string}\n";
    }
    echo "\n";
}

// =========================================================================
// BƯỚC 4: GỬI CẬP NHẬT QUA PUSHER
// =========================================================================
echo "Preparing Pusher update...\n";

// Lấy phiên đang chạy
$current_session = $vincenzo->get_row("SELECT * FROM `game_sessions` WHERE `status` = 'running' ORDER BY `id` DESC LIMIT 1");

// Lấy phiên vừa kết thúc gần nhất
$last_session = $vincenzo->get_row("SELECT * FROM `game_sessions` WHERE `status` = 'finished' ORDER BY `id` DESC LIMIT 1");

// Chuẩn bị dữ liệu
$response_data = [
    'next_id' => $current_session['id'] ?? null,
    'countdown' => 0,
    'last_id' => $last_session['id'] ?? null,
    'result' => [],
];

// Tính countdown nếu có phiên đang chạy
if ($current_session && !empty($current_session['end_time'])) {
    $end_timestamp = strtotime($current_session['end_time']);
    $now_timestamp = time();
    $response_data['countdown'] = max(0, $end_timestamp - $now_timestamp);
}

// Parse kết quả phiên cuối
if ($last_session && !empty($last_session['result'])) {
    $response_data['result'] = array_map('intval', explode(',', $last_session['result']));
}

echo "Pusher data: " . json_encode($response_data, JSON_PRETTY_PRINT) . "\n";

// Gửi qua Pusher
try {
    $pusher = new Pusher\Pusher(
        'd8f1f623fd37086447aa', 
        'b7c8376810dbe2c0d74c', 
        '2066362', 
        ['cluster' => 'ap1', 'useTLS' => true]
    );
    
    $pusher->trigger('game-events', 'state-update', $response_data);
    echo "Successfully pushed to Pusher!\n";
    
} catch (Exception $e) {
    echo "ERROR: Pusher failed - " . $e->getMessage() . "\n";
}

// =========================================================================
// BƯỚC 5: XỬ LÝ STUCK BETS (Bets running nhưng session finished)
// =========================================================================
$stuck_bets = $vincenzo->get_list("SELECT ub.*, gs.status as session_status, gs.end_time, gs.result as session_result 
    FROM `user_bets` ub 
    JOIN `game_sessions` gs ON ub.session_id = gs.id 
    WHERE ub.status = 'running' AND gs.status = 'finished' 
    LIMIT 50");  // Tăng limit nếu cần

if (!empty($stuck_bets)) {
    echo "\n=== PROCESSING STUCK BETS ===\n";
    foreach ($stuck_bets as $stuck) {
        echo "Processing stuck bet ID: {$stuck['id']}, User: {$stuck['username']}, Session: {$stuck['session_id']}\n";
        
        if (!empty($stuck['session_result']) && $stuck['session_result'] !== '0,0,0,0,0') {
            $result_array = array_map('intval', explode(',', $stuck['session_result']));
            $sum = array_sum($result_array);
            $last_digit = $sum % 10;
            $winning_type = ($last_digit >= 5) ? 'TH TRUEMILK' : 'VINAMILK';
            
            $bet_type_trimmed = trim($stuck['bet_type']);
            $winning_type_trimmed = trim($winning_type);
            
            // DEBUG LOG
            echo "DEBUG - Stuck bet: Bet type trimmed: '{$bet_type_trimmed}', Winning: '{$winning_type_trimmed}', Match?: " . ($bet_type_trimmed === $winning_type_trimmed ? 'YES' : 'NO') . "\n";
            
            $username_escaped = $vincenzo->real_escape_string($stuck['username']);
            
            if ($bet_type_trimmed === $winning_type_trimmed) {
                // Xử lý thắng
                $win_amount = (int)($stuck['bet_amount'] * PAYOUT_RATE);
                
                // Cập nhật bet
                $update_bet_sql = "UPDATE `user_bets` SET `status` = 'won', `win_amount` = {$win_amount} WHERE `id` = " . $stuck['id'];
                $vincenzo->query($update_bet_sql);
                
                // Cập nhật user
                $current_user = $vincenzo->get_row("SELECT `coin`, `total_coin` FROM `users` WHERE `username` = '{$username_escaped}' LIMIT 1");
                if ($current_user) {
                    $old_coin = (int)$current_user['coin'];
                    $new_coin = $old_coin + $win_amount;
                    $old_total = (int)$current_user['total_coin'];
                    $new_total = $old_total + $win_amount;
                    
                    $update_user_sql = "UPDATE `users` SET `coin` = {$new_coin}, `total_coin` = {$new_total} WHERE `username` = '{$username_escaped}'";
                    $vincenzo->query($update_user_sql);
                    
                    echo "Fixed stuck WIN: User {$stuck['username']}: +{$win_amount} coin\n";
                    
                    // Log
                    $note = "Thắng cược stuck phiên #{$stuck['session_id']} - {$bet_type_trimmed}";
                    $insert_point_sql = "INSERT INTO `point_status` (`username`, `date`, `note`, `coin`, `received`) 
                                        VALUES ('{$username_escaped}', NOW(), '{$note}', {$win_amount}, 0)";
                    $vincenzo->query($insert_point_sql);
                } else {
                    echo "ERROR: User {$stuck['username']} not found for stuck bet!\n";
                }
            } else {
                // Xử lý thua
                $update_bet_sql = "UPDATE `user_bets` SET `status` = 'lost' WHERE `id` = " . $stuck['id'];
                $vincenzo->query($update_bet_sql);
                echo "Fixed stuck LOST for user: {$stuck['username']} (bet on {$bet_type_trimmed})\n";
            }
        } else {
            echo "WARNING: Stuck bet in session {$stuck['session_id']} has no valid result. Skipping...\n";
        }
    }
    echo "Stuck bets processing completed.\n\n";
}

// Commit transaction
$vincenzo->commit();

echo "\n=== CRON JOB END: " . date('Y-m-d H:i:s') . " ===\n\n";
?>