<?php
// check_gift.php
session_start();
require_once __DIR__ . "/config/function.php";

$user_id = (int)$_GET['user_id'];
$last_id = (int)$_GET['last_id'] ?? 0;

// Check quà mới (chưa đọc)
$sql = "SELECT id, amount, type, note FROM user_gifts WHERE user_id = ? AND id > ? AND read = 0 ORDER BY id DESC LIMIT 1";
$gift = $_vincenzo->get_row($sql, [$user_id, $last_id]);

if ($gift) {
    $formatted = number_format($gift['amount'], 0, ',', '.');
    echo json_encode([
        'success' => true,
        'gift' => $gift,
        'formatted' => $formatted,
        'message' => "Xin chúc mừng! Bạn nhận quà {$gift['type']} trị giá {$formatted} VND từ Vinamilk."
    ]);

    // Đánh dấu đã đọc
    $_vincenzo->query("UPDATE user_gifts SET read = 1 WHERE id = ?", [$gift['id']]);
} else {
    echo json_encode(['success' => false]);
}
?>