<?php
// chat_load_messages.php (ĐÃ SỬA LỖI HIỂN THỊ HÌNH ẢNH)
include __DIR__ . '/config/function.php';

$user_id = $getUser['id'];
$sql = "
    SELECT * 
    FROM `chat_messages` 
    WHERE (sender_id = $user_id AND sender_type = 'user') OR (receiver_id = $user_id AND sender_type = 'admin')
    ORDER BY created_at ASC
";

$chat_messages = $_vincenzo->get_list($sql);

foreach ($chat_messages as $message) {
    // --- PHẦN SỬA LỖI: Xử lý hiển thị nhiều hình ảnh từ chuỗi JSON ---
    $images_html = '';
    if (!empty($message['images'])) {
        $images_arr = json_decode($message['images'], true);
        if (is_array($images_arr)) {
            // Lặp qua mảng URL để tạo các thẻ a và img
            foreach($images_arr as $img_url) {
                $images_html .= '<a href="'.htmlspecialchars($img_url).'" target="_blank"><img src="'.htmlspecialchars($img_url).'" alt="Image"></a>';
            }
        }
    }
    // --- KẾT THÚC PHẦN SỬA LỖI ---
    
    // Logic xác định tin nhắn của USER hay ADMIN
    if ($message['sender_type'] == 'user') {
        // Tin nhắn từ người dùng (bên phải)
        echo '<div class="message-wrapper align-right">
                <div class="message-content-container">
                    <span class="message-sender">' . htmlspecialchars($getUser['username']) . '</span>
                    <div class="message-box user-message bg-user">
                        <p class="mb-0 text-message">' . nl2br(htmlspecialchars($message['message'])) . '</p>
                        <div class="d-flex flex-wrap align-items-center gap-2 mt-2">' . $images_html . '</div>
                        <span class="message-time small">' . date('H:i', strtotime($message['created_at'])) . '</span>
                    </div>
                </div>
              </div>';
    } else {
        // Tin nhắn từ admin (bên trái)
        echo '<div class="message-wrapper align-left">
                <div class="message-content-container">
                    <span class="message-sender">CSKH FAMILYMIK</span>
                    <div class="message-box admin-message bg-admin">
                        <p class="mb-0 text-message">' . nl2br(htmlspecialchars($message['message'])) . '</p>
                        <div class="d-flex flex-wrap align-items-center gap-2 mt-2">' . $images_html . '</div>
                        <span class="message-time small">' . date('H:i', strtotime($message['created_at'])) . '</span>
                    </div>
                </div>
              </div>';
    }
}

// Thêm các lớp CSS cần thiết để đảm bảo giao diện luôn đúng
echo '
<style>
    .message-wrapper { display: flex; margin-bottom: 15px; }
    .message-wrapper.align-right { justify-content: flex-end; }
    .message-wrapper.align-left { justify-content: flex-start; }
    .message-content-container { max-width: 80%; }
    .message-box { padding: 10px; border-radius: 10px; color: #fff; }
    .bg-user { background-color: #007bff; }
    .bg-admin { background-color: #6c757d; }
    .message-sender { font-size: 12px; color: #ccc; margin-bottom: 5px; display: block; }
    .message-wrapper.align-right .message-sender { text-align: right; }
    .message-time { display: block; text-align: right; font-size: 11px; margin-top: 5px; color: #eee; }
    .message-box .text-message { margin: 0; word-wrap: break-word; }
    .message-box img { max-width: 200px; height: auto; border-radius: 6px; }
</style>
';
?>