<?php
// chat.php - PHIÊN BẢN HOÀN CHỈNH - REAL-TIME, ĐỒNG BỘ GIAO DIỆN VÀ THỜI GIAN

// --- BƯỚC 1: CÀI ĐẶT MÔI TRƯỜNG SERVER ---
// Luôn đặt múi giờ ở đầu file để đảm bảo mọi hàm date() đều chính xác
date_default_timezone_set('Asia/Ho_Chi_Minh');

// Nạp các file cần thiết
require_once __DIR__ . "/head.php";
require_once __DIR__ . '/vendor/autoload.php';

use Pusher\Pusher;
$pusher = null;
try {
    // Thay thế bằng key của bạn nếu cần
    $pusher = new Pusher('2d0f22dbc701cefbfde0', 'ecd8c8070503a09fda8c', '1951282', ['cluster' => 'mt1', 'useTLS' => true]);
} catch (Exception $e) { 
    error_log("Pusher init error: " . $e->getMessage()); 
}

// --- BƯỚC 2: XỬ LÝ YÊU CẦU AJAX KHI USER GỬI TIN NHẮN ---
if (isset($_GET['action']) && $_GET['action'] == 'send_message') {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        header('Content-Type: application/json');
        $message = trim($_POST['message'] ?? '');
        $current_time = date('Y-m-d H:i:s'); // Lấy thời gian chuẩn từ server

        if (!empty($message) || !empty($_FILES['images']['name'][0])) {
            $images_to_save = null; 
            $images_to_push = [];

            // Xử lý upload nhiều ảnh và gộp thành 1 chuỗi JSON
            if (!empty($_FILES['images']['name'][0])) {
                $upload_dir = __DIR__ . '/upload/chat_images/';
                if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);
                foreach ($_FILES['images']['name'] as $key => $name) {
                    if ($_FILES['images']['error'][$key] === UPLOAD_ERR_OK) {
                        $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
                        $newName = time() . '_' . rand(1000, 9999) . '.' . $ext;
                        if (move_uploaded_file($_FILES['images']['tmp_name'][$key], $upload_dir . $newName)) {
                            $images_to_push[] = BASE_URL() . 'upload/chat_images/' . $newName;
                        }
                    }
                }
                if(!empty($images_to_push)) $images_to_save = json_encode($images_to_push);
            }
            
            // Lưu vào database với 1 bản ghi duy nhất
            $_vincenzo->insert("chat_messages", [
                'sender_id' => $getUser['id'], 'sender_type' => 'user', 'receiver_id' => 1,
                'message' => $message, 'images' => $images_to_save, 'created_at' => $current_time
            ]);
            
            // Báo cho admin có tin nhắn mới qua Pusher
            if ($pusher) {
                $pusher->trigger('admin-notifications', 'new-user-message', ['user_id' => $getUser['id']]);
            }

            // Trả về dữ liệu tin nhắn hoàn chỉnh (bao gồm thời gian server) cho JavaScript
            $response_data = [
                'sender_type' => 'user', 'message' => $message, 'images' => $images_to_push, 'created_at' => $current_time
            ];
            echo json_encode(['success' => true, 'message_data' => $response_data]);

        } else {
            echo json_encode(['success' => false, 'error' => 'Dữ liệu không hợp lệ.']);
        }
        exit; // Dừng script sau khi xử lý AJAX
    }
}
?>

<!-- --- BƯỚC 3: GIAO DIỆN HTML VÀ CSS (TƯƠNG THÍCH VỚI LAYOUT CỦA BẠN) --- -->
<style>
    body { background: #272d2d !important; }
    .border { border: 1px solid #dee2e600 !important; }
    #imagePreviewContainer img { max-height: 60px; margin: 5px; border-radius: 4px; }
    
    .message-wrapper { display: flex; margin-bottom: 15px; }
    .message-wrapper.align-right { justify-content: flex-end; }
    .message-wrapper.align-left { justify-content: flex-start; }
    .message-content-container { max-width: 80%; }
    .message-box { padding: 10px; border-radius: 10px; color: #fff; }
    .bg-user { background-color: #007bff; }
    .bg-admin { background-color: #6c757d; }
    .message-sender { font-size: 12px; color: #ccc; margin-bottom: 5px; display: block; }
    .message-wrapper.align-right .message-sender { text-align: right; }
    .message-time { display: block; text-align: right; font-size: 11px; margin-top: 5px; color: #eee; }
    .message-box .text-message { margin: 0; word-wrap: break-word; }
    .message-box img { max-width: 200px; height: auto; border-radius: 6px; }
</style>

<div class="d-flex flex-row vh-100">
    <div class="flex-grow-1">
		<div class="chat-support-container text-center">
			<div class="chat-avatar-wrapper mt-2"><img src="upload/default-chat-icon.png" alt="Chat Support" class="chat-avatar"></div>
			<div class="chat-info">
				<h1 class="chat-title">CSKH FAMILYMIK</h1>
				<div class="chat-subtitle">Thương hiệu mang tới &quot;hạnh phúc đích thực&quot;</div>
			</div>
		</div>

		<div id="chatMessages" class="border p-3 mb-3 chat-container" style="height: 65vh; overflow-y: auto;"></div>
		<div id="imagePreviewContainer" class="d-flex flex-wrap" style="position: fixed; bottom: 140px; width:100%; z-index: 9999;"></div>

		<form id="chatForm" onsubmit="sendMessage(event)" method="POST" enctype="multipart/form-data" style="position: fixed; bottom: 64px; width:100%; z-index: 9999;">
			<div class="chat-input-container d-flex align-items-center border rounded p-2 shadow-sm" style="background-color: #f9f9f9;">
				<textarea class="form-control border-0 shadow-none me-2" placeholder="Viết tin nhắn..." name="message" id="chatInput" rows="1" style="resize: none;"></textarea>
				<label for="fileInput" class="btn btn-link text-secondary me-2" title="Tải lên hình ảnh"><i class="fas fa-image"></i></label>
				<input type="file" id="fileInput" class="d-none" accept="image/*" name="images[]" multiple>
				<button type="submit" class="btn btn-link text-primary" id="sendButton" title="Gửi tin nhắn"><i class="fas fa-paper-plane"></i></button>
			</div>
		</form>
    </div>
</div>

<!-- --- BƯỚC 4: JAVASCRIPT REAL-TIME VÀ ĐỒNG BỘ THỜI GIAN --- -->
<script src="https://js.pusher.com/8.2/pusher.min.js"></script>
<script>
document.addEventListener("DOMContentLoaded", function() {
    const currentUserId = <?php echo $getUser['id']; ?>;
    const currentUsername = '<?php echo htmlspecialchars($getUser['username']); ?>';
    const chatMessages = document.getElementById("chatMessages");
    const chatInput = document.getElementById("chatInput");
    const fileInput = document.getElementById("fileInput");
    const imagePreviewContainer = document.getElementById("imagePreviewContainer");

    function scrollToBottom() { chatMessages.scrollTop = chatMessages.scrollHeight; }
    
    function appendMessage(data) {
        let imagesHtml = '';
        if (data.images && data.images.length > 0) {
            data.images.forEach(imgUrl => { imagesHtml += `<a href="${imgUrl}" target="_blank"><img src="${imgUrl}" alt="Image"></a>`; });
        }
        
        const time = new Date(data.created_at || new Date());
        const timeString = time.getHours().toString().padStart(2, '0') + ':' + time.getMinutes().toString().padStart(2, '0');
        const isUser = data.sender_type === 'user';
        const senderName = isUser ? currentUsername : 'CSKH FAMILYMIK';
        const wrapperClass = isUser ? 'align-right' : 'align-left';
        const boxClass = isUser ? 'user-message bg-user' : 'admin-message bg-admin';

        const messageWrapper = document.createElement('div');
        messageWrapper.className = `message-wrapper ${wrapperClass}`;
        
        // Gán ID tạm thời nếu có, để có thể tìm và sửa lại sau
        if (data.tempId) { messageWrapper.id = data.tempId; }

        messageWrapper.innerHTML = `
            <div class="message-content-container">
                <span class="message-sender">${senderName}</span>
                <div class="message-box ${boxClass}">
                    <p class="mb-0 text-message">${data.message.replace(/\n/g, '<br>')}</p>
                    <div class="d-flex flex-wrap align-items-center gap-2 mt-2">${imagesHtml}</div>
                    <span class="message-time small">${timeString}</span>
                </div>
            </div>`;
        chatMessages.appendChild(messageWrapper);
        scrollToBottom();
    }
    
    window.sendMessage = function(event) {
        event.preventDefault();
        const message = chatInput.value.trim();
        const files = Array.from(fileInput.files);
        if (message === '' && files.length === 0) return;

        // 1. Tạo ID tạm thời duy nhất
        const tempId = 'temp_msg_' + Date.now();

        // 2. Hiển thị tin nhắn "giả" ngay lập tức với ID tạm thời
        appendMessage({
            tempId: tempId,
            sender_type: 'user',
            message: message,
            images: files.map(file => URL.createObjectURL(file)),
            created_at: new Date().toISOString()
        });

        // 3. Gửi dữ liệu thật lên server
        const formData = new FormData(document.getElementById('chatForm'));
        fetch('chat.php?action=send_message', { method: 'POST', body: formData })
            .then(res => res.json())
            .then(data => { 
                const tempMessage = document.getElementById(tempId);
                if (data.success) {
                    // 4. Sửa chữa: Tìm lại tin nhắn "giả" và cập nhật thời gian đúng từ server
                    if (tempMessage) {
                        const correctTime = new Date(data.message_data.created_at);
                        const correctTimeString = correctTime.getHours().toString().padStart(2, '0') + ':' + correctTime.getMinutes().toString().padStart(2, '0');
                        const timeElement = tempMessage.querySelector('.message-time');
                        if (timeElement) { timeElement.textContent = correctTimeString; }
                        tempMessage.removeAttribute('id'); // Hoàn tất, xóa ID tạm thời
                    }
                } else { 
                    alert('Lỗi: ' + (data.error || 'Không thể gửi tin nhắn.')); 
                    if (tempMessage) { tempMessage.remove(); } // Xóa tin nhắn "giả" nếu gửi thất bại
                }
            });

        // 5. Xóa nội dung form
        chatInput.value = ''; fileInput.value = ''; imagePreviewContainer.innerHTML = ''; chatInput.focus();
    }

    function loadChatHistory() {
        fetch("./chat_load_messages.php").then(res => res.text()).then(html => {
            chatMessages.innerHTML = html;
            scrollToBottom();
        });
    }
    
    loadChatHistory();

    const pusher = new Pusher('2d0f22dbc701cefbfde0', { cluster: 'mt1' });
    const channel = pusher.subscribe(`chat-channel-${currentUserId}`);
    channel.bind('new-message', function(data) {
        if (data.sender_type === 'admin') {
            appendMessage(data); // Tin nhắn từ admin đã có sẵn thời gian chuẩn
        }
    });

    fileInput.addEventListener("change", function(event) {
        imagePreviewContainer.innerHTML = "";
        Array.from(event.target.files).forEach(file => {
            if (file.type.startsWith("image/")) {
                const reader = new FileReader();
                reader.onload = e => {
                    const img = document.createElement("img");
                    img.src = e.target.result;
                    imagePreviewContainer.appendChild(img);
                };
                reader.readAsDataURL(file);
            }
        });
    });

    chatInput.addEventListener("keypress", function(e) {
        if (e.key === "Enter" && !e.shiftKey) { 
            e.preventDefault(); 
            document.getElementById('chatForm').dispatchEvent(new Event('submit', { cancelable: true, bubbles: true }));
        }
    });
});
</script>

<?php
require_once __DIR__ . "/foot.php";
?>