<?php
require_once __DIR__ . "/head.php";

$per_page = 10;
$current_page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($current_page - 1) * $per_page;

// Get total count
$count_query = "SELECT COUNT(*) as total FROM `point_status` WHERE `username` = '" . $getUser['username'] . "'";
$count_result = $_vincenzo->get_list($count_query);
$total_items = $count_result[0]['total'] ?? 0;
$total_pages = ceil($total_items / $per_page);

// Get paginated data
$main_query = "SELECT * FROM `point_status` WHERE `username` = '" . $getUser['username'] . "' ORDER BY `id` DESC LIMIT " . $per_page . " OFFSET " . $offset;
$page_data = $_vincenzo->get_list($main_query);

// Adjust current_page if total_pages is less
$current_page = min($current_page, $total_pages);
?>


<style>
    .modal-custom {
        max-width: 500px;
        min-height: 100vh;
        margin: 0px auto;
        background: #fff;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
    }

    .modal-header {
        background-color: #26a69a;
        color: white;
        padding: 12px;
        text-align: center;
        font-size: 16px;
        font-weight: bold;
    }

    .summary-box {
        background-color: #e0f2f1;
        padding: 10px;
        display: flex;
        justify-content: space-between;
        font-size: 14px;
        font-weight: bold;
    }

    .table {
        width: 100%;
        font-size: 14px;
        border-collapse: collapse;
    }

    .table thead {
        background-color: #eceff1;
    }

    .table th,
    .table td {
        padding: 8px 10px;
        border-bottom: 1px solid #ddd;
        vertical-align: top;
    }

    .table td.amount-positive {
        color: #00796b;
    }

    .table td.amount-negative {
        color: #d32f2f;
    }

    .pagination {
        display: flex;
        justify-content: center;
        margin: 15px 0;
    }

    .pagination a,
    .pagination span {
        margin: 0 3px;
        padding: 5px 10px;
        text-decoration: none;
        border-radius: 4px;
        font-size: 14px;
    }

    .pagination a {
        background-color: #f1f1f1;
        color: #333;
    }

    .pagination a:hover {
        background-color: #b2dfdb;
    }

    .pagination .active {
        background-color: #26a69a;
        color: white;
        font-weight: bold;
    }
</style>

<div class="modal-custom">
    <div class="modal-header">Biến Động Số Điểm</div>
    <div class="summary-box">
        <div>Tổng số GD: <strong><?php echo $total_items; ?></strong></div>
        <div>Trang: <strong><?php echo $current_page . '/' . $total_pages; ?></strong></div>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>Thời gian</th>
                <th>Nội dung</th>
                <th>Điểm</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($page_data)): ?>
                <tr>
                    <td colspan="3" style="text-align:center;">Không có dữ liệu</td>
                </tr>
            <?php else: ?>
                <?php foreach ($page_data as $item): ?>
                    <?php
                    // Assuming columns: 'created_at' for time, 'note' for content, 'amount' for points
                    // Adjust column names as per your database schema
                    $time = $item['date'] ?? '';
                    $content = $item['note'] ?? '';
                    $points = $item['coin'] ?? 0;
                    ?>
                    <tr>
                        <td><?php echo htmlspecialchars($time); ?></td>
                        <td><?php echo htmlspecialchars($content); ?></td>
                        <td><?php echo htmlspecialchars($points); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>

    <?php if ($total_pages > 1): ?>
        <div class="pagination">
            <?php if ($current_page > 1): ?>
                <a href="?page=<?php echo $current_page - 1; ?>">« Trước</a>
            <?php endif; ?>

            <?php
            // Hiển thị các trang, giới hạn số trang hiển thị nếu nhiều
            $start_page = max(1, $current_page - 2);
            $end_page = min($total_pages, $current_page + 2);
            if ($start_page > 1): ?>
                <a href="?page=1">1</a>
                <?php if ($start_page > 2): ?>
                    <span>...</span>
                <?php endif; ?>
            <?php endif; ?>

            <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
                <?php if ($i == $current_page): ?>
                    <span class="active"><?php echo $i; ?></span>
                <?php else: ?>
                    <a href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                <?php endif; ?>
            <?php endfor; ?>

            <?php if ($end_page < $total_pages): ?>
                <?php if ($end_page < $total_pages - 1): ?>
                    <span>...</span>
                <?php endif; ?>
                <a href="?page=<?php echo $total_pages; ?>"><?php echo $total_pages; ?></a>
            <?php endif; ?>

            <?php if ($current_page < $total_pages): ?>
                <a href="?page=<?php echo $current_page + 1; ?>">Tiếp »</a>
            <?php endif; ?>
        </div>
    <?php endif; ?>

</div>

<?php
require_once __DIR__ . "/foot.php";


?>