<?php
header('Content-Type: application/json'); // Rất quan trọng: báo cho trình duyệt biết đây là dữ liệu JSON
require_once __DIR__ . '/config/config.php';

$vincenzo = new Vincenzo();

// Lấy phiên đang chạy mới nhất
$current_session = $vincenzo->get_row("SELECT * FROM `game_sessions` WHERE `status` = 'running' ORDER BY `id` DESC LIMIT 1");

// Lấy phiên đã kết thúc mới nhất
$last_session = $vincenzo->get_row("SELECT * FROM `game_sessions` WHERE `status` = 'finished' ORDER BY `id` DESC LIMIT 1");

$response = [
    'next_id' => null,
    'countdown' => 0,
    'last_id' => null,
    'result' => [],
];

if ($current_session) {
    $response['next_id'] = $current_session['id'];
    // Tính thời gian đếm ngược
    $countdown = strtotime($current_session['end_time']) - time();
    $response['countdown'] = max(0, $countdown); // Đảm bảo không bị số âm
}

if ($last_session) {
    $response['last_id'] = $last_session['id'];
    // Chuyển chuỗi kết quả "3,1,6,5,0" thành mảng [3, 1, 6, 5, 0]
    if (!empty($last_session['result'])) {
        $response['result'] = array_map('intval', explode(',', $last_session['result']));
    }
}

// Trả về dữ liệu dưới dạng JSON
echo json_encode($response);

$vincenzo->dis_connect();

?>