<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$gift_id = (int)$_POST['gift_id'] ?? 0;
if ($gift_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid gift ID']);
    exit;
}

// Kết nối DB
$conn = new mysqli("localhost", "eqwdrsog_test", "eqwdrsog_test", "eqwdrsog_test");
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'DB error']);
    exit;
}
$conn->set_charset("utf8mb4");

// Update (dùng is_received nếu có, fallback received)
$sql = "UPDATE user_gifts SET is_received = 1 WHERE id = ? AND user_id = ?";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    $sql = "UPDATE user_gifts SET received = 1 WHERE id = ? AND user_id = ?"; // Fallback
    $stmt = $conn->prepare($sql);
}
$stmt->bind_param("ii", $gift_id, $_SESSION['user_id']);
$success = $stmt->execute() && $stmt->affected_rows > 0;

echo json_encode(['success' => $success, 'message' => $success ? 'Gift received!' : 'Gift not found']);
$conn->close();
?>