<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'gifts' => []]);
    exit;
}

$user_id = (int)$_SESSION['user_id'];  // Default từ session
$last_id = (int)($_GET['last_id'] ?? 0);

// ✅ FIX: Fallback user_id từ GET nếu session fail (debug)
if (isset($_GET['user_id']) && $_GET['user_id'] > 0) {
    $user_id = (int)$_GET['user_id'];
    error_log("Fallback user_id from GET: " . $user_id);  // DEBUG log server
}

// Kết nối DB
$conn = new mysqli("localhost", "eqwdrsog_test", "eqwdrsog_test", "eqwdrsog_test");
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'gifts' => []]);
    exit;
}
$conn->set_charset("utf8mb4");

// ✅ DEBUG: Log query params
error_log("Query gifts for user_id: $user_id, last_id: $last_id");

// Query gifts unread (dùng is_received nếu có, fallback received)
$sql = "SELECT id, amount, type, note FROM user_gifts WHERE user_id = ? AND (is_received = 0 OR received = 0) AND id > ? ORDER BY id ASC LIMIT 5";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    error_log("Unread query fail, fallback to all > last_id: " . $conn->error);  // DEBUG
    $sql = "SELECT id, amount, type, note FROM user_gifts WHERE user_id = ? AND id > ? ORDER BY id ASC LIMIT 5"; // Fallback nếu thiếu cột
    $stmt = $conn->prepare($sql);
}
$stmt->bind_param("ii", $user_id, $last_id);
$stmt->execute();
$result = $stmt->get_result();
$gifts = [];
while ($row = $result->fetch_assoc()) {
    $gifts[] = $row;
}

error_log("Found " . count($gifts) . " unread gifts");  // DEBUG

echo json_encode(['success' => true, 'gifts' => $gifts]);
$conn->close();
?>