<?php
require_once __DIR__ . "/head.php";

// Giả định admin đã đăng nhập để test
$_SESSION['activeAdmin'] = 'tom88'; 
$adminUsername = $_SESSION['activeAdmin'];

// --- LỚP KẾT NỐI CƠ SỞ DỮ LIỆU ---
class DB {
    private $conn;
    public function __construct() {
        $servername = "localhost";
        $username   = "eqwdrsog_test";
        $password   = "eqwdrsog_test";
        $dbname     = "eqwdrsog_test";
        try {
            $this->conn = new PDO("mysql:host=$servername;dbname=$dbname;charset=utf8mb4", $username, $password);
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
        } catch(PDOException $e) {
            die("Lỗi kết nối cơ sở dữ liệu: " . $e->getMessage());
        }
    }
    public function execute_query($sql, $params = []) {
        $stmt = $this->conn->prepare($sql);
        $stmt->execute($params);
        return $stmt;
    }
    public function get_list($sql, $params = []) {
        return $this->execute_query($sql, $params)->fetchAll();
    }
    public function get_row($sql, $params = []) {
        return $this->execute_query($sql, $params)->fetch();
    }
    public function get_one($sql, $params = []) {
        return $this->execute_query($sql, $params)->fetchColumn();
    }
}
$_vincenzo = new DB();
// ================= HEAD.PHP SIMULATION END ====================


// ================= BACK-END LOGIC START =======================

// --- CẤU HÌNH PHÂN TRANG ---
$per_page = 10; // Số mục trên mỗi trang
$current_page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($current_page - 1) * $per_page;

// --- XỬ LÝ TÌM KIẾM VÀ LỌC (AN TOÀN VỚI PREPARED STATEMENTS) ---
$conditions = [];
$params = [];
$query_params_url = '';

// Lọc theo từ khóa
$search_term = $_GET['search'] ?? '';
if (!empty($search_term)) {
    $conditions[] = "(`username` LIKE :search OR `stk_bank` LIKE :search OR `name_bank` LIKE :search)";
    $params[':search'] = "%" . $search_term . "%";
    $query_params_url .= '&search=' . urlencode($search_term);
}

// Lọc theo trạng thái
$status_filter = $_GET['status'] ?? '';
if (!empty($status_filter)) {
    // Chuyển đổi giá trị từ form sang giá trị trong database
    $status_map = [
        'pending' => 'Đang Duyệt',
        'approved' => 'Thành Công',
        'failed' => 'Thất Bại',
        'reverted' => 'Hoàn'
    ];
    if (array_key_exists($status_filter, $status_map)) {
        $conditions[] = "`status` = :status";
        $params[':status'] = $status_map[$status_filter];
    }
    $query_params_url .= '&status=' . urlencode($status_filter);
}

$where_clause = '';
if (!empty($conditions)) {
    $where_clause = " WHERE " . implode(' AND ', $conditions);
}

// --- TRUY VẤN DỮ LIỆU ---

// Đếm tổng số mục
$total_items = $_vincenzo->get_one("SELECT COUNT(*) FROM `history_withdraw`" . $where_clause, $params);
$total_pages = ceil($total_items / $per_page);

// Lấy dữ liệu cho trang hiện tại
$main_query = "SELECT *, id as uid FROM `history_withdraw`" . $where_clause . " ORDER BY CASE WHEN `status` = 'Đang Duyệt' THEN 0 ELSE 1 END, `id` DESC LIMIT " . $per_page . " OFFSET " . $offset;
$page_data = $_vincenzo->get_list($main_query, $params);


// --- CÁC HÀM HỖ TRỢ ---
function status_ruttien_badge($status) {
    switch ($status) {
        case 'Thành Công':
            return '<span class="badge bg-success text-white">Đã duyệt</span>';
        case 'Thất Bại':
            return '<span class="badge bg-danger text-white">Từ chối</span>';
        case 'Đang Duyệt':
            return '<span class="badge bg-warning">Xử lý</span>';
        case 'Hoàn':
            return '<span class="badge bg-info">Hoàn</span>';
        default:
            return '<span class="badge bg-secondary">Không xác định</span>';
    }
}
// ================= BACK-END LOGIC END =========================

?>

<style>
.swal-wide-popup { width: 700px !important; max-width: 95vw !important; }
.btn-add { color: #fff; background-color: #4d166e; border-color: #4d166e; }
.table-dark { position: sticky; top: 0; z-index: 10; }

/* CSS với kiểu 2 vạch đen song song, khoảng trắng nền trắng ở giữa như đường, đường kẻ rộng hơn */
.table-responsive {
    border: none;
    border-radius: 0;
    overflow: hidden;
    background: #fff;
}

.table {
    border-collapse: separate;
    border-spacing: 0;
    width: 100%;
    margin-bottom: 0;
    background: #fff;
}

.table-bordered {
    border: none !important;
}

.table thead th,
.table tbody td {
    position: relative;
    background: #fff;
    vertical-align: middle;
    padding: 12px 8px;
}

/* Viền dọc: 2 vạch đen với khoảng trắng rộng hơn ở giữa (tăng width lên 7px, khoảng trắng 5px) */
.table thead th:not(:last-child)::after,
.table tbody td:not(:last-child)::after {
    content: '';
    position: absolute;
    top: 0;
    bottom: 0;
    right: 0;
    width: 7px;
    background: linear-gradient(to right, #000 0px, #000 1px, transparent 1px, transparent 6px, #000 6px, #000 7px);
    background-size: 7px 1px;
}

.table thead th:first-child::before,
.table tbody td:first-child::before {
    content: '';
    position: absolute;
    top: 0;
    bottom: 0;
    left: 0;
    width: 7px;
    background: linear-gradient(to right, #000 0px, #000 1px, transparent 1px, transparent 6px, #000 6px, #000 7px);
    background-size: 7px 1px;
}

.table thead th:last-child::after,
.table tbody td:last-child::after {
    content: '';
    position: absolute;
    top: 0;
    bottom: 0;
    right: 0;
    width: 7px;
    background: linear-gradient(to right, #000 0px, #000 1px, transparent 1px, transparent 6px, #000 6px, #000 7px);
    background-size: 7px 1px;
}

/* Viền ngang cho header: 2 vạch đen với khoảng trắng */
.table thead th {
    border-top: 2px double #000 !important;
    border-bottom: 2px double #000 !important;
    background-color: #343a40 !important;
    color: #fff;
}

/* Viền ngang cho body: 1 vạch đơn giản, hàng cuối 2 vạch */
.table tbody td {
    border-bottom: 1px solid #000 !important;
}

.table tbody tr:last-child td {
    border-bottom: 2px double #000 !important;
}

/* Hover effect */
.table tbody tr:hover td {
    background-color: #f8f9fa !important;
}
</style>
            <h3 class="mb-4">Quản lý rút tiền</h3>
			
			<div class="d-flex justify-content-between align-items-center mb-3">
				<button class="btn btn-add" onclick="openQuickWithdrawSwal()">
					<i class="fas fa-plus-circle"></i> Thêm đơn rút điểm
				</button>
			</div>

            <!-- Form tìm kiếm -->
            <form method="GET" class="mb-3">
                <div class="input-group mb-2">
					<input type="text" name="search" class="form-control" placeholder="Tìm theo username, STK, tên chủ thẻ..." value="<?= htmlspecialchars($search_term) ?>">
                    <select name="status" class="form-select" onchange="this.form.submit()">
                        <option value="">Tất cả trạng thái</option>
                        <option value="pending" <?= $status_filter == 'pending' ? 'selected' : '' ?>>Xử lý</option>
                        <option value="approved" <?= $status_filter == 'approved' ? 'selected' : '' ?>>Đã duyệt</option>
                        <option value="failed" <?= $status_filter == 'failed' ? 'selected' : '' ?>>Từ chối</option>
                    </select>
                    <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i> Tìm kiếm</button>
                </div>
            </form>

            <!-- Danh sách giao dịch -->
            <div class="table-responsive">
                <table class="table table-bordered table-hover align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>#</th>
							<th>UID</th>
                            <th>Người dùng</th>
                            <th>Yêu cầu rút</th>
							<th>Thông tin thanh toán</th>
							<th>Mã QR</th>
                            <th>Trạng thái</th>
							<th>Xử lý bởi</th>
                            <th>Thời gian tạo</th>
                            <th>Tác vụ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($page_data)): ?>
                            <tr>
                                <td colspan="10" class="text-center py-5">
                                    <p class="mb-0 fw-semibold">Không tìm thấy giao dịch nào.</p>
                                    <small class="text-muted">Hãy thử thay đổi bộ lọc tìm kiếm.</small>
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($page_data as $item): ?>
                                <?php
                                    // Chuẩn bị dữ liệu JSON cho các hàm JavaScript
                                    $js_data = json_encode([
                                        'withdraw_id' => $item['id'],
                                        'username' => $item['username'],
                                        'user_id' => $item['id'],
                                        'amount' => number_format($item['coin']),
                                        'bank_name' => $item['bank_name'],
                                        'account_holder' => $item['name_bank'],
                                        'account_number' => $item['stk_bank'],
                                        'img_qr_url' => 'https://api.vietqr.io/' . $item['bank_name'] . '/' . $item['stk_bank'] . '/' . $item['coin'] . '/chuyen khoan/vietqr_net_2.jpg?accountName=' . urlencode($item['name_bank']),
                                    ], JSON_UNESCAPED_UNICODE);
                                    
                                    $revert_data = json_encode($item, JSON_UNESCAPED_UNICODE);
                                ?>
                                <tr>
                                    <td><?= $item['id'] ?></td>
                                    <td onclick="copyToClipboard('<?= $item['id'] ?>')" style="cursor:pointer;" title="Click để copy">
                                        <?= $item['id'] ?>
                                    </td>
                                    <td><?= htmlspecialchars($item['username']) ?></td>
                                    <td class="font-weight-bold text-danger">
                                        <?= number_format($item['coin']) ?>
                                    </td>
                                    <td>
                                        <span class="text-danger font-weight-bold"><?= htmlspecialchars($item['bank_name']) ?></span> -
                                        <span class="text-primary font-weight-bold"><?= htmlspecialchars($item['name_bank']) ?></span> -
                                        <span class="text-success font-weight-bold"><?= htmlspecialchars($item['stk_bank']) ?></span>
                                    </td>
                                    <td>
                                        <a href="<?= 'https://api.vietqr.io/' . $item['bank_name'] . '/' . $item['stk_bank'] . '/' . $item['coin'] . '/chuyen khoan/vietqr_net_2.jpg?accountName=' . urlencode($item['name_bank']) ?>" data-lightbox="qr-<?= $item['id'] ?>" data-title="Mã QR #<?= $item['id'] ?>">
                                            <img src="<?= 'https://api.vietqr.io/' . $item['bank_name'] . '/' . $item['stk_bank'] . '/' . $item['coin'] . '/chuyen khoan/vietqr_net_2.jpg?accountName=' . urlencode($item['name_bank']) ?>" alt="QR"
                                                 style="height: 50px; max-width: 100px; cursor: zoom-in;" class="img-thumbnail">
                                        </a>
                                    </td>
                                    <td><?= status_ruttien_badge($item['status']) ?></td>
                                    <td><?= ($item['status'] != 'Đang Duyệt') ? htmlspecialchars($adminUsername) : 'Chưa xử lý' ?></td>
                                    <td><?= date('Y-m-d H:i:s', strtotime($item['date'])) ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-info me-1" onclick='editWithdrawBankInfo(<?= $js_data ?>)' title="Chỉnh sửa">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-success" onclick='showWithdrawDetailPopup(<?= $js_data ?>)' title="Duyệt đơn">
                                            <i class="fas fa-check"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" onclick='confirmWithdrawRevert(<?= $revert_data ?>)' <?= ($item['status'] == 'Đang Duyệt') ? 'disabled' : '' ?> title="Hoàn tác về chờ duyệt">
                                            <i class="fas fa-undo"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="showRejectPopup('<?= $item['id'] ?>')" <?= ($item['status'] == 'Thất Bại') ? 'disabled' : '' ?> title="Từ chối">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

			<!-- Phân trang nâng cao -->
			<?php if ($total_pages > 1): ?>
			<nav aria-label="Page navigation">
				<ul class="pagination justify-content-center mt-4">
                    <!-- Nút Previous -->
					<li class="page-item <?= ($current_page <= 1) ? 'disabled' : '' ?>">
						<a class="page-link" href="?page=<?= $current_page - 1 ?><?= $query_params_url ?>">&laquo;</a>
					</li>
                    
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
					    <li class="page-item <?= ($i == $current_page) ? 'active' : '' ?>">
						    <a class="page-link" href="?page=<?= $i ?><?= $query_params_url ?>"><?= $i ?></a>
					    </li>
                    <?php endfor; ?>

                    <!-- Nút Next -->
					<li class="page-item <?= ($current_page >= $total_pages) ? 'disabled' : '' ?>">
						<a class="page-link" href="?page=<?= $current_page + 1 ?><?= $query_params_url ?>">&raquo;</a>
					</li>
				</ul>
			</nav>
			<?php endif; ?>

        </div>
    </div>
</div>

<script>
function showWithdrawDetailPopup(data) {	
	var content =
		'<div class="text-left">' +
			'<div class="mb-2"><strong>Người chơi:</strong> ' + data.username + '</div>' +
			'<div class="mb-2"><strong>ID người chơi:</strong> ' + data.user_id + '</div>' +
			'<div class="mb-2"><strong>Số tiền yêu cầu rút:</strong> ' + data.amount + '</div>' +
			'<hr class="my-2">' +
			'<div class="mb-2">Admin vui lòng chuyển khoản tới tài khoản:</div>' +
			'<div class="mb-1"><strong>Ngân hàng:</strong> <span class="text-success">' + data.bank_name + '</span></div>' +
			'<div class="mb-1"><strong>Chủ tài khoản:</strong> <span class="text-success">' + data.account_holder + '</span></div>' +
			'<div class="mb-1"><strong>Số tài khoản:</strong> <span class="text-success">' + data.account_number + '</span></div>' +
			(data.img_qr_url 
				? '<div class="mt-3 text-center"><strong>Mã QR:</strong><br><img src="' + data.img_qr_url + '" alt="QR" style="height: 300px; max-width: 100%; border-radius: 6px; border: 1px solid #ccc;"></div>' 
				: '<div class="mt-3 text-muted text-center">Không có mã QR</div>')
		'</div>';	
    Swal.fire({
        title: 'THÔNG TIN ĐƠN RÚT TIỀN',
        html: content,
        showCancelButton: true,
        confirmButtonText: '✅ Đã chuyển, Xác nhận duyệt',
        cancelButtonText: 'Hủy',
        customClass: { popup: 'swal-wide-popup', title: 'text-center' }
    }).then(function (result) {
        if (result.isConfirmed) {
            fetch("process_ruttien.php", {
                method: "POST",
                headers: { "Content-Type": "application/x-www-form-urlencoded" },
                body: "withdraw_id=" + encodeURIComponent(data.withdraw_id) + "&new_status=approved"
            })
            .then(res => res.json())
            .then(res => {
                if (res.success) {
                    Swal.fire('Thành công', 'Đơn rút đã được duyệt.', 'success').then(() => location.reload());
                } else {
                    Swal.fire('Lỗi', res.error || 'Không thể duyệt đơn rút.', 'error');
                }
            }).catch(() => Swal.fire('Lỗi', 'Lỗi kết nối máy chủ.', 'error'));
        }
    });
}

function confirmWithdrawRevert(data) {
    Swal.fire({
        title: 'HOÀN TÁC ĐƠN RÚT TIỀN?',
        html: `Bạn có chắc muốn hoàn tác đơn rút của <b>${data.username}</b> về trạng thái "Xử lý" không?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Xác nhận hoàn tác',
        cancelButtonText: 'Hủy'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch("process_ruttien.php", {
                method: "POST",
                headers: { "Content-Type": "application/x-www-form-urlencoded" },
                body: `withdraw_id=${data.id}&new_status=pending`
            })
            .then(res => res.json())
            .then(res => {
                if (res.success) {
                    Swal.fire('Đã hoàn tác', 'Đơn rút đã chuyển về trạng thái Xử lý.', 'success').then(() => location.reload());
                } else {
                    Swal.fire('Lỗi', res.error || 'Không thể cập nhật.', 'error');
                }
            }).catch(() => Swal.fire('Lỗi', 'Không thể kết nối máy chủ.', 'error'));
        }
    });
}

function showRejectPopup(withdrawId) {
    Swal.fire({
        title: 'Nhập lý do từ chối',
        input: 'textarea',
        inputPlaceholder: 'Nhập lý do từ chối tại đây (không bắt buộc)...',
        showCancelButton: true,
        confirmButtonText: 'Xác nhận từ chối',
        cancelButtonText: 'Hủy'
    }).then((result) => {
        if (result.isConfirmed) {
            let commentNote = result.value || '';
            fetch("process_ruttien.php", {
                method: "POST",
                headers: { "Content-Type": "application/x-www-form-urlencoded" },
                body: `withdraw_id=${withdrawId}&new_status=failed&comment_note=${encodeURIComponent(commentNote)}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire("Đã từ chối!", "Trạng thái đơn đã được cập nhật.", "success").then(() => location.reload());
                } else {
                    Swal.fire("Lỗi!", data.error, "error");
                }
            }).catch(() => Swal.fire("Lỗi!", "Không thể kết nối máy chủ!", "error"));
        }
    });
}

function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(() => {
        Swal.fire({
            toast: true, icon: 'success', title: 'Đã sao chép: ' + text,
            position: 'top-end', showConfirmButton: false, timer: 1500, timerProgressBar: true
        });
    });
}

function editWithdrawBankInfo(data) {
    Swal.fire({
        title: 'Chỉnh sửa thông tin ngân hàng',
        html:
            `<div class="text-left">
                <label class="mb-1"><strong>Chủ tài khoản</strong></label>
                <input id="edit_account_holder" class="form-control mb-3" value="${data.account_holder || ''}">
                <label class="mb-1"><strong>Tên ngân hàng</strong></label>
                <input id="edit_bank_name" class="form-control mb-3" value="${data.bank_name || ''}">
                <label class="mb-1"><strong>Số tài khoản</strong></label>
                <input id="edit_account_number" class="form-control" value="${data.account_number || ''}">
            </div>`,
        showCancelButton: true,
        confirmButtonText: 'Lưu thay đổi',
        preConfirm: () => {
            const holder = document.getElementById('edit_account_holder').value.trim();
            const bank = document.getElementById('edit_bank_name').value.trim();
            const number = document.getElementById('edit_account_number').value.trim();
            if (!holder || !bank || !number) {
                Swal.showValidationMessage('Vui lòng nhập đầy đủ thông tin');
                return false;
            }
            return { holder, bank, number };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const newInfo = result.value;
            fetch('update_withdraw_bank.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `withdraw_id=${data.withdraw_id}&account_holder=${encodeURIComponent(newInfo.holder)}&bank_name=${encodeURIComponent(newInfo.bank)}&account_number=${encodeURIComponent(newInfo.number)}`
            })
            .then(res => res.json())
            .then(res => {
                if (res.success) {
                    Swal.fire('Thành công', 'Thông tin ngân hàng đã cập nhật.', 'success').then(() => location.reload());
                } else {
                    Swal.fire('Lỗi', res.message || 'Cập nhật thất bại.', 'error');
                }
            }).catch(() => Swal.fire('Lỗi', 'Lỗi kết nối máy chủ.', 'error'));
        }
    });
}

function openQuickWithdrawSwal() {
    Swal.fire({
        title: 'Thêm đơn rút điểm',
        html: `
            <div class="text-left">
                <label class="mb-1"><strong>Username</strong></label>
                <input id="new_username" class="form-control mb-3" placeholder="Nhập username">
                <label class="mb-1"><strong>Số tiền rút</strong></label>
                <input id="new_amount" type="number" class="form-control mb-3" placeholder="Nhập số tiền">
                <label class="mb-1"><strong>Ngân hàng</strong></label>
                <input id="new_bank_name" class="form-control mb-3" placeholder="Tên ngân hàng">
                <label class="mb-1"><strong>Chủ tài khoản</strong></label>
                <input id="new_account_holder" class="form-control mb-3" placeholder="Tên chủ tài khoản">
                <label class="mb-1"><strong>Số tài khoản</strong></label>
                <input id="new_account_number" class="form-control" placeholder="Số tài khoản">
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Thêm đơn',
        cancelButtonText: 'Hủy',
        preConfirm: () => {
            const username = document.getElementById('new_username').value.trim();
            const amount = document.getElementById('new_amount').value.trim();
            const bank = document.getElementById('new_bank_name').value.trim();
            const holder = document.getElementById('new_account_holder').value.trim();
            const number = document.getElementById('new_account_number').value.trim();
            
            if (!username || !amount || !bank || !holder || !number) {
                Swal.showValidationMessage('Vui lòng nhập đầy đủ thông tin');
                return false;
            }
            return { username, amount, bank, holder, number };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const data = result.value;
            fetch('add_withdraw.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `username=${encodeURIComponent(data.username)}&amount=${encodeURIComponent(data.amount)}&bank_name=${encodeURIComponent(data.bank)}&account_holder=${encodeURIComponent(data.holder)}&account_number=${encodeURIComponent(data.number)}`
            })
            .then(res => res.json())
            .then(res => {
                if (res.success) {
                    Swal.fire('Thành công', 'Đơn rút mới đã được thêm.', 'success').then(() => location.reload());
                } else {
                    Swal.fire('Lỗi', res.message || 'Không thể thêm đơn rút.', 'error');
                }
            }).catch(() => Swal.fire('Lỗi', 'Lỗi kết nối máy chủ.', 'error'));
        }
    });
}
</script>

<?php require_once __DIR__ . "/foot.php"; ?>
</html>