<?php
require_once __DIR__ . "/head.php";
// Bật hiển thị lỗi để debug (tắt ở production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

//======================================================================
// PHẦN 1: CẤU HÌNH VÀ KẾT NỐI CƠ SỞ DỮ LIỆU
//======================================================================

define('DB_SERVER', 'localhost');
define('DB_USERNAME', 'eqwdrsog_test');
define('DB_PASSWORD', 'eqwdrsog_test'); // Sửa password
define('DB_NAME', 'eqwdrsog_test');

// Tạo kết nối bằng MySQLi
$conn = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);

// Kiểm tra kết nối
if ($conn->connect_error) {
    die("Lỗi kết nối cơ sở dữ liệu: " . $conn->connect_error);
}

// Thiết lập bộ ký tự UTF-8
$conn->set_charset("utf8mb4");


// Lấy danh sách yêu cầu rút tiền
$search_term = isset($_GET['search']) ? $conn->real_escape_string(trim($_GET['search'])) : '';
$status_filter = isset($_GET['status']) ? $conn->real_escape_string(trim($_GET['status'])) : '';

// Xây dựng câu truy vấn SQL
$sql_withdrawals = "
    SELECT hw.*, u.id as user_uid 
    FROM history_withdraw hw
    LEFT JOIN users u ON hw.username = u.username
    WHERE 1=1";

// Thêm điều kiện tìm kiếm
if (!empty($search_term)) {
    $sql_withdrawals .= " AND (hw.username LIKE '%$search_term%' OR u.id LIKE '%$search_term%')";
}

// Thêm điều kiện lọc trạng thái
if (!empty($status_filter)) {
    $status_map = [
        'pending' => 'Đang Duyệt',
        'approved' => 'Thành Công',
        'failed' => 'Thất Bại'
    ];
    if (array_key_exists($status_filter, $status_map)) {
        $db_status = $status_map[$status_filter];
        $sql_withdrawals .= " AND hw.status = '$db_status'";
    }
}

// Sắp xếp
$sql_withdrawals .= " ORDER BY hw.id DESC";

// Thực thi truy vấn
$result_withdrawals = $conn->query($sql_withdrawals);

// Kiểm tra lỗi query
if (!$result_withdrawals) {
    die("Lỗi truy vấn SQL: " . $conn->error);
}
?>
            
            <h3 class="mb-4">Quản lý rút tiền</h3>
            
            <div class="d-flex justify-content-between align-items-center mb-3">
                <button class="btn btn-add" onclick="openQuickWithdrawSwal()">
                    <i class="fas fa-plus-circle"></i> Thêm đơn rút điểm
                </button>
            </div>

            <!-- Form tìm kiếm -->
            <form method="GET" class="mb-3">
                <div class="row">
                    <div class="col-md-6 mb-2">
                        <input type="text" name="search" class="form-control" placeholder="Tìm theo Username hoặc UID..." value="<?php echo htmlspecialchars($search_term); ?>">
                    </div>
                    <div class="col-md-4 mb-2">
                        <select name="status" class="form-control">
                            <option value="">Tất cả trạng thái</option>
                            <option value="pending" <?php if ($status_filter == 'pending') echo 'selected'; ?>>Chờ duyệt</option>
                            <option value="approved" <?php if ($status_filter == 'approved') echo 'selected'; ?>>Đã duyệt</option>
                            <option value="failed" <?php if ($status_filter == 'failed') echo 'selected'; ?>>Từ chối</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-2">
                        <button class="btn btn-primary btn-block" type="submit"><i class="fas fa-search"></i> Tìm</button>
                    </div>
                </div>
            </form>

            <!-- Bảng Danh sách giao dịch -->
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="thead-dark">
                        <tr>
                            <th>#</th>
                            <th>UID</th>
                            <th>Người dùng</th>
                            <th>Yêu cầu rút (Coin)</th>
                            <th>Thông tin thanh toán</th>
                            <th>Trạng thái</th>
                            <th>Thời gian tạo</th>
                            <th class="text-center">Tác vụ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result_withdrawals && $result_withdrawals->num_rows > 0): ?>
                            <?php while($row = $result_withdrawals->fetch_assoc()): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($row['id']); ?></td>
                                    <td onclick="copyToClipboard('<?php echo htmlspecialchars($row['user_uid'] ?? 'N/A'); ?>')" style="cursor:pointer;" title="Click để sao chép">
                                        <?php echo htmlspecialchars($row['user_uid'] ?? 'N/A'); ?>
                                    </td>
                                    <td><?php echo htmlspecialchars($row['username']); ?></td>
                                    <td class="font-weight-bold text-danger">
                                        <?php echo number_format($row['coin']); ?>
                                    </td>
                                    <td style="font-size: 13px;">
                                        <div><span class="text-danger font-weight-bold"><?php echo htmlspecialchars($row['bank_name']); ?></span></div>
                                        <div><span class="text-primary"><?php echo htmlspecialchars($row['name_bank']); ?></span></div>
                                        <div><span class="text-success"><?php echo htmlspecialchars($row['stk_bank']); ?></span></div>
                                    </td>
                                    <td>
                                        <?php 
                                            $status = $row['status'];
                                            if ($status == 'Đang Duyệt') {
                                                echo '<span class="badge badge-warning">Chờ duyệt</span>';
                                            } elseif ($status == 'Thành Công') {
                                                echo '<span class="badge badge-success">Đã duyệt</span>';
                                            } elseif ($status == 'Thất Bại') {
                                                echo '<span class="badge badge-danger">Từ chối</span>';
                                            } elseif ($status == 'Hoàn') {
                                                echo '<span class="badge badge-info">Đã hoàn</span>';
                                            } else {
                                                echo '<span class="badge badge-secondary">'.htmlspecialchars($status).'</span>';
                                            }
                                        ?>
                                    </td>
                                    <td style="font-size: 12px;"><?php echo htmlspecialchars($row['date']); ?></td>
                                    <td class="text-center">
                                        <button class="btn btn-sm btn-info mb-1" title="Chỉnh sửa thông tin"
                                            onclick='editWithdrawBankInfo(<?php echo json_encode([
                                                "withdraw_id" => $row["id"],
                                                "account_holder" => $row["name_bank"],
                                                "bank_name" => $row["bank_name"],
                                                "account_number" => $row["stk_bank"]
                                            ], JSON_HEX_APOS | JSON_HEX_QUOT); ?>)'>
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-success mb-1" title="Xác nhận duyệt"
                                            onclick='showWithdrawDetailPopup(<?php echo json_encode([
                                                "withdraw_id" => $row["id"],
                                                "username" => $row["username"],
                                                "user_id" => $row["user_uid"] ?? "N/A",
                                                "amount" => number_format($row["coin"]),
                                                "bank_name" => $row["bank_name"],
                                                "account_holder" => $row["name_bank"],
                                                "account_number" => $row["stk_bank"]
                                            ], JSON_HEX_APOS | JSON_HEX_QUOT); ?>)'>
                                            <i class="fas fa-check"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger mb-1" title="Từ chối yêu cầu"
                                            onclick="showRejectPopup('<?php echo htmlspecialchars($row['id']); ?>')">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center">Không tìm thấy yêu cầu nào phù hợp.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Phân trang -->
            <nav aria-label="Page navigation">
                <ul class="pagination justify-content-center mt-4">
                    <li class="page-item disabled"><a class="page-link" href="#">&laquo;</a></li>
                    <li class="page-item active"><a class="page-link" href="#">1</a></li>
                    <li class="page-item"><a class="page-link" href="#">2</a></li>
                    <li class="page-item"><a class="page-link" href="#">3</a></li>
                    <li class="page-item"><a class="page-link" href="#">&raquo;</a></li>
                </ul>
            </nav>

        </div>
    </div>
</div>

<script>
// Toggle menu mobile
function togglePostsList() {
    document.getElementById('postsListContainer').classList.toggle('active');
}

// Format số
function formatNumberInput(input) {
    let raw = input.value.replace(/[^0-9]/g, '');
    input.value = raw ? Number(raw).toLocaleString('en-US') : '';
}

// Copy to clipboard
function copyToClipboard(text) {
    if (navigator.clipboard && window.isSecureContext) {
        navigator.clipboard.writeText(text).then(() => {
            Swal.fire({
                toast: true,
                icon: 'success',
                title: 'Đã sao chép: ' + text,
                position: 'top-end',
                showConfirmButton: false,
                timer: 1500,
                timerProgressBar: true
            });
        });
    }
}

// Popup: Thêm đơn rút điểm
function openQuickWithdrawSwal() {
    Swal.fire({
        title: 'THÊM ĐƠN RÚT ĐIỂM',
        html: `
            <div class="text-left mb-3">
                <label class="form-label"><strong>ID người chơi:</strong></label>
                <div class="input-group">
                    <input type="text" id="withdraw_user_id" class="form-control" placeholder="Nhập ID người chơi">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-primary" onclick="fetchWithdrawUser()">Tìm</button>
                    </div>
                </div>
            </div>
            <div id="withdraw_user_info" style="display:none;" class="text-left mt-3 border p-2"></div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Xác nhận tạo đơn',
        cancelButtonText: 'Hủy',
        focusConfirm: false,
        customClass: { popup: 'swal-wide-popup' },
        preConfirm: () => {
            const uid = document.getElementById('withdraw_user_id').value.trim();
            const rawAmount = (document.getElementById('withdraw_amount')?.value || '').replace(/,/g, '');
            const amount = parseInt(rawAmount) || 0;
            if (!uid || amount <= 0) {
                Swal.showValidationMessage('Vui lòng tìm người dùng và nhập số điểm rút hợp lệ');
                return false;
            }
            return { uid, amount };
        }
    }).then(result => {
        if (result.isConfirmed) {
            Swal.fire('Thành công', 'Đã tạo đơn rút điểm thành công!', 'success').then(() => location.reload());
        }
    });
}

// Fetch user info (demo)
function fetchWithdrawUser() {
    const uid = document.getElementById('withdraw_user_id').value.trim();
    const infoDiv = document.getElementById('withdraw_user_info');
    if (!uid) {
        infoDiv.style.display = 'none';
        return;
    }
    
    // Demo data
    infoDiv.style.display = 'block';
    infoDiv.innerHTML = `
        <div><strong>Người chơi:</strong> <span class="text-primary">User demo #${uid}</span></div>
        <div><strong>Số điểm:</strong> <span class="text-success">${Number(1000000).toLocaleString('vi-VN')}</span></div>
        <hr>
        <div class="mt-3">
            <label><strong>Số điểm yêu cầu rút:</strong></label>
            <input type="text" id="withdraw_amount" class="form-control" placeholder="0" oninput="formatNumberInput(this)">
        </div>
    `;
}

// Popup: Duyệt đơn rút
function showWithdrawDetailPopup(data) {
    const content = `
        <div class="text-left">
            <p><strong>Người chơi:</strong> ${data.username} (ID: ${data.user_id})</p>
            <p><strong>Số điểm rút:</strong> <span class="text-danger font-weight-bold">${data.amount}</span></p>
            <hr>
            <p>Vui lòng chuyển khoản đến:</p>
            <p><strong>Ngân hàng:</strong> <span class="text-success">${data.bank_name}</span></p>
            <p><strong>Chủ tài khoản:</strong> <span class="text-success">${data.account_holder}</span></p>
            <p><strong>Số tài khoản:</strong> <span class="text-success">${data.account_number}</span></p>
        </div>`;
    
    Swal.fire({
        title: 'DUYỆT ĐƠN RÚT ĐIỂM',
        html: content,
        icon: 'info',
        showCancelButton: true,
        confirmButtonText: 'Đã chuyển & Duyệt đơn',
        cancelButtonText: 'Hủy',
        customClass: { popup: 'swal-wide-popup' }
    }).then(result => {
        if (result.isConfirmed) {
            Swal.fire('Thành công', 'Đơn rút đã được duyệt.', 'success').then(() => location.reload());
        }
    });
}

// Popup: Từ chối đơn
function showRejectPopup(withdrawId) {
    Swal.fire({
        title: 'Xác nhận từ chối đơn #' + withdrawId,
        text: 'Hành động này sẽ từ chối yêu cầu rút tiền và hoàn điểm cho người chơi.',
        input: 'textarea',
        inputLabel: 'Lý do từ chối (không bắt buộc)',
        inputPlaceholder: 'Nhập lý do tại đây...',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Đúng, từ chối!',
        cancelButtonText: 'Hủy'
    }).then(result => {
        if (result.isConfirmed) {
            Swal.fire('Đã từ chối!', 'Đơn rút tiền đã được từ chối.', 'success').then(() => location.reload());
        }
    });
}

// Popup: Chỉnh sửa thông tin ngân hàng
function editWithdrawBankInfo(data) {
    Swal.fire({
        title: 'Chỉnh sửa thông tin ngân hàng',
        html: `
            <div class="text-left">
                <label class="mb-1"><strong>Chủ tài khoản</strong></label>
                <input id="edit_account_holder" class="form-control mb-3" value="${data.account_holder || ''}">
                <label class="mb-1"><strong>Tên ngân hàng</strong></label>
                <input id="edit_bank_name" class="form-control mb-3" value="${data.bank_name || ''}">
                <label class="mb-1"><strong>Số tài khoản</strong></label>
                <input id="edit_account_number" class="form-control" value="${data.account_number || ''}">
            </div>`,
        showCancelButton: true,
        confirmButtonText: 'Lưu thay đổi',
        cancelButtonText: 'Hủy',
        focusConfirm: false,
        preConfirm: () => {
            const holder = document.getElementById('edit_account_holder').value.trim();
            const bank = document.getElementById('edit_bank_name').value.trim();
            const number = document.getElementById('edit_account_number').value.trim();
            if (!holder || !bank || !number) {
                Swal.showValidationMessage('Vui lòng nhập đầy đủ thông tin');
                return false;
            }
            return { holder, bank, number };
        }
    }).then(result => {
        if (result.isConfirmed) {
            Swal.fire('Thành công', 'Thông tin ngân hàng đã được cập nhật.', 'success').then(() => location.reload());
        }
    });
}
</script>

<?php require_once __DIR__ . "/foot.php"; ?>
<?php
// Đóng kết nối
$conn->close();
?>