<?php
session_start();
require('../../config/function.php');

// Chặn GET
if ($_SERVER['REQUEST_METHOD'] == 'GET' && realpath(__FILE__) == realpath($_SERVER['SCRIPT_FILENAME'])) {
    http_response_code(404);
    return;
}

// Thêm hàm check_string
if (!function_exists('check_string')) {
    function check_string($str) {
        if (empty($str)) return '';
        $str = trim($str);
        return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
    }
}

// Thêm hàm check_username
if (!function_exists('check_username')) {
    function check_username($str) {
        if (empty($str)) return false;
        return preg_match('/^[a-zA-Z0-9_]{3,50}$/', $str);
    }
}

// Lấy input
$username = isset($_POST['username']) ? trim($_POST['username']) : '';
$password = isset($_POST['password']) ? trim($_POST['password']) : '';

// Check empty
if (empty($username) || empty($password)) {
    die(json_encode([
        'status' => false,
        'message' => 'Vui lòng nhập đầy đủ các trường còn thiếu!'
    ]));
}

// Check username format
if (!check_username($username)) {
    die(json_encode([
        'status' => false,
        'message' => 'Vui lòng nhập định dạng tài khoản hợp lệ!'
    ]));
}

// Clean
$username = check_string($username);
$password_hash = md5($password);

// Check username exists
if (!$_vincenzo->get_row("SELECT * FROM `admin` WHERE `username` = '{$username}'")) {
    die(json_encode([
        'status' => false,
        'message' => 'Tên đăng nhập không tồn tại!'
    ]));
}

// Check password
$user = $_vincenzo->get_row("SELECT * FROM `admin` WHERE `username` = '{$username}' AND `password` = '{$password_hash}'");
if (!$user) {
    die(json_encode([
        'status' => false,
        'message' => 'Mật khẩu bạn nhập không chính xác!'
    ]));
}

// Check banned
if (isset($user['banned']) && $user['banned'] >= 1) {
    die(json_encode([
        'status' => false,
        'message' => 'Bạn đã bị block vì vi phạm chính sách cộng đồng của chúng tôi!'
    ]));
}

// Success
$_SESSION['activeAdmin'] = $username;
die(json_encode([
    'status' => true,
    'message' => 'Đăng nhập thành công!'
]));
?>