<?php
require_once __DIR__ . "/head.php";

?>
<style>
    body::after {
        content: '';
        display: block;
        height: 0px;
    }

    .modal-custom {
        max-width: 500px;
        min-height: 100vh;
        margin: 0 auto;
        background: #fff;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
    }

    .modal-header {
        background: linear-gradient(to right, #00c9a7, #009688);
        color: white;
        padding: 20px;
        text-align: center;
        font-size: 18px;
        font-weight: bold;
    }

    .member-header {
        background: linear-gradient(135deg, #00c9a7, #009688);
        border-radius: 0 0 20px 20px;
        padding: 20px 15px;
        color: white;
        text-align: center;
    }

    .member-header .title {
        font-weight: bold;
        font-size: 18px;
        margin-bottom: 5px;
    }

    .member-header .user-id {
        font-size: 14px;
        margin-bottom: 10px;
    }

    .member-header .points-label {
        font-size: 14px;
    }

    .member-header .points-value {
        font-size: 36px;
        font-weight: bold;
        margin: 5px 0;
    }

    .member-actions {
        display: flex;
        justify-content: center;
        margin-top: 15px;
    }

    .member-actions a {
        flex: 1;
        text-align: center;
        padding: 10px;
        color: white;
        border: 1px solid rgba(255, 255, 255, 0.7);
        border-radius: 10px;
        margin: 0 5px;
        font-weight: bold;
        text-decoration: none;
        transition: all 0.3s ease;
        font-size: 14px;
    }

    .member-actions a:hover {
        background-color: rgba(255, 255, 255, 0.1);
    }

    .member-actions i {
        display: block;
        font-size: 20px;
        margin-bottom: 3px;
    }

    .account-item {
        display: flex;
        align-items: center;
        padding: 12px 15px;
        border-bottom: 1px solid #eee;
        cursor: pointer;
        transition: background 0.2s;
    }

    .account-item:hover {
        background: #f0f8ff;
    }

    .account-item i {
        font-size: 20px;
        width: 30px;
        text-align: center;
        margin-right: 10px;
    }

    .account-label {
        font-weight: bold;
    }

    .account-desc {
        font-size: 12px;
        color: #777;
    }

    .button-group {
        display: flex;
        justify-content: space-between;
        gap: 10px;
        margin: 15px 10px;
    }

    .button-group a {
        flex: 1;
        background: #ffffff;
        border-radius: 12px;
        padding: 10px;
        text-align: center;
        font-weight: bold;
        color: #00b894;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        text-decoration: none;
        transition: all 0.2s ease-in-out;
        border: 2px solid transparent;
        font-size: 14px;
    }

    .button-group a:hover {
        background: #f0fffa;
        border-color: #00cec9;
    }

    .button-group i {
        display: block;
        font-size: 18px;
        margin-bottom: 4px;
    }
</style>
<div class="modal-custom">
    <div class="member-header">
        <div class="title">Trung Tâm Thành Viên</div>
        <div class="user-id">ID: <?= $getUser['id']; ?></div>
        <div class="points-label">Số điểm tài khoản</div>
        <div class="points-value"><?= format_money($getUser['coin']); ?></div>

        <div class="member-actions">
            <a href="javascript:void(0);" onclick="showNapDiemPopup()">
                <i class="fa-regular fa-envelope-open-dollar"></i>
                Nạp điểm
            </a>
            <a href="rut-tien.php">
                <i class="fa-regular fa-money-from-bracket"></i>
                Rút điểm
            </a>
        </div>
    </div>


    <div onclick="location.href='lich-su-tham-gia.php'" class="account-item">
        <i class="fa fa-chart-line text-primary"></i>
        <div>
            <div class="account-label">Lịch sử tham gia</div>
            <div class="account-desc">Xem hoạt động bạn đã tham gia</div>
        </div>
    </div>
    <div onclick="location.href='bien-dong-diem.php'" class="account-item">
        <i class="fa fa-arrows-alt-h text-success"></i>
        <div>
            <div class="account-label">Biến động số điểm</div>
            <div class="account-desc">Theo dõi thay đổi điểm</div>
        </div>
    </div>
    <div onclick="location.href='history-deposit.php'" class="account-item">
        <i class="fa fa-money-bill-wave text-warning"></i>
        <div>
            <div class="account-label">Lịch sử nạp</div>
            <div class="account-desc">Xem lại các lần nạp</div>
        </div>
    </div>
    <div onclick="location.href='history-withdraw.php'" class="account-item">
        <i class="fa fa-sack-dollar text-info"></i>
        <div>
            <div class="account-label">Lịch sử rút</div>
            <div class="account-desc">Theo dõi các yêu cầu rút</div>
        </div>
    </div>
    <div onclick="location.href='banking.php'" class="account-item">
        <i class="fa fa-university text-danger"></i>
        <div>
            <div class="account-label">Ngân hàng</div>
            <div class="account-desc">Cập nhật thông tin ngân hàng</div>
        </div>
    </div>
    <div onclick="location.href='password.php'" class="account-item">
        <i class="fa fa-key text-dark"></i>
        <div>
            <div class="account-label">Đổi mật khẩu</div>
            <div class="account-desc">Thay đổi mật khẩu đăng nhập</div>
        </div>
    </div>
    <div onclick="location.href='logout.php'" class="account-item" style="color: red;">
        <i class="fa fa-sign-out-alt"></i>
        <div>
            <div class="account-label">Đăng xuất</div>
            <div class="account-desc">Thoát khỏi tài khoản</div>
        </div>
    </div>


    <!-- Nút Mã mời + CSKH -->
    <div class="button-group">
        <a href="javascript:void(0);">
            <i class="fa-light fa-qrcode"></i>
            Mã mời
        </a>

        <a href="chat.php">
            <i class="fa-light fa-headset"></i>
            CSKH
        </a>
    </div>

    <div class="d-none">
        <!-- Danh sách các chức năng bổ sung -->
        <div onclick="location.href='lich-su-dau-tu.php'" class="account-item">
            <i class="fa fa-coins text-danger"></i>
            <div>
                <div class="account-label">Lịch Sử Đầu Tư</div>
                <div class="account-desc">Theo dõi các lần đầu tư trước đây</div>
            </div>
        </div>

        <div onclick="location.href='notifications.php'" class="account-item">
            <i class="fa fa-bell text-warning"></i>
            <div>
                <div class="account-label">Thông Báo Tin Nhắn</div>
                <div class="account-desc">Xem thông báo và tin nhắn từ hệ thống</div>
            </div>
        </div>

        <div onclick="location.href='banking.php'" class="account-item">
            <i class="fa fa-university text-primary"></i>
            <div>
                <div class="account-label">Tài Khoản Ngân Hàng</div>
                <div class="account-desc">Quản lý thông tin ngân hàng</div>
            </div>
        </div>


        <div onclick="location.href='address.php'" class="account-item">
            <i class="fa fa-map-marker-alt text-info"></i>
            <div>
                <div class="account-label">Địa Chỉ Nhận Hàng</div>
                <div class="account-desc">Cập nhật địa chỉ giao hàng của bạn</div>
            </div>
        </div>

        <div onclick="location.href='logout.php'" class="account-item" style="color: red;">
            <i class="fa fa-sign-out-alt"></i>
            <div>
                <div class="account-label text-danger">Đăng Xuất</div>
                <div class="account-desc">Rời khỏi tài khoản của bạn</div>
            </div>
        </div>
    </div>

    <div class="my-5 py-5"></div>

</div>

<script>
    function showNapDiemPopup() {
        Swal.fire({
            title: 'NẠP ĐIỂM',
            html: 'Vui lòng liên hệ với <b><a href="chat.php" style="color: #007bff; text-decoration: underline;">CSKH</a></b> để được hướng dẫn nạp điểm',
            confirmButtonText: 'ĐỒNG Ý',
            customClass: {
                confirmButton: 'bg-success text-white px-4 py-2 rounded'
            }
        });
    }
</script>


<script>
    function copyInviteCode() {
        // Lấy mã mời từ phần tử có ID "inviteCode"
        var inviteCode = document.getElementById("inviteCode").innerText;

        // Tạo một input ẩn để sao chép nội dung
        var tempInput = document.createElement("input");
        tempInput.value = inviteCode;
        document.body.appendChild(tempInput);
        tempInput.select();
        tempInput.setSelectionRange(0, 99999); // Dành cho mobile
        document.execCommand("copy");
        document.body.removeChild(tempInput);

        // Hiển thị thông báo bằng SweetAlert2 (nếu có thư viện này)
        if (typeof Swal !== "undefined") {
            Swal.fire({
                icon: 'success',
                title: 'Đã sao chép!',
                text: 'Mã mời của bạn: ' + inviteCode,
                timer: 2000,
                showConfirmButton: false
            });
        } else {
            // Hiển thị thông báo mặc định nếu không có SweetAlert2
            alert("Đã sao chép mã mời: " + inviteCode);
        }
    }
</script>



<?php
require_once __DIR__ . "/foot.php";

?>