<?php
require_once __DIR__ . "/head.php"; // Assume head.php chứa config DB và $_vincenzo

// Xử lý phân trang
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

// Lấy tổng phiên (finished sessions)
$total_sessions = $_vincenzo->get_var("SELECT COUNT(*) FROM `game_sessions` WHERE `status` = 'finished'");

// Lấy tổng đơn (tổng bets đã xử lý: won + lost)
$total_orders = $_vincenzo->get_var("SELECT COUNT(*) FROM `user_bets` WHERE `status` IN ('won', 'lost')");

// Lấy lịch sử phiên (finished, DESC để mới nhất trước)
$history = $_vincenzo->get_list("SELECT * FROM `game_sessions` WHERE `status` = 'finished' ORDER BY `id` DESC LIMIT $limit OFFSET $offset");

// Tính tổng pages
$total_pages = ceil($total_sessions / $limit);
?>

<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=0">
    <meta name="robots" content="noindex, nofollow">
    <title>CSKH FAMILYMILK 24/7</title>
    <!-- Giữ nguyên meta tags từ code gốc -->
    <meta name="description" content="Hạnh phúc đích thực là khi cả gia đình cùng nhau tận hưởng những gì tinh tuý nhất từ thiên nhiên">
    <meta name="keywords" content="thtruemart, thtrue milk, thtrue milks">
    <meta name="author" content="THTRUE MILK">
    <!-- Open Graph và Twitter Card giữ nguyên -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="CSKH FAMILYMILK 24/7">
    <meta property="og:description" content="Hạnh phúc đích thực là khi cả gia đình cùng nhau tận hưởng những gì tinh tuý nhất từ thiên nhiên">
    <meta property="og:url" content="https://www.hanamvietnam-milks.com">
    <meta property="og:image" content="https://www.hanamvietnam-milks.com/upload/thtruemilk.jpg">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="CSKH FAMILYMILK 24/7">
    <meta name="twitter:description" content="Hạnh phúc đích thực là khi cả gia đình cùng nhau tận hưởng những gì tinh tuý nhất từ thiên nhiên">
    <meta name="twitter:image" content="https://www.hanamvietnam-milks.com/upload/thtruemilk.jpg">
    <link rel="icon" href="https://www.hanamvietnam-milks.com/favicon/favicon.png" type="image/x-icon">
    <link rel="canonical" href="https://www.hanamvietnam-milks.com">
    <!-- CSS links giữ nguyên -->
    <link rel="stylesheet" href="https://www.hanamvietnam-milks.com/css/stylev2.css">
    <link rel="stylesheet" href="https://www.hanamvietnam-milks.com/css/sweetalert2/sweetalert2.min.css">
    <link rel="stylesheet" href="https://www.hanamvietnam-milks.com/css/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="https://www.hanamvietnam-milks.com/css/bootstrap/bootstrap.min.css">
    <link rel="stylesheet" href="https://www.hanamvietnam-milks.com/css/slick.css">
    <link rel="stylesheet" href="https://www.hanamvietnam-milks.com/css/slick-theme.css">
    <link rel="stylesheet" href="https://www.hanamvietnam-milks.com/css/flickity/flickity.css">
    <!-- JS links giữ nguyên -->
    <script src="https://www.hanamvietnam-milks.com/css/sweetalert2/sweetalert2.min.js"></script>
    <script src="https://www.hanamvietnam-milks.com/css/jquery-3.6.0.min.js"></script> 
    <script src="https://www.hanamvietnam-milks.com/css/bootstrap/bootstrap.min.js"></script>
    <script src="https://www.hanamvietnam-milks.com/css/flickity/flickity.pkgd.min.js"></script>
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebPage"
    }
    </script>
    <!-- Custom CSS giống ảnh -->
    <style>
    .modal-custom {
        max-width: 500px;
        min-height: 100vh;
        margin: 0px auto;
        background: #fff;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0,0,0,0.3);
    }
    .modal-header {
        background-color: #2fbba1;
        color: white;
        padding: 12px;
        text-align: center;
        font-size: 16px;
        font-weight: bold;
    }
    .summary-box {
        background-color: #c3e9e2;
        padding: 10px;
        display: flex;
        justify-content: space-between;
        font-size: 14px;
        font-weight: bold;
    }
    .table {
        width: 100%;
        font-size: 14px;
        border-collapse: collapse;
    }
    .table thead {
        background-color: #dbf7f2;
    }
    .table th, .table td {
        padding: 8px 10px;
        border-bottom: 1px solid #c3e9e2;
        text-align: center;
    }
    .table td:first-child {
        color: #ff5722;
        font-weight: bold;
    }
    .pagination {
        display: flex;
        justify-content: center;
        margin: 15px 0;
    }
    .pagination a, .pagination span {
        margin: 0 3px;
        padding: 5px 10px;
        text-decoration: none;
        border-radius: 4px;
        font-size: 14px;
    }
    .pagination a {
        background-color: #f1f1f1;
        color: #333;
    }
    .pagination a:hover {
        background-color: #ffccbc;
    }
    .pagination .active {
        background-color: #ff7043;
        color: white;
        font-weight: bold;
    }
    </style>
</head>
<body>

<div class="modal-custom">
    <div class="modal-header">Xu Hướng Kỷ Lục</div>
    <div class="summary-box">
        <div>Tổng phiên: <strong><?= number_format($total_sessions) ?></strong></div>
        <div>Tổng số đơn: <strong><?= number_format($total_orders) ?></strong></div>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>Phiên</th>
                <th>Kết quả</th>
                <th>Trạng thái</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($history)): ?>
                <tr>
                    <td colspan="3">Không có dữ liệu.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($history as $session): ?>
                    <?php 
                    // Format kết quả: '2,9,5,8,8' -> '2 9 5 8 8'
                    $result_formatted = str_replace(',', ' ', $session['result']);
                    ?>
                    <tr>
                        <td><?= $session['id'] ?></td>
                        <td><?= $result_formatted ?></td>
                        <td>Đã kết thúc</td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>

    <?php if ($total_pages > 1): ?>
    <nav>
        <ul class="pagination">
            <?php if ($page > 1): ?>
                <li><a href="?page=<?= $page - 1 ?>">« Trước</a></li>
            <?php endif; ?>

            <?php
            // Hiển thị 1,2,... với ... nếu nhiều
            $start = max(1, $page - 2);
            $end = min($total_pages, $page + 2);

            if ($start > 1): ?>
                <li><a href="?page=1">1</a></li>
                <?php if ($start > 2): ?>
                    <li><span>...</span></li>
                <?php endif; ?>
            <?php endif; ?>

            <?php for ($i = $start; $i <= $end; $i++): ?>
                <?php if ($i == $page): ?>
                    <li><span class="active"><?= $i ?></span></li>
                <?php else: ?>
                    <li><a href="?page=<?= $i ?>"><?= $i ?></a></li>
                <?php endif; ?>
            <?php endfor; ?>

            <?php if ($end < $total_pages): ?>
                <?php if ($end < $total_pages - 1): ?>
                    <li><span>...</span></li>
                <?php endif; ?>
                <li><a href="?page=<?= $total_pages ?>"><?= $total_pages ?></a></li>
            <?php endif; ?>

            <?php if ($page < $total_pages): ?>
                <li><a href="?page=<?= $page + 1 ?>">Sau »</a></li>
            <?php endif; ?>
        </ul>
    </nav>
    <?php endif; ?>
</div>

<!-- Giữ nguyên supper-nav và scripts từ code gốc -->
<div class="supper-nav">
    <div class="row m-0 p-0 mb-1">
        <div class="col-6 text-left text-white">
            <small>Nhân viên ID: 2</small> 
        </div>
        <div class="col-6 text-right text-white">
            <small class="reloadBalance" data-balance-id="footer">Số dư: 0</small>
        </div>
    </div>
    
    <ul>
        <li>
            <a href="/" rel="nofollow">
                <i class="fas fa-home text-white fa-2x"></i> Home
            </a>
        </li>
        <li>
            <a href="/" rel="nofollow">
                <i class="fas fa-sync-alt text-white fa-2x"></i> Làm mới
            </a>
        </li>
        <li>
            <a href="/xuhuong.php" rel="nofollow">
                <i class="fa-solid fa-chart-line-up text-white fa-2x"></i> Xu hướng
            </a>
        </li>
        <li>
            <a href="/account.php" rel="nofollow">
                <i class="fas fa-user text-white fa-2x"></i> Cá nhân
            </a>
        </li>
        <li>
            <a href="chat.php" class="chat_animation">
                <i class="fas fa-headset text-white fa-2x"></i> CSKH
            </a>
        </li>
    </ul>
</div>

<script src="/css/confetti.browser.min.js"></script>
<script src="/css/slick/slick.min.js"></script>
<script src="/css/lightbox2/js/lightbox.js"></script>
<script src="/css/popper/dist/umd/popper.min.js"></script>
<script src="/css/bootstrap/bootstrap.min.js"></script>
<script src="/css/bootstrap/bootstrap.bundle.min.js"></script>

<?php
require_once __DIR__ . "/foot.php"; // Nếu có foot.php để đóng body
?>
</body>
</html>