<?php
// Bắt đầu session và tải các tệp cần thiết
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once '../config/function.php';

// Kiểm tra quyền admin
if (!isset($_SESSION['activeAdmin'])) {
    header("Location: /");
    exit();
}

// --- BẮT ĐẦU TRUY VẤN DỮ LIỆU ---

// 1. Phân tích chi tiết hiệu suất từng cổng cược (toàn thời gian)
$gate_results = $_vincenzo->get_list("
    SELECT 
        bet_type,
        COUNT(id) AS total_bets, SUM(bet_amount) AS total_bet_amount,
        SUM(CASE WHEN status = 'won' THEN 1 ELSE 0 END) AS total_wins, SUM(win_amount) AS total_win_amount
    FROM user_bets
    WHERE bet_type IN ('TH TRUEMILK', 'VINAMILK') GROUP BY bet_type
");
$gate_stats = [];
foreach ($gate_results as $row) {
    $gate_stats[$row['bet_type']] = [
        'total_bets' => (int)$row['total_bets'],
        'total_bet_amount' => (float)$row['total_bet_amount'],
        'win_rate' => ($row['total_bets'] > 0) ? round(($row['total_wins'] / $row['total_bets']) * 100, 2) : 0,
        'net_profit' => (float)$row['total_bet_amount'] - (float)$row['total_win_amount']
    ];
}

// 2. Lấy 100 lượt cược gần nhất
$recent_bets = $_vincenzo->get_list("SELECT * FROM user_bets ORDER BY id DESC LIMIT 100");

// Hàm trợ giúp
function getStatusBadge($status) {
    switch ($status) {
        case 'won': return '<span class="badge text-bg-success">Thắng</span>';
        case 'lost': return '<span class="badge text-bg-danger">Thua</span>';
        default: return '<span class="badge text-bg-warning">Đang chờ</span>';
    }
}

require_once __DIR__ . "/head.php";
?>

<!--begin::App Content Header-->
<div class="app-content-header">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-6"><h3 class="mb-0">Dashboard Phân Tích Đối Đầu</h3></div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-end">
                    <li class="breadcrumb-item"><a href="./">Trang chủ</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Phân Tích Cược</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<!--end::App Content Header-->

<!--begin::App Content-->
<div class="app-content">
    <div class="container-fluid">
        <div class="row">
            <!-- Cột TH TRUEMILK -->
            <div class="col-lg-6 d-flex flex-column">
                <div class="card card-body border-2 border-danger shadow-lg rounded-4 flex-fill">
                    <h4 class="text-danger fw-bolder mb-3 text-center">TH TRUEMILK</h4>
                    <div id="th-win-rate-chart" class="mb-2"></div>
                    <h6 class="text-center text-muted fw-light">TỶ LỆ THẮNG</h6>
                </div>
            </div>

            <!-- Cột VINAMILK -->
            <div class="col-lg-6 d-flex flex-column">
                 <div class="card card-body border-2 border-info shadow-lg rounded-4 flex-fill">
                    <h4 class="text-info fw-bolder mb-3 text-center">VINAMILK</h4>
                    <div id="vina-win-rate-chart" class="mb-2"></div>
                    <h6 class="text-center text-muted fw-light">TỶ LỆ THẮNG</h6>
                </div>
            </div>
        </div>

        <!-- Bảng Kê So Sánh Hiệu Suất -->
        <div class="card shadow-lg rounded-4 mt-4">
             <div class="card-header bg-transparent border-0 pt-3">
                <h3 class="card-title fs-5"><i class="fa-solid fa-scale-balanced me-2 text-primary"></i>Bảng Kê So Sánh Hiệu Suất</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th scope="col">Cổng Cược</th>
                                <th scope="col" class="text-center">Tổng Lượt Cược</th>
                                <th scope="col" class="text-end">Tổng Doanh Thu</th>
                                <th scope="col" class="text-end">Lợi Nhuận Ròng</th>
                                <th scope="col" style="width: 25%;">Tỷ Lệ Thắng</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><span class="badge fs-6 text-bg-danger">TH TRUEMILK</span></td>
                                <td class="text-center fw-bold"><?= format_money($gate_stats['TH TRUEMILK']['total_bets'] ?? 0) ?></td>
                                <td class="text-end fw-bold"><?= format_money($gate_stats['TH TRUEMILK']['total_bet_amount'] ?? 0) ?></td>
                                <?php $th_profit = $gate_stats['TH TRUEMILK']['net_profit'] ?? 0; ?>
                                <td class="text-end fw-bold fs-5 <?= $th_profit >= 0 ? 'text-success' : 'text-danger' ?>"><?= format_money($th_profit) ?></td>
                                <td>
                                    <?php $th_win_rate = $gate_stats['TH TRUEMILK']['win_rate'] ?? 0; ?>
                                    <div class="d-flex align-items-center">
                                        <div class="progress flex-grow-1" style="height: 12px;">
                                            <div class="progress-bar bg-danger" role="progressbar" style="width: <?= $th_win_rate ?>%" aria-valuenow="<?= $th_win_rate ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                        </div>
                                        <span class="ms-2 fw-bold text-danger"><?= $th_win_rate ?>%</span>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td><span class="badge fs-6 text-bg-info">VINAMILK</span></td>
                                <td class="text-center fw-bold"><?= format_money($gate_stats['VINAMILK']['total_bets'] ?? 0) ?></td>
                                <td class="text-end fw-bold"><?= format_money($gate_stats['VINAMILK']['total_bet_amount'] ?? 0) ?></td>
                                <?php $vina_profit = $gate_stats['VINAMILK']['net_profit'] ?? 0; ?>
                                <td class="text-end fw-bold fs-5 <?= $vina_profit >= 0 ? 'text-success' : 'text-danger' ?>"><?= format_money($vina_profit) ?></td>
                                <td>
                                    <?php $vina_win_rate = $gate_stats['VINAMILK']['win_rate'] ?? 0; ?>
                                    <div class="d-flex align-items-center">
                                        <div class="progress flex-grow-1" style="height: 12px;">
                                            <div class="progress-bar bg-info" role="progressbar" style="width: <?= $vina_win_rate ?>%" aria-valuenow="<?= $vina_win_rate ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                        </div>
                                        <span class="ms-2 fw-bold text-info"><?= $vina_win_rate ?>%</span>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Bảng dữ liệu chi tiết -->
        <div class="card shadow-lg rounded-4 mt-4">
            <div class="card-header"><h3 class="card-title fs-5"><i class="fa-solid fa-table-list me-2"></i>Dữ Liệu Cược Chi Tiết (100 Lượt Gần Nhất)</h3></div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="bets-table" class="table table-bordered table-striped table-hover">
                        <thead><tr><th>ID</th><th>Người Chơi</th><th>Kỳ</th><th>Lựa Chọn</th><th>Điểm Cược</th><th>Điểm Thắng</th><th>Thời Gian</th><th>Trạng Thái</th></tr></thead>
                        <tbody>
                            <?php foreach ($recent_bets as $bet): ?>
                            <tr>
                                <td><?= $bet['id'] ?></td>
                                <td><?= htmlspecialchars($bet['username']) ?></td>
                                <td>#<?= $bet['session_id'] ?></td>
                                <td><span class="badge text-bg-<?= (strpos($bet['bet_type'], 'TH') !== false) ? 'danger' : 'info' ?>"><?= htmlspecialchars($bet['bet_type']) ?></span></td>
                                <td><?= format_money($bet['bet_amount']) ?></td>
                                <td><?= format_money($bet['win_amount']) ?></td>
                                <td><?= date('d/m/Y H:i', strtotime($bet['bet_time'])) ?></td>
                                <td><?= getStatusBadge($bet['status']) ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end::App Content-->

<?php
// Tải các script cần thiết
?>
<link rel="stylesheet" href="https://cdn.datatables.net/2.0.8/css/dataTables.bootstrap5.min.css">
<script src="https://cdn.datatables.net/2.0.8/js/dataTables.min.js"></script>
<script src="https://cdn.datatables.net/2.0.8/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>

<script>
$(document).ready(function() {
    // 1. Khởi tạo DataTables
    $('#bets-table').DataTable({ "order": [[0, "desc"]], "language": { "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Vietnamese.json" }, "pageLength": 10 });

    // 2. Biểu đồ Gauge cho TH TRUEMILK
    var thOptions = {
        series: [<?= $gate_stats['TH TRUEMILK']['win_rate'] ?? 0 ?>], chart: { height: 250, type: 'radialBar' },
        plotOptions: { radialBar: {
            hollow: { margin: 15, size: '65%' }, track: { background: '#f8d7da' },
            dataLabels: { name: { show: false }, value: { fontSize: '2.5rem', fontWeight: 'bold', color: '#dc3545', offsetY: 10, formatter: (val) => val + '%' }}
        }}, fill: { colors: ['#dc3545'] }, stroke: { lineCap: 'round' }
    };
    new ApexCharts(document.querySelector("#th-win-rate-chart"), thOptions).render();

    // 3. Biểu đồ Gauge cho VINAMILK
    var vinaOptions = {
        series: [<?= $gate_stats['VINAMILK']['win_rate'] ?? 0 ?>], chart: { height: 250, type: 'radialBar' },
        plotOptions: { radialBar: {
             hollow: { margin: 15, size: '65%' }, track: { background: '#cff4fc' },
             dataLabels: { name: { show: false }, value: { fontSize: '2.5rem', fontWeight: 'bold', color: '#0dcaf0', offsetY: 10, formatter: (val) => val + '%' }}
        }}, fill: { colors: ['#0dcaf0'] }, stroke: { lineCap: 'round' }
    };
    new ApexCharts(document.querySelector("#vina-win-rate-chart"), vinaOptions).render();
});
</script>

<?php require_once __DIR__ . "/foot.php"; ?>