<?php
session_start();
require_once '../config/function.php';

// Kiểm tra quyền admin
if (!isset($_SESSION['activeAdmin'])) {
    exit('Bạn cần đăng nhập với quyền admin.');
}

// --- PHẦN 1: XỬ LÝ POST REQUEST (CẬP NHẬT KẾT QUẢ) ---
// Logic này không thay đổi, nó đã hoạt động tốt.
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'update_result') {
    $session_id = (int)($_POST['session_id'] ?? 0);
    $new_result = trim($_POST['new_result'] ?? '');

    if ($session_id > 0 && strlen($new_result) == 5 && ctype_digit($new_result)) {
        $ketqua_formatted = implode(',', str_split($new_result));
        $_vincenzo->update("game_sessions", ['result' => $ketqua_formatted], "`id` = $session_id AND `status` = 'upcoming'");
        header('Content-Type: application/json');
        echo json_encode(['success' => true, 'message' => 'Cập nhật kết quả thành công!']);
        exit();
    } else {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Dữ liệu không hợp lệ.']);
        exit();
    }
}

// --- PHẦN 2: LẤY DỮ LIỆU TỪ DATABASE ĐỂ HIỂN THỊ ---
// Logic này không thay đổi.
$all_sessions = $_vincenzo->get_list("
    (SELECT * FROM `game_sessions` WHERE `status` = 'running' ORDER BY id DESC LIMIT 1)
    UNION
    (SELECT * FROM `game_sessions` WHERE `status` = 'upcoming' ORDER BY id ASC LIMIT 3)
    UNION
    (SELECT * FROM `game_sessions` WHERE `status` = 'finished' ORDER BY id DESC LIMIT 10)
    ORDER BY `status` DESC, `id` DESC
");

function get_winner_display($result_str) {
    if (empty($result_str)) return '';
    $sum = array_sum(explode(',', $result_str));
    return ($sum % 2 == 1) ? 'TH TRUEMILK' : 'VINAMILK';
}

require_once __DIR__ . "/head.php";

// PHẦN MỚI: Lấy ID của phiên đang chạy để truyền xuống JavaScript
$current_running_session_id = null;
foreach ($all_sessions as $s) {
    if ($s['status'] == 'running') {
        $current_running_session_id = $s['id'];
        break;
    }
}
?>

<div class="app-content">
    <div class="container-fluid">
        <div class="card card-primary card-outline">
            <div class="card-header"><h3 class="card-title"><i class="fas fa-list-ol mr-2"></i>Quản lý phiên 180 giây</h3></div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped text-center table-hover">
                        <thead class="thead-dark">
                            <tr>
                                <th>Số kỳ</th><th>Kết quả</th><th>Bên thắng</th><th>Trạng thái</th><th>Thao tác</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($all_sessions)): ?>
                                <tr><td colspan="5">Chưa có dữ liệu phiên. Vui lòng chờ cron job chạy.</td></tr>
                            <?php else: ?>
                                <?php foreach ($all_sessions as $session): ?>
                                    <tr>
                                        <td><strong><?= $session['id'] ?></strong></td>
                                        <td>
                                            <div class="d-flex justify-content-center align-items-center" style="gap: 5px;">
                                                <?php if (!empty($session['result'])):
                                                    $result_arr = explode(',', $session['result']);
                                                    $sum = array_sum($result_arr);
                                                    $is_th_milk = ($sum % 2 == 1);
                                                    foreach ($result_arr as $num):
                                                        $ball_color_class = $session['status'] == 'finished' ? 'bg-dark' : ($is_th_milk ? 'bg-success' : 'bg-warning text-dark');
                                                ?>
                                                    <span class="badge <?= $ball_color_class ?> rounded-circle p-2" style="font-size: 1rem; width: 30px; height: 30px; line-height: 16px;"><?= $num ?></span>
                                                <?php endforeach; endif; ?>
                                            </div>
                                        </td>
                                        <td><strong><?= get_winner_display($session['result']) ?></strong></td>
                                        <td>
                                            <?php
                                            switch ($session['status']) {
                                                case 'running':
                                                    echo '<span class="badge bg-success countdown-timer" data-endtime="' . strtotime($session['end_time']) . '">Đang chạy 00:00</span>';
                                                    break;
                                                case 'upcoming':
                                                    echo '<span class="badge bg-info">Sắp chạy</span>';
                                                    break;
                                                case 'finished':
                                                    echo '<span class="badge bg-danger">Đã kết thúc</span>';
                                                    break;
                                            }
                                            ?>
                                        </td>
                                        <td>
                                            <?php if ($session['status'] == 'upcoming'): ?>
                                                <button class="btn btn-sm btn-warning" title="Chỉnh sửa kết quả" onclick="editResult('<?= $session['id'] ?>', '<?= str_replace(',', '', $session['result']) ?>')">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- =================================================================== -->
<!-- KHỐI SCRIPT HOÀN CHỈNH (Đã nâng cấp logic chống F5) -->
<!-- =================================================================== -->
<script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    
    // Lấy ID của phiên đang chạy từ PHP để so sánh
    const currentRunningIdOnPage = <?= json_encode($current_running_session_id) ?>;

    // --- 1. LOGIC REAL-TIME VỚI PUSHER (ĐÃ NÂNG CẤP) ---
    const PUSHER_APP_KEY = 'd8f1f623fd37086447aa';
    const PUSHER_CLUSTER = 'ap1';

    try {
        const pusher = new Pusher(PUSHER_APP_KEY, { cluster: PUSHER_CLUSTER });
        const channel = pusher.subscribe('game-events');

        channel.bind('state-update', function(data) {
            console.log('Update received. Page running ID:', currentRunningIdOnPage, '| Pusher next ID:', data.next_id);
            
            // ĐIỀU KIỆN MỚI: Chỉ tải lại khi ID của phiên đang chạy đã thay đổi
            if (data.next_id && data.next_id != currentRunningIdOnPage) {
                console.log('New session detected! Reloading page...');
                
                // Thêm hiệu ứng mờ đi để người dùng biết trang sắp tải lại
                document.body.style.transition = 'opacity 0.5s ease-in-out';
                document.body.style.opacity = '0.5';
                
                // Tải lại sau một khoảng trễ nhỏ
                setTimeout(() => {
                    location.reload();
                }, 500); // 0.5 giây
            } else {
                console.log('No change in running session. Ignoring reload.');
            }
        });

        pusher.connection.bind('connected', () => console.log('Pusher connected.'));
        pusher.connection.bind('error', (err) => console.error("Pusher error:", err));

    } catch (e) {
        console.error("Error initializing Pusher:", e);
    }
    
    // --- 2. LOGIC CHO ĐỒNG HỒ ĐẾM NGƯỢC (GIỮ NGUYÊN) ---
    startCountdownTimers();
});


/**
 * Hàm cho đồng hồ đếm ngược.
 */
function startCountdownTimers() {
    setInterval(function() {
        document.querySelectorAll('.countdown-timer').forEach(function(timer) {
            if (timer.hasAttribute('data-endtime')) {
                const endTime = parseInt(timer.getAttribute('data-endtime'));
                const now = Math.floor(Date.now() / 1000);
                let secondsRemaining = endTime - now;
                if (secondsRemaining < 0) secondsRemaining = 0;
                const minutes = Math.floor(secondsRemaining / 60);
                const seconds = secondsRemaining % 60;
                timer.textContent = `Đang chạy ${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
            }
        });
    }, 1000);
}

/**
 * Hàm cho chức năng chỉnh sửa kết quả.
 */
function editResult(sessionId, currentResult) {
    Swal.fire({
        title: 'Chỉnh sửa kết quả cho phiên #' + sessionId,
        input: 'text',
        inputValue: currentResult,
        inputAttributes: { maxlength: 5, pattern: '[0-9]{5}', placeholder: 'Nhập 5 chữ số' },
        showCancelButton: true,
        confirmButtonText: 'Lưu thay đổi',
        cancelButtonText: 'Hủy',
        showLoaderOnConfirm: true,
        preConfirm: (newResult) => {
            if (!/^[0-9]{5}$/.test(newResult)) {
                Swal.showValidationMessage('Vui lòng nhập đúng 5 chữ số');
                return false;
            }
            return fetch('', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    'action': 'update_result',
                    'session_id': sessionId,
                    'new_result': newResult
                })
            })
            .then(response => {
                if (!response.ok) throw new Error(response.statusText);
                return response.json();
            })
            .catch(error => Swal.showValidationMessage(`Yêu cầu thất bại: ${error}`));
        },
        allowOutsideClick: () => !Swal.isLoading()
    }).then((result) => {
        if (result.isConfirmed) {
            if (result.value.success) {
                Swal.fire({ title: 'Thành công!', text: result.value.message, icon: 'success' })
                .then(() => location.reload());
            } else {
                Swal.fire('Lỗi!', result.value.message || 'Có lỗi xảy ra', 'error');
            }
        }
    });
}
</script>

<?php
require_once __DIR__ . "/foot.php";
?>