<?php
// Bắt đầu hoặc tiếp tục phiên làm việc
// session_start(); // Giữ nguyên, vì có thể đã được gọi ở tệp khác

// Tải các hàm và cấu hình cần thiết
require_once '../config/function.php';

// KIỂM TRA ĐĂNG NHẬP - LOGIC GỐC ĐƯỢC GIỮ NGUYÊN
if (!isset($_SESSION['activeAdmin'])) {
    header("Location: /");
    exit(); // Luôn thoát sau khi chuyển hướng
}

// NÂNG CẤP: Tự động lấy tên file của trang hiện tại để xác định menu active
$currentPage = basename($_SERVER['PHP_SELF']);
// Xử lý trường hợp trang chủ (ví dụ: /admin/ sẽ trả về 'admin')
if ($currentPage == 'admin') {
    $currentPage = 'index.php'; // Giả sử trang chủ là index.php
}

?>
<!doctype html>
<html lang="vi">
<!--begin::Head-->

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Admin Dashboard | Bảng điều khiển</title>

    <!-- Meta Tags quan trọng cho Responsive và Accessibility -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="description" content="AdminLTE là một trang quản trị Bootstrap 5 miễn phí." />
    <meta name="author" content="ColorlibHQ" />
    <meta name="color-scheme" content="light dark" />
    <link rel="icon" href="/favicon.ico" type="image/x-icon">

    <!-- Preconnect để tăng tốc độ tải font và tài nguyên từ CDN -->
    <link rel="preconnect" href="https://cdn.jsdelivr.net" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin>
    <link rel="preconnect" href="https://cdnjs.cloudflare.com" crossorigin>

    <!-- Fonts -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Source+Sans+3:ital,wght@0,300;0,400;0,700;1,400&display=swap" />

    <!-- CÁC THƯ VIỆN CSS GỐC - ĐƯỢỢC GIỮ NGUYÊN -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.7.3/styles/overlayscrollbars.min.css" />
    <link rel="stylesheet" href="/admin/css/adminlte.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/css/jsvectormap.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/apexcharts@3.50.0/dist/apexcharts.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/sweetalert2/sweetalert2.min.css">
    <script src="<?= BASE_URL(); ?>css/sweetalert2/sweetalert2.min.js"></script>

</head>
<!--end::Head-->

<!--begin::Body-->
<body class="layout-fixed sidebar-expand-lg bg-body-tertiary">
    <!--begin::App Wrapper-->
    <div class="app-wrapper">
        <!--begin::Header-->
        <nav class="app-header navbar navbar-expand bg-body">
            <div class="container-fluid">
                <!-- Nút bật/tắt sidebar trên mobile -->
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" data-lte-toggle="sidebar" href="#" role="button">
                            <i class="bi bi-list"></i>
                        </a>
                    </li>
                </ul>

                <!-- Menu người dùng bên phải -->
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item dropdown user-menu">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
                            <img src="/admin/assets/img/user2-160x160.jpg" class="user-image rounded-circle shadow" alt="User Image" />
                            <!-- NÂNG CẤP: Hiển thị tên Admin từ Session -->
                            <span class="d-none d-md-inline"><?= htmlspecialchars($_SESSION['activeAdmin']); ?></span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                            <li class="user-header text-bg-primary">
                                <img src="/admin/assets/img/user2-160x160.jpg" class="rounded-circle shadow" alt="User Image" />
                                <p>
                                    <!-- NÂNG CẤP: Hiển thị tên Admin và ngày tham gia -->
                                    <?= htmlspecialchars($_SESSION['activeAdmin']); ?> - Quản trị viên
                                    <small>Thành viên từ <?= date('m/Y'); ?></small>
                                </p>
                            </li>
                            <li class="user-footer">
                                <a href="#" class="btn btn-default btn-flat">Hồ sơ</a>
                                <a href="/logout.php" class="btn btn-default btn-flat float-end">Đăng xuất</a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </nav>
        <!--end::Header-->

        <!--begin::Sidebar-->
        <aside class="app-sidebar bg-body-secondary shadow" data-bs-theme="dark">
            <div class="sidebar-brand">
                <a href="./index.php" class="brand-link">
                    <img src="/admin/assets/img/AdminLTELogo.png" alt="AdminLTE Logo" class="brand-image opacity-75 shadow" />
                    <span class="brand-text fw-light">Admin Panel</span>
                </a>
            </div>
            <div class="sidebar-wrapper">
                <nav class="mt-2">
                    <!--begin::Sidebar Menu-->
                    <ul class="nav sidebar-menu flex-column" data-lte-toggle="treeview" role="navigation" aria-label="Main navigation">
                        
                        <!-- NÂNG CẤP: Thêm logic để tự động active cho từng mục -->
                        <li class="nav-item">
                            <a href="./" class="nav-link <?= ($currentPage == 'index.php') ? 'active' : '' ?>">
                                <i class="nav-icon fa-solid fa-house"></i>
                                <p>Trang chủ</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="./thongke.php" class="nav-link <?= ($currentPage == 'thongke.php') ? 'active' : '' ?>">
                                <i class="nav-icon fa-solid fa-chart-simple"></i>
                                <p>Thống kê cược</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="./members.php" class="nav-link <?= ($currentPage == 'members.php') ? 'active' : '' ?>">
                                <i class="nav-icon fa-solid fa-users"></i>
                                <p>Người chơi</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="./ketqua.php" class="nav-link <?= ($currentPage == 'ketqua.php') ? 'active' : '' ?>">
                                <i class="nav-icon fa-solid fa-trophy"></i>
                                <p>Set kết quả</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="./cau-hinh-rut-tien.php" class="nav-link <?= ($currentPage == 'cau-hinh-rut-tien.php') ? 'active' : '' ?>">
                                <i class="nav-icon fa-solid fa-gears"></i>
                                <p>Cấu hình rút tiền</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="./rut-tien.php" class="nav-link <?= ($currentPage == 'rut-tien.php') ? 'active' : '' ?>">
                                <i class="nav-icon fa-solid fa-wallet"></i>
                                <p>Yêu cầu rút tiền</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="./cskh.php" class="nav-link <?= ($currentPage == 'cskh.php') ? 'active' : '' ?>">
                                <i class="nav-icon fa-solid fa-headset"></i>
                                <p>Chăm sóc khách hàng</p>
                            </a>
                        </li>

                    </ul>
                    <!--end::Sidebar Menu-->
                </nav>
            </div>
            <!--end::Sidebar Wrapper-->
        </aside>
        <!--end::Sidebar-->
        
        <!--begin::App Main-->
        <main class="app-main">
            <!-- Nội dung của từng trang sẽ được đặt ở đây -->
            <!-- Thẻ <main> sẽ được đóng trong file footer.php -->