<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/config/function.php'; // File này đã có hàm parse_vietnamese_number

// Kiểm tra session admin
if (!isset($_SESSION['activeAdmin'])) {
    ob_end_clean();
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Truy cập không được phép']);
    exit;
}

// Lấy user_id từ GET
$user_id = (int)($_GET['id'] ?? 0);
if ($user_id <= 0) {
    ob_end_clean();
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'ID người dùng không hợp lệ']);
    exit;
}

// Khởi tạo kết nối DB
$getUsers = $_vincenzo->get_list(" SELECT * FROM users WHERE id = '" . $user_id . "' ");
if (empty($getUsers)) {
    ob_end_clean();
    http_response_code(404);
    echo json_encode(['success' => false, 'error' => 'Không tìm thấy người dùng']);
    exit;
}
$user_name = $getUsers[0]['username'];

// Xử lý POST (gửi quà)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $gift_type = trim($_POST['gift_type'] ?? '');
    $amount_str = trim($_POST['amount'] ?? '');
    $note = trim($_POST['note'] ?? '');

    // Debug: Log input
    error_log("Admin gift input: user_id=$user_id, type=$gift_type, amount_str=$amount_str, note=$note");

    if (empty($amount_str)) {
        $amount = 0;
    } else {
        $amount = parse_vietnamese_number($amount_str); // Nếu hàm lỗi, fallback parse thủ công
        if ($amount <= 0) {
            // Fallback: Parse thủ công nếu hàm không tồn tại
            $amount = (int)str_replace('.', '', $amount_str);
        }
    }

    if ($amount <= 0 || empty($gift_type) || empty($note)) {
        ob_end_clean();
        echo json_encode(['success' => false, 'error' => 'Dữ liệu không hợp lệ (kiểm tra số tiền, loại quà, ghi chú)']);
        exit;
    }

    try {
        if ($gift_type === 'Points') {
            $current_coin = $getUsers[0]['coin'] ?? 0;
            $_vincenzo->update('users', [
                'coin' => $current_coin + $amount
            ], "id = $user_id");
            error_log("Updated coin for user $user_id: +$amount, new total: " . ($current_coin + $amount));
        }
        // Insert quà
        $insert_id = $_vincenzo->insert('user_gifts', [
            'user_id' => $user_id,
            'amount' => $amount,
            'type' => $gift_type,
            'note' => $note,
            'is_read' => 0,
            'is_received' => 0,
            'created_at' => date('Y-m-d H:i:s')
        ]);
        $formatted = number_format($amount, 0, ',', '.');

        error_log("Gift inserted: ID=$insert_id for user $user_id");

        echo json_encode([
            'success' => true,
            'message' => "Đã gửi quà: '$gift_type' trị giá $formatted VND cho $user_name (Ghi chú: $note)"
        ]);
    } catch (Exception $e) {
        error_log("Lỗi Insert SQL: " . $e->getMessage());
        ob_end_clean();
        echo json_encode(['success' => false, 'error' => 'Lỗi lưu dữ liệu: ' . $e->getMessage()]);
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gửi Quà Cho Người Dùng - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-4">
        <h2>Gửi Quà Cho Người Dùng</h2>
        <p><strong>Người dùng:</strong> <?= htmlspecialchars($user_name) ?> (ID: <?= $user_id ?>)</p>

        <form id="giftForm" method="POST">
            <div class="mb-3">
                <label for="gift_type" class="form-label">Loại Quà</label>
                <select class="form-select" id="gift_type" name="gift_type" required>
                    <option value="">Chọn loại</option>
                    <option value="Voucher">Voucher</option>
                    <option value="Reward">Phần thưởng</option>
                    <option value="Points">Điểm (cộng vào số dư)</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="amount" class="form-label">Số Tiền (ví dụ: 48.517.000)</label>
                <input type="text" class="form-control" id="amount" name="amount" placeholder="Nhập số tiền" required>
                <div class="form-text">Sử dụng dấu chấm (.) để phân cách nghìn. Sẽ tự động parse.</div>
            </div>

            <div class="mb-3">
                <label for="note" class="form-label">Ghi Chú (hiện trong popup thông báo)</label>
                <textarea class="form-control" id="note" name="note" rows="3" placeholder="Ví dụ: Chúc mừng bạn là khách hàng may mắn!" required></textarea>
                <div class="form-text">Nội dung này sẽ hiển thị trong thông báo popup của người dùng. (Tự động đề xuất khi nhập tiền)</div>
            </div>

            <button type="submit" class="btn btn-success" id="confirmBtn">Gửi Quà 🎁</button>
            <a href="cskh.php" class="btn btn-secondary">Quay Lại Danh Sách Chat</a>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        // User ID từ PHP
        const userId = <?= $user_id ?>;

        // Format input số Việt Nam & đề xuất note
        document.getElementById('amount').addEventListener('input', function(e) {
            let val = e.target.value.replace(/\./g, '');
            val = val.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
            e.target.value = val;

            // Tự động đề xuất nội dung cho note nếu note đang trống
            const note = document.getElementById('note');
            if (note.value.trim() === '') {
                const rawAmount = parseInt(e.target.value.replace(/\./g, '')) || 0;
                if (rawAmount > 0) {
                    const formattedAmount = new Intl.NumberFormat('vi-VN').format(rawAmount);
                    const suggestedNote = `&#127881;&#127881;&#127881;Xin Chúc Mừng Quý Khách mang "${userId}" đã may mắn nhận được phần quà Tri Ân khách hàng ngẫu nhiên từ Hệ thống với giá trị là: ${formattedAmount} VND. Vui lòng liên hệ CSKH để nhận phần quà.&#127873&#127873&#127873`;
                    note.value = suggestedNote;
                    console.log('Suggested note:', suggestedNote); // Debug
                }
            }
        });

        // Submit AJAX với xác nhận
        document.getElementById('giftForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);

            Swal.fire({
                title: 'Xác Nhận Gửi Quà?',
                text: 'Người dùng sẽ nhận thông báo popup ngay lập tức!',
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Gửi Ngay! 🎁',
                cancelButtonText: 'Hủy'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(window.location.href, {
                            method: 'POST',
                            body: formData
                        })
                        .then(res => {
                            if (!res.ok) {
                                throw new Error(`HTTP ${res.status}: ${res.statusText}`);
                            }
                            return res.text();
                        })
                        .then(text => {
                            try {
                                const data = JSON.parse(text);
                                if (data.success) {
                                    Swal.fire('Thành Công!', data.message, 'success').then(() => {
                                        location.reload();
                                    });
                                } else {
                                    Swal.fire('Lỗi!', data.error, 'error');
                                }
                            } catch (parseErr) {
                                console.error('Raw response:', text);
                                Swal.fire('Lỗi Parse!', 'Response không phải JSON. Kiểm tra log server.', 'error');
                            }
                        })
                        .catch(err => {
                            console.error('Fetch error:', err);
                            Swal.fire('Lỗi Kết Nối!', err.message, 'error');
                        });
                }
            });
        });
    </script>
</body>
</html>