<?php
require_once __DIR__ . "/head.php";

// Lấy ID người dùng và kiểm tra
$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    die('<script>Swal.fire("Lỗi!", "ID thành viên không hợp lệ.", "error").then(() => window.location.href = "./members.php");</script>');
}
$user = $_vincenzo->get_row("SELECT * FROM `users` WHERE `id` = '$id'");
if (!$user) {
    die('<script>Swal.fire("Lỗi!", "Thành viên không tồn tại.", "error").then(() => window.location.href = "./members.php");</script>');
}

// Xử lý khi form được gửi đi
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Mảng để chứa dữ liệu cần cập nhật
    $update_data = [];

    // Lấy và làm sạch dữ liệu từ form
    $update_data['name_bank']   = $_POST['name_bank'] ?? '';
    $update_data['type_bank']   = $_POST['type_bank'] ?? '';
    $update_data['stk_bank']    = $_POST['stk_bank'] ?? '';
    $update_data['coin']        = (int)($_POST['coin'] ?? $user['coin']);
    
    // Các trường có thể bạn cần thêm vào bảng `users`
    // $update_data['phone']       = $_POST['phone'] ?? '';
    // $update_data['vip_level']   = $_POST['vip_level'] ?? 'VIP 0';
    // $update_data['user_group']  = $_POST['user_group'] ?? 'Thành viên';
    // $update_data['lock_reason'] = $_POST['lock_reason'] ?? '';

    // Xử lý mật khẩu mới (chỉ cập nhật nếu được nhập)
    if (!empty($_POST['new_password'])) {
        $update_data['password'] = md5($_POST['new_password']);
    }

    // Xử lý mật khẩu rút tiền mới (chỉ cập nhật nếu được nhập)
    // Giả sử bạn có cột `withdraw_password` trong bảng users
    // if (!empty($_POST['new_withdraw_password'])) {
    //     $update_data['withdraw_password'] = md5($_POST['new_withdraw_password']);
    // }

    // Thực hiện cập nhật vào CSDL
    if (!empty($update_data)) {
        $_vincenzo->update("users", $update_data, "id = " . $user['id']);
        
        // Tải lại dữ liệu người dùng sau khi cập nhật để hiển thị thông tin mới nhất
        $user = $_vincenzo->get_row("SELECT * FROM `users` WHERE `id` = '$id'");

        echo '<script>Swal.fire("Thành công!", "Đã cập nhật thông tin thành viên.", "success");</script>';
    } else {
        echo '<script>Swal.fire("Thông báo", "Không có thay đổi nào được thực hiện.", "info");</script>';
    }
}
?>

<!-- Header -->
<div class="app-content-header">
    <div class="container-fluid">
        <h3 class="mb-0">Chỉnh Sửa Thông Tin Thành Viên</h3>
    </div>
</div>

<!-- Nội dung chính -->
<div class="app-content">
    <div class="container-fluid">
        <div class="card card-primary card-outline shadow-sm">
            <form method="POST">
                <div class="card-body">
                    <div class="row">
                        <!-- CỘT BÊN TRÁI -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">ID</label>
                                <input type="text" class="form-control" value="<?= $user['id'] ?>" disabled>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Tài khoản</label>
                                <input type="text" class="form-control" value="<?= htmlspecialchars($user['username']) ?>" disabled>
                            </div>
                            <div class="mb-3">
                                <label for="name_bank" class="form-label">Họ và tên (Chủ tài khoản)</label>
                                <input type="text" class="form-control" id="name_bank" name="name_bank" value="<?= htmlspecialchars($user['name_bank'] ?? '') ?>">
                            </div>
                            <div class="mb-3">
                                <label for="type_bank" class="form-label">Tên ngân hàng</label>
                                <select class="form-select" id="type_bank" name="type_bank">
                                    <option value="">-- Chọn ngân hàng --</option>
                                    <?php
                                    // Mảng ngân hàng có thể được lấy từ DB hoặc file config
                                    $banks = ['ACB', 'Agribank', 'BIDV', 'MB', 'Sacombank', 'Techcombank', 'Vietcombank', 'VietinBank', 'VPBank', 'TPBank', 'VIB', 'HDBank', 'OCB', 'MSB', 'SHB', 'LienVietPostBank', 'Eximbank', 'Nam A Bank', 'Bac A Bank'];
                                    sort($banks);
                                    foreach ($banks as $bank) {
                                        $selected = ($user['type_bank'] == $bank) ? 'selected' : '';
                                        echo "<option value=\"{$bank}\" {$selected}>{$bank}</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                             <div class="mb-3">
                                <label for="stk_bank" class="form-label">Số tài khoản</label>
                                <input type="text" class="form-control" id="stk_bank" name="stk_bank" value="<?= htmlspecialchars($user['stk_bank'] ?? '') ?>">
                            </div>
                            <div class="mb-3">
                                <label for="phone" class="form-label">Số điện thoại</label>
                                <input type="text" class="form-control" id="phone" name="phone" value="<?= htmlspecialchars($user['phone'] ?? '') ?>" placeholder="Chức năng này cần thêm cột 'phone' vào CSDL">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Thời gian đăng ký</label>
                                <input type="text" class="form-control" value="<?= $user['date'] ?>" disabled>
                            </div>
                        </div>

                        <!-- CỘT BÊN PHẢI -->
                        <div class="col-md-6">
                             <div class="mb-3">
                                <label for="coin" class="form-label">Số tiền VND</label>
                                <div class="input-group">
                                    <button class="btn btn-danger" type="button" id="btn-minus">-</button>
                                    <input type="number" class="form-control text-center" id="coin" name="coin" value="<?= (int)($user['coin'] ?? 0) ?>">
                                    <button class="btn btn-success" type="button" id="btn-plus">+</button>
                                </div>
                            </div>
                             <div class="mb-3">
                                <label for="vip_level" class="form-label">Cấp độ thành viên</label>
                                <select class="form-select" id="vip_level" name="vip_level">
                                    <option value="VIP 0">VIP 0</option>
                                    <option value="VIP 1">VIP 1</option>
                                    <option value="VIP 2">VIP 2</option>
                                </select>
                            </div>
                             <div class="mb-3">
                                <label for="new_password" class="form-label">Mật khẩu mới (nếu muốn đổi)</label>
                                <input type="password" class="form-control" id="new_password" name="new_password" placeholder="Để trống nếu không thay đổi">
                            </div>
                            <div class="mb-3">
                                <label for="new_withdraw_password" class="form-label">Mật khẩu rút tiền (nếu muốn đổi)</label>
                                <input type="password" class="form-control" id="new_withdraw_password" name="new_withdraw_password" placeholder="Chức năng này cần thêm cột 'withdraw_password'">
                            </div>
                            <div class="mb-3">
                                <label for="user_group" class="form-label">Nhóm người dùng</label>
                                <select class="form-select" id="user_group" name="user_group">
                                    <option value="Thành viên">Thành viên</option>
                                    <option value="Đại lý">Đại lý</option>
                                    <option value="Admin">Admin</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="lock_reason" class="form-label">Lý do khóa tài khoản</label>
                                <textarea class="form-control" id="lock_reason" name="lock_reason" rows="4" placeholder="Nhập lý do nếu bạn khóa tài khoản này từ trang danh sách"><?= htmlspecialchars($user['lock_reason'] ?? '') ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-danger"><i class="fas fa-save me-2"></i>Lưu thay đổi</button>
                    <a href="./members.php" class="btn btn-secondary">Quay lại danh sách</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const coinInput = document.getElementById('coin');
    const btnPlus = document.getElementById('btn-plus');
    const btnMinus = document.getElementById('btn-minus');

    btnPlus.addEventListener('click', function() {
        let currentValue = parseInt(coinInput.value, 10) || 0;
        coinInput.value = currentValue + 1000; // Có thể thay đổi bước nhảy
    });

    btnMinus.addEventListener('click', function() {
        let currentValue = parseInt(coinInput.value, 10) || 0;
        coinInput.value = currentValue - 1000; // Có thể thay đổi bước nhảy
    });
});
</script>

<?php
require_once __DIR__ . "/foot.php";
?>