<?php
require_once __DIR__ . "/head.php";
$per_page = 10;
$current_page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($current_page - 1) * $per_page;

// 🔧 THAY ĐỔI: Query để lấy danh sách users có tin nhắn (group by sender_id, latest message, check unread)
$count_query = "SELECT COUNT(DISTINCT cm.sender_id) as total FROM `chat_messages` cm WHERE `sender_type` = 'user'";
$count_result = $_vincenzo->get_list($count_query);
$total_items = $count_result[0]['total'] ?? 0;
$total_pages = ceil($total_items / $per_page);

// Main query: Fix bằng subquery để lấy latest message per user
$main_query = "
    SELECT 
        u.id as user_id, 
        u.username, 
        u.city, 
        cm.message, 
        cm.is_read, 
        cm.created_at,
        (SELECT COUNT(*) FROM chat_messages sub WHERE sub.sender_id = u.id AND sub.sender_type = 'user' AND sub.is_read = 0) as unread_count
    FROM users u 
    INNER JOIN chat_messages cm ON u.id = cm.sender_id 
    INNER JOIN (
        SELECT sender_id, MAX(created_at) as max_date
        FROM chat_messages 
        WHERE sender_type = 'user' 
        GROUP BY sender_id
    ) latest ON cm.sender_id = latest.sender_id AND cm.created_at = latest.max_date
    WHERE cm.sender_type = 'user' 
    ORDER BY latest.max_date DESC 
    LIMIT " . $per_page . " OFFSET " . $offset;
$page_data = $_vincenzo->get_list($main_query);

$current_page = min($current_page, max(1, $total_pages));

// 🔧 THÊM: Lấy user hiện tại đang xem chat (nếu có GET chat_id)
$current_user_id = isset($_GET['chat_id']) ? (int)$_GET['chat_id'] : (isset($_GET['id']) ? (int)$_GET['id'] : 0);
$current_username = '';
if ($current_user_id > 0) {
    // Mark as read
    $_vincenzo->query("UPDATE chat_messages SET is_read = 1 WHERE sender_id = " . $current_user_id . " AND sender_type = 'user' AND is_read = 0");
    // Find username from page_data or query
    foreach ($page_data as $u) {
        if ($u['user_id'] == $current_user_id) {
            $current_username = $u['username'];
            break;
        }
    }
    if (empty($current_username)) {
        $user_query = $_vincenzo->get_row("SELECT username FROM users WHERE id = " . $current_user_id);
        $current_username = $user_query['username'] ?? 'Unknown';
    }
}
?>

<style>
    /* 🔧 THÊM: Style cho giao diện chat giống ảnh (dark theme) + tích hợp direct-chat từ chat.php */
    .app-content {
        display: flex;
        flex-direction: column;
        min-height: calc(100vh - 120px); /* Adjust based on header height */
    }
    .chat-container {
        flex: 1;
        display: flex;
        height: 100%;
    }
    .chat-container .row {
        flex: 1;
        height: 100%;
        margin: 0;
    }
    .chat-container .col-md-4,
    .chat-container .col-md-8 {
        padding: 0;
        height: 100%;
    }
    .chat-sidebar {
        background-color: #1a1a1a;
        border-right: 1px solid #333;
        display: flex;
        flex-direction: column;
        height: 100%;
    }
    .chat-header {
        background-color: #2a2a2a;
        color: white;
        padding: 15px;
        border-bottom: 1px solid #333;
        flex-shrink: 0;
    }
    .chat-list {
        flex: 1;
        overflow-y: auto;
        min-height: 0;
    }
    .chat-list-item {
        display: flex;
        padding: 15px;
        border-bottom: 1px solid #333;
        cursor: pointer;
        color: #ccc;
        transition: background 0.2s;
    }
    .chat-list-item:hover, .chat-list-item.active {
        background-color: #333;
        color: white;
    }
    .chat-list-item.unread {
        background-color: #fff3cd; /* Highlight vàng nhạt cho chưa đọc */
        color: #000;
    }
    .user-name {
        font-weight: bold;
        margin-bottom: 5px;
    }
    .user-city {
        font-size: 12px;
        color: #888;
        margin-bottom: 5px;
    }
    .message-preview {
        font-size: 14px;
        color: #aaa;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    .message-time {
        font-size: 12px;
        color: #666;
        align-self: flex-end;
        flex-shrink: 0;
        margin-left: auto;
    }
    .chat-main {
        background-color: #0d1117;
        color: white;
        flex: 1;
        display: flex;
        flex-direction: column;
        height: 100%;
        min-height: 0;
    }
    .direct-chat-messages {
        flex: 1;
        overflow-y: auto;
        padding: 10px;
        background-color: #0d1117;
        min-height: 0;
        max-width: 100%; /* Ensure it takes full width */
    }
    .direct-chat-msg.right .direct-chat-text {
        background-color: #17a2b8 !important;
        border-color: #17a2b8 !important;
        color: white !important;
        max-width: 80%; /* Increase width for readability */
    }
    .direct-chat-msg.left .direct-chat-text {
        background-color: #30363d !important;
        border-color: #30363d !important;
        color: white !important;
        max-width: 80%; /* Increase width for readability */
    }
    .direct-chat-text {
        border-radius: 10px;
        padding: 15px; /* Increase padding for better spacing */
        word-wrap: break-word; /* Allow text to wrap */
        max-width: 100%; /* Ensure it adjusts to container */
    }
    .card-primary.card-outline {
        border-color: #17a2b8;
        background-color: #21262d;
        flex: 1;
        display: flex;
        flex-direction: column;
        height: 100%;
        margin: 0;
    }
    .card-header {
        background-color: #21262d;
        border-bottom-color: #30363d;
        flex-shrink: 0;
    }
    .card-body {
        flex: 1;
        display: flex;
        flex-direction: column;
        overflow: hidden;
        min-height: 0;
    }
    .card-footer {
        background-color: #21262d;
        border-top-color: #30363d;
        flex-shrink: 0;
    }
    .tab-content {
        flex: 1;
        display: flex;
        flex-direction: column;
        min-height: 0;
    }
    .tab-pane {
        flex: 1;
        display: flex;
        flex-direction: column;
        min-height: 0;
    }
    .form-control {
        background-color: #30363d;
        border-color: #30363d;
        color: white;
        overflow: hidden;
    }
    .form-control:focus {
        background-color: #30363d;
        border-color: #17a2b8;
        color: white;
    }
    .btn-primary {
        background-color: #17a2b8;
        border-color: #17a2b8;
    }
    #imagePreviewContainer {
        display: flex;
        flex-wrap: wrap;
        margin-top: 10px;
        gap: 5px;
        flex-shrink: 0;
        max-height: 100px;
        overflow-y: auto;
    }
    .image-wrapper img {
        max-width: 100%;
        height: auto;
        border-radius: 6px;
    }
    .btn-outline-secondary {
        color: #ccc;
        border-color: #30363d;
    }
    .btn-outline-secondary:hover {
        background-color: #30363d;
        color: white;
    }
    #noChatSelected {
        flex: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }
    .pagination-container {
        background-color: #f8f9fa;
        padding: 10px 0;
        border-top: 1px solid #dee2e6;
    }
    .pagination {
        margin: 0;
    }
</style>

<div class="app-content-header">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-6">
                <h3 class="mb-0">Danh Sách Chat CSKH</h3>
            </div>
        </div>
    </div>
</div>

<div class="app-content">
    <div class="container-fluid chat-container">
        <div class="row">
            <!-- Sidebar trái giống ảnh -->
            <div class="col-md-4">
                <div class="chat-sidebar">
                    <div class="chat-header">
                        <h5>DANH SÁCH CHAT</h5>
                    </div>
                    <div class="chat-list">
                        <?php if (empty($page_data)): ?>
                            <div class="p-3 text-center text-muted">Không có dữ liệu</div>
                        <?php else: ?>
                            <?php foreach ($page_data as $item): ?>
                                <?php
                                $unread_count = (int)($item['unread_count'] ?? 0);
                                $is_unread = $unread_count > 0;
                                $time_formatted = date('H:i', strtotime($item['created_at']));
                                $username_display = htmlspecialchars($item['username']) . ($unread_count > 0 ? ' (' . $unread_count . ')' : '');
                                ?>
                                <div class="chat-list-item <?= $is_unread ? 'unread' : ''; ?> <?= $current_user_id == $item['user_id'] ? 'active' : ''; ?>" onclick="loadChat(event, <?= $item['user_id']; ?>, '<?= htmlspecialchars($item['username']); ?>')">
                                    <div style="flex: 1;">
                                        <div class="user-name"><?= $username_display; ?></div>
                                        <div class="user-city"><?= htmlspecialchars($item['city'] ?? 'Chưa cập nhật'); ?></div>
                                        <div class="message-preview"><?= htmlspecialchars(substr($item['message'], 0, 50)); ?>...</div>
                                    </div>
                                    <div class="message-time"><?= $time_formatted; ?></div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Khu vực chat phải tích hợp từ chat.php -->
            <div class="col-md-8">
                <div class="chat-main" id="chatMain">
                    <div id="noChatSelected" class="text-center text-muted" style="display: <?= $current_user_id == 0 ? 'flex' : 'none'; ?>;">
                        <div>
                            <h5>Chọn một cuộc chat để bắt đầu</h5>
                            <p>Không có cuộc chat nào được chọn.</p>
                        </div>
                    </div>
                    <div id="chatCard" class="card card-primary card-outline" style="display: <?= $current_user_id == 0 ? 'none' : 'block'; ?>;">
                        <div class="card-header p-0 border-bottom-0">
                            <h1 class="m-0" style="padding: 15px; color: white;"><?= $current_username ? 'Chat với ' . htmlspecialchars($current_username) : ''; ?></h1>
                            <ul class="nav nav-tabs" id="chat-tab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="chat-tab-pane" data-bs-toggle="pill" data-bs-target="#chat-tab-pane" type="button" role="tab">Tin nhắn</button>
                                </li>
                            </ul>
                        </div>
                        <div class="card-body">
                            <div class="tab-content" id="chat-tab-content">
                                <div class="tab-pane fade show active" id="chat-tab-pane" role="tabpanel">
                                    <!-- Chat Messages Container -->
                                    <div id="chatMessages" class="direct-chat-messages">
                                        <!-- Messages sẽ load động qua JS -->
                                    </div>

                                    <!-- Image Preview Container - Giữ nguyên nhưng giới hạn chiều cao -->
                                    <div id="imagePreviewContainer">
                                        <!-- Previews sẽ load động -->
                                    </div>

                                    <!-- Chat Input Form -->
                                    <div class="card-footer">
                                        <form id="chatForm">
                                            <div class="input-group">
                                                <textarea
                                                    class="form-control"
                                                    placeholder="Viết tin nhắn..."
                                                    name="message"
                                                    id="chatInput"
                                                    rows="1"
                                                    style="resize: none; overflow-y: auto; min-height: 38px; max-height: 120px;"></textarea>
                                                <div class="input-group-append">
                                                    <button type="button" class="btn btn-outline-secondary" id="emojiButton" title="Chèn emoji">
                                                        <i class="fas fa-smile"></i>
                                                    </button>
                                                    <label for="fileInput" class="btn btn-outline-secondary" title="Tải lên hình ảnh">
                                                        <i class="fas fa-image"></i>
                                                        <input type="file"
                                                            id="fileInput"
                                                            class="d-none"
                                                            accept="image/*"
                                                            name="images[]"
                                                            multiple>
                                                    </label>
                                                    <button type="button" class="btn btn-primary" id="sendButton" title="Gửi">
                                                        <i class="fas fa-paper-plane"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Pagination - Đặt trong container riêng để không ảnh hưởng chiều cao chat -->
    <?php if ($total_pages > 1): ?>
        <div class="container-fluid pagination-container">
            <nav aria-label="Page navigation">
                <ul class="pagination justify-content-center">
                    <?php if ($current_page > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="?page=<?php echo $current_page - 1; ?><?php echo $current_user_id > 0 ? '&chat_id=' . $current_user_id : ''; ?>" aria-label="Previous">
                                <span aria-hidden="true">&laquo; Trước</span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php
                    $start_page = max(1, $current_page - 2);
                    $end_page = min($total_pages, $current_page + 2);
                    if ($start_page > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="?page=1<?php echo $current_user_id > 0 ? '&chat_id=' . $current_user_id : ''; ?>">1</a>
                        </li>
                        <?php if ($start_page > 2): ?>
                            <li class="page-item disabled">
                                <span class="page-link">...</span>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
                        <?php if ($i == $current_page): ?>
                            <li class="page-item active">
                                <span class="page-link"><?php echo $i; ?></span>
                            </li>
                        <?php else: ?>
                            <li class="page-item">
                                <a class="page-link" href="?page=<?php echo $i; ?><?php echo $current_user_id > 0 ? '&chat_id=' . $current_user_id : ''; ?>"><?php echo $i; ?></a>
                            </li>
                        <?php endif; ?>
                    <?php endfor; ?>

                    <?php if ($end_page < $total_pages): ?>
                        <?php if ($end_page < $total_pages - 1): ?>
                            <li class="page-item disabled">
                                <span class="page-link">...</span>
                            </li>
                        <?php endif; ?>
                        <li class="page-item">
                            <a class="page-link" href="?page=<?php echo $total_pages; ?><?php echo $current_user_id > 0 ? '&chat_id=' . $current_user_id : ''; ?>"><?php echo $total_pages; ?></a>
                        </li>
                    <?php endif; ?>

                    <?php if ($current_page < $total_pages): ?>
                        <li class="page-item">
                            <a class="page-link" href="?page=<?php echo $current_page + 1; ?><?php echo $current_user_id > 0 ? '&chat_id=' . $current_user_id : ''; ?>" aria-label="Next">
                                <span aria-hidden="true">Tiếp &raquo;</span>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
    <?php endif; ?>
</div>

<script>
    // 🔧 TÍCH HỢP JS từ chat.php, adapted cho cskh.php (AJAX load/send, switch chat without reload)
    let currentChatId = <?= $current_user_id; ?>;
    let currentUsername = '<?= htmlspecialchars($current_username); ?>';
    const chatMessages = document.getElementById("chatMessages");
    const chatInput = document.getElementById("chatInput");
    const sendButton = document.getElementById("sendButton");
    const fileInput = document.getElementById("fileInput");
    const imagePreviewContainer = document.getElementById("imagePreviewContainer");
    const noChatSelected = document.getElementById("noChatSelected");
    const chatCard = document.getElementById("chatCard");
    const chatMain = document.getElementById("chatMain");

    let isUserAtBottom = true;

    function isNearBottom() {
        return chatMessages.scrollHeight - chatMessages.scrollTop <= chatMessages.clientHeight + 50;
    }

    function scrollToBottom(force = false) {
        if (force || isUserAtBottom) {
            chatMessages.scrollTop = chatMessages.scrollHeight;
        }
    }

    chatMessages.addEventListener("scroll", function() {
        isUserAtBottom = isNearBottom();
    });

    // Auto-resize textarea
    function autoResize() {
        chatInput.style.height = 'auto';
        chatInput.style.height = Math.min(chatInput.scrollHeight, 120) + 'px';
    }

    chatInput.addEventListener("input", autoResize);

    chatInput.addEventListener("keypress", function(e) {
        if (e.key === "Enter" && !e.shiftKey) {
            e.preventDefault();
            sendButton.click();
        }
    });

    fileInput.addEventListener("change", function(event) {
        imagePreviewContainer.innerHTML = "";
        const files = event.target.files;
        Array.from(files).forEach(file => {
            if (file.type.startsWith("image/")) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement("img");
                    img.src = e.target.result;
                    img.alt = file.name;
                    img.style.maxWidth = "60px";
                    img.style.maxHeight = "60px";
                    img.style.margin = "5px";
                    img.classList.add("border", "rounded", "p-1");
                    imagePreviewContainer.appendChild(img);
                };
                reader.readAsDataURL(file);
            }
        });
    });

    // 🔧 Function load chat for specific user (switch without reload)
    function loadChat(event, userId, username) {
        currentChatId = userId;
        currentUsername = username;
        // Update header
        const cardHeader = chatCard.querySelector('.card-header h1');
        if (cardHeader) {
            cardHeader.textContent = `Chat với ${username}`;
        }
        // Show chat
        noChatSelected.style.display = 'none';
        chatCard.style.display = 'block';
        // Update sidebar active only if event is provided (skip for initial load)
        if (event && event.target) {
            const activeItem = event.target.closest('.chat-list-item');
            if (activeItem) {
                document.querySelectorAll('.chat-list-item').forEach(item => item.classList.remove('active'));
                activeItem.classList.add('active');
            }
        }
        // Load messages
        loadChatMessages();
        startChatPolling();
        // Mark as read via AJAX
        fetch(`send_message.php?action=mark_read&user_id=${userId}`)
            .then(() => console.log('Marked as read'));
        scrollToBottom(true);
    }

    function loadChatMessages() {
        if (currentChatId === 0) return;
        fetch(`chat_load_messages.php?id=${currentChatId}`)
            .then(response => response.text())
            .then(html => {
                chatMessages.innerHTML = html;
                scrollToBottom(true);
            })
            .catch(error => console.error("Lỗi khi tải tin nhắn:", error));
    }

    // Send message via AJAX
    sendButton.addEventListener("click", function() {
        if (!currentChatId || (chatInput.value.trim() === '' && fileInput.files.length === 0)) return;
        const formData = new FormData();
        formData.append('user_id', currentChatId);
        formData.append('message', chatInput.value.trim());
        Array.from(fileInput.files).forEach(file => formData.append('images[]', file));

        fetch('send_message.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                chatInput.value = '';
                fileInput.value = '';
                imagePreviewContainer.innerHTML = '';
                autoResize(); // Reset height
                loadChatMessages();
            } else {
                alert('Lỗi gửi tin nhắn: ' + (data.error || 'Unknown'));
            }
        })
        .catch(error => console.error('Error:', error));
    });

    let pollingInterval;
    function startChatPolling() {
        if (pollingInterval) clearInterval(pollingInterval);
        pollingInterval = setInterval(() => {
            if (currentChatId > 0) loadChatMessages();
        }, 10000); // 10s
    }

    // Initial state
    if (currentChatId === 0) {
        noChatSelected.style.display = 'flex';
        chatCard.style.display = 'none';
    } else {
        // Initial load for current chat (pass null for event to skip active update)
        loadChat(null, <?= $current_user_id; ?>, '<?= htmlspecialchars($current_username); ?>');
    }

    // Initial auto-resize
    autoResize();
</script>

<?php require_once __DIR__ . "/foot.php"; ?>