<?php
require_once __DIR__ . "/head.php";
require_once $_SERVER['DOCUMENT_ROOT'] . '/config/function.php'; // Đảm bảo file này có hàm parse_vietnamese_number

// Lấy thông tin user
$id = (int)($_GET['id'] ?? 0);
$user = $_vincenzo->get_row("SELECT * FROM `users` WHERE `id` = '$id'");

if (!$user) {
    die('<script>Swal.fire("Lỗi!", "Thành viên không tồn tại.", "error").then(() => window.location.href = "./members.php");</script>');
}

// Xử lý form khi submit
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Lấy dữ liệu từ form
    $tac_vu         = $_POST['tac_vu'] ?? 'cong';
    $so_diem_str    = $_POST['so_diem'] ?? '0';
    $ghi_chu        = $_POST['ghi_chu'] ?? '';
    $tien_no_hu_str = $_POST['tien_no_hu'] ?? '0';
    $noi_dung_no_hu = $_POST['noi_dung_no_hu'] ?? '';

    // Chuyển đổi số từ chuỗi có dấu chấm
    $so_diem    = parse_vietnamese_number($so_diem_str);
    $tien_no_hu = parse_vietnamese_number($tien_no_hu_str);

    $username = $user['username'];
    $current_coin = $user['coin'];

    // Bắt đầu xử lý
    if ($tac_vu == 'cong') {
        $real_coin_change = 0;
        
        // 1. Xử lý cộng điểm thông thường
        if ($so_diem > 0) {
            $real_coin_change += $so_diem;
            $note_log = empty($ghi_chu) ? 'Admin cộng điểm' : $ghi_chu;
            
            // Ghi log giao dịch
            $_vincenzo->insert("point_status", [
                'username' => $username,
                'note'     => $note_log,
                'coin'     => "+".$so_diem,
                'date'     => date('Y-m-d H:i:s')
            ]);
        }

        // 2. Xử lý gửi quà "Nổ Hũ" (không cộng tiền thật, chỉ tạo popup)
        if ($tien_no_hu > 0 && !empty($noi_dung_no_hu)) {
            $_vincenzo->insert('user_gifts', [
                'user_id'     => $id,
                'amount'      => $tien_no_hu,
                'type'        => 'Reward', // Hoặc 'Voucher' tùy bạn muốn
                'note'        => $noi_dung_no_hu,
                'is_read'     => 0,
                'is_received' => 0,
                'created_at'  => date('Y-m-d H:i:s')
            ]);
        }
        
        // 3. Cập nhật số dư thật của người dùng
        if ($real_coin_change > 0) {
            $_vincenzo->update("users", [
                'coin'       => $user['coin'] + $real_coin_change,
                'total_coin' => $user['total_coin'] + $real_coin_change,
                'admin_add'  => $user['admin_add'] + $real_coin_change
            ], "id = '$id'");
        }
        
        echo '<script>Swal.fire("Thành công!", "Thao tác cộng điểm và gửi quà đã được thực hiện.", "success").then(() => window.location.href = window.location.href);</script>';

    } elseif ($tac_vu == 'tru') {
        if ($so_diem <= 0) {
             echo '<script>Swal.fire("Lỗi!", "Số điểm cần trừ phải lớn hơn 0.", "error");</script>';
        } else {
            // Trừ tiền
            $_vincenzo->update("users", [
                'coin'      => $user['coin'] - $so_diem,
                'admin_tru' => $user['admin_tru'] + $so_diem
            ], "id = '$id'");
            
            // Ghi log
            $note_log = empty($ghi_chu) ? 'Admin trừ điểm' : $ghi_chu;
            $_vincenzo->insert("point_status", [
                'username' => $username,
                'note'     => $note_log,
                'coin'     => "-".$so_diem,
                'date'     => date('Y-m-d H:i:s')
            ]);

            echo '<script>Swal.fire("Thành công!", "Đã trừ điểm của người chơi.", "success").then(() => window.location.href = window.location.href);</script>';
        }
    }
}
?>

<!-- Header -->
<div class="app-content-header">
    <div class="container-fluid">
        <h3 class="mb-0">CỘNG/TRỪ ĐIỂM NGƯỜI CHƠI</h3>
    </div>
</div>

<!-- Content -->
<div class="app-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                         <h3 class="card-title">
                            <i class="fas fa-user-circle"></i>
                            <strong><?= htmlspecialchars($user['username']) ?></strong>
                            - Số dư: <span class="text-success"><?= format_money($user['coin']) ?></span>
                        </h3>
                    </div>
                    <form method="POST">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label class="form-label">Tác vụ</label>
                                        <select class="form-select" name="tac_vu" id="tac_vu">
                                            <option value="cong">Cộng điểm / Gửi quà Nổ Hũ</option>
                                            <option value="tru">Trừ điểm</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="so_diem" class="form-label">Số điểm</label>
                                        <input type="text" class="form-control" name="so_diem" id="so_diem" placeholder="Số điểm cộng/trừ thật vào tài khoản">
                                        <div class="form-text">Để trống nếu chỉ muốn gửi quà Nổ Hũ.</div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                     <div class="mb-3">
                                        <label for="ghi_chu" class="form-label">Ghi chú (nếu có)</label>
                                        <input type="text" class="form-control" name="ghi_chu" id="ghi_chu" placeholder="Nội dung log cộng/trừ điểm">
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Phần Nổ Hũ - chỉ hiển thị khi chọn Cộng -->
                            <div id="no_hu_section">
                                <hr>
                                <h5 class="text-danger mb-3">🎁 Gửi Quà Nổ Hũ (Tạo Popup Thông Báo)</h5>
                                <div class="mb-3">
                                    <label for="tien_no_hu" class="form-label">Số tiền Nổ Hũ (nếu có)</label>
                                    <input type="text" class="form-control" name="tien_no_hu" id="tien_no_hu" placeholder="VD: 59.666 hoặc 59666">
                                     <div class="form-text">Số tiền này <strong>KHÔNG</strong> cộng vào số dư, chỉ để hiển thị trong popup.</div>
                                </div>
                                <div class="mb-3">
                                    <label for="noi_dung_no_hu" class="form-label">Nội dung Nổ Hũ</label>
                                    <textarea class="form-control" name="noi_dung_no_hu" id="noi_dung_no_hu" rows="4" placeholder="Nội dung sẽ tự động cập nhật khi bạn nhập số tiền ở trên."></textarea>
                                </div>
                            </div>
                            
                            <p class="mt-3 text-muted small">
                                Tính năng dành cho Admin thực hiện cộng trừ điểm và gửi quà trực tiếp. Mục đích sử dụng trong trường hợp nạp nhầm, thưởng sự kiện hoặc phát hiện gian lận.
                            </p>
                        </div>
                        <div class="card-footer text-center">
                            <button type="submit" class="btn btn-primary px-5">Xác nhận</button>
                            <a href="./members.php" class="btn btn-secondary">Hủy</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const tacVuSelect = document.getElementById('tac_vu');
    const noHuSection = document.getElementById('no_hu_section');
    const tienNoHuInput = document.getElementById('tien_no_hu');
    const noiDungNoHuTextarea = document.getElementById('noi_dung_no_hu');
    const userId = <?= json_encode($user['username']) ?>;

    function toggleNoHuSection() {
        if (tacVuSelect.value === 'cong') {
            noHuSection.style.display = 'block';
        } else {
            noHuSection.style.display = 'none';
        }
    }

    // Format số với dấu chấm
    function formatNumber(input) {
        let val = input.value.replace(/\D/g, ''); // Bỏ hết ký tự không phải số
        val = val.replace(/\B(?=(\d{3})+(?!\d))/g, '.'); // Thêm dấu chấm
        input.value = val;
    }

    // Tự động điền và CẬP NHẬT nội dung Nổ Hũ
    tienNoHuInput.addEventListener('input', function(e) {
        // Luôn format số trước
        formatNumber(e.target);
        
        const amountValue = e.target.value;

        // Kiểm tra xem có giá trị tiền không
        if (amountValue && amountValue.trim() !== '') {
            // Nếu có, tạo và cập nhật nội dung
            const suggestedNote = `&#127881;&#127881;&#127881 Xin Chúc Mừng người chơi "${userId}" đã may mắn nhận được phần quà Tri Ân từ Hệ thống với giá trị là: ${amountValue} VND. Vui lòng liên hệ CSKH để biết thêm chi tiết. &#127873&#127873&#127873`;
            noiDungNoHuTextarea.value = suggestedNote;
        } else {
            // Nếu không có (admin xóa hết), thì cũng xóa nội dung gợi ý
            noiDungNoHuTextarea.value = '';
        }
    });
    
    // Áp dụng format số cho ô "Số điểm"
    document.getElementById('so_diem').addEventListener('input', (e) => formatNumber(e.target));

    // Lắng nghe sự kiện thay đổi tác vụ
    tacVuSelect.addEventListener('change', toggleNoHuSection);

    // Chạy lần đầu khi tải trang
    toggleNoHuSection();
});
</script>

<?php
require_once __DIR__ . "/foot.php";
?>