<?php
// chat_load_messages.php - Dựa trên code bạn cung cấp, đã tích hợp session check và config
require_once __DIR__ . "/../config/function.php";

if (!isset($_SESSION['activeAdmin'])) {
    header("Location: /");
    exit();
}

$user_id = (int)$_GET['id']; // Cast to int for safety

// Fetch user info to get username
$user = $_vincenzo->get_row("SELECT `username` FROM `users` WHERE `id` = " . $user_id);
if (!$user) {
    echo ''; // Or error message if needed
    exit;
}
$username = $user['username'];

$sql = "
    SELECT * 
    FROM `chat_messages` 
    WHERE 
        (
            (sender_id = 1 AND sender_type = 'admin' AND receiver_id = " . $user_id . " AND receiver_type = 'user')
            OR 
            (sender_id = " . $user_id . " AND sender_type = 'user' AND receiver_id = 1 AND receiver_type = 'admin')
        )
    ORDER BY created_at ASC
";
// Gọi get_list để lấy array kết quả
$chat_messages = $_vincenzo->get_list($sql);

foreach ($chat_messages as $message) {
    // Tin nhắn từ admin đến user: hiển thị bên trái (admin)
    if ($message['sender_type'] == 'admin') {
        echo '<div class="direct-chat-msg left">
            <div class="direct-chat-info clearfix">
                <span class="direct-chat-name">THTRUE MILK</span>
                <span class="direct-chat-timestamp">' . date('H:i', strtotime($message['created_at'])) . '</span>
            </div>
            <div class="direct-chat-text">
                ' . nl2br(htmlspecialchars($message['message'])) . '
            </div>
            ' . ($message['images'] ? '<div class="d-flex flex-wrap align-items-center gap-2 mt-2" style="gap: 8px;"><div class="image-wrapper" style="width: 100%; height: auto;">' . $message['images'] . '</div></div>' : '') . '
        </div>';
    } 
    // Tin nhắn từ user đến admin: hiển thị bên phải (user)
    else {
        echo '<div class="direct-chat-msg right">
            <div class="direct-chat-info clearfix">
                <span class="direct-chat-name">' . htmlspecialchars($username) . '</span>
                <span class="direct-chat-timestamp">' . date('H:i', strtotime($message['created_at'])) . '</span>
            </div>
            <div class="direct-chat-text">
                ' . nl2br(htmlspecialchars($message['message'])) . '
            </div>
            ' . ($message['images'] ? '<div class="d-flex flex-wrap align-items-center gap-2 mt-2" style="gap: 8px;"><div class="image-wrapper" style="width: 100%; height: auto;">' . $message['images'] . '</div></div>' : '') . '
        </div>';
    }
}
?>