<?php
require_once __DIR__ . "/head.php";

$per_page = 10;
$current_page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($current_page - 1) * $per_page;

// Get total count
$count_query = "SELECT COUNT(*) as total FROM `nganhang`";
$count_result = $_vincenzo->get_list($count_query);
$total_items = $count_result[0]['total'] ?? 0;
$total_pages = ceil($total_items / $per_page);

// Get paginated data
$main_query = "SELECT * FROM `nganhang` ORDER BY `id` ASC LIMIT " . $per_page . " OFFSET " . $offset;
$page_data = $_vincenzo->get_list($main_query);

// Adjust current_page if total_pages is less
$current_page = min($current_page, $total_pages);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nganhang = $_POST['nganhang'];
    $image = $_POST['image'];
    $_vincenzo->insert("nganhang", [
        'nganhang' => $nganhang,
        'image' => $image,
        'status' => '1'
    ]);
    echo '<script>Swal.fire("Thông báo!", "Thêm cấu hình rút tiền thành công.", "success"); setTimeout(function(){ window.location.href = "./cau-hinh-rut-tien.php"; }, 1500);</script>';
}
?>

<!--begin::App Content Header-->
<div class="app-content-header">
    <!--begin::Container-->
    <div class="container-fluid">
        <!--begin::Row-->
        <div class="row">
            <div class="col-sm-6">
                <h3 class="mb-0">Danh sách ngân hàng</h3>
            </div>
        </div>

    </div>

</div>
<div class="app-content">
    <!--begin::Container-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary card-outline mb-4">
                    <!--begin::Header-->
                    <div class="card-header">
                        <div class="card-title">Thêm cấu hình rút tiền</div>
                    </div>
                    <!--end::Header-->
                    <!--begin::Form-->
                    <form method="POST">
                        <div class="card-body">
                            <div class="mb-3">
                                <label for="bankSelect" class="form-label">Ngân hàng:</label>
                                <input type="text" class="form-control" name="nganhang" value="">
                                <label for="bankSelect" class="form-label">Đường dẫn ảnh:</label>
                                <input type="text" class="form-control" name="image" value="">
                                <div class="social-auth-links text-center mb-3 d-grid gap-2">
                                    <div class="social-auth-links text-center mb-3 d-grid gap-2">

                                        <button type="submit" class="btn btn-primary">Thao tác</button>
                                    </div>
                                </div>
                                <!--end::Body-->
                                <!--begin::Footer-->
                                <!--end::Footer-->
                    </form>
                    <!--end::Form-->
                </div>
            </div>
            <!-- /.col -->
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <!-- /.card-header -->
                    <div class="card-body p-0">
                        <table class="table" role="table">
                            <thead>
                                <tr>
                                    <th style="width: 10px" scope="col">ID</th>
                                    <th scope="col">Tên ngân hàng</th>
                                    <th scope="col">Ngân hàng</th>
                                    <th scope="col">Trạng thái</th>
                                    <th scope="col" class="text-center align-middle">Tác vụ</th>
                                    <!-- <th style="width: 40px" scope="col">Label</th> -->
                                </tr>
                            </thead>
                            <?php if (empty($page_data)): ?>
                                <tr>
                                    <td colspan="5" style="text-align:center;">Không có dữ liệu</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($page_data as $item): ?>
                                    <?php
                                    $id = $item['id'];
                                    $nganhang = $item['nganhang'];
                                    $image = $item['image'];
                                    $status = $item['status'];

                                    ?>
                                    <tr>
                                        <td><?php echo $id; ?></td>
                                        <td><?php echo $nganhang; ?></td>
                                        <td><img src="<?php echo $image; ?>" alt="Ảnh" width="80" height="30"></td>
                                        <td><?= status_members($status); ?></td>

                                        <td class="text-center align-middle">
                                            <div class="d-flex justify-content-center gap-2">
                                                <?php if ($status == 1): ?>
                                                    <a href="./block-cau-hinh-rut-tien.php?id=<?= $id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bạn có chắc chắn muốn khoá cổng rút này?');">
                                                        <i class="fas fa-key"></i>
                                                    </a>
                                                <?php else: ?>
                                                    <a href="./unblock-cau-hinh-rut-tien.php?id=<?= $id; ?>" class="btn btn-sm btn-primary" onclick="return confirm('Bạn có chắc chắn muốn mở cổng rút này?');">
                                                        <i class="fas fa-lock-open"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <a href="./edit-cau-hinh-rut-tien.php?id=<?= $id; ?>" class="btn btn-sm btn-info">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <a href="./remove-cau-hinh-rut-tien.php?id=<?= $id; ?>" class="btn btn-sm btn-danger">
                                                    <i class="fas fa-remove"></i>
                                                </a>
                                            </div>
                                        </td>

                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <?php if ($total_pages > 1): ?>
                    <nav aria-label="Page navigation">
                        <ul class="pagination justify-content-center">
                            <?php if ($current_page > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?php echo $current_page - 1; ?>" aria-label="Previous">
                                        <span aria-hidden="true">&laquo; Trước</span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php
                            // Hiển thị các trang, giới hạn số trang hiển thị nếu nhiều
                            $start_page = max(1, $current_page - 2);
                            $end_page = min($total_pages, $current_page + 2);
                            if ($start_page > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=1">1</a>
                                </li>
                                <?php if ($start_page > 2): ?>
                                    <li class="page-item disabled">
                                        <span class="page-link">...</span>
                                    </li>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
                                <?php if ($i == $current_page): ?>
                                    <li class="page-item active">
                                        <span class="page-link"><?php echo $i; ?></span>
                                    </li>
                                <?php else: ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                                    </li>
                                <?php endif; ?>
                            <?php endfor; ?>

                            <?php if ($end_page < $total_pages): ?>
                                <?php if ($end_page < $total_pages - 1): ?>
                                    <li class="page-item disabled">
                                        <span class="page-link">...</span>
                                    </li>
                                <?php endif; ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?php echo $total_pages; ?>"><?php echo $total_pages; ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if ($current_page < $total_pages): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?php echo $current_page + 1; ?>" aria-label="Next">
                                        <span aria-hidden="true">Tiếp &raquo;</span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                <?php endif; ?>
            </div>
            <!-- /.col -->
        </div>
    </div>
    <!--end::Container-->
</div>
<!--end::App Content-->

<?php
require_once __DIR__ . "/foot.php";

?>