<?php
// File: manager-cuoc-bom3p.php - FIXED: Chỉ sửa backend, giữ nguyên giao diện

require_once 'head.php'; // Bao gồm header, sidebar và navigation

// --- LẤY DỮ LIỆU THỐNG KÊ TỔNG QUAN (SỬA: Dùng get_row thay vì get_one) ---

// Thống kê thắng/thua
$total_wins_row = $vincenzo->get_row("SELECT COUNT(id) as count FROM user_bets WHERE status = 'won'");
$total_wins_count = $total_wins_row['count'] ?? 0;

$total_wins_amount_row = $vincenzo->get_row("SELECT SUM(win_amount) as amount FROM user_bets WHERE status = 'won'");
$total_wins_amount = $total_wins_amount_row['amount'] ?? 0;

$total_losses_row = $vincenzo->get_row("SELECT COUNT(id) as count FROM user_bets WHERE status = 'lost'");
$total_losses_count = $total_losses_row['count'] ?? 0;

$total_losses_amount_row = $vincenzo->get_row("SELECT SUM(bet_amount) as amount FROM user_bets WHERE status = 'lost'");
$total_losses_amount = $total_losses_amount_row['amount'] ?? 0;

// Thống kê theo lựa chọn cược
$total_bets_row = $vincenzo->get_row("SELECT COUNT(id) as total FROM user_bets");
$total_bets_count = $total_bets_row['total'] ?? 0;

$th_true_milk_row = $vincenzo->get_row("SELECT COUNT(id) as count FROM user_bets WHERE bet_type = 'TH TRUEMILK'");
$th_true_milk_count = $th_true_milk_row['count'] ?? 0;

$vinamilk_row = $vincenzo->get_row("SELECT COUNT(id) as count FROM user_bets WHERE bet_type = 'VINAMILK'");
$vinamilk_count = $vinamilk_row['count'] ?? 0;

$th_percentage = ($total_bets_count > 0) ? round(($th_true_milk_count / $total_bets_count) * 100, 2) : 0;
$vina_percentage = ($total_bets_count > 0) ? round(($vinamilk_count / $total_bets_count) * 100, 2) : 0;


// --- LOGIC PHÂN TRANG ---
$limit = 15; // Số dòng mỗi trang
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;
$total_records = $total_bets_count; // Đã có sẵn ở trên
$total_pages = ceil($total_records / $limit);


// --- LẤY DỮ LIỆU CHO BẢNG ---
// **SỬA ĐỔI QUAN TRỌNG**: Lấy thêm `gs.status` để biết phiên đã kết thúc chưa
$bets = $vincenzo->get_list("
    SELECT
        ub.id, ub.username, ub.session_id, ub.bet_type, ub.bet_amount,
        ub.win_amount, ub.bet_time, ub.status AS bet_status_db,
        u.id as user_id,
        gs.result as session_result,
        gs.status as session_status
    FROM user_bets ub
    LEFT JOIN users u ON ub.username = u.username
    LEFT JOIN game_sessions gs ON ub.session_id = gs.id
    ORDER BY ub.id DESC
    LIMIT $limit OFFSET $offset
");

// Hàm trợ giúp để tính kết quả phiên từ chuỗi result
function getGameResult($result_string) {
    if (empty($result_string)) return ['name' => 'Chưa có', 'value' => 'N/A'];
    $numbers = explode(',', $result_string);
    $sum = 0;
    foreach ($numbers as $num) {
        $sum += (int)$num;
    }
    $last_digit = $sum % 10;
    $result_name = ($last_digit >= 5) ? 'THTRUE MILK' : 'VINAMILK';
    return ['name' => $result_name, 'value' => $last_digit];
}
?>

<h3 class="mb-3">Quản lý cược 180 giây</h3>

<div class="mb-3">
    <div class="row text-center">
        <div class="col-md-3">
            <div class="border p-2 bg-light">
                <strong class="text-danger">Tổng lượt thua:</strong><br>
                <?= number_format($total_losses_count) ?>
            </div>
        </div>
        <div class="col-md-3">
            <div class="border p-2 bg-light">
                <strong class="text-danger">Tổng điểm thua:</strong><br>
                <?= number_format($total_losses_amount) ?>
            </div>
        </div>
        <div class="col-md-3">
            <div class="border p-2 bg-light">
                <strong class="text-success">Tổng lượt thắng:</strong><br>
                <?= number_format($total_wins_count) ?>
            </div>
        </div>
        <div class="col-md-3">
            <div class="border p-2 bg-light">
                <strong class="text-success">Tổng điểm thắng:</strong><br>
                <?= number_format($total_wins_amount) ?>
            </div>
        </div>
    </div>

    <div class="text-center mt-3">
        <strong>Phân bố lựa chọn:</strong><br>
        <span class="badge badge-danger">
            THTRUE MILK: <?= number_format($th_true_milk_count) ?> lượt (<?= $th_percentage ?>%)
        </span>
        <span class="badge badge-dark">
            VINAMILK: <?= number_format($vinamilk_count) ?> lượt (<?= $vina_percentage ?>%)
        </span>
    </div>
</div>

<!-- Bảng thống kê cược -->
<div class="table-responsive">
    <table class="table table-bordered text-center">
        <thead class="thead-dark">
            <tr>
                <th>ID</th>
                <th>Người chơi</th>
                <th>VIP</th>
                <th>Số kỳ</th>
                <th>Kết quả phiên</th>
                <th>Khách đã đặt</th>
                <th>Điểm cược</th>
                <th>Điểm thắng</th>
                <th>Thời gian</th>
                <th>Trạng thái</th>
                <th>Thao tác</th>
            </tr>
        </thead>
        <tbody id="gameTableBody">
            <?php foreach ($bets as $bet): ?>
                <?php
                    // --- LOGIC SỬA LỖI HIỂN THỊ TRẠNG THÁI ---
                    $real_status = 'running'; // Mặc định là đang chạy
                    $sessionResult = getGameResult($bet['session_result']);

                    // Nếu phiên đã 'finished' thì ta phải tự tính lại trạng thái
                    if ($bet['session_status'] == 'finished') {
                        if ($sessionResult['name'] == $bet['bet_type']) {
                            $real_status = 'won';
                        } else {
                            $real_status = 'lost';
                        }
                    }
                ?>
                <tr>
                    <td><?= $bet['id'] ?></td>
                    <td class="text-left">
                        <a class="font-weight-bold text-primary" href="edit-user.php?id=<?= $bet['user_id'] ?>">
                            <?= htmlspecialchars($bet['username']) ?>
                        </a> (ID: <?= $bet['user_id'] ?>)
                    </td>
                    <td>VIP 0</td> <!-- Tạm thời để tĩnh -->
                    <td><?= $bet['session_id'] ?></td>
                    <td>
                        <?php if ($bet['session_status'] == 'finished'): ?>
                            <div>
                                <span class="font-weight-bold <?= $sessionResult['name'] == 'THTRUE MILK' ? 'text-danger' : 'text-dark' ?>">
                                    <?= $sessionResult['name'] ?>
                                </span>
                                <span>(<?= $sessionResult['value'] ?>)</span>
                            </div>
                        <?php else: ?>
                             <span class="badge badge-info">Đang chạy</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <span class="font-weight-bold <?= $bet['bet_type'] == 'THTRUE MILK' ? 'text-danger' : 'text-dark' ?>">
                            <?= $bet['bet_type'] ?>
                        </span>
                        <?php if ($bet['session_status'] == 'finished'): // Chỉ hiển thị (sẽ thắng/thua) khi phiên đã xong ?>
                            <span class="font-weight-bold <?= $real_status == 'won' ? 'text-success' : 'text-danger' ?>">
                                (<?= $real_status == 'won' ? 'sẽ thắng' : 'sẽ thua' ?>)
                            </span>
                        <?php endif; ?>
                    </td>
                    <td><?= number_format($bet['bet_amount']) ?></td>
                    <td><?= number_format($bet['win_amount']) ?></td>
                    <td><?= date('Y-m-d H:i:s', strtotime($bet['bet_time'])) ?></td>
                    <td>
                        <?php
                            // Dùng $real_status đã tính toán để hiển thị
                            $status_class = 'info';
                            $status_text = 'Đang chạy';
                            if ($real_status == 'won') {
                                $status_class = 'success';
                                $status_text = 'Đã thắng';
                            } elseif ($real_status == 'lost') {
                                $status_class = 'danger';
                                $status_text = 'Đã thua';
                            }
                        ?>
                        <span class="badge badge-<?= $status_class ?>"><?= $status_text ?></span>
                    </td>
                    <td>
                        <button class="btn btn-warning btn-sm edit-bet-btn" data-bet-id="<?= $bet['id'] ?>" <?= ($bet['session_status'] != 'running') ? 'disabled' : '' ?>>
                            <i class="fas fa-edit"></i>
                        </button>
                        <button class="btn btn-danger btn-sm delete-bet-btn" data-bet-id="<?= $bet['id'] ?>">
                            <i class="fas fa-trash"></i>
                        </button>
                    </td>
                </tr>
            <?php endforeach; ?>
            <?php if (empty($bets)): ?>
                <tr><td colspan="11" class="text-center">Không tìm thấy dữ liệu.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Phân trang -->
<nav>
    <ul class="pagination justify-content-center">
        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
            <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
                <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
            </li>
        <?php endfor; ?>
    </ul>
</nav>

<?php require_once 'foot.php'; // Bao gồm footer ?>