<?php
include __DIR__ . '/config/function.php';

// Nếu đã đăng nhập rồi thì chuyển về trang chủ
if (isset($_SESSION['username'])) {
    header('Location: /');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');
    $confirm_password = trim($_POST['confirm_password'] ?? '');
    $error_message = '';

    if (empty($username) || empty($password)) {
        $error_message = "Vui lòng nhập đầy đủ thông tin.";
    } elseif ($password !== $confirm_password) {
        $error_message = "Mật khẩu xác nhận không khớp.";
    } else {
        // Kiểm tra tên đăng nhập đã tồn tại chưa
        $existing_user = $_vincenzo->get_row("SELECT * FROM `users` WHERE `username` = '$username'");
        if ($existing_user) {
            $error_message = "Tên đăng nhập đã tồn tại. Vui lòng chọn tên khác.";
        } else {
            $hashed_password = md5($password);
            
            // Lấy IP và vị trí của người dùng
            $user_ip = $_SERVER['REMOTE_ADDR'];
            $location = getLocationFromIP_Cached($user_ip);
            
            // ============================================================
            // BƯỚC 1: Kiểm tra ID cao nhất hiện tại
            // ============================================================
            $max_id_row = $_vincenzo->get_row("SELECT MAX(id) as max_id FROM `users`");
            $current_max_id = $max_id_row ? (int)$max_id_row['max_id'] : 0;
            
            // Nếu ID hiện tại < 9000 thì bắt đầu từ 9000
            // Nếu ID hiện tại >= 9000 thì tiếp tục tăng dần
            $next_id = ($current_max_id < 9000) ? 9000 : ($current_max_id + 1);
            
            // ============================================================
            // BƯỚC 2: Thêm người dùng với ID tùy chỉnh (Cấu trúc đầy đủ)
            // ============================================================
            $_vincenzo->insert("users", [
                'id'         => $next_id,
                'username'   => $username,
                'password'   => $hashed_password,
                'coin'       => 0,
                'type_bank'  => '',
                'name_bank'  => '',
                'stk_bank'   => '',
                'rut_diem'   => 0,
                'total_coin' => 0,
                'total_bet'  => 0,
                'admin_add'  => 0,
                'admin_tru'  => 0,
                'date'       => date('Y-m-d H:i:s'),
                'status'     => 1,
                'city'       => $location ?? 'Unknown',
                'ipaddress'  => $user_ip
            ]);

            // ============================================================
            // BƯỚC 3: TỰ ĐỘNG ĐĂNG NHẬP - Tạo session
            // ============================================================
            $_SESSION['username'] = $username;
            $_SESSION['user_id'] = $next_id;
            $_SESSION['logged_in'] = true;
            $_SESSION['login_time'] = time();
            
            // ============================================================
            // BƯỚC 4: Chuyển hướng về trang chủ (index.php)
            // ============================================================
            header('Location: /index.php');
            exit;
        }
    }
    
    // Hiển thị lỗi nếu có
    if (!empty($error_message)) {
         echo '<script>alert("'.$error_message.'");</script>';
    }
}
?>
<html lang="vi">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=0">
    <meta name="robots" content="noindex, nofollow">
    <title>THTRUE MILK</title>
    <meta name="description" content="Hạnh phúc đích thực là khi cả gia đình cùng nhau tận hưởng những gì tinh tuý nhất từ thiên nhiên">
    <meta name="keywords" content="thtruemart, thtrue milk, thtrue milks">
    <meta name="author" content="THTRUE MILK">
    <!-- Open Graph (Facebook) -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="THTRUE MILK">
    <meta property="og:description" content="Hạnh phúc đích thực là khi cả gia đình cùng nhau tận hưởng những gì tinh tuý nhất từ thiên nhiên">
    <meta property="og:url" content="https://www.familymilkkvn.com">
    <meta property="og:image" content="<?= BASE_URL(); ?>upload/thtruemilk.jpg">
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="THTRUE MILK">
    <meta name="twitter:description" content="Hạnh phúc đích thực là khi cả gia đình cùng nhau tận hưởng những gì tinh tuý nhất từ thiên nhiên">
    <meta name="twitter:image" content="<?= BASE_URL(); ?>upload/thtruemilk.jpg">
    <link rel="icon" href="<?= BASE_URL(); ?>favicon/favicon.png" type="image/x-icon">
    <link rel="canonical" href="https://www.familymilkkvn.com">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/stylev8.css">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/sweetalert2/sweetalert2.min.css">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/bootstrap/bootstrap.min.css">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/slick.css">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/slick-theme.css">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/flickity/flickity.css">
    <script src="<?= BASE_URL(); ?>css/sweetalert2/sweetalert2.min.js"></script>
    <script src="<?= BASE_URL(); ?>css/jquery-3.6.0.min.js"></script>
    <script src="<?= BASE_URL(); ?>css/bootstrap/bootstrap.min.js"></script>
    <script src="<?= BASE_URL(); ?>css/flickity/flickity.pkgd.min.js"></script>
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "WebPage"
        }
    </script>
    <!--Bootstrap v4.5.3 and Font Awesome Free 6.5.1-->
</head>

<body>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Inter", sans-serif, system-ui, -apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Helvetica Neue, Arial, Noto Sans, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol, Noto Color Emoji;
        }

        body {
            background: #f0f0f0;
            display: flex;
            justify-content: center;
            align-items: center;
        }


        .signup-container {
            width: 540px;
            height: 100vh;
            background-image: linear-gradient(178178deg, hsla(0, 0%, 100%, 0), #f3fcff, #9ad4f0), url(images/bg-signup-new.jpg);
            background-size: cover;
            padding: 30px;
            text-align: center;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
            align-items: center;
            background-position: 100%;
            background-repeat: no-repeat;
            background-size: auto 100%;
        }

        .signup-container img {
            width: 100%;
            height: auto;
        }

        .signup-container h2 {
            font-size: 22px;
            margin-bottom: 20px;
            color: #004d40;
        }

        .input-group {
            position: relative;
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }

        .input-group input {
            width: 100%;
            padding: 10px 40px 10px 10px;
            /* Chừa chỗ cho icon */
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 16px;
        }

        .input-group i {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #777;
            pointer-events: auto;
            /* Đảm bảo icon nhận được sự kiện click */
            z-index: 10;
            /* Đảm bảo icon nằm trên input */
        }


        .remember-me {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
            font-size: 14px;
        }

        .remember-me input {
            margin-right: 5px;
            margin-bottom: 10px;
        }

        .signup-btn {
            width: 100%;
            padding: 12px;
            border: none;
            background: #e32823;
            color: white;
            font-size: 16px;
            font-weight: bold;
            border-radius: 5px;
            cursor: pointer;
            transition: 0.3s;
        }

        .signup-btn:hover {
            background: #00796b;
        }

        .register-link {
            margin-top: 15px;
            font-size: 14px;
        }

        .register-link a {
            color: #00796b;
            text-decoration: none;
            font-weight: bold;
        }

        .register-link a:hover {
            text-decoration: underline;
        }

        .partners-container {
            width: 100%;
            display: flex;
            justify-content: center;
        }

        .partners-row {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            width: 90%;
            max-width: 800px;
        }

        .partner {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .partner-img-box {
            width: 100%;
            max-width: 150px;
            height: auto;
        }

        .partner-img-box img {
            width: 100%;
            height: auto;
            object-fit: contain;
            transition: transform 0.3s ease-in-out;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .partners-row {
                grid-template-columns: repeat(3, 1fr);
                gap: 10px;
            }
        }

        @media (max-width: 480px) {
            .partners-row {
                grid-template-columns: repeat(3, 1fr);
                gap: 8px;
            }
        }


        .company-info {
            margin-top: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background-color: rgba(203, 233, 247, 0.7019607843);
            border-top: solid;
            border-bottom: solid;
        }

        th {
            text-align: left;
            padding: 8px;
            width: 150px;
        }

        td {
            padding: 5px;
            text-align: left;
        }

        b,
        strong {
            font-weight: bold;
        }
    </style>


    <div class="signup-container">
        <img src="images/thtruemilk/logo.png" alt="TH True Milk" height="60">

        <!-- Hiển thị thông báo lỗi -->
        <?php if (!empty($error)) : ?>
            <div class="alert alert-danger" role="alert"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        <!-- ====================== DÒNG ĐÃ THAY ĐỔI ====================== -->
        <form method="POST" action="">
            <!-- ================================================================ -->

            <div class="input-group">
                <input type="text" class="form-control" id="user_signup" name="username" placeholder="Tên đăng nhập" required autocomplete="username">
                <i class="fas fa-user"></i>
            </div>

            <div class="input-group">
                <input type="password" class="form-control password-input" id="password" name="password" placeholder="Mật khẩu" required autocomplete="new-password">
                <i class="fas fa-eye togglePassword"></i>
            </div>


            <div class="input-group">
                <input type="password" class="form-control password-input" id="confirm_password" name="confirm_password" placeholder="Xác nhận mật khẩu" required autocomplete="new-password">
                <i class="fas fa-eye togglePassword"></i>
            </div>



            <div class="remember-me">
                <input type="checkbox" id="remember">
                <label for="remember">Duy trì đăng nhập</label>
            </div>

            <button type="submit" class="signup-btn">Đăng Ký Ngay</button>
        </form>

        <div class="register-link">
            Đã có tài khoản? <a href="/login.php">Đăng nhập ngay</a>
        </div>

        <div class="partners-container my-4">
            <div class="partners-row">
                <div class="partner">
                    <div class="partner-img-box">
                        <img src="images/partners/vietinbank.png" alt="VietinBank">
                    </div>
                </div>
                <div class="partner">
                    <div class="partner-img-box">
                        <img src="images/partners/vingroup.png" alt="Vingroup">
                    </div>
                </div>
                <div class="partner">
                    <div class="partner-img-box">
                        <img src="images/partners/techcombank.png" alt="Techcombank">
                    </div>
                </div>
                <div class="partner">
                    <div class="partner-img-box">
                        <img src="images/partners/sungroup.png" alt="Sun Group">
                    </div>
                </div>
                <div class="partner">
                    <div class="partner-img-box">
                        <img src="images/partners/online-gov.png" alt="Đã đăng ký Bộ Công Thương">
                    </div>
                </div>
                <div class="partner">
                    <div class="partner-img-box">
                        <img src="images/partners/topcv.png" alt="TopCV">
                    </div>
                </div>
            </div>
        </div>

        <div class="company-info">
            <h6 class="font-weight-bold">ĐỒNG HÀNH CÙNG TH TRUEMILK</h6>
            <table>
                <tr>
                    <th>Tên quốc tế:</th>
                    <td><strong>HA NAM MILK JOINT STOCK COMPANY</strong></td>
                </tr>
                <tr>
                    <th>Tên viết tắt:</th>
                    <td><strong>HA NAM MILK., JSC</strong></td>
                </tr>
                <tr>
                    <th>Mã số thuế:</th>
                    <td><strong>0700731083</strong></td>
                </tr>
                <tr>
                    <th>Địa chỉ:</th>
                    <td><strong>Thôn Đồ Quán, Xã Mộc Nam, Thị xã Duy Tiên, Tỉnh Hà Nam, Việt Nam</strong></td>
                </tr>
                <tr>
                    <th>Ngày hoạt động:</th>
                    <td><strong>2014-10-28</strong></td>
                </tr>
                <tr>
                    <th>Quản lý bởi:</th>
                    <td><strong>Chi cục Thuế khu vực Duy Tiên - Lý Nhân</strong></td>
                </tr>
                <tr>
                    <th>Loại hình DN:</th>
                    <td><strong>Công ty cổ phần ngoại NN</strong></td>
                </tr>
            </table>
        </div>
    </div>

    <script>
        document.querySelectorAll(".togglePassword").forEach((toggle) => {
            toggle.addEventListener("click", function() {
                const passwordInput = this.previousElementSibling;
                if (passwordInput.type === "password") {
                    passwordInput.type = "text";
                    this.classList.replace("fa-eye", "fa-eye-slash");
                } else {
                    passwordInput.type = "password";
                    this.classList.replace("fa-eye-slash", "fa-eye");
                }
            });
        });
    </script>
</body>

</html>