<?php
require_once __DIR__ . "/head.php";
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name_bank = $_POST['name_bank'];
    $stk_bank = $_POST['stk_bank'];
    $amount = $_POST['amount'];

    if (empty($name_bank) || empty($stk_bank) || empty($amount)) {
        echo '<script>Swal.fire("Lỗi!", "Vui lòng điền đầy đủ thông tin.", "error");</script>';
    } else {

        // Kiểm tra số điểm rút
        if ($amount <= 0) {
            echo '<script>Swal.fire("Lỗi!", "Số điểm rút phải lớn hơn 0.", "error");</script>';
        }

        if ($amount > $getUser['coin']) {
            echo '<script>Swal.fire("Lỗi!", "Số điểm rút vượt quá số dư hiện tại.", "error");</script>';
        } else {


            $status_rut = $_vincenzo->insert("history_withdraw", [
                'username' => $getUser['username'],
                'bank_name' => $getUser['type_bank'],
                'name_bank' => $name_bank,
                'stk_bank' => $stk_bank,
                'coin' => $amount,
                'date' => date('Y-m-d H:i:s')
            ]);
            if ($status_rut) {
                $_vincenzo->update("users", [
                    'coin' => $getUser['coin'] - $amount
                ], "id = " . $getUser['id']);

                $status_rut = $_vincenzo->insert("point_status", [
                    'username' => $getUser['username'],
                    'date' => date('Y-m-d H:i:s'),
                    'note' => 'Rút điểm qua ngân hàng ' . $getUser['type_bank'],
                    'coin' => "-" . $amount,
                ]);
                echo '<script>Swal.fire("Thành công!", "Yêu cầu rút điểm của bạn đã được ghi nhận.", "success")</script>';
            } else {
                echo '<script>Swal.fire("Lỗi!", "Đã có lỗi xảy ra, vui lòng thử lại.", "error");</script>';
            }
        }
    }

    // Xử lý rút điểm

}
?>


<link rel="stylesheet" href="css/select2/dist/css/select2.min.css">


<style>
    .swal-mb-180 {
        margin-bottom: 180px !important;
    }

    .swal-popup-compact {
        min-height: 35px !important;
        height: 35px !important;
        padding: 5px 10px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        font-size: 14px !important;
        line-height: 1 !important;
    }

    .modal-custom {
        max-width: 500px;
        min-height: 100vh;
        margin: 0px auto;
        background: #fff;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
    }

    .modal-header {
        background-color: #2fbba0;
        color: white;
        padding: 12px;
        text-align: center;
        font-size: 16px;
        font-weight: bold;
    }

    .modal-body {
        padding: 15px;
    }

    .form-label {
        font-weight: bold;
    }

    .form-control[readonly] {
        background-color: #f4f4f4;
    }

    .btn-blue {
        background: #2fbba0 !important;
        color: #ffffff;
    }


    .alert {
        font-size: 14px;
    }

    .alert-danger {
        background-color: #d32f2f;
        color: white;
    }

    .alert-success {
        background-color: #388e3c;
        color: white;
    }

    .alert-warning {
        background-color: #fbc02d;
        color: #333;
    }

    .btn-danger {
        background: url(/images/menu-footer.png), -webkit-gradient(linear, left top, left bottom, from(#2fbba0), to(#2fbba0));
        border: none;
        font-weight: bold;
    }

    .btn-danger:hover {
        background: linear-gradient(to right, #096453, #287a6a);
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
        color: #444;
        line-height: 48px !important;
        font-weight: 600 !important;
    }

    .select2-container .select2-selection--single {
        box-sizing: border-box;
        cursor: pointer;
        display: block;
        height: 48px !important;
        user-select: none;
        -webkit-user-select: none;
    }

    #select2-bank_name-results {
        color: #000 !important;
    }
</style>


<div class="modal-custom">
    <div class="modal-header">Rút điểm</div>
    <div class="modal-body">

        <form method="POST" enctype="multipart/form-data">
            <div class="mb-3">
                <label class="form-label">Tên ngân hàng</label>
                <select name="bank_name" id="bank_name" class="form-control select2" required disabled>
                    <option value="">-- Chọn ngân hàng --</option>

                    <?php
                    $old_bank_name = $getUser['type_bank']; // Lấy giá trị cũ từ DB
                    $list_bank = $_vincenzo->get_list("SELECT * FROM `nganhang` WHERE `status` = 1 ORDER BY `id` ASC");

                    // echo json_encode($list_bank);
                    $data = json_encode($list_bank); // chuyển JSON thành mảng PHP
                    $data = json_decode($data, true); // chuyển JSON thành mảng PHP

                    $banks = [];

                    foreach ($data as $item) {
                        $banks[$item['nganhang']] = $item['image'];
                    }

                    // print_r($banks);


                    foreach ($banks as $value => $img) {
                        $selected = ($old_bank_name == $value) ? 'selected' : '';
                        echo "<option value=\"{$value}\" data-code=\"{$value}\" data-image=\"{$img}\" {$selected}>{$value}</option>";
                    }
                    ?>
                </select>
            </div>

            <div class="mb-3">
                <label class="form-label">Chủ tài khoản</label>
                <input type="text" name="name_bank" id="real_name" class="form-control" autocomplete="off" value="<?= $getUser['name_bank']; ?>" readonly>
            </div>
            <div class="mb-3">
                <label class="form-label">Số tài khoản</label>
                <input type="text" name="stk_bank" id="bank_number" class="form-control" autocomplete="off" value="<?= $getUser['stk_bank']; ?>" readonly>
            </div>

            <div class="mb-3">
                <label class="form-label">Số dư hiện tại</label>
                <input type="text" class="form-control" value="<?= format_money($getUser['coin']); ?>" readonly>
            </div>


            <div class="mb-3">
                <label class="form-label">Số điểm muốn rút</label>
                <input type="text" id="amount_display" class="form-control" autocomplete="off"
                    oninput="formatCurrency(this)" onblur="syncHiddenField('amount_display', 'amount')">
                <input type="hidden" id="amount" name="amount">
            </div>

            <div class="mb-3 text-center d-none">
                <img id="vietqr_image" src="" style="max-width: 100%; display: none; margin-bottom: 10px;">
            </div>

            <button type="submit" class="btn btn-danger w-100">Xác nhận rút điểm</button>
        </form>
    </div>
</div>


<script>
    function formatCurrency(input) {
        let value = input.value.replace(/,/g, '');
        if (!isNaN(value) && value !== '') {
            input.value = Number(value).toLocaleString('en-US', {
                maximumFractionDigits: 0
            });
        }
        syncHiddenField('amount_display', 'amount');
    }

    function syncHiddenField(displayId, hiddenId) {
        const val = document.getElementById(displayId).value.replace(/,/g, '');
        document.getElementById(hiddenId).value = val;
        updateVietQR(); // Gọi lại khi đồng bộ
    }

    function updateVietQR() {
        const bankName = document.querySelector('[name="bank_name"]').value;
        const realName = document.querySelector('[name="real_name"]').value;
        const bankNumber = document.querySelector('[name="bank_number"]').value;
        const amount = document.getElementById('amount').value;

        if (bankName && realName && bankNumber && amount) {
            const formData = new FormData();
            formData.append('bank_name', bankName);
            formData.append('real_name', realName);
            formData.append('bank_number', bankNumber);
            formData.append('amount', amount);

            fetch('generate_vietqr.php', {
                    method: 'POST',
                    body: formData
                })
                .then(res => res.json())
                .then(data => {
                    const qrImg = document.getElementById('vietqr_image');
                    if (data.success) {
                        qrImg.src = data.qr_url;
                        qrImg.style.display = 'block';
                    } else {
                        qrImg.style.display = 'none';
                    }
                });
        }
    }

    document.addEventListener("DOMContentLoaded", function() {
        ['bank_name', 'real_name', 'bank_number', 'amount_display'].forEach(id => {
            const el = document.getElementById(id);
            if (el) {
                el.addEventListener('input', updateVietQR);
                el.addEventListener('change', updateVietQR);
                el.addEventListener('blur', updateVietQR);
            }
        });
    });

    function uploadCccdImage(input, previewId, type) {
        const file = input.files[0];
        if (!file) return;

        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById(previewId).src = e.target.result;
        };
        reader.readAsDataURL(file);

        const formData = new FormData();
        formData.append('file', file);
        formData.append('cccd_type', type);

        fetch('ajax_upload_cccd.php', {
            method: 'POST',
            body: formData
        }).then(res => res.json()).then(data => {
            if (data.success) {
                Swal.fire('Thành công', data.message, 'success');
            } else {
                Swal.fire('Lỗi', data.message, 'error');
            }
        }).catch(err => {
            Swal.fire('Lỗi', 'Không thể upload ảnh', 'error');
            console.error(err);
        });
    }
</script>


<script>
    $(document).ready(function() {
        function formatBank(bank) {
            if (!bank.id) return bank.text;
            var logo = $(bank.element).data('image');
            var name = bank.text;
            return $(
                '<span><img src="' + logo + '" style="height: 20px; margin-right: 6px;">' + name + '</span>'
            );
        }

        $('#bank_name').select2({
            templateResult: formatBank,
            templateSelection: formatBank,
            width: '100%',
            placeholder: "-- Chọn ngân hàng --",
            allowClear: true
        });

        // 👇 Thêm placeholder cho ô tìm kiếm khi dropdown mở
        $('#bank_name').on('select2:open', function() {
            setTimeout(function() {
                $('.select2-container--open .select2-search__field').attr('placeholder', 'Vui lòng nhập tên ngân hàng');
            }, 0);
        });
    });
</script>

<script src="css/select2/dist/js/select2.min.js"></script>



<?php
require_once __DIR__ . "/foot.php";
?>