<?php
// login.php - SỬA LỖI: Sử dụng đúng cú pháp của class Vincenzo cũ

include __DIR__ . '/config/function.php';

// 1. Kiểm tra nếu người dùng đã đăng nhập thì chuyển hướng
if (isset($_SESSION['username'])) {
    header('Location: /');
    exit;
}

$error = ''; // Khởi tạo biến thông báo lỗi

// 2. Xử lý khi người dùng gửi form
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = isset($_POST['username']) ? trim($_POST['username']) : '';
    $password = isset($_POST['password']) ? $_POST['password'] : '';

    // Kiểm tra đầu vào
    if (empty($username) || empty($password)) {
        $error = 'Vui lòng nhập tên đăng nhập và mật khẩu.';
    } else {
        // 3. Escape username để tránh SQL Injection (dùng hàm escape_string đã có)
        $safe_username = $vincenzo->escape_string($username);
        
        // Truy vấn theo cú pháp CŨ (không dùng prepared statement)
        $sql = "SELECT * FROM `users` WHERE `username` = '{$safe_username}'";
        $getUser = $vincenzo->get_row($sql);

        // 4. So sánh mật khẩu và xử lý đăng nhập
        if ($getUser && $getUser['password'] === md5($password)) {
            // Đăng nhập thành công, lưu session
            $_SESSION['username'] = $getUser['username'];
            
            // Lấy IP và vị trí
            $user_ip = $_SERVER['REMOTE_ADDR'];
            $location = getLocationFromIP_Cached($user_ip);
            
            // 5. Cập nhật theo CÚ PHÁP CŨ của hàm update()
            $update_data = [
                'ipaddress' => $user_ip,
                'city'      => $location ?? 'Unknown'
            ];
            $where_clause = "`id` = '" . $vincenzo->escape_string($getUser['id']) . "'";
            
            // Gọi hàm update với 3 tham số (không có prepared statement)
            $vincenzo->update('users', $update_data, $where_clause);
            
            // Chuyển hướng đến trang chủ
            header('Location: /');
            exit;
        } else {
            // Sai tên đăng nhập hoặc mật khẩu
            $error = 'Tên đăng nhập hoặc mật khẩu không đúng.';
        }
    }
}
?>

<!-- PHẦN HTML GIỮ NGUYÊN -->
<html lang="vi">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=0">
    <meta name="robots" content="noindex, nofollow">
    <title>THTRUE MILK</title>
    <meta name="description" content="Hạnh phúc đích thực là khi cả gia đình cùng nhau tận hưởng những gì tinh tuý nhất từ thiên nhiên">
    <meta name="keywords" content="thtruemart, thtrue milk, thtrue milks">
    <meta name="author" content="THTRUE MILK">
    <meta property="og:type" content="website">
    <meta property="og:title" content="THTRUE MILK">
    <meta property="og:description" content="Hạnh phúc đích thực là khi cả gia đình cùng nhau tận hưởng những gì tinh tuý nhất từ thiên nhiên">
    <meta property="og:url" content="<?= BASE_URL(); ?>">
    <meta property="og:image" content="<?= BASE_URL(); ?>upload/ ">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="THTRUE MILK">
    <meta name="twitter:description" content="Hạnh phúc đích thực là khi cả gia đình cùng nhau tận hưởng những gì tinh tuý nhất từ thiên nhiên">
    <meta name="twitter:image" content="<?= BASE_URL(); ?>upload/thtruemilk.jpg">
    <link rel="icon" href="<?= BASE_URL(); ?>favicon/favicon.png" type="image/x-icon">
    <link rel="canonical" href="<?= BASE_URL(); ?>">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/stylev8.css">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/sweetalert2/sweetalert2.min.css">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/bootstrap/bootstrap.min.css">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/slick.css">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/slick-theme.css">
    <link rel="stylesheet" href="<?= BASE_URL(); ?>css/flickity/flickity.css">
    <script src="<?= BASE_URL(); ?>css/sweetalert2/sweetalert2.min.js"></script>
    <script src="<?= BASE_URL(); ?>css/jquery-3.6.0.min.js"></script>
    <script src="<?= BASE_URL(); ?>css/bootstrap/bootstrap.min.js"></script>
    <script src="<?= BASE_URL(); ?>css/flickity/flickity.pkgd.min.js"></script>
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "WebPage"
        }
    </script>
</head>

<body>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Inter", sans-serif, system-ui, -apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Helvetica Neue, Arial, Noto Sans, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol, Noto Color Emoji;
        }

        body {
            background: #f0f0f0;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .login-container {
            width: 540px;
            height: 100vh;
            background-image: linear-gradient(178178deg, hsla(0, 0%, 100%, 0), #f3fcff, #2fbba1), url(images/bg-login-new.jpg);
            background-size: cover;
            padding: 30px;
            text-align: center;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
            align-items: center;
            background-position: 100%;
            background-repeat: no-repeat;
            background-size: auto 100%;
        }

        .login-container img {
            width: 100%;
            height: auto;
        }

        .login-container h2 {
            font-size: 22px;
            margin-bottom: 20px;
            color: #004d40;
        }

        .input-group {
            width: 100%;
            position: relative;
            margin-bottom: 15px;
        }

        .input-group input {
            width: 100%;
            padding: 10px 40px 10px 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 16px;
        }

        .input-group i {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #777;
        }

        .remember-me {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
            font-size: 14px;
        }

        .remember-me input {
            margin-right: 5px;
            margin-bottom: 10px;
        }

        .login-btn {
            width: 100%;
            padding: 12px;
            border: none;
            background: #009688;
            color: white;
            font-size: 16px;
            font-weight: bold;
            border-radius: 5px;
            cursor: pointer;
            transition: 0.3s;
        }

        .login-btn:hover {
            background: #00796b;
        }

        .register-link {
            margin-top: 15px;
            font-size: 14px;
        }

        .register-link a {
            color: #00796b;
            text-decoration: none;
            font-weight: bold;
        }

        .register-link a:hover {
            text-decoration: underline;
        }

        .partners-container {
            width: 100%;
            display: flex;
            justify-content: center;
        }

        .partners-row {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            width: 90%;
            max-width: 800px;
        }

        .partner {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .partner-img-box {
            width: 100%;
            max-width: 150px;
            height: auto;
        }

        .partner-img-box img {
            width: 100%;
            height: auto;
            object-fit: contain;
            transition: transform 0.3s ease-in-out;
        }

        @media (max-width: 768px) {
            .partners-row {
                grid-template-columns: repeat(3, 1fr);
                gap: 10px;
            }
        }

        @media (max-width: 480px) {
            .partners-row {
                grid-template-columns: repeat(3, 1fr);
                gap: 8px;
            }
        }

        .company-info {
            margin-top: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background-color: rgba(203, 233, 247, 0.7019607843);
            border-top: solid;
            border-bottom: solid;
        }

        th {
            text-align: left;
            padding: 8px;
            width: 150px;
        }

        td {
            padding: 5px;
            text-align: left;
        }

        b, strong {
            font-weight: bold;
        }
    </style>

    <div class="login-container">
        <img src="images/thtruemilk/logo.png" alt="TH True Milk" height="60">
        <?php if (!empty($error)) : ?>
            <div class="alert alert-danger" role="alert"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="input-group">
                <input type="text" id="username" name="username" placeholder="Tên đăng nhập" required autocomplete="username">
                <i class="fas fa-user"></i>
            </div>

            <div class="input-group">
                <input type="password" id="password" name="password" placeholder="Mật khẩu" required autocomplete="current-password">
                <i class="fas fa-eye" id="togglePassword"></i>
            </div>

            <div class="remember-me">
                <input type="checkbox" id="remember">
                <label for="remember">Duy trì đăng nhập</label>
            </div>

            <button type="submit" class="login-btn">Đăng Nhập Ngay</button>
        </form>

        <div class="register-link">
            Chưa có tài khoản? <a href="/signup.php">Đăng ký tài khoản mới</a>
        </div>

        <div class="partners-container my-4">
            <div class="partners-row">
                <div class="partner">
                    <div class="partner-img-box">
                        <img src="images/partners/vietinbank.png" alt="VietinBank">
                    </div>
                </div>
                <div class="partner">
                    <div class="partner-img-box">
                        <img src="images/partners/vingroup.png" alt="Vingroup">
                    </div>
                </div>
                <div class="partner">
                    <div class="partner-img-box">
                        <img src="images/partners/techcombank.png" alt="Techcombank">
                    </div>
                </div>
                <div class="partner">
                    <div class="partner-img-box">
                        <img src="images/partners/sungroup.png" alt="Sun Group">
                    </div>
                </div>
                <div class="partner">
                    <div class="partner-img-box">
                        <img src="images/partners/online-gov.png" alt="Đã đăng ký Bộ Công Thương">
                    </div>
                </div>
                <div class="partner">
                    <div class="partner-img-box">
                        <img src="images/partners/topcv.png" alt="TopCV">
                    </div>
                </div>
            </div>
        </div>

        <div class="company-info">
            <h6 class="font-weight-bold">ĐỒNG HÀNH CÙNG TH TRUEMILK</h6>
            <table>
                <tr>
                    <th>Tên quốc tế:</th>
                    <td><strong>HA NAM MILK JOINT STOCK COMPANY</strong></td>
                </tr>
                <tr>
                    <th>Tên viết tắt:</th>
                    <td><strong>HA NAM MILK., JSC</strong></td>
                </tr>
                <tr>
                    <th>Mã số thuế:</th>
                    <td><strong>0700731083</strong></td>
                </tr>
                <tr>
                    <th>Địa chỉ:</th>
                    <td><strong>Thôn Đồ Quán, Xã Mộc Nam, Thị xã Duy Tiên, Tỉnh Hà Nam, Việt Nam</strong></td>
                </tr>
                <tr>
                    <th>Ngày hoạt động:</th>
                    <td><strong>2014-10-28</strong></td>
                </tr>
                <tr>
                    <th>Quản lý bởi:</th>
                    <td><strong>Chi cục Thuế khu vực Duy Tiên - Lý Nhân</strong></td>
                </tr>
                <tr>
                    <th>Loại hình DN:</th>
                    <td><strong>Công ty cổ phần ngoại NN</strong></td>
                </tr>
            </table>
        </div>
    </div>

    <script>
        document.getElementById("togglePassword").addEventListener("click", function() {
            const passwordInput = document.getElementById("password");
            if (passwordInput.type === "password") {
                passwordInput.type = "text";
                this.classList.remove("fa-eye");
                this.classList.add("fa-eye-slash");
            } else {
                passwordInput.type = "password";
                this.classList.remove("fa-eye-slash");
                this.classList.add("fa-eye");
            }
        });
    </script>
</body>
</html>