<?php
require_once __DIR__ . "/head.php";

$total_giaodich = $_vincenzo->get_row(
    "SELECT COUNT(*) AS cnt FROM `history_withdraw` WHERE `username` = '" . $getUser['username'] . "'"
)['cnt'];

$per_page = 10;
$current_page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($current_page - 1) * $per_page;

// Get total count
$count_query = "SELECT COUNT(*) as total FROM `history_withdraw` WHERE `username` = '" . $getUser['username'] . "'";
$count_result = $_vincenzo->get_list($count_query);
$total_items = $count_result[0]['total'] ?? 0;
$total_pages = ceil($total_items / $per_page);

// Get paginated data
$main_query = "SELECT * FROM `history_withdraw` WHERE `username` = '" . $getUser['username'] . "' ORDER BY `id` DESC LIMIT " . $per_page . " OFFSET " . $offset;
$page_data = $_vincenzo->get_list($main_query);

// Adjust current_page if total_pages is less
$current_page = min($current_page, $total_pages);
?>

<style>
    .modal-custom {
        max-width: 500px;
        min-height: 100vh;
        margin: 0px auto;
        background: #fff;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
    }

    .modal-header {
        background-color: #2fbba1;
        color: white;
        padding: 12px;
        text-align: center;
        font-size: 16px;
        font-weight: bold;
    }

    .summary-box {
        background-color: #c3e9e2;
        padding: 10px;
        display: flex;
        justify-content: space-between;
        font-size: 14px;
        font-weight: bold;
    }

    .table {
        width: 100%;
        font-size: 14px;
        border-collapse: collapse;
    }

    .table thead {
        background-color: #dbf7f2;
    }

    .table th,
    .table td {
        padding: 8px 10px;
        border-bottom: 1px solid #c3e9e2;
    }

    .table td:first-child {
        color: #e64a19;
        font-weight: bold;
    }

    .status-approved {
        color: green;
        font-weight: bold;
    }

    .status-pending {
        color: orange;
        font-weight: bold;
    }

    .status-failed {
        color: red;
        font-weight: bold;
    }

    .pagination {
        display: flex;
        justify-content: center;
        margin: 15px 0;
    }

    .pagination a,
    .pagination span {
        margin: 0 3px;
        padding: 5px 10px;
        text-decoration: none;
        border-radius: 4px;
        font-size: 14px;
    }

    .pagination a {
        background-color: #f1f1f1;
        color: #333;
    }

    .pagination a:hover {
        background-color: #ffccbc;
    }

    .pagination .active {
        background-color: #ff7043;
        color: white;
        font-weight: bold;
    }
</style>

<div class="modal-custom">
    <div class="modal-header">Lịch Sử Rút Điểm</div>
    <div class="summary-box">
        <div>Tổng giao dịch: <strong><?= $total_giaodich; ?></strong></div>
        <div>Đã rút: <strong><?= format_money($getUser['rut_diem']); ?></strong></div>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>Số điểm</th>
                <th>Thời gian</th>
                <th>Trạng thái</th>
                <th>Chi tiết</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($page_data)): ?>
                <tr>
                    <td colspan="4" style="text-align:center;">Không có dữ liệu</td>
                </tr>
            <?php else: ?>
                <?php foreach ($page_data as $item): ?>
                    <tr>
                        <td><?= format_money($item['coin']); ?></td>
                        <td><?= $item['date']; ?></td>
                        <td><?= $item['status']; ?></td>
                        <td><?= $item['note']; ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
    <?php if ($total_pages > 1): ?>
        <div class="pagination">
            <?php if ($current_page > 1): ?>
                <a href="?page=<?php echo $current_page - 1; ?>">« Trước</a>
            <?php endif; ?>

            <?php
            // Hiển thị các trang, giới hạn số trang hiển thị nếu nhiều
            $start_page = max(1, $current_page - 2);
            $end_page = min($total_pages, $current_page + 2);
            if ($start_page > 1): ?>
                <a href="?page=1">1</a>
                <?php if ($start_page > 2): ?>
                    <span>...</span>
                <?php endif; ?>
            <?php endif; ?>

            <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
                <?php if ($i == $current_page): ?>
                    <span class="active"><?php echo $i; ?></span>
                <?php else: ?>
                    <a href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                <?php endif; ?>
            <?php endfor; ?>

            <?php if ($end_page < $total_pages): ?>
                <?php if ($end_page < $total_pages - 1): ?>
                    <span>...</span>
                <?php endif; ?>
                <a href="?page=<?php echo $total_pages; ?>"><?php echo $total_pages; ?></a>
            <?php endif; ?>

            <?php if ($current_page < $total_pages): ?>
                <a href="?page=<?php echo $current_page + 1; ?>">Tiếp »</a>
            <?php endif; ?>
        </div>
    <?php endif; ?>

</div>

<script>
    document.addEventListener('click', function(e) {
        var btn = e.target.closest('.xem-chi-tiet');
        if (!btn) return;

        var holder = btn.getAttribute('data-holder') || '—';
        var stk = btn.getAttribute('data-stk') || '—';
        var bank = btn.getAttribute('data-bank') || '—';
        var amount = btn.getAttribute('data-amount') || 0;

        // Format số tiền 
        try {
            amount = new Intl.NumberFormat('vi-VN').format(parseInt(amount, 10));
        } catch (_) {}

        Swal.fire({
            title: 'Chi tiết rút điểm',
            html: `
            <div style="text-align:left; font-size:14px; line-height:1.6">
                <div><strong>Chủ tài khoản:</strong> ${holder}</div>
                <div><strong>Ngân hàng:</strong> ${bank}</div>
                <div><strong>Số tài khoản:</strong> ${stk}</div>
                <div><strong>Số tiền rút:</strong> ${amount} </div>
            </div>
        `,
            confirmButtonText: 'Đóng',
            confirmButtonColor: '#2fbba1'
        });
    }, false);
</script>





<?php
require_once __DIR__ . "/foot.php";


?>