<?php
// Lấy URL hiện tại (bao gồm cả https/http, domain, và path)
include __DIR__ . '/config/function.php';
if (!isset($_SESSION['username'])) {
    $return['status'] = false;
    $return['message']   = 'Đăng nhập đi bạn ơi!';
    die(json_encode($return));
} else {
    $lastGameInfo = $_vincenzo->get_row("SELECT * FROM `game_sessions` ORDER BY `start_time` DESC LIMIT 1");
    if (!$lastGameInfo) {
        $return['status'] = false;
        $return['message'] = 'Chưa có ván nào được chơi cả!';
        die(json_encode($return));
    }
    $prevGameInfo = $_vincenzo->get_row("SELECT * FROM `game_sessions` ORDER BY `start_time` DESC LIMIT 1 OFFSET 1");

    if (!$prevGameInfo) {
        $return['status'] = true;
        $return['message'] = 'Chỉ có 1 ván, không có ván trước!';
        $return['next_game_id'] = $lastGameInfo['id'] + 1;
        $return['last_game_id'] = $lastGameInfo['id'];
        $return['boms'] = null;  // Hoặc $lastGameInfo['result'] nếu muốn fallback
    } else {
        $return['status'] = true;
        $return['next_game_id'] = $lastGameInfo['id'] + 1;
        $return['last_game_id'] = $lastGameInfo['id'];
        $return['prev_game_id'] = $prevGameInfo['id'];  // Thêm ID ván trước
        $resultString = $prevGameInfo['result'];
        $bomsArray = explode(',', $resultString);

        $return['boms'] = $bomsArray;
    }

    die(json_encode($return));
}
