<html lang="vi">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=0">
    <meta name="robots" content="noindex, nofollow">
    <title>THTRUE MILK</title>
    <meta name="description" content="Hạnh phúc đích thực là khi cả gia đình cùng nhau tận hưởng những gì tinh tuý nhất từ thiên nhiên">
    <meta name="keywords" content="thtruemart, thtrue milk, thtrue milks">
    <meta name="author" content="THTRUE MILK">
    <!-- Open Graph (Facebook) -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="THTRUE MILK">
    <meta property="og:description" content="Hạnh phúc đích thực là khi cả gia đình cùng nhau tận hưởng những gì tinh tuý nhất từ thiên nhiên">
    <meta property="og:url" content="https://www.familymilkkvn.com">
    <meta property="og:image" content="https://www.familymilkkvn.com/upload/thtruemilk.jpg">
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="THTRUE MILK">
    <meta name="twitter:description" content="Hạnh phúc đích thực là khi cả gia đình cùng nhau tận hưởng những gì tinh tuý nhất từ thiên nhiên">
    <meta name="twitter:image" content="https://www.familymilkkvn.com/upload/thtruemilk.jpg">
    <link rel="icon" href="https://www.familymilkkvn.com/favicon/favicon.png" type="image/x-icon">
    <link rel="canonical" href="https://www.familymilkkvn.com">
    <link rel="stylesheet" href="https://www.familymilkkvn.com/css/stylev8.css">
    <link rel="stylesheet" href="https://www.familymilkkvn.com/css/sweetalert2/sweetalert2.min.css">
    <link rel="stylesheet" href="https://www.familymilkkvn.com/css/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="https://www.familymilkkvn.com/css/bootstrap/bootstrap.min.css">
    <link rel="stylesheet" href="https://www.familymilkkvn.com/css/slick.css">
    <link rel="stylesheet" href="https://www.familymilkkvn.com/css/slick-theme.css">
    <link rel="stylesheet" href="https://www.familymilkkvn.com/css/flickity/flickity.css">
    <script src="https://www.familymilkkvn.com/css/sweetalert2/sweetalert2.min.js"></script>
    <script src="https://www.familymilkkvn.com/css/jquery-3.6.0.min.js"></script>
    <script src="https://www.familymilkkvn.com/css/bootstrap/bootstrap.min.js"></script>
    <script src="https://www.familymilkkvn.com/css/flickity/flickity.pkgd.min.js"></script>
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "WebPage"
        }
    </script>
    <!--Bootstrap v4.5.3 and Font Awesome Free 6.5.1-->
</head>

<body>

    <style>
        .friends-card {
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 6px 24px rgba(0, 0, 0, 0.06);
            padding: 25px;
            margin-bottom: 30px;
        }

        .friends-card h5 {
            font-weight: 600;
            margin-bottom: 18px;
        }

        .friend-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-weight: 500;
            font-size: 1rem;
            padding: 12px 0;
            border-bottom: 1px solid #eee;
        }

        .friend-item a:hover {
            font-weight: normal;
            font-size: 1rem;
            text-decoration: underline;
        }

        .friend-name {
            font-weight: 500;
            font-size: 1rem;
            display: flex;
            align-items: center;
        }

        .friend-name i {
            font-size: 1.2rem;
            margin-right: 10px;
            color: #5c5c5c;
        }

        .friend-actions button {
            margin-left: 6px;
        }

        img.rounded-circle {
            object-fit: cover;
            border: 1px solid #ddd;
        }


        .sidebar-toggle {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            z-index: 998;
            width: 90%;
            transform: translateX(-100%);
            transition: transform 0.3s ease;
            background: #fff;
        }

        .sidebar-toggle.show {
            transform: translateX(0);
        }

        .sidebar-toggle {
            overflow-y: auto;
        }

        @media (min-width: 768px) {
            .sidebar-toggle {
                position: relative;
                transform: none !important;
                width: auto;
                height: auto;
                z-index: auto;
            }

            #toggleMenu {
                display: none !important;
            }
        }
    </style>


    <div class="container-fluid p-0" style="height: 100vh; overflow: hidden;">

        <!-- Nút menu ba gạch hiển thị trên mobile -->
        <button id="toggleMenu" class="btn btn-light d-md-none" style="position: fixed; top: 10px; right: 10px; z-index: 9999;">
            <i class="fas fa-bars"></i>
        </button>

        <div class="row no-gutters h-100">

            <!-- Cột trái: Danh sách lời mời, đã gửi, bạn bè -->
            <div id="sidebarMenu" class="col-md-4 col-lg-3 bg-white border-right sidebar-toggle" style="overflow-y:auto;">

                <div class="list-group list-group-flush">
                    <input type="text" id="searchInput" class="form-control form-control-sm p-3" placeholder="Tìm kiếm...">
                    <ul class="list-group mt-2 d-none" id="searchResults"></ul>
                </div>

                <div class="list-group list-group-flush">
                    <div class="px-3 text-muted small mt-3 mb-1">Bạn bè</div>
                    <div class="text-muted px-3 mb-3">Bạn chưa có bạn bè nào.</div>
                </div>
            </div>

            <!-- Cột phải: vùng trống -->
            <div class="col-md-8 col-lg-9 d-flex align-items-center justify-content-center" style="background: #e3f2fd;">
                <div class="text-center">
                    <img src="images/empty.png" style="width:150px; opacity: 0.7;">
                    <p class="text-muted mt-3">Chọn một người để bắt đầu trò chuyện</p>
                </div>
            </div>
        </div>
    </div>


    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 2000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            });

            const showToastAndReload = (icon, title) => {
                Toast.fire({
                    icon,
                    title
                }).then(() => location.reload());
            };

            // Chấp nhận lời mời
            document.querySelectorAll(".btn-accept").forEach(function(btn) {
                btn.addEventListener("click", function() {
                    const userId = this.getAttribute("data-user");
                    fetch("ajax-friends-group.php?u=" + userId + "&accept=1")
                        .then(res => res.json())
                        .then(data => {
                            if (data.success) {
                                showToastAndReload('success', '✅ Đã chấp nhận lời mời');
                            } else {
                                Toast.fire({
                                    icon: 'error',
                                    title: data.message || '❌ Không thể xử lý'
                                });
                            }
                        });
                });
            });

            // Từ chối lời mời
            document.querySelectorAll(".btn-decline").forEach(function(btn) {
                btn.addEventListener("click", function() {
                    const userId = this.getAttribute("data-user");
                    fetch("ajax-friends-group.php?u=" + userId + "&decline=1")
                        .then(res => res.json())
                        .then(data => {
                            if (data.success) {
                                showToastAndReload('success', '✅ Đã từ chối lời mời');
                            } else {
                                Toast.fire({
                                    icon: 'error',
                                    title: data.message || '❌ Không thể xử lý'
                                });
                            }
                        });
                });
            });

            // Hủy kết bạn
            document.querySelectorAll(".btn-remove-friend").forEach(function(btn) {
                btn.addEventListener("click", function() {
                    const uid = this.getAttribute("data-id");
                    const friendName = this.getAttribute("data-name") || "người dùng";

                    Swal.fire({
                        icon: 'warning',
                        title: 'Xác nhận hủy kết bạn?',
                        html: 'Bạn sẽ không thể nhắn tin với <strong>' + friendName + '</strong> nếu không kết bạn lại.',
                        showCancelButton: true,
                        confirmButtonText: '✅ Hủy kết bạn',
                        cancelButtonText: '❌ Bỏ qua'
                    }).then(function(result) {
                        if (result.isConfirmed) {
                            fetch("ajax_unfriend_group_chat.php?u=" + uid)
                                .then(function(res) {
                                    return res.json();
                                })
                                .then(function(data) {
                                    if (data.success) {
                                        showToastAndReload('success', '🗑️ Đã hủy kết bạn');
                                    } else {
                                        Toast.fire({
                                            icon: 'error',
                                            title: data.message || '❌ Không thể xử lý'
                                        });
                                    }
                                }).catch(function() {
                                    Toast.fire({
                                        icon: 'error',
                                        title: '❌ Lỗi mạng. Vui lòng thử lại'
                                    });
                                });
                        }
                    });
                });
            });
        });
    </script>

    <script>
        document.addEventListener("click", function(e) {
            if (e.target.closest(".btn-cancel-invite")) {
                const btn = e.target.closest(".btn-cancel-invite");
                const userId = btn.getAttribute("data-user");

                Swal.fire({
                    icon: 'warning',
                    title: 'Hủy lời mời kết bạn?',
                    text: 'Bạn có chắc muốn hủy lời mời đã gửi?',
                    showCancelButton: true,
                    confirmButtonText: '✅ Hủy lời mời',
                    cancelButtonText: '❌ Bỏ qua'
                }).then((result) => {
                    if (result.isConfirmed) {
                        fetch("ajax-friends-group.php?u=" + userId + "&cancel=1")
                            .then(res => res.json())
                            .then(data => {
                                if (data.success) {
                                    Swal.fire({
                                        toast: true,
                                        icon: 'success',
                                        title: '🎯 Đã hủy lời mời',
                                        position: 'top-end',
                                        showConfirmButton: false,
                                        timer: 1800
                                    }).then(() => {
                                        location.reload(); // ✅ Reload sau khi hiển thị toast
                                    });
                                } else {
                                    Swal.fire("❌ Lỗi", data.message || "Không thể xử lý", "error");
                                }
                            }).catch(() => {
                                Swal.fire("❌ Lỗi mạng", "Không thể kết nối máy chủ", "error");
                            });
                    }
                });
            }
        });
    </script>


    <!-- WebSocket Notification & Popup -->
    <script>
        const ws = new WebSocket("wss://ws.familymilkkvn.com/ws/socket");
        let popupTimer;

        // ✅ Kết nối WebSocket
        ws.onopen = function() {
            console.log("[WebSocket] Đã kết nối từ footer");
            ws.send(JSON.stringify({
                type: "init",
                user_id: 10042,
                session_token: "user_session_1_3f39e2487e9e5d2017e3308c14f9685a35ce0dcbbbf75f6590247b70b73d96e1"
            }));
        };

        // ✅ Nhận thông báo từ server
        ws.onmessage = function(event) {
            const data = JSON.parse(event.data);

            if (data.type === 'send_message_group') {
                const senderId = data.sender_id;
                const message = data.text;
                const msgId = data.id;

                showPopup("message", "Tin nhắn mới từ người dùng #" + senderId, message, "private-chat.php?u=" + senderId, msgId);
            } else if (data.type === 'send_add_friend_message') {
                const fromId = data.from_id;
                const name = data.name;

                showPopup("friend", name + " đã gửi lời mời kết bạn", "", "add-friends.php?u=" + fromId);
            }
        };

        // ✅ Hàm hiển thị popup
        function showPopup(type, mainText, subText, link, msgId) {
            const popup = document.getElementById("popupNotify");
            const icon = document.getElementById("popupIcon");
            const content = document.getElementById("popupContent");
            const sub = document.getElementById("popupSubtext");

            content.innerHTML = mainText;
            sub.innerHTML = subText || "";

            // Đặt icon phù hợp
            if (type === "message") {
                icon.className = "fa-solid fa-comment-dots text-primary";
            } else if (type === "friend") {
                icon.className = "fa-solid fa-user-plus text-success";
            } else {
                icon.className = "fa-solid fa-bell text-info";
            }

            // Hiển thị
            popup.style.display = "block";
            popup.onclick = () => window.location.href = link;

            // Nếu có mã tin nhắn, gọi AJAX đánh dấu đã đọc
            if (msgId) {
                fetch("ajax_mark_message_read.php", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/x-www-form-urlencoded"
                    },
                    body: "msg_id=" + encodeURIComponent(msgId)
                });
            }

            // Tự ẩn sau 30s
            clearTimeout(popupTimer);
            popupTimer = setTimeout(() => {
                popup.style.display = "none";
            }, 30000);
        }
    </script>

    <!-- Popup Container -->
    <div id="popupNotify" style="display:none; position:fixed; bottom:80px; right:10px; z-index:9999; max-width:500px; width:100%;">
        <div class="card shadow border-info animated-popup" style="cursor:pointer;">
            <div class="card-body d-flex align-items-start">
                <div class="mr-3">
                    <i id="popupIcon" class="fa-solid fa-bell text-info"></i>
                </div>
                <div style="flex: 1;">
                    <div id="popupContent" class="font-weight-bold text-dark small"></div>
                    <div id="popupSubtext" class="text-muted small mt-1"></div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .animated-popup {
            animation: slideInFade 0.5s ease-out;
            border-radius: 12px;
        }

        @keyframes slideInFade {
            from {
                transform: translateY(30px);
                opacity: 0;
            }

            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
    </style>

    <script>
        document.getElementById("searchInput").addEventListener("input", function() {
            const query = this.value.trim();
            const resultBox = document.getElementById("searchResults");

            if (query.length < 2) {
                resultBox.classList.add("d-none");
                resultBox.innerHTML = "";
                return;
            }

            fetch("ajax_search_chat_list.php?q=" + encodeURIComponent(query))
                .then(function(res) {
                    return res.json();
                })
                .then(function(data) {
                    resultBox.innerHTML = "";
                    if (data.length === 0) {
                        resultBox.innerHTML = '<li class="list-group-item text-muted">Không tìm thấy</li>';
                    } else {
                        data.forEach(function(item) {
                            const li = document.createElement("li");
                            li.className = "list-group-item list-group-item-action d-flex align-items-center";

                            const avatar = item.avatar || '/images/default-avatar.png';

                            li.innerHTML =
                                '<a href="' + item.link + '" class="d-flex align-items-center text-dark text-decoration-none flex-grow-1">' +
                                '<img src="' + avatar + '" alt="avatar" class="rounded-circle mr-2" style="width:36px; height:36px; object-fit:cover;">' +
                                '<div>' +
                                '<div><strong>' + item.name + '</strong></div>' +
                                '<div><small class="text-muted">' + item.subtitle + '</small></div>' +
                                '</div>' +
                                '</a>' +
                                '<a href="' + item.link + '" class="btn btn-sm btn-outline-primary ml-2">' +
                                '<i class="fa-solid fa-arrow-right"></i>' +
                                '</a>';

                            resultBox.appendChild(li);
                        });
                    }

                    resultBox.classList.remove("d-none");
                });
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const toggleBtn = document.getElementById("toggleMenu");
            const sidebar = document.getElementById("sidebarMenu");
            const icon = toggleBtn.querySelector("i");

            toggleBtn.addEventListener("click", function() {
                sidebar.classList.toggle("show");
                icon.classList.toggle("fa-bars");
                icon.classList.toggle("fa-times");
            });
        });
    </script>



    <div class="supper-nav">

        <div class="row m-0 p-0 mb-1">
            <div class="col-6 text-left text-white">
                <small>Nhân viên ID: 10042</small>
            </div>
            <div class="col-6 text-right text-white">
                <small class="reloadBalance" data-balance-id="footer">Số dư: 0</small>
            </div>
        </div>

        <ul>
            <li>
                <a href="/" rel="nofollow">
                    <i class="fas fa-home text-white fa-2x"></i> Home
                </a>
            </li>
            <li>
                <a href="/" rel="nofollow">
                    <i class="fas fa-sync-alt text-white fa-2x"></i> Làm mới
                </a>
            </li>
            <li>
                <a href="/friends-list.php" rel="nofollow">
                    <i class="fa-solid fa-users-gear text-white fa-2x"></i> Phòng làm việc
                </a>
            </li>
            <!-- <li class="phone-mobile"> -->
            <!-- <a href="/dau-tu.php?coin=gold" rel="nofollow" class="button"> -->
            <!-- <span class="phone_animation animation-shadow"> -->
            <!-- <i class="fas fa-coins text-white fa-2x" aria-hidden="true"></i> -->
            <!-- </span> -->
            <!-- <span class="btn_phone_txt">Đầu tư</span> -->
            <!-- </a> -->
            <!-- </li> -->
            <!-- <li> -->
            <!-- <a href="/vitien.php" rel="nofollow"> -->
            <!-- <i class="fas fa-wallet text-white fa-2x"></i> Ví tiền -->
            <!-- </a> -->
            <!-- </li> -->
            <li>
                <a href="/account.php" rel="nofollow">
                    <i class="fas fa-user text-white fa-2x"></i> Cá nhân
                </a>
            </li>
            <li>
                <a href="chat.php" class="chat_animation">
                    <i class="fas fa-headset text-white fa-2x"></i> CSKH
                </a>
            </li>
        </ul>

    </div>




    <script src="/css/confetti.browser.min.js"></script>
    <script src="/css/slick/slick.min.js"></script>
    <script src="/css/lightbox2/js/lightbox.js"></script>
    <script src="/css/popper/dist/umd/popper.min.js"></script>
    <script src="/css/bootstrap/bootstrap.min.js"></script>
    <script src="/css/bootstrap/bootstrap.bundle.min.js"></script>
</body>

</html>