<?php
// config.php - Phiên bản HOÀN CHỈNH, chống mọi lỗi khai báo lại
if (!function_exists('startSection')) {
    $sections = [];
    
    function startSection($name) {
        global $sections;
        $sections[$name] = '';
        ob_start();
    }
    
    function endSection($name) {
        global $sections;
        $sections[$name] = ob_get_clean();
    }
    
    function renderSection($name) {
        global $sections;
        echo $sections[$name] ?? '';
    }
}
// Bắt đầu session một cách an toàn, chỉ khi nó chưa được bắt đầu
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Bật hiển thị lỗi để dễ dàng gỡ lỗi (bạn có thể tắt ở môi trường production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Cài đặt múi giờ Việt Nam
date_default_timezone_set('Asia/Ho_Chi_Minh');

// =========================================================================
// SỬA LỖI 1: CHỐNG ĐỊNH NGHĨA LẠI HẰNG SỐ
// Chỉ định nghĩa các hằng số nếu chúng chưa tồn tại.
// =========================================================================
if (!defined('SERVERNAME')) {
    define('SERVERNAME', 'localhost');
}
if (!defined('USERNAME')) {
    define('USERNAME', 'eqwdrsog_test');
}
if (!defined('PASSWORD')) {
    define('PASSWORD', 'eqwdrsog_test');
}
if (!defined('DATABASE')) {
    define('DATABASE', 'eqwdrsog_test');
}
// Biến $path_admin không phải hằng số nên không cần kiểm tra.
$path_admin = 'vincenzo';

// =========================================================================
// SỬA LỖI 2: CHỐNG KHAI BÁO LẠI CLASS
// Chỉ định nghĩa class nếu nó chưa tồn tại.
// =========================================================================
if (!class_exists('Vincenzo')) {
    class Vincenzo
    {
        private $ketnoi;
        public function escape_string($string)
        {
            $this->connect(); // Đảm bảo đã có kết nối
            return mysqli_real_escape_string($this->ketnoi, $string);
        }

        function connect()
        {
            // Chỉ kết nối nếu chưa có kết nối
            if (!$this->ketnoi) {
                $this->ketnoi = mysqli_connect(SERVERNAME, USERNAME, PASSWORD, DATABASE) or die('Lỗi kết nối CSDL!');
                mysqli_query($this->ketnoi, "set names 'utf8'");
            }
        }

        function dis_connect()
        {
            if ($this->ketnoi) {
                mysqli_close($this->ketnoi);
                $this->ketnoi = null; // Gán lại là null để có thể kết nối lại nếu cần
            }
        }

        function site($data)
        {
            $this->connect();
            $row = $this->ketnoi->query("SELECT * FROM `setting`")->fetch_array();
            return $row[$data] ?? null;
        }

        function data_web($data)
        {
            $this->connect();
            $row = $this->ketnoi->query($data)->fetch_array();
            return $row;
        }

        function check($data)
        {
            $this->connect();
            $row = $this->ketnoi->query("SELECT * FROM `options` WHERE `key` = '$data' ")->fetch_array();
            return $row['value'] ?? null;
        }

        function check_ip($data)
        {
            $this->connect();
            $row = $this->ketnoi->query("SELECT * FROM `band_ip` WHERE `ip_band` = '$data'")->fetch_array();
            return $row['status'] ?? null;
        }

        function modal($data, $data2)
        {
            $this->connect();
            $row = $this->ketnoi->query("SELECT * FROM `thong_bao_modal` WHERE `loai_tb` = '$data' AND `url_config` = '" . strtoupper($_SERVER['SERVER_NAME']) . "'")->fetch_array();
            return $row[$data2] ?? null;
        }

        function getUsers($data)
        {
            if (!isset($_SESSION['username'])) return null;
            $this->connect();
            $username = mysqli_real_escape_string($this->ketnoi, $_SESSION['username']);
            $row = $this->ketnoi->query("SELECT * FROM `users` WHERE `username` = '{$username}'")->fetch_array();
            return $row[$data] ?? null;
        }

        function query($sql)
        {
            $this->connect();
            return $this->ketnoi->query($sql);
        }

        function cong($table, $data, $sotien, $where)
        {
            $this->connect();
            // Chuyển đổi $sotien thành số để đảm bảo an toàn
            $sotien = (float)$sotien;
            return $this->ketnoi->query("UPDATE `$table` SET `$data` = `$data` + $sotien WHERE $where");
        }

        function tru($table, $data, $sotien, $where)
        {
            $this->connect();
            $sotien = (float)$sotien;
            return $this->ketnoi->query("UPDATE `$table` SET `$data` = `$data` - $sotien WHERE $where");
        }

        function insert($table, $data)
        {
            $this->connect();
            $field_list = '';
            $value_list = '';
            foreach ($data as $key => $value) {
                $field_list .= ",`$key`";
                $value_list .= ",'" . mysqli_real_escape_string($this->ketnoi, $value) . "'";
            }
            $sql = 'INSERT INTO `' . $table . '` (' . trim($field_list, ',') . ') VALUES (' . trim($value_list, ',') . ')';
            return mysqli_query($this->ketnoi, $sql);
        }

        function update($table, $data, $where)
        {
            $this->connect();
            $sql_parts = [];
            foreach ($data as $key => $value) {
                // Xử lý trường hợp cập nhật giá trị số học như 'coin = coin + 500'
                if (is_string($value) && (strpos($value, $key) !== false)) {
                    $sql_parts[] = "`$key` = $value";
                } else {
                    $sql_parts[] = "`$key` = '" . mysqli_real_escape_string($this->ketnoi, $value) . "'";
                }
            }
            $sql = 'UPDATE `' . $table . '` SET ' . implode(', ', $sql_parts) . ' WHERE ' . $where;
            return mysqli_query($this->ketnoi, $sql);
        }

        // Giữ lại hàm update_value nếu bạn có dùng
        function update_value($table, $data, $where, $value1)
        {
            $this->connect();
            $sql = '';
            foreach ($data as $key => $value) {
                $sql .= "`$key` = '" . mysqli_real_escape_string($this->ketnoi, $value) . "',";
            }
            $sql = 'UPDATE `' . $table . '` SET ' . trim($sql, ',') . ' WHERE ' . $where . ' LIMIT ' . (int)$value1;
            return mysqli_query($this->ketnoi, $sql);
        }

        function remove($table, $where)
        {
            $this->connect();
            $sql = "DELETE FROM `$table` WHERE $where";
            return mysqli_query($this->ketnoi, $sql);
        }

        function get_list($sql)
        {
            $this->connect();
            $result = mysqli_query($this->ketnoi, $sql);
            if (!$result) {
                error_log("DB Query Failed: " . mysqli_error($this->ketnoi) . " | SQL: " . $sql);
                return []; // Luôn trả về một mảng
            }
            $return = [];
            while ($row = mysqli_fetch_assoc($result)) {
                $return[] = $row;
            }
            mysqli_free_result($result);
            return $return;
        }

        function get_row($sql, $params = [])
        {
            $this->connect();
            
            // Nếu không có tham số, chạy truy vấn như cũ để không làm hỏng các hàm khác
            if (empty($params)) {
                $result = mysqli_query($this->ketnoi, $sql);
                if (!$result) {
                    error_log("DB Query Failed: " . mysqli_error($this->ketnoi) . " | SQL: " . $sql);
                    return false;
                }
                $row = mysqli_fetch_assoc($result);
                mysqli_free_result($result);
                return $row ?: false;
            }

            // Nếu có tham số, sử dụng prepared statements
            $stmt = $this->ketnoi->prepare($sql);
            if ($stmt === false) {
                error_log('MySQL prepare error: ' . $this->ketnoi->error . ' | SQL: ' . $sql);
                return false;
            }

            // Giả sử tất cả tham số là chuỗi để đơn giản và an toàn
            $types = str_repeat('s', count($params));
            $stmt->bind_param($types, ...$params);

            $stmt->execute();
            $result = $stmt->get_result();
            $row = $result->fetch_assoc();
            $stmt->close();
            
            return $row ?: false;
        }
        function num_rows($sql)
        {
            $this->connect();
            $result = mysqli_query($this->ketnoi, $sql);
            if (!$result) {
                error_log("DB Query Failed: " . mysqli_error($this->ketnoi) . " | SQL: " . $sql);
                return 0; // Luôn trả về một số
            }
            $row_count = mysqli_num_rows($result);
            mysqli_free_result($result);
            return $row_count;
        }
    }
}

// =========================================================================
// PHẦN KHỞI TẠO ĐỐI TƯỢNG (Chỉ tạo nếu chưa tồn tại)
// =========================================================================
if (!isset($vincenzo) || !$vincenzo instanceof Vincenzo) {
    $vincenzo = new Vincenzo();
}

// Lấy thông tin user nếu đã đăng nhập
if (isset($_SESSION['username']) && !isset($getUser)) {
    // =========================================================================
    // SỬA LỖI DÒNG 224: SỬ DỤNG HÀM MỚI `escape_string()`
    // =========================================================================
    $escaped_username = $vincenzo->escape_string($_SESSION['username']);
    $getUser = $vincenzo->get_row("SELECT * FROM users WHERE username = '{$escaped_username}'");
}
