<?php 
require_once __DIR__ . "/head.php";

// Xóa tài khoản
$delete_id = $_GET['delete_id'] ?? 0;
if (!empty($delete_id)) {
    if (!$_vincenzo->get_row("SELECT * FROM `users` WHERE `id` = '$delete_id'")) {
        echo '<script>Swal.fire("Thông báo", "Thành viên không tồn tại xong hệ thống.", "error"); setTimeout(function(){ window.location.href = "./manager-user.php"; }, 1500);</script>';
    } else {
        $_vincenzo->remove("users", "id = " . $delete_id);
        echo '<script>window.location.href = "./manager-user.php";</script>';
    }
}

$per_page = 10;
$current_page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$search = $_GET['search'] ?? '';

// Build WHERE clause for search
$where_clause = '';
if (!empty($search)) {
    $int_search = (int)$search;
    $escaped_search = addslashes($search);
    $where_clause = "WHERE (`id` LIKE '%$int_search%' OR `username` LIKE '%$escaped_search%')";
}
$offset = ($current_page - 1) * $per_page;

// Get total count
$count_query = "SELECT COUNT(*) as total FROM `users` $where_clause";
$count_result = $_vincenzo->get_list($count_query);
$total_items = $count_result[0]['total'] ?? 0;
$total_pages = ceil($total_items / $per_page);

// Get paginated data
$main_query = "SELECT * FROM `users` $where_clause ORDER BY `id` ASC LIMIT $per_page OFFSET $offset";
$page_data = $_vincenzo->get_list($main_query);

// Adjust current_page
$current_page = min($current_page, $total_pages);

// Hàm tạo pagination dynamic with search support
function renderPagination($current, $total, $search = '')
{
    $query_string = !empty($search) ? '?search=' . urlencode($search) . '&page=' : '?page=';
    $html = '<nav><ul class="pagination justify-content-center">';
    if ($current > 1) {
        $html .= '<li class="page-item"><a class="page-link" href="' . $query_string . ($current - 1) . '">Previous</a></li>';
    }
    $start = max(1, $current - 2);
    $end = min($total, $current + 2);
    if ($start > 1) $html .= '<li class="page-item"><span class="page-link">...</span></li>';
    for ($i = $start; $i <= $end; $i++) {
        $active = ($i == $current) ? 'active' : '';
        $html .= '<li class="page-item ' . $active . '"><a class="page-link' . ($active ? ' disabled' : '') . '" href="' . $query_string . $i . '">' . $i . '</a></li>';
    }
    if ($end < $total) $html .= '<li class="page-item"><span class="page-link">...</span></li>';
    if ($current < $total) {
        $html .= '<li class="page-item"><a class="page-link" href="' . $query_string . ($current + 1) . '">Next</a></li>';
    }
    $html .= '</ul></nav>';
    return $html;
}
?>

<style>
.swal-wide-popup {
    width: 700px !important;
    max-width: 90% !important;
}
</style>

<div class="d-flex justify-content-between align-items-center mb-3">
    <a href="add-user.php" class="btn btn-add"><i class="fas fa-user-plus"></i> Tạo tài khoản</a>
    <h3 class="mb-0">Quản lý người chơi (<?= $total_items; ?>)</h3>
</div>

<!-- 📌 Form tìm kiếm -->
<form method="GET" class="mb-3">
    <div class="input-group">
        <input type="text" name="search" class="form-control" placeholder="Tìm theo tên hoặc ID người chơi..." value="">
        <button class="btn btn-primary">Tìm kiếm</button>
    </div>
</form>

<!-- 📌 Danh sách người chơi -->
<div class="table-responsive">
    <table class="table table-bordered">
        <thead class="table-dark">
            <tr>
                <th>UID</th>
                <th>Tài khoản</th>
                <th>Số điểm</th>
                <th>Tổng nạp</th>
                <th>Tổng rút</th>
                <th>Thông tin thêm</th>
                <th>Trạng thái/Khu vực</th>
                <th>Ngày tạo</th>
                <th>Tác vụ</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($page_data)): ?>
                <tr>
                    <td colspan="9" class="text-center">Không có dữ liệu</td>
                </tr>
            <?php else: ?>
                <?php foreach ($page_data as $user): ?>
                    <tr>
                        <td onclick="copyToClipboard('<?= $user['id']; ?>')" style="cursor:pointer;" title="Click để copy"><?= $user['id']; ?></td>
                        <td>
                            <a class="font-weight-bold text-primary" href="edit-user.php?id=<?= $user['id']; ?>">
                                <?= $user['username']; ?>
                                <i class="fas fa-mobile-alt text-dark ml-1" title="Thiết bị đang hoạt động"></i>
                                <span class="badge badge-info">0</span>
                            </a>
                        </td>
                        <td><?= format_money($user['coin']) ?></td>
                        <td><?= format_money($user['total_coin']) ?></td>
                        <td><?= format_money($user['rut_diem']) ?></td>
                        <td>
                            <div>Tổng hưởng KM: <span class="text-success"><?= format_money($user['total_km']) ?></span></div>
                            <div>Tổng Admin cộng điểm: <span class="text-info"><?= format_money($user['admin_add']) ?></span></div>
                            <div>Tổng bị thu hồi: <span class="text-danger"><?= format_money($user['admin_tru']) ?></span></div>
                        </td>
                        <td>
                            <?= status_members($user['status']); ?>
                            <div class="mt-1"><small><?= $user['city']; ?></small></div>
                        </td>
                        <td><?= date('Y/m/d H:i:s', strtotime($user['date'] ?? 'now')) ?></td>
                        <td class="text-center">
                            <button type="button"
                                class="btn btn-sm btn-dark btn-change-balance"
                                data-customer="<?= $user['id']; ?>"
                                data-username="<?= $user['username']; ?>"
                                data-balance="<?= $user['coin']; ?>"
                                title="Cộng/Trừ điểm tài khoản <?= $user['username']; ?>">
                                <i class="fas fa-plus-minus"></i>
                            </button>

                            <!-- Nút khoá/mở tài khoản -->
                            <?php if ($user['status'] == 1) { ?>
                                <button class="btn btn-sm btn-success btn-toggle-lock"
                                    data-user-id="<?= $user['id']; ?>"
                                    data-action="lock"
                                    title="Thành viên hoạt động - Nhấn để khóa lại">
                                    <i class="fas fa-lock-open"></i>
                                </button>
                            <?php } else { ?>
                                <button class="btn btn-sm btn-secondary btn-toggle-lock"
                                    data-user-id="<?= $user['id']; ?>"
                                    data-action="unlock"
                                    title="Thành viên bị khóa - Nhấn để mở khóa">
                                    <i class="fas fa-lock"></i>
                                </button>
                            <?php } ?>

                            <button class="btn btn-sm btn-secondary btn-change-password"
                                data-user-id="<?= $user['id']; ?>"
                                data-username="<?= $user['username']; ?>"
                                title="Đổi mật khẩu">
                                <i class="far fa-key"></i>
                            </button>

                            <a href="edit-user.php?id=<?= $user['id']; ?>" class="btn btn-sm btn-warning" title="Chỉnh sửa">
                                <i class="fas fa-edit"></i>
                            </a>

                            <button class="btn btn-sm btn-danger btn-delete-user" 
                                data-user-id="<?= $user['id']; ?>" 
                                title="Xóa">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- 📌 Phân trang -->
<?= renderPagination($current_page, $total_pages) ?>

<script>
function copyToClipboard(text) {
    if (navigator.clipboard && window.isSecureContext) {
        navigator.clipboard.writeText(text).then(() => {
            showCopied(text);
        }).catch(() => fallbackCopyText(text));
    } else {
        fallbackCopyText(text);
    }
}

function fallbackCopyText(text) {
    const input = document.createElement("textarea");
    input.value = text;
    input.setAttribute('readonly', '');
    input.style.position = 'absolute';
    input.style.left = '-9999px';
    document.body.appendChild(input);
    input.select();
    document.execCommand('copy');
    document.body.removeChild(input);
    showCopied(text);
}

function showCopied(text) {
    Swal.fire({
        toast: true,
        icon: 'success',
        title: 'Đã sao chép: ' + text,
        position: 'top-end',
        showConfirmButton: false,
        timer: 1200,
        timerProgressBar: true
    });
}

document.addEventListener("DOMContentLoaded", function() {
    // ============ CỘNG/TRỪ ĐIỂM ============
    document.querySelectorAll(".btn-change-balance").forEach(function(button) {
        button.addEventListener("click", function() {
            var userId = this.getAttribute("data-customer");
            var username = this.getAttribute("data-username");
            var balance = this.getAttribute("data-balance");

            Swal.fire({
                title: 'CỘNG/TRỪ ĐIỂM NGƯỜI CHƠI',
                html: '<div class="container-fluid"><div class="row"><div class="col-12 text-start">' +
                    '<div class="text-left mb-2"><strong>Người chơi:</strong> ' + username + '</div>' +
                    '<div class="text-left mb-2"><strong>Số điểm hiện tại:</strong> <span class="text-success">' + Number(balance).toLocaleString('vi-VN') + '</span></div>' +

                    '<div class="text-left mb-2"><strong>Tác vụ</strong></div>' +
                    '<select id="actionType" class="form-control mb-3">' +
                    '<option value="congTien">Cộng điểm</option>' +
                    '<option value="truTien">Trừ điểm</option>' +
                    '</select>' +

                    '<div class="text-left mb-2"><strong>Số điểm</strong></div>' +
                    '<input type="number" id="amount" class="form-control mb-3" placeholder="Số điểm không bắt buộc nếu chỉ muốn khách cộng tiền nổ hũ">' +

                    '<div class="text-left mb-2"><strong>Ghi chú nạp điểm</strong></div>' +
                    '<textarea id="note" class="form-control mb-3" rows="4" placeholder="Ghi chú nạp tiền không bắt buộc nếu chỉ muốn khách cộng tiền nổ hũ"></textarea>' +

                    '<div class="text-left mb-2"><strong>Số tiền Nổ Hũ (nếu có)</strong></div>' +
                    '<input type="text" id="jackpotAmount" class="form-control mb-3" placeholder="Số tiền Nổ Hũ nhập 59666 sẽ chỉ cộng 59.666 nhưng khách sẽ thấy 59.666.000">' +

                    '<div class="text-left mb-2"><strong>Nội dung Nổ Hũ</strong></div>' +
                    '<textarea id="jackpotNote" class="form-control mb-3" rows="4" placeholder="Nội dung Nổ Hũ sẽ tự động bạn khi nhập số tiền nổ hũ cũng có thể sửa tùy thích"></textarea>' +

                    '<div class="text-left text-dark">Tính năng dành cho Admin thực hiện cộng trừ điểm trực tiếp trên tài khoản người chơi. Mục đích sử dụng trong những trường hợp nạp nhầm hoặc phát hiện tài khoản người chơi gian lận.</div>' +
                    '</div></div></div>',
                confirmButtonText: 'Xác nhận',
                showCancelButton: true,
                cancelButtonText: 'Hủy',
                focusConfirm: false,
                customClass: {
                    popup: 'swal-wide-popup'
                },
                didOpen: function() {
                    const jackpotAmountInput = document.getElementById('jackpotAmount');
                    const jackpotNoteInput = document.getElementById('jackpotNote');

                    jackpotAmountInput.addEventListener('input', function() {
                        const val = this.value.replace(/,/g, '').trim();
                        const parsed = parseInt(val);
                        if (!isNaN(parsed) && parsed > 0) {
                            const realAmount = parsed * 1000;
                            const formatted = realAmount.toLocaleString('vi-VN') + ' VND';
                            const content = `➣&#127881;&#127881;&#127881;Xin Chúc Mừng Quý Khách mang "ID ${userId}" đã may mắn nhận được phần quà Tri Ân khách hàng ngẫu nhiên từ Hệ thống với giá trị là: ${formatted}. Vui lòng liên hệ CSKH để nhận phần quà.&#127873&#127873&#127873 !`;
                            jackpotNoteInput.value = content;
                        } else {
                            jackpotNoteInput.value = '';
                        }
                    });
                },
                preConfirm: function() {
                    const amountVal = parseFloat(document.getElementById('amount').value || 0);
                    const jackpotVal = parseFloat(document.getElementById('jackpotAmount').value.replace(/,/g, '') || 0);
                    const noteVal = document.getElementById('note').value.trim();
                    const jackpotNote = document.getElementById('jackpotNote').value.trim();

                    if ((isNaN(amountVal) || amountVal <= 0) && (isNaN(jackpotVal) || jackpotVal <= 0 || jackpotNote === '')) {
                        Swal.showValidationMessage('Vui lòng nhập số điểm hoặc thông tin Nổ Hũ hợp lệ.');
                        return false;
                    }

                    return fetch('process-change-balance.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            body: JSON.stringify({
                                user_id: userId,
                                action_type: document.getElementById('actionType').value,
                                amount: amountVal,
                                note: noteVal,
                                jackpot_amount: jackpotVal,
                                jackpot_note: jackpotNote
                            })
                        })
                        .then(function(res) {
                            return res.json();
                        })
                        .catch(function() {
                            Swal.showValidationMessage('Lỗi kết nối server');
                            return false;
                        });
                }
            }).then(function(result) {
                if (result.isConfirmed && result.value && result.value.success) {
                    Swal.fire('Thành công', result.value.message, 'success').then(function() {
                        location.reload();
                    });
                } else if (result.isConfirmed) {
                    Swal.fire('Thất bại', result.value.message || 'Không rõ lý do', 'error');
                }
            });
        });
    });

    // ============ ĐỔI MẬT KHẨU ============
    document.querySelectorAll(".btn-change-password").forEach(function(btn) {
        btn.addEventListener("click", function() {
            var userId = this.getAttribute("data-user-id");
            var username = this.getAttribute("data-username");

            Swal.fire({
                title: 'ĐỔI MẬT KHẨU',
                html: '<div class="text-left mb-2"><strong>Người dùng:</strong> ' + username + '</div>' +
                    '<input type="password" id="newPassword" class="form-control" placeholder="Nhập mật khẩu mới">',
                showCancelButton: true,
                confirmButtonText: 'Thay đổi mật khẩu',
                cancelButtonText: 'Hủy',
                preConfirm: function() {
                    var password = document.getElementById('newPassword').value.trim();
                    if (!password || password.length < 6) {
                        Swal.showValidationMessage('Mật khẩu phải có ít nhất 6 ký tự');
                        return false;
                    }

                    return fetch('process-change-password.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            body: JSON.stringify({
                                user_id: userId,
                                new_password: password
                            })
                        })
                        .then(function(res) {
                            return res.json();
                        })
                        .catch(function() {
                            Swal.showValidationMessage('Không thể kết nối đến server');
                            return false;
                        });
                }
            }).then(function(result) {
                if (result.isConfirmed && result.value && result.value.success) {
                    Swal.fire('Thành công', result.value.message, 'success');
                } else if (result.isConfirmed) {
                    Swal.fire('Lỗi', result.value.message || 'Không rõ lỗi', 'error');
                }
            });
        });
    });

    // ============ KHÓA/MỞ KHÓA TÀI KHOẢN ============
    document.querySelectorAll(".btn-toggle-lock").forEach(button => {
        button.addEventListener("click", function() {
            const userId = this.getAttribute("data-user-id");
            const action = this.getAttribute("data-action");

            Swal.fire({
                title: action === "lock" ? "Xác nhận khóa tài khoản?" : "Xác nhận mở khóa tài khoản?",
                icon: "question",
                showCancelButton: true,
                confirmButtonText: "Xác nhận",
                cancelButtonText: "Hủy",
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch('process-toggle-lock.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            body: JSON.stringify({
                                user_id: userId,
                                action: action
                            })
                        })
                        .then(res => res.json())
                        .then(data => {
                            if (data.success) {
                                Swal.fire("Thành công", data.message, "success").then(() => {
                                    location.reload();
                                });
                            } else {
                                Swal.fire("Lỗi", data.message || "Không rõ lỗi", "error");
                            }
                        })
                        .catch(() => Swal.fire("Lỗi", "Không thể kết nối server", "error"));
                }
            });
        });
    });

    // ============ XÓA TÀI KHOẢN ============
    document.querySelectorAll(".btn-delete-user").forEach(button => {
        button.addEventListener("click", function() {
            const userId = this.getAttribute("data-user-id");

            Swal.fire({
                title: 'Xác nhận xóa',
                text: 'Bạn có chắc chắn muốn xóa người chơi này? Hành động này không thể hoàn tác!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Xóa',
                cancelButtonText: 'Hủy',
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = '?delete_id=' + userId;
                }
            });
        });
    });
});
</script>

<?php require_once __DIR__ . "/foot.php"; ?>