<?php
// manager-chat.php - PHIÊN BẢN TÍCH HỢP HOÀN CHỈNH

// --- PHẦN 1: KHỞI TẠO VÀ CẤU HÌNH ---
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING); // Ẩn các cảnh báo không cần thiết từ giao diện cũ
session_start();
if (!isset($_SESSION['admin_loggedin'])) {
    $_SESSION['admin_username'] = 'Admin'; // Tên admin mặc định nếu chưa đăng nhập
}

require_once __DIR__ . '/../vendor/autoload.php';
use Pusher\Pusher;

$pusher = null;
try {
    $pusher = new Pusher('2d0f22dbc701cefbfde0', 'ecd8c8070503a09fda8c', '1951282', ['cluster' => 'mt1', 'useTLS' => true]);
} catch (Exception $e) {
    error_log("Pusher init error: " . $e->getMessage());
}

// --- Class Database ---
class Database {
    public $connection;
    
    public function __construct() {
        $host = 'localhost';
        $user = 'eqwdrsog_test';
        $pass = 'eqwdrsog_test';
        $dbname = 'eqwdrsog_test';

        mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
        try {
            $this->connection = new mysqli($host, $user, $pass, $dbname);
            $this->connection->set_charset("utf8mb4");
        } catch (mysqli_sql_exception $e) {
            die("Lỗi kết nối CSDL: " . $e->getMessage());
        }
    }

    public function query($sql, $params = []) {
        try {
            $stmt = $this->connection->prepare($sql);
            if ($stmt === false) throw new Exception("Prepare failed: " . $this->connection->error);
            if (!empty($params)) {
                $types = str_repeat('s', count($params)); // Dùng 's' cho tất cả để đơn giản
                $stmt->bind_param($types, ...$params);
            }
            if (!$stmt->execute()) throw new Exception("Execute failed: " . $stmt->error);
            return $stmt;
        } catch (Exception $e) {
            error_log("DB Query Error: " . $e->getMessage());
            return false;
        }
    }

    public function get_list($sql, $params = []) {
        $stmt = $this->query($sql, $params);
        if ($stmt === false) return [];
        $result = $stmt->get_result();
        $stmt->close();
        return $result->fetch_all(MYSQLI_ASSOC);
    }

    public function get_row($sql, $params = []) {
        $stmt = $this->query($sql, $params);
        if ($stmt === false) return null;
        $result = $stmt->get_result();
        $stmt->close();
        return $result->fetch_assoc();
    }
    
    public function __destruct() {
        if ($this->connection) $this->connection->close();
    }
}

$db = new Database();

// --- PHẦN 2: XỬ LÝ API (ACTIONS) ---
if (isset($_GET['action'])) {
    $action = $_GET['action'];
    header('Content-Type: application/json; charset=utf-8');

    // Load tin nhắn
    if ($action == 'load_messages') {
        ob_start(); // Bắt đầu bộ đệm đầu ra để chứa HTML
        $user_id = (int)($_GET['user_id'] ?? 0);
        if ($user_id > 0) {
            $messages = $db->get_list(
                "SELECT * FROM chat_messages 
                WHERE (sender_id = 1 AND receiver_id = ?) OR (sender_id = ? AND receiver_id = 1)
                ORDER BY id ASC",
                [$user_id, $user_id]
            );
            
            $current_admin_username = $_SESSION['admin_username'] ?? 'Admin';
            $user_info = $db->get_row("SELECT username FROM users WHERE id = ?", [$user_id]);
            $current_chat_username = $user_info['username'] ?? 'User';

            if (empty($messages)) {
                echo '<div class="text-center text-muted">Bắt đầu cuộc trò chuyện!</div>';
            } else {
                foreach ($messages as $msg) {
                    $isAdmin = $msg['sender_type'] === 'admin';
                    $alignClass = $isAdmin ? 'align-left' : 'align-right';
                    $bgClass = $isAdmin ? 'bg-admin' : 'bg-user';
                    $messageClass = $isAdmin ? 'admin-message' : 'user-message';
                    $time = date('H:i', strtotime($msg['created_at']));
                    $senderName = $isAdmin ? $current_admin_username : $current_chat_username;
                    
                    $readStatus = '';
                    if ($isAdmin) {
                        $readStatus = $msg['is_read'] ? '<span class="text-success small"> (Khách đã xem)</span>' : '<span class="text-warning small"> (Khách chưa xem)</span>';
                    }
                    
                    echo '<div class="message-wrapper ' . $alignClass . '">';
                    echo '<div class="message-content-container">';
                    echo '<span class="message-sender">' . htmlspecialchars($senderName) . $readStatus . '</span>';
                    echo '<div class="message-box ' . $messageClass . ' ' . $bgClass . '" data-message-id="' . $msg['id'] . '">';
                    echo '<div class="message-content">';
                    
                    if (!empty($msg['message'])) {
                        echo '<p class="mb-1 text-message">' . nl2br(htmlspecialchars($msg['message'])) . '</p>';
                    }
                    
                    if (!empty($msg['images'])) {
                        $images_arr = json_decode($msg['images'], true);
                        if (is_array($images_arr)) {
                            echo '<div class="d-flex flex-wrap align-items-center mt-2" style="gap: 8px;">';
                            foreach($images_arr as $img) {
                                echo '<div class="image-wrapper" style="width: 100%; height: auto;"><a href="' . htmlspecialchars($img) . '" target="_blank"><img src="' . htmlspecialchars($img) . '" alt="Hình ảnh" style="width: 300px; max-width: 200px; height: auto; object-fit: cover; border-radius: 6px; border: 1px solid #ddd;"></a></div>';
                            }
                            echo '</div>';
                        }
                    }
                    
                    echo '</div>';
                    echo '<div class="message-footer d-flex justify-content-between align-items-center mt-2">';
                    echo '<span class="message-time small" style="font-size: 12px;">' . $time . '</span>';
                    echo '<div class="message-actions">';
                    echo '<i class="fas fa-edit text-white edit-message mx-2" data-message-id="' . $msg['id'] . '" style="cursor:pointer;"></i>';
                    echo '<i class="fas fa-trash text-danger delete-message" data-message-id="' . $msg['id'] . '" style="cursor:pointer;"></i>';
                    echo '</div></div></div></div></div>';
                }
            }
        }
        $html_content = ob_get_clean();
        // Trả về HTML dưới dạng text, không phải JSON
        header('Content-Type: text/html; charset=utf-8');
        echo $html_content;
        exit;
    }
    
    // Gửi tin nhắn
    if ($action == 'send_message' && $_SERVER['REQUEST_METHOD'] === 'POST') {
        $user_id = (int)($_POST['user_id'] ?? 0);
        $message = trim($_POST['message'] ?? '');
        $response = ['success' => false, 'error' => 'Dữ liệu không hợp lệ.'];
        
        if ($user_id > 0 && (!empty($message) || !empty($_FILES['images']['name'][0]))) {
            $images_to_save = null;
            $images_to_push = [];
            if (!empty($_FILES['images']['name'][0])) {
                $upload_dir = __DIR__ . '/../uploads/chat/';
                if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);
                foreach ($_FILES['images']['name'] as $key => $name) {
                    if ($_FILES['images']['error'][$key] === 0) {
                        $newName = 'chat_' . time() . '_' . uniqid() . '.' . pathinfo($name, PATHINFO_EXTENSION);
                        if (move_uploaded_file($_FILES['images']['tmp_name'][$key], $upload_dir . $newName)) {
                            $images_to_push[] = '/uploads/chat/' . $newName;
                        }
                    }
                }
                if(!empty($images_to_push)) $images_to_save = json_encode($images_to_push);
            }
            
            $stmt = $db->query(
                "INSERT INTO chat_messages (sender_id, sender_type, receiver_id, receiver_type, message, images) VALUES (1, 'admin', ?, 'user', ?, ?)",
                [$user_id, $message, $images_to_save]
            );
            
            if ($stmt) {
                $new_id = $db->connection->insert_id;
                if ($pusher) {
                    $pusher->trigger("chat-channel-{$user_id}", 'new-message', [
                        'sender_type' => 'admin',
                        'message' => htmlspecialchars($message),
                        'images' => $images_to_push,
                        'id' => $new_id
                    ]);
                }
                $response = ['success' => true];
            } else {
                $response['error'] = 'Lỗi insert CSDL';
            }
        }
        echo json_encode($response);
        exit;
    }
    
    // Xóa tin nhắn cụ thể
    if ($action == 'delete_message' && $_SERVER['REQUEST_METHOD'] === 'POST') {
        $message_id = (int)($_POST['message_id'] ?? 0);
        if ($message_id > 0) {
            $stmt = $db->query("DELETE FROM chat_messages WHERE id = ?", [$message_id]);
            if ($stmt && $stmt->affected_rows > 0) {
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'error' => 'Không tìm thấy tin nhắn hoặc lỗi CSDL.']);
            }
        } else {
            echo json_encode(['success' => false, 'error' => 'ID tin nhắn không hợp lệ.']);
        }
        exit;
    }

    // Lấy nội dung tin nhắn để sửa
    if ($action == 'get_message') {
        $message_id = (int)($_GET['message_id'] ?? 0);
        if ($message_id > 0) {
            $message_data = $db->get_row("SELECT message, images FROM chat_messages WHERE id = ?", [$message_id]);
            if ($message_data) {
                echo json_encode(['success' => true, 'message' => $message_data['message'], 'images' => json_decode($message_data['images'] ?? '[]')]);
            } else {
                 echo json_encode(['success' => false, 'error' => 'Không tìm thấy tin nhắn.']);
            }
        }
        exit;
    }

    // Lưu tin nhắn đã sửa
    if ($action == 'edit_message' && $_SERVER['REQUEST_METHOD'] === 'POST') {
        $message_id = (int)($_POST['message_id'] ?? 0);
        $new_message = trim($_POST['new_message'] ?? '');
        if ($message_id > 0) {
            $stmt = $db->query("UPDATE chat_messages SET message = ? WHERE id = ?", [$new_message, $message_id]);
            if ($stmt && $stmt->affected_rows > 0) {
                 echo json_encode(['success' => true]);
            } else {
                 echo json_encode(['success' => false, 'error' => 'Cập nhật thất bại hoặc không có gì thay đổi.']);
            }
        }
        exit;
    }

    // Xóa tất cả tin nhắn
    if ($action == 'delete_all_messages' && $_SERVER['REQUEST_METHOD'] === 'POST') {
        $user_id = (int)($_POST['user_id'] ?? 0);
        if ($user_id > 0) {
            $stmt = $db->query("DELETE FROM chat_messages WHERE (sender_id = 1 AND receiver_id = ?) OR (sender_id = ? AND receiver_id = 1)", [$user_id, $user_id]);
            if ($stmt) {
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'error' => 'Lỗi thực thi CSDL.']);
            }
        } else {
            echo json_encode(['success' => false, 'error' => 'ID người dùng không hợp lệ.']);
        }
        exit;
    }
}

// --- PHẦN 3: LOAD DỮ LIỆU TRANG CHÍNH ---
$current_user_id = (int)($_GET['user_id'] ?? 0);
$current_page = max(1, (int)($_GET['page'] ?? 1));
$per_page = 20;
$offset = ($current_page - 1) * $per_page;

// Lấy tổng số người
$total_items = $db->get_row("SELECT COUNT(DISTINCT sender_id) as total FROM chat_messages WHERE sender_type = 'user'")['total'] ?? 0;
$total_pages = ceil($total_items / $per_page);

// Lấy danh sách user
$main_query = "SELECT u.id as user_id, u.username, u.city, cm.message, cm.created_at,
    (SELECT COUNT(*) FROM chat_messages sub WHERE sub.sender_id = u.id AND sub.sender_type = 'user' AND sub.is_read = 0) as unread_count
    FROM users u
    JOIN chat_messages cm ON u.id = cm.sender_id
    JOIN (SELECT sender_id, MAX(id) as max_id FROM chat_messages WHERE sender_type = 'user' GROUP BY sender_id) latest 
        ON cm.sender_id = latest.sender_id AND cm.id = latest.max_id
    WHERE cm.sender_type = 'user'
    ORDER BY latest.max_id DESC
    LIMIT ? OFFSET ?";
$page_data = $db->get_list($main_query, [$per_page, $offset]);

$current_username = 'Không xác định';
if ($current_user_id > 0) {
    // Đánh dấu đã đọc
    $db->query("UPDATE chat_messages SET is_read = 1 WHERE sender_id = ? AND sender_type = 'user' AND is_read = 0", [$current_user_id]);
    $user_info = $db->get_row("SELECT username FROM users WHERE id = ?", [$current_user_id]);
    $current_username = $user_info['username'] ?? 'Không xác định';
}

?>
<!DOCTYPE html>
<html lang="vi">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=0">
<meta name="robots" content="noindex, nofollow">
<link rel="icon" href="/favicon/favicon.png" type="image/x-icon">
<title>Admin Panel</title>
<link rel="stylesheet" href="css/stylev4.css">
<link rel="stylesheet" href="css/editor.css">
<link rel="stylesheet" href="css/select2/dist/css/select2.min.css">
<link rel="stylesheet" href="css/lightbox2/css/lightbox.min.css">
<link rel="stylesheet" href="css/sweetalert2/sweetalert2.min.css">
<link rel="stylesheet" href="css/fontawesome/css/all.min.css">
<link rel="stylesheet" href="css/bootstrap/bootstrap.min.css">
<style>
.select2-container--default .select2-selection--single .select2-selection__rendered {line-height: 38px;}
span.select2-selection.select2-selection--single {height: 40px;}
#postsListContainer {max-height: 100vh; overflow-y: auto; padding-right: 8px; scroll-behavior: smooth;}
#postsListContainer::-webkit-scrollbar {width: 6px;}
#postsListContainer::-webkit-scrollbar-track {background: #f1f1f1;}
#postsListContainer::-webkit-scrollbar-thumb {background: #888; border-radius: 3px;}
#postsListContainer::-webkit-scrollbar-thumb:hover {background: #555;}
.text-address {color: #6e9fcb !important;}
.badge-unread {background-color: #dc3545; color: white; padding: 2px 8px; border-radius: 10px; font-size: 11px;}
.message-wrapper {display: flex; margin-bottom: 15px; width: 100%;}
.message-wrapper.align-left {justify-content: flex-start;}
.message-wrapper.align-right {justify-content: flex-end;}
.message-content-container {max-width: 70%; display: flex; flex-direction: column;}
.message-sender {font-size: 12px; margin-bottom: 5px; font-weight: 600; color: #555;}
.message-box {padding: 12px; border-radius: 8px; position: relative; word-wrap: break-word;}
.bg-admin {background-color: #007bff; color: white;}
.bg-user {background-color: #f1f3f4; color: #333;}
.message-footer {display: flex; justify-content: space-between; align-items: center; margin-top: 8px;}
.message-time {font-size: 11px; color: rgba(255,255,255,0.8);}
.bg-user .message-time {color: #666;}
.message-actions {display: none; gap: 8px;}
.message-box:hover .message-actions {display: flex;}
.message-actions i {cursor: pointer; transition: transform 0.2s;}
.message-actions i:hover {transform: scale(1.2);}
</style>
</head>
<body>

<div class="container-fluid">
<div class="row">
    <button class="togglePostsListButton" id="togglePostsListButton" onclick="togglePostsList()">
        <i class="fas fa-bars"></i>
    </button>
    <button class="closePostsListButton bg-danger" id="closePostsListButton" onclick="togglePostsList()">
        <i class="fas fa-times"></i>
    </button>

<!-- Danh sách người dùng đã chat -->
<div class="col-md-2 bg-dark font-weight-bold" id="postsListContainer">
  <ul class="list-group">
    <a href="manager-chat.php"><h3 class="bg-success text-white text-center">DANH SÁCH CHAT</h3></a>
    <?php foreach ($page_data as $item): ?>
      <li class="list-group-item d-flex justify-content-between align-items-center <?= $current_user_id == $item['user_id'] ? 'active' : '' ?>">
        <div class="flex-grow-1">
          <a href="manager-chat.php?page=<?= $current_page ?>&user_id=<?= $item['user_id'] ?>" title="ID: <?= $item['user_id'] ?>" class="d-block">
            <i class="fas fa-user"></i> <?= htmlspecialchars($item['username']) ?> (ID: <?= $item['user_id'] ?>)
            <?php if ((int)$item['unread_count'] > 0): ?>
                <span class="badge-unread"><?= $item['unread_count'] ?></span>
            <?php endif; ?>
          </a>
          <?php if (!empty($item['city'])): ?>
              <div class="small text-address"><?= htmlspecialchars($item['city']) ?></div>
          <?php endif; ?>
        </div>
        <button class="btn btn-sm btn-link text-danger px-2"
          onclick="confirmDeleteAllMessages(event, <?= $item['user_id'] ?>, '<?= htmlspecialchars(addslashes($item['username'])) ?>')"
          title="Xóa tất cả tin nhắn của <?= htmlspecialchars($item['username']) ?>">
          <i class="fas fa-trash"></i>
        </button>
      </li>
    <?php endforeach; ?>
  </ul>

  <!-- PHÂN TRANG -->
  <?php if ($total_pages > 1): ?>
  <nav class="mt-2">
      <ul class="pagination pagination-sm justify-content-center mb-0">
          <li class="page-item <?= $current_page <= 1 ? 'disabled' : '' ?>"><a class="page-link" href="?page=1<?= $current_user_id ? '&user_id='.$current_user_id : '' ?>">&laquo;</a></li>
          <li class="page-item <?= $current_page <= 1 ? 'disabled' : '' ?>"><a class="page-link" href="?page=<?= $current_page - 1 ?><?= $current_user_id ? '&user_id='.$current_user_id : '' ?>">&lsaquo;</a></li>
          <?php for ($i = max(1, $current_page - 2); $i <= min($total_pages, $current_page + 2); $i++): ?>
          <li class="page-item <?= $i == $current_page ? 'active' : '' ?>"><a class="page-link" href="?page=<?= $i ?><?= $current_user_id ? '&user_id='.$current_user_id : '' ?>"><?= $i ?></a></li>
          <?php endfor; ?>
          <li class="page-item <?= $current_page >= $total_pages ? 'disabled' : '' ?>"><a class="page-link" href="?page=<?= $current_page + 1 ?><?= $current_user_id ? '&user_id='.$current_user_id : '' ?>">&rsaquo;</a></li>
          <li class="page-item <?= $current_page >= $total_pages ? 'disabled' : '' ?>"><a class="page-link" href="?page=<?= $total_pages ?><?= $current_user_id ? '&user_id='.$current_user_id : '' ?>">&raquo;</a></li>
      </ul>
      <div class="text-center text-muted small mt-1">Trang <?= $current_page ?> / <?= $total_pages ?></div>
  </nav>
  <?php endif; ?>
</div>

    <!-- Nội dung chat -->
    <div class="col-md-10">
      <nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm mb-2">
          <div class="container-fluid">
              <a href="index.php" class="text-uppercase text-danger font-weight-bold"><i class="fas fa-user-cog"></i> <?= htmlspecialchars($_SESSION['admin_username']) ?></a>
              <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav"><i class="fas fa-bars"></i></button>
              <div class="collapse navbar-collapse font-weight-bold" id="navbarNav">
                  <ul class="navbar-nav ml-auto align-items-center">
                      <li class="nav-item dropdown">
                          <a class="nav-link dropdown-toggle" href="#" id="liveChatDropdown" role="button" data-toggle="dropdown"><i class="fas fa-comments"></i> Cài đặt Live Chat</a>
                          <div class="dropdown-menu" aria-labelledby="liveChatDropdown">
                              <a class="dropdown-item" href="manager-chat-replay.php"><i class="fas fa-robot mr-2"></i> Phản Hồi Tự Động</a>
                              <a class="dropdown-item" href="manager-chat-content.php"><i class="fas fa-comment-dots mr-2"></i> Tin Nhắn Mẫu Live Chat</a>
                              <a class="dropdown-item" href="manager-info-chat.php"><i class="fas fa-headset mr-2"></i> Thông Tin Live Chat</a>
                              <a class="dropdown-item" href="manager-livechat-custom.php"><i class="fas fa-cogs mr-2"></i> Cấu Hình LiveChat.Com</a>
                          </div>
                      </li>
                      <li class="nav-item"><a class="nav-link" target="_blank" href="/"><i class="fas fa-home"></i> Đi tới trang chủ</a></li>
                      <li class="nav-item"><a class="nav-link text-danger" href="manager-chat.php"><i class="fas fa-comments"></i> Live Chat</a></li>
                      <li class="nav-item"><a class="nav-link text-danger" href="logout.php"><i class="fas fa-sign-out-alt"></i> Đăng xuất</a></li>
                  </ul>
              </div>
          </div>
      </nav>
        <div class="d-flex flex-row vh-100">
            <div class="flex-grow-1 p-3 d-flex flex-column">
              <h5 class="d-flex justify-content-between align-items-center">
                Chat với: <b><?= htmlspecialchars($current_username) ?></b>
                <?php if ($current_user_id > 0): ?>
                <button class="btn btn-sm btn-danger" onclick="confirmDeleteAllMessages(event, <?= $current_user_id ?>, '<?= htmlspecialchars(addslashes($current_username)) ?>')">
                  <i class="fas fa-trash"></i> Xóa tất cả tin nhắn
                </button>
                <?php endif; ?>
              </h5>
              <div id="chatMessages" class="chat-container border p-3 mb-3 flex-grow-1" style="overflow-y: auto;">
                  <?php if ($current_user_id > 0): ?>
                      <div class="text-center text-muted">Đang tải tin nhắn...</div>
                  <?php else: ?>
                      <div class="text-center text-muted">Chọn một cuộc trò chuyện để bắt đầu</div>
                  <?php endif; ?>
              </div>

              <?php if ($current_user_id > 0): ?>
                <!-- Form gửi tin nhắn -->
                <form id="chatForm" onsubmit="sendMessage(event)">
                    <div id="imagePreviewContainer" class="d-flex flex-wrap mt-3"></div>
                    <div class="chat-input-container d-flex align-items-center border rounded p-2 shadow-sm" style="background-color: #f9f9f9;">
                      <textarea class="form-control border-0 shadow-none me-2" placeholder="Viết tin nhắn..." id="chatInput" rows="4" style="outline: none; font-size: 1rem; resize: none;"></textarea>
                      <label for="fileInput" class="btn btn-link text-secondary me-2" title="Tải lên hình ảnh"><i class="fas fa-image"></i></label>
                      <input type="file" id="fileInput" class="d-none" accept="image/*" name="images[]" multiple>
                      <button type="submit" class="btn btn-link text-primary" id="sendButton" title="Gửi tin nhắn"><i class="fas fa-paper-plane"></i></button>
                    </div>
                </form>
              <?php endif; ?>
            </div>
        </div>
    </div>
</div>
</div>

<script src="css/jquery-3.6.0.min.js"></script>
<script src="css/bootstrap/bootstrap.bundle.min.js"></script> <!-- Dùng bundle để có Popper.js -->
<script src="css/sweetalert2/sweetalert2.min.js"></script>
<script src="https://js.pusher.com/8.2/pusher.min.js"></script>

<script>
const currentUserId = <?= $current_user_id ?>;
const chatMessagesContainer = document.getElementById("chatMessages");
const chatInput = document.getElementById("chatInput");
const sendButton = document.getElementById("sendButton");
const fileInput = document.getElementById("fileInput");
const imagePreviewContainer = document.getElementById("imagePreviewContainer");

//--- LOGIC CUỘN KHUNG CHAT ---
function isNearBottom() {
    if (!chatMessagesContainer) return true;
    return chatMessagesContainer.scrollHeight - chatMessagesContainer.scrollTop <= chatMessagesContainer.clientHeight + 100;
}
function scrollToBottom(force = false) {
    if (chatMessagesContainer && (force || isNearBottom())) {
        chatMessagesContainer.scrollTop = chatMessagesContainer.scrollHeight;
    }
}

//--- LOGIC TẢI VÀ GỬI TIN NHẮN ---
function loadChatMessages() {
    if (currentUserId === 0) return;
    fetch(`manager-chat.php?action=load_messages&user_id=${currentUserId}`)
        .then(response => response.text())
        .then(html => {
            chatMessagesContainer.innerHTML = html;
            scrollToBottom();
        })
        .catch(error => console.error("Lỗi khi tải tin nhắn:", error));
}

function sendMessage(event) {
    event.preventDefault();
    const message = chatInput.value.trim();
    const files = fileInput.files;
    if (!currentUserId || (message === '' && files.length === 0)) return;

    const formData = new FormData();
    formData.append('user_id', currentUserId);
    formData.append('message', message);
    for (let i = 0; i < files.length; i++) {
        formData.append('images[]', files[i]);
    }

    sendButton.disabled = true;
    fetch('manager-chat.php?action=send_message', { method: 'POST', body: formData })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            loadChatMessages(); // Tải lại toàn bộ để hiển thị tin nhắn mới
            chatInput.value = '';
            fileInput.value = '';
            imagePreviewContainer.innerHTML = '';
        } else {
            Swal.fire('Lỗi!', data.error || 'Không thể gửi tin nhắn.', 'error');
        }
    })
    .catch(err => Swal.fire('Lỗi!', 'Đã xảy ra lỗi mạng.', 'error'))
    .finally(() => { sendButton.disabled = false; });
}

//--- LOGIC SỬA / XÓA TIN NHẮN ---
document.addEventListener("click", function (event) {
    // Xóa tin nhắn đơn
    if (event.target.classList.contains("delete-message")) {
        const messageId = event.target.getAttribute("data-message-id");
        if (!messageId) return;
        Swal.fire({
            title: "Bạn có chắc chắn?", text: "Tin nhắn này sẽ bị xóa vĩnh viễn!", icon: "warning",
            showCancelButton: true, confirmButtonColor: "#d33", cancelButtonColor: "#3085d6",
            confirmButtonText: "Đồng ý xóa", cancelButtonText: "Hủy"
        }).then((result) => {
            if (result.isConfirmed) {
                const formData = new FormData();
                formData.append('message_id', messageId);
                fetch("manager-chat.php?action=delete_message", {method: 'POST', body: new URLSearchParams(formData)})
                .then(res => res.json()).then(data => {
                    if (data.success) {
                        event.target.closest(".message-wrapper").remove();
                    } else { Swal.fire("Lỗi!", data.error, "error"); }
                }).catch(err => Swal.fire("Lỗi!", "Có lỗi xảy ra.", "error"));
            }
        });
    }
    // Sửa tin nhắn
    if (event.target.classList.contains("edit-message")) {
        const messageId = event.target.getAttribute("data-message-id");
        if (!messageId) return;
        fetch(`manager-chat.php?action=get_message&message_id=${messageId}`)
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                let imageHtml = '';
                if(data.images && data.images.length > 0) {
                    imageHtml = '<div class="mt-3 d-flex flex-wrap gap-2">';
                    data.images.forEach(img => {
                        imageHtml += `<div><img src="${img}" style="width: 80px; height: 80px; object-fit: cover; border-radius: 5px;"></div>`;
                    });
                    imageHtml += '</div>';
                }
                Swal.fire({
                    title: "Chỉnh sửa tin nhắn",
                    html: `<textarea id="editMessageContent" class="form-control" style="height: 150px;">${data.message}</textarea>${imageHtml}`,
                    showCancelButton: true, confirmButtonText: "Lưu thay đổi",
                    preConfirm: () => document.getElementById("editMessageContent").value.trim()
                }).then((result) => {
                    if (result.isConfirmed) {
                        const formData = new FormData();
                        formData.append('message_id', messageId);
                        formData.append('new_message', result.value);
                        fetch("manager-chat.php?action=edit_message", {method: "POST", body: new URLSearchParams(formData)})
                        .then(res => res.json()).then(data => {
                            if (data.success) {
                                loadChatMessages();
                            } else { Swal.fire("Lỗi!", data.error, "error"); }
                        }).catch(err => Swal.fire("Lỗi!", "Không thể cập nhật.", "error"));
                    }
                });
            } else { Swal.fire("Lỗi!", data.error, "error"); }
        });
    }
});

function confirmDeleteAllMessages(event, userId, username) {
    event.stopPropagation();
    Swal.fire({
        title: `Xóa tất cả tin nhắn với ${username}?`, text: "Hành động này không thể hoàn tác!", icon: "warning",
        showCancelButton: true, confirmButtonColor: "#d33", cancelButtonColor: "#3085d6",
        confirmButtonText: "Đồng ý xóa", cancelButtonText: "Hủy"
    }).then((result) => {
        if (result.isConfirmed) {
            const formData = new FormData();
            formData.append('user_id', userId);
            fetch("manager-chat.php?action=delete_all_messages", {method: "POST", body: new URLSearchParams(formData)})
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    Swal.fire("Đã xóa!", "Tất cả tin nhắn đã được xóa.", "success").then(() => {
                        if (currentUserId == userId) {
                           chatMessagesContainer.innerHTML = '<div class="text-center text-muted">Cuộc trò chuyện đã được xóa.</div>';
                           // Tải lại để xóa khỏi danh sách bên trái
                           location.href = 'manager-chat.php';
                        } else {
                           location.reload();
                        }
                    });
                } else { Swal.fire("Lỗi!", data.error, "error");}
            }).catch(err => Swal.fire("Lỗi!", "Có lỗi xảy ra.", "error"));
        }
    });
}

function togglePostsList() { document.getElementById('postsListContainer').classList.toggle('d-none'); }

//--- KHỞI TẠO VÀ LẮNG NGHE SỰ KIỆN ---
document.addEventListener("DOMContentLoaded", function () {
    if (currentUserId > 0) {
        loadChatMessages();

        // Lắng nghe sự kiện từ Pusher
        const pusher = new Pusher('2d0f22dbc701cefbfde0', { cluster: 'mt1' });
        const userChannel = pusher.subscribe(`chat-channel-${currentUserId}`);
        userChannel.bind('new-message', function(data) {
            if (data.sender_type === 'user') {
                loadChatMessages();
            }
        });
    }

    // Lắng nghe kênh thông báo chung cho admin
    const adminChannel = pusher.subscribe('admin-notifications');
    adminChannel.bind('new-user-message', function(data) {
        // Reload trang để cập nhật danh sách và số tin chưa đọc
        location.reload();
    });

    // Gửi tin nhắn bằng Enter
    if (chatInput) {
      chatInput.addEventListener("keypress", (e) => {
        if (e.key === "Enter" && !e.shiftKey) { e.preventDefault(); sendMessage(e); }
      });
    }

    // Xem trước ảnh
    if (fileInput) {
      fileInput.addEventListener("change", (event) => {
          imagePreviewContainer.innerHTML = "";
          Array.from(event.target.files).forEach(file => {
              const reader = new FileReader();
              reader.onload = (e) => {
                  const img = document.createElement("img");
                  img.src = e.target.result;
                  img.style.maxHeight = "80px";
                  img.style.margin = "5px";
                  img.classList.add("border", "rounded");
                  imagePreviewContainer.appendChild(img);
              };
              reader.readAsDataURL(file);
          });
      });
    }
});
</script>

</body>
</html>