<?php
// 1. GỌI FILE HEAD.PHP (Chứa sidebar, header, và kết nối CSDL)
require_once 'head.php';

// 2. LOGIC RIÊNG CỦA TRANG DASHBOARD
// Lấy dữ liệu cho các thẻ thống kê
$tongNap = $_vincenzo->get_row("SELECT SUM(`total_coin`) FROM `users` WHERE `total_coin` >= 0 ")['SUM(`total_coin`)'];
$tongRut = $_vincenzo->get_row("SELECT SUM(`rut_diem`) FROM `users` WHERE `rut_diem` >= 0 ")['SUM(`rut_diem`)'];
$tongDiemHeThong = $_vincenzo->get_row("SELECT SUM(`coin`) FROM `users` WHERE `coin` >= 0 ")['SUM(`coin`)'];
$tongAdminThuHoi = $_vincenzo->get_row("SELECT SUM(`admin_tru`) FROM `users` WHERE `admin_tru` >= 0 ")['SUM(`admin_tru`)'];
$tongAdminCongDiem = $_vincenzo->get_row("SELECT SUM(`admin_add`) FROM `users` WHERE `admin_add` >= 0 ")['SUM(`admin_add`)'];
$tongThuongCuoc = $_vincenzo->get_row("SELECT SUM(`win_amount`) FROM `user_bets` WHERE `win_amount` >= 0 ")['SUM(`win_amount`)'];
$tongKhuyenMai = $_vincenzo->get_row("SELECT SUM(`total_km`) FROM `users` WHERE `total_km` >= 0 ")['SUM(`total_km`)'];
$tongHoanDiemRut = $_vincenzo->get_row("SELECT SUM(`coin`) FROM `point_status` WHERE `note` LIKE '%Hoàn tiền%'")['SUM(`coin`)'];


// Logic phân trang cho bảng lịch sử
$limit = 20; // Số bản ghi mỗi trang
$currentPage = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($currentPage - 1) * $limit;
$count_result = $_vincenzo->get_row("SELECT COUNT(id) as total FROM `point_status`");
$totalRecords = isset($count_result['total']) ? (int)$count_result['total'] : 0;
$totalPages = ceil($totalRecords / $limit);
// Truy vấn dữ liệu cho trang hiện tại, sắp xếp mới nhất lên đầu
$lichSuGiaoDich = $_vincenzo->get_list("SELECT * FROM `point_status` ORDER BY `date` DESC LIMIT $limit OFFSET $offset");

// Hàm giúp xác định loại giao dịch từ ghi chú
function getTransactionType($note, $coin)
{
    if (strpos($note, 'Rút điểm') !== false) return 'Rút điểm';
    if (strpos($note, 'Hệ thống trừ') !== false) return 'Admin Thu hồi';
    if (strpos($note, 'Admin cộng') !== false || strpos($note, 'Hệ thống cộng') !== false) return 'Admin Cộng điểm';
    if (strpos($note, 'Quà tặng') !== false) return 'Quà tặng';
    if (strpos($note, 'Hoàn tiền') !== false) return 'Hoàn tiền';
    if ($coin > 0) return 'Nạp điểm';
    return 'Giao dịch khác';
}
?>

<!-- 3. HTML NỘI DUNG CHÍNH -->
<div class="text-center mb-4">
    <h3 class="text-uppercase">Thống kê hệ thống</h3>
</div>

<!-- Hàng 1 -->
<div class="card-deck mb-3">
    <div class="card bg-success text-white">
        <div class="card-header text-center font-weight-bold">TỔNG NẠP</div>
        <div class="card-body text-center">
            <h4><?= number_format($tongNap) ?></h4>
        </div>
    </div>
    <div class="card bg-danger text-white">
        <div class="card-header text-center font-weight-bold">TỔNG RÚT</div>
        <div class="card-body text-center">
            <h4><?= number_format($tongRut) ?></h4>
        </div>
    </div>
    <div class="card bg-secondary text-white">
        <div class="card-header text-center font-weight-bold">TỔNG ĐIỂM</div>
        <div class="card-body text-center">
            <h4><?= number_format($tongDiemHeThong) ?></h4>
        </div>
    </div>
    <div class="card bg-dark text-white">
        <div class="card-header text-center font-weight-bold">TỔNG ADMIN THU HỒI</div>
        <div class="card-body text-center">
            <h4><?= number_format($tongAdminThuHoi) ?></h4>
        </div>
    </div>
</div>

<!-- Hàng 2 -->
<div class="card-deck mb-3">
    <div class="card bg-success text-white">
        <div class="card-header text-center font-weight-bold">TỔNG ADMIN CỘNG ĐIỂM</div>
        <div class="card-body text-center">
            <h4><?= number_format($tongAdminCongDiem) ?></h4>
        </div>
    </div>
    <div class="card bg-warning text-white">
        <div class="card-header text-center font-weight-bold">TỔNG THƯỞNG CƯỢC</div>
        <div class="card-body text-center">
            <h4><?= number_format($tongThuongCuoc) ?></h4>
        </div>
    </div>
    <div class="card bg-primary text-white">
        <div class="card-header text-center font-weight-bold">TỔNG KHUYẾN MẠI</div>
        <div class="card-body text-center">
            <h4><?= number_format($tongKhuyenMai) ?></h4>
        </div>
    </div>
    <div class="card bg-info text-white">
        <div class="card-header text-center font-weight-bold">TỔNG HOÀN ĐIỂM RÚT</div>
        <div class="card-body text-center">
            <h4><?= number_format($tongHoanDiemRut) ?></h4>
        </div>
    </div>
</div>

<div class="table-responsive">
    <table class="table table-bordered table-sm table-hover">
        <thead class="thead-dark">
            <tr>
                <th>Người chơi</th>
                <th>Loại giao dịch</th>
                <th>Số điểm</th>
                <th>Ghi chú</th>
                <th>Thời gian</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($lichSuGiaoDich) > 0): ?>
                <?php foreach ($lichSuGiaoDich as $gd): ?>
                    <tr>
                        <td>
                            <a href="statistic_user.php?username=<?= htmlspecialchars($gd['username']) ?>" target="_blank">
                                <span><?= htmlspecialchars($gd['username']) ?></span>
                            </a>
                        </td>
                        <td><?= getTransactionType($gd['note'], $gd['coin']) ?></td>
                        <td class="font-weight-bold <?= $gd['coin'] >= 0 ? 'text-success' : 'text-danger' ?>">
                            <?= number_format($gd['coin']) ?>
                        </td>
                        <td style="white-space: wrap;"><?= htmlspecialchars($gd['note']) ?></td>
                        <td><?= date('d/m/Y H:i', strtotime($gd['date'])) ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="5" class="text-center">Không có giao dịch nào.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Phân trang -->
<?php if ($totalPages > 1): ?>
    <nav>
        <ul class="pagination justify-content-center">
            <?php if ($currentPage > 1): ?>
                <li class="page-item"><a class="page-link" href="?page=<?= $currentPage - 1 ?>">«</a></li>
            <?php endif; ?>

            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <li class="page-item <?= ($i == $currentPage) ? 'active' : '' ?>">
                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>

            <?php if ($currentPage < $totalPages): ?>
                <li class="page-item"><a class="page-link" href="?page=<?= $currentPage + 1 ?>">»</a></li>
            <?php endif; ?>
        </ul>
    </nav>
<?php endif; ?>

</script><?php require_once __DIR__ . "/foot.php"; ?>