// Kích hoạt/thao tác trên văn bản đã chọn
function formatText(command) {
    if (command) {
        document.execCommand(command, false, null);
    }
}


// 📝 Chèn thẻ <p></p>
function insertParagraph() {
    document.execCommand('formatBlock', false, 'p');
}

// 🏛 Chèn bảng với Bootstrap Table
function insertTable() {
    var tableHTML = 
        '<div class="table-responsive">' +
            '<table class="table table-bordered table-striped">' +
                '<thead>' +
                    '<tr>' +
                        '<th>TEXT THEAD 1</th>' +
						'<th>TEXT THEAD 2</th>' +
						'<th>TEXT THEAD 3</th>' +
						'<th>TEXT THEAD 4</th>' +
                    '</tr>' +
                '</thead>' +
                '<tbody>' +
                    '<tr>' +
                        '<td>CONTENT 1</td>' +
						'<td>CONTENT 2</td>' +
						'<td>CONTENT 3</td>' +
						'<td>CONTENT 4</td>' +
                    '</tr>' +
                '</tbody>' +
            '</table>' +
        '</div>';

    document.execCommand('insertHTML', false, tableHTML);
}



// Áp dụng kiểu tiêu đề (H1 - H6)
function formatBlock(tag) {
    if (tag) document.execCommand('formatBlock', false, tag);
}


// 🔤 Thay đổi cỡ chữ
function formatFontSize(size) {
    if (size) {
        document.execCommand('fontSize', false, size);
    }
}


// 🖋 Thay đổi font chữ ngay lập tức
function formatFontFamily(font) {
    let selection = window.getSelection();
    let range = selection.getRangeAt(0);

    if (!selection.isCollapsed) {
        // Nếu có văn bản được chọn, bọc nó trong thẻ <span>
        let span = document.createElement("span");
        span.style.fontFamily = font;
        span.innerHTML = range.toString();

        range.deleteContents();  // Xóa nội dung đã chọn
        range.insertNode(span);  // Chèn nội dung mới với font chữ
    } else {
        // Nếu không có vùng chọn, áp dụng font cho toàn bộ nội dung nhập
        document.execCommand('fontName', false, font);
    }
}



// 🎨 Thay đổi màu sắc cho văn bản đã chọn
function formatTextColor(color) {
    let selection = window.getSelection();
    let range = selection.getRangeAt(0);

    if (!selection.isCollapsed) {
        // Nếu có văn bản được chọn, bọc nó trong thẻ <span>
        let span = document.createElement("span");
        span.style.color = color;
        span.innerHTML = range.toString();

        range.deleteContents();  // Xóa nội dung đã chọn
        range.insertNode(span);  // Chèn nội dung mới có màu
    } else {
        // Nếu không có văn bản được chọn, áp dụng màu toàn bộ
        document.execCommand('foreColor', false, color);
    }
}

// 🔧 Căn chỉnh văn bản bằng class Bootstrap
function formatTextAlign(alignClass) {
    let selection = window.getSelection();
    let range = selection.getRangeAt(0);

    if (!selection.isCollapsed) {
        // Tạo thẻ div chứa nội dung đã chọn
        let div = document.createElement("div");
        div.className = alignClass; // Gán class căn chỉnh (text-left, text-center, text-right)
        div.innerHTML = range.toString();

        // Xóa nội dung cũ và chèn nội dung mới có class căn chỉnh
        range.deleteContents();
        range.insertNode(div);
    }
}



// Chèn link
function insertLink() {
    let url = prompt("Nhập URL:");
    if (url) document.execCommand('createLink', false, url);
}

// Chèn ảnh từ input file
function insertImage() {
    document.getElementById('images').click();
}


// Chèn file tài liệu từ input file
function insertFile() {
    document.getElementById('document').click();
}


// Chèn video từ YouTube (Responsive) không dùng backtick
function insertVideo() {
    var url = prompt("Nhập URL video YouTube:");
    if (url) {
        var embedUrl = url.replace("watch?v=", "embed/");

        var videoHTML = '<div class="embed-responsive embed-responsive-16by9">' +
                            '<iframe class="embed-responsive-item" src="' + embedUrl + '" allowfullscreen></iframe>' +
                        '</div>';

        document.execCommand('insertHTML', false, videoHTML);
    }
}



// Hàm làm đẹp HTML khi chuyển sang Code View
function beautifyHTML(html) {
    return html
		.replace(/<br\s*\/?>/g, '\n') // Loại bỏ thẻ <br>
}

// Chế độ Code View với Beautify HTML
let isCodeView = false;
function toggleCodeView() {
    let editor = document.getElementById('editor');
    let modeLabel = document.getElementById('editorMode');

    if (isCodeView) {
        // Quay lại WYSIWYG
        editor.innerHTML = editor.textContent.trim(); // Giữ nguyên HTML chuẩn
        editor.contentEditable = true;
        editor.classList.remove('code-view');
        modeLabel.textContent = "WYSIWYG";
        modeLabel.classList.replace("badge-danger", "badge-light");
    } else {
        // Chuyển sang Code View với Beautify HTML
        let formattedHTML = beautifyHTML(editor.innerHTML.trim());
        editor.textContent = formattedHTML;
        editor.contentEditable = true;
        editor.classList.add('code-view');
        modeLabel.textContent = "HTML";
        modeLabel.classList.replace("badge-light", "badge-danger");
    }

    isCodeView = !isCodeView;
}


// Bật công cụ khi chọn văn bản
function checkSelection() {
    let selection = window.getSelection().toString();
    let toolbarButtons = document.querySelectorAll(".toolbar button, .toolbar select, .toolbar input");

    toolbarButtons.forEach(btn => btn.style.opacity = selection.length > 0 ? "1" : "0.6");
}
